# -*- coding: utf-8 -*-
# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
import importlib
import sys


if sys.version_info < (3, 7):
    raise ImportError("This module requires Python 3.7 or later.")


_lazy_type_to_package_map = {
    # Message types
    "AdAssetPolicySummary": "airflow.providers.google_vendor.googleads.v12.common.types.asset_policy",
    "AdDiscoveryCarouselCardAsset": "airflow.providers.google_vendor.googleads.v12.common.types.ad_asset",
    "AddressInfo": "airflow.providers.google_vendor.googleads.v12.common.types.criteria",
    "AdImageAsset": "airflow.providers.google_vendor.googleads.v12.common.types.ad_asset",
    "AdMediaBundleAsset": "airflow.providers.google_vendor.googleads.v12.common.types.ad_asset",
    "AdScheduleInfo": "airflow.providers.google_vendor.googleads.v12.common.types.criteria",
    "AdTextAsset": "airflow.providers.google_vendor.googleads.v12.common.types.ad_asset",
    "AdVideoAsset": "airflow.providers.google_vendor.googleads.v12.common.types.ad_asset",
    "AffiliateLocationFeedItem": "airflow.providers.google_vendor.googleads.v12.common.types.extensions",
    "AgeDimension": "airflow.providers.google_vendor.googleads.v12.common.types.audiences",
    "AgeRangeInfo": "airflow.providers.google_vendor.googleads.v12.common.types.criteria",
    "AgeSegment": "airflow.providers.google_vendor.googleads.v12.common.types.audiences",
    "AppAdInfo": "airflow.providers.google_vendor.googleads.v12.common.types.ad_type_infos",
    "AppEngagementAdInfo": "airflow.providers.google_vendor.googleads.v12.common.types.ad_type_infos",
    "AppFeedItem": "airflow.providers.google_vendor.googleads.v12.common.types.extensions",
    "AppPaymentModelInfo": "airflow.providers.google_vendor.googleads.v12.common.types.criteria",
    "AppPreRegistrationAdInfo": "airflow.providers.google_vendor.googleads.v12.common.types.ad_type_infos",
    "AssetInteractionTarget": "airflow.providers.google_vendor.googleads.v12.common.types.segments",
    "AssetUsage": "airflow.providers.google_vendor.googleads.v12.common.types.asset_usage",
    "AudienceDimension": "airflow.providers.google_vendor.googleads.v12.common.types.audiences",
    "AudienceExclusionDimension": "airflow.providers.google_vendor.googleads.v12.common.types.audiences",
    "AudienceInfo": "airflow.providers.google_vendor.googleads.v12.common.types.criteria",
    "AudienceSegment": "airflow.providers.google_vendor.googleads.v12.common.types.audiences",
    "AudienceSegmentDimension": "airflow.providers.google_vendor.googleads.v12.common.types.audiences",
    "BasicUserListInfo": "airflow.providers.google_vendor.googleads.v12.common.types.user_lists",
    "BidModifierSimulationPoint": "airflow.providers.google_vendor.googleads.v12.common.types.simulation",
    "BidModifierSimulationPointList": "airflow.providers.google_vendor.googleads.v12.common.types.simulation",
    "BookOnGoogleAsset": "airflow.providers.google_vendor.googleads.v12.common.types.asset_types",
    "BudgetCampaignAssociationStatus": "airflow.providers.google_vendor.googleads.v12.common.types.segments",
    "BudgetSimulationPoint": "airflow.providers.google_vendor.googleads.v12.common.types.simulation",
    "BudgetSimulationPointList": "airflow.providers.google_vendor.googleads.v12.common.types.simulation",
    "BusinessNameFilter": "airflow.providers.google_vendor.googleads.v12.common.types.feed_item_set_filter_type_infos",
    "BusinessProfileBusinessNameFilter": "airflow.providers.google_vendor.googleads.v12.common.types.asset_set_types",
    "BusinessProfileLocation": "airflow.providers.google_vendor.googleads.v12.common.types.asset_types",
    "BusinessProfileLocationGroup": "airflow.providers.google_vendor.googleads.v12.common.types.asset_set_types",
    "BusinessProfileLocationSet": "airflow.providers.google_vendor.googleads.v12.common.types.asset_set_types",
    "CallAdInfo": "airflow.providers.google_vendor.googleads.v12.common.types.ad_type_infos",
    "CallAsset": "airflow.providers.google_vendor.googleads.v12.common.types.asset_types",
    "CallFeedItem": "airflow.providers.google_vendor.googleads.v12.common.types.extensions",
    "CalloutAsset": "airflow.providers.google_vendor.googleads.v12.common.types.asset_types",
    "CalloutFeedItem": "airflow.providers.google_vendor.googleads.v12.common.types.extensions",
    "CallToActionAsset": "airflow.providers.google_vendor.googleads.v12.common.types.asset_types",
    "CarrierInfo": "airflow.providers.google_vendor.googleads.v12.common.types.criteria",
    "ChainFilter": "airflow.providers.google_vendor.googleads.v12.common.types.asset_set_types",
    "ChainLocationGroup": "airflow.providers.google_vendor.googleads.v12.common.types.asset_set_types",
    "ChainSet": "airflow.providers.google_vendor.googleads.v12.common.types.asset_set_types",
    "ClickLocation": "airflow.providers.google_vendor.googleads.v12.common.types.click_location",
    "CombinedAudienceInfo": "airflow.providers.google_vendor.googleads.v12.common.types.criteria",
    "CombinedRuleUserListInfo": "airflow.providers.google_vendor.googleads.v12.common.types.user_lists",
    "Commission": "airflow.providers.google_vendor.googleads.v12.common.types.bidding",
    "ConceptGroup": "airflow.providers.google_vendor.googleads.v12.common.types.keyword_plan_common",
    "ContentLabelInfo": "airflow.providers.google_vendor.googleads.v12.common.types.criteria",
    "CpcBidSimulationPoint": "airflow.providers.google_vendor.googleads.v12.common.types.simulation",
    "CpcBidSimulationPointList": "airflow.providers.google_vendor.googleads.v12.common.types.simulation",
    "CpvBidSimulationPoint": "airflow.providers.google_vendor.googleads.v12.common.types.simulation",
    "CpvBidSimulationPointList": "airflow.providers.google_vendor.googleads.v12.common.types.simulation",
    "CriterionCategoryAvailability": "airflow.providers.google_vendor.googleads.v12.common.types.criterion_category_availability",
    "CriterionCategoryChannelAvailability": "airflow.providers.google_vendor.googleads.v12.common.types.criterion_category_availability",
    "CriterionCategoryLocaleAvailability": "airflow.providers.google_vendor.googleads.v12.common.types.criterion_category_availability",
    "CrmBasedUserListInfo": "airflow.providers.google_vendor.googleads.v12.common.types.user_lists",
    "CustomAffinityInfo": "airflow.providers.google_vendor.googleads.v12.common.types.criteria",
    "CustomAudienceInfo": "airflow.providers.google_vendor.googleads.v12.common.types.criteria",
    "CustomAudienceSegment": "airflow.providers.google_vendor.googleads.v12.common.types.audiences",
    "CustomerMatchUserListMetadata": "airflow.providers.google_vendor.googleads.v12.common.types.offline_user_data",
    "CustomIntentInfo": "airflow.providers.google_vendor.googleads.v12.common.types.criteria",
    "CustomizerValue": "airflow.providers.google_vendor.googleads.v12.common.types.customizer_value",
    "CustomParameter": "airflow.providers.google_vendor.googleads.v12.common.types.custom_parameter",
    "DateRange": "airflow.providers.google_vendor.googleads.v12.common.types.dates",
    "DetailedDemographicSegment": "airflow.providers.google_vendor.googleads.v12.common.types.audiences",
    "DeviceInfo": "airflow.providers.google_vendor.googleads.v12.common.types.criteria",
    "DiscoveryCarouselAdInfo": "airflow.providers.google_vendor.googleads.v12.common.types.ad_type_infos",
    "DiscoveryCarouselCardAsset": "airflow.providers.google_vendor.googleads.v12.common.types.asset_types",
    "DiscoveryMultiAssetAdInfo": "airflow.providers.google_vendor.googleads.v12.common.types.ad_type_infos",
    "DisplayUploadAdInfo": "airflow.providers.google_vendor.googleads.v12.common.types.ad_type_infos",
    "DynamicAffiliateLocationSetFilter": "airflow.providers.google_vendor.googleads.v12.common.types.feed_item_set_filter_type_infos",
    "DynamicBusinessProfileLocationGroupFilter": "airflow.providers.google_vendor.googleads.v12.common.types.asset_set_types",
    "DynamicCustomAsset": "airflow.providers.google_vendor.googleads.v12.common.types.asset_types",
    "DynamicEducationAsset": "airflow.providers.google_vendor.googleads.v12.common.types.asset_types",
    "DynamicFlightsAsset": "airflow.providers.google_vendor.googleads.v12.common.types.asset_types",
    "DynamicHotelsAndRentalsAsset": "airflow.providers.google_vendor.googleads.v12.common.types.asset_types",
    "DynamicJobsAsset": "airflow.providers.google_vendor.googleads.v12.common.types.asset_types",
    "DynamicLocalAsset": "airflow.providers.google_vendor.googleads.v12.common.types.asset_types",
    "DynamicLocationSetFilter": "airflow.providers.google_vendor.googleads.v12.common.types.feed_item_set_filter_type_infos",
    "DynamicRealEstateAsset": "airflow.providers.google_vendor.googleads.v12.common.types.asset_types",
    "DynamicTravelAsset": "airflow.providers.google_vendor.googleads.v12.common.types.asset_types",
    "EnhancedCpc": "airflow.providers.google_vendor.googleads.v12.common.types.bidding",
    "EventAttribute": "airflow.providers.google_vendor.googleads.v12.common.types.offline_user_data",
    "EventItemAttribute": "airflow.providers.google_vendor.googleads.v12.common.types.offline_user_data",
    "ExclusionSegment": "airflow.providers.google_vendor.googleads.v12.common.types.audiences",
    "ExpandedDynamicSearchAdInfo": "airflow.providers.google_vendor.googleads.v12.common.types.ad_type_infos",
    "ExpandedTextAdInfo": "airflow.providers.google_vendor.googleads.v12.common.types.ad_type_infos",
    "ExplorerAutoOptimizerSetting": "airflow.providers.google_vendor.googleads.v12.common.types.explorer_auto_optimizer_setting",
    "ExpressionRuleUserListInfo": "airflow.providers.google_vendor.googleads.v12.common.types.user_lists",
    "FinalAppUrl": "airflow.providers.google_vendor.googleads.v12.common.types.final_app_url",
    "FlexibleRuleOperandInfo": "airflow.providers.google_vendor.googleads.v12.common.types.user_lists",
    "FlexibleRuleUserListInfo": "airflow.providers.google_vendor.googleads.v12.common.types.user_lists",
    "FrequencyCapEntry": "airflow.providers.google_vendor.googleads.v12.common.types.frequency_cap",
    "FrequencyCapKey": "airflow.providers.google_vendor.googleads.v12.common.types.frequency_cap",
    "GenderDimension": "airflow.providers.google_vendor.googleads.v12.common.types.audiences",
    "GenderInfo": "airflow.providers.google_vendor.googleads.v12.common.types.criteria",
    "GeoPointInfo": "airflow.providers.google_vendor.googleads.v12.common.types.criteria",
    "HistoricalMetricsOptions": "airflow.providers.google_vendor.googleads.v12.common.types.keyword_plan_common",
    "HotelAdInfo": "airflow.providers.google_vendor.googleads.v12.common.types.ad_type_infos",
    "HotelAdvanceBookingWindowInfo": "airflow.providers.google_vendor.googleads.v12.common.types.criteria",
    "HotelCalloutAsset": "airflow.providers.google_vendor.googleads.v12.common.types.asset_types",
    "HotelCalloutFeedItem": "airflow.providers.google_vendor.googleads.v12.common.types.extensions",
    "HotelCheckInDateRangeInfo": "airflow.providers.google_vendor.googleads.v12.common.types.criteria",
    "HotelCheckInDayInfo": "airflow.providers.google_vendor.googleads.v12.common.types.criteria",
    "HotelCityInfo": "airflow.providers.google_vendor.googleads.v12.common.types.criteria",
    "HotelClassInfo": "airflow.providers.google_vendor.googleads.v12.common.types.criteria",
    "HotelCountryRegionInfo": "airflow.providers.google_vendor.googleads.v12.common.types.criteria",
    "HotelDateSelectionTypeInfo": "airflow.providers.google_vendor.googleads.v12.common.types.criteria",
    "HotelIdInfo": "airflow.providers.google_vendor.googleads.v12.common.types.criteria",
    "HotelLengthOfStayInfo": "airflow.providers.google_vendor.googleads.v12.common.types.criteria",
    "HotelStateInfo": "airflow.providers.google_vendor.googleads.v12.common.types.criteria",
    "HouseholdIncomeDimension": "airflow.providers.google_vendor.googleads.v12.common.types.audiences",
    "ImageAdInfo": "airflow.providers.google_vendor.googleads.v12.common.types.ad_type_infos",
    "ImageAsset": "airflow.providers.google_vendor.googleads.v12.common.types.asset_types",
    "ImageDimension": "airflow.providers.google_vendor.googleads.v12.common.types.asset_types",
    "ImageFeedItem": "airflow.providers.google_vendor.googleads.v12.common.types.extensions",
    "IncomeRangeInfo": "airflow.providers.google_vendor.googleads.v12.common.types.criteria",
    "InFeedVideoAdInfo": "airflow.providers.google_vendor.googleads.v12.common.types.ad_type_infos",
    "InteractionTypeInfo": "airflow.providers.google_vendor.googleads.v12.common.types.criteria",
    "IpBlockInfo": "airflow.providers.google_vendor.googleads.v12.common.types.criteria",
    "ItemAttribute": "airflow.providers.google_vendor.googleads.v12.common.types.offline_user_data",
    "Keyword": "airflow.providers.google_vendor.googleads.v12.common.types.segments",
    "KeywordAnnotations": "airflow.providers.google_vendor.googleads.v12.common.types.keyword_plan_common",
    "KeywordConcept": "airflow.providers.google_vendor.googleads.v12.common.types.keyword_plan_common",
    "KeywordInfo": "airflow.providers.google_vendor.googleads.v12.common.types.criteria",
    "KeywordPlanAggregateMetricResults": "airflow.providers.google_vendor.googleads.v12.common.types.keyword_plan_common",
    "KeywordPlanAggregateMetrics": "airflow.providers.google_vendor.googleads.v12.common.types.keyword_plan_common",
    "KeywordPlanDeviceSearches": "airflow.providers.google_vendor.googleads.v12.common.types.keyword_plan_common",
    "KeywordPlanHistoricalMetrics": "airflow.providers.google_vendor.googleads.v12.common.types.keyword_plan_common",
    "KeywordThemeInfo": "airflow.providers.google_vendor.googleads.v12.common.types.criteria",
    "LanguageInfo": "airflow.providers.google_vendor.googleads.v12.common.types.criteria",
    "LeadFormAsset": "airflow.providers.google_vendor.googleads.v12.common.types.asset_types",
    "LeadFormCustomQuestionField": "airflow.providers.google_vendor.googleads.v12.common.types.asset_types",
    "LeadFormDeliveryMethod": "airflow.providers.google_vendor.googleads.v12.common.types.asset_types",
    "LeadFormField": "airflow.providers.google_vendor.googleads.v12.common.types.asset_types",
    "LeadFormSingleChoiceAnswers": "airflow.providers.google_vendor.googleads.v12.common.types.asset_types",
    "LegacyAppInstallAdInfo": "airflow.providers.google_vendor.googleads.v12.common.types.ad_type_infos",
    "LegacyResponsiveDisplayAdInfo": "airflow.providers.google_vendor.googleads.v12.common.types.ad_type_infos",
    "LifeEventSegment": "airflow.providers.google_vendor.googleads.v12.common.types.audiences",
    "ListingDimensionInfo": "airflow.providers.google_vendor.googleads.v12.common.types.criteria",
    "ListingGroupInfo": "airflow.providers.google_vendor.googleads.v12.common.types.criteria",
    "ListingScopeInfo": "airflow.providers.google_vendor.googleads.v12.common.types.criteria",
    "LocalAdInfo": "airflow.providers.google_vendor.googleads.v12.common.types.ad_type_infos",
    "LocationAsset": "airflow.providers.google_vendor.googleads.v12.common.types.asset_types",
    "LocationFeedItem": "airflow.providers.google_vendor.googleads.v12.common.types.extensions",
    "LocationGroupInfo": "airflow.providers.google_vendor.googleads.v12.common.types.criteria",
    "LocationInfo": "airflow.providers.google_vendor.googleads.v12.common.types.criteria",
    "LocationSet": "airflow.providers.google_vendor.googleads.v12.common.types.asset_set_types",
    "LogicalUserListInfo": "airflow.providers.google_vendor.googleads.v12.common.types.user_lists",
    "LogicalUserListOperandInfo": "airflow.providers.google_vendor.googleads.v12.common.types.user_lists",
    "ManualCpa": "airflow.providers.google_vendor.googleads.v12.common.types.bidding",
    "ManualCpc": "airflow.providers.google_vendor.googleads.v12.common.types.bidding",
    "ManualCpm": "airflow.providers.google_vendor.googleads.v12.common.types.bidding",
    "ManualCpv": "airflow.providers.google_vendor.googleads.v12.common.types.bidding",
    "MapsLocationInfo": "airflow.providers.google_vendor.googleads.v12.common.types.asset_set_types",
    "MapsLocationSet": "airflow.providers.google_vendor.googleads.v12.common.types.asset_set_types",
    "MatchingFunction": "airflow.providers.google_vendor.googleads.v12.common.types.matching_function",
    "MaximizeConversions": "airflow.providers.google_vendor.googleads.v12.common.types.bidding",
    "MaximizeConversionValue": "airflow.providers.google_vendor.googleads.v12.common.types.bidding",
    "MediaBundleAsset": "airflow.providers.google_vendor.googleads.v12.common.types.asset_types",
    "MetricGoal": "airflow.providers.google_vendor.googleads.v12.common.types.metric_goal",
    "Metrics": "airflow.providers.google_vendor.googleads.v12.common.types.metrics",
    "MobileAppAsset": "airflow.providers.google_vendor.googleads.v12.common.types.asset_types",
    "MobileAppCategoryInfo": "airflow.providers.google_vendor.googleads.v12.common.types.criteria",
    "MobileApplicationInfo": "airflow.providers.google_vendor.googleads.v12.common.types.criteria",
    "MobileDeviceInfo": "airflow.providers.google_vendor.googleads.v12.common.types.criteria",
    "Money": "airflow.providers.google_vendor.googleads.v12.common.types.feed_common",
    "MonthlySearchVolume": "airflow.providers.google_vendor.googleads.v12.common.types.keyword_plan_common",
    "OfflineUserAddressInfo": "airflow.providers.google_vendor.googleads.v12.common.types.offline_user_data",
    "Operand": "airflow.providers.google_vendor.googleads.v12.common.types.matching_function",
    "OperatingSystemVersionInfo": "airflow.providers.google_vendor.googleads.v12.common.types.criteria",
    "PageFeedAsset": "airflow.providers.google_vendor.googleads.v12.common.types.asset_types",
    "ParentalStatusDimension": "airflow.providers.google_vendor.googleads.v12.common.types.audiences",
    "ParentalStatusInfo": "airflow.providers.google_vendor.googleads.v12.common.types.criteria",
    "PercentCpc": "airflow.providers.google_vendor.googleads.v12.common.types.bidding",
    "PercentCpcBidSimulationPoint": "airflow.providers.google_vendor.googleads.v12.common.types.simulation",
    "PercentCpcBidSimulationPointList": "airflow.providers.google_vendor.googleads.v12.common.types.simulation",
    "PlacementInfo": "airflow.providers.google_vendor.googleads.v12.common.types.criteria",
    "PolicySummary": "airflow.providers.google_vendor.googleads.v12.common.types.policy_summary",
    "PolicyTopicConstraint": "airflow.providers.google_vendor.googleads.v12.common.types.policy",
    "PolicyTopicEntry": "airflow.providers.google_vendor.googleads.v12.common.types.policy",
    "PolicyTopicEvidence": "airflow.providers.google_vendor.googleads.v12.common.types.policy",
    "PolicyValidationParameter": "airflow.providers.google_vendor.googleads.v12.common.types.policy",
    "PolicyViolationKey": "airflow.providers.google_vendor.googleads.v12.common.types.policy",
    "PreferredContentInfo": "airflow.providers.google_vendor.googleads.v12.common.types.criteria",
    "PriceAsset": "airflow.providers.google_vendor.googleads.v12.common.types.asset_types",
    "PriceFeedItem": "airflow.providers.google_vendor.googleads.v12.common.types.extensions",
    "PriceOffer": "airflow.providers.google_vendor.googleads.v12.common.types.extensions",
    "PriceOffering": "airflow.providers.google_vendor.googleads.v12.common.types.asset_types",
    "ProductBiddingCategoryInfo": "airflow.providers.google_vendor.googleads.v12.common.types.criteria",
    "ProductBrandInfo": "airflow.providers.google_vendor.googleads.v12.common.types.criteria",
    "ProductChannelExclusivityInfo": "airflow.providers.google_vendor.googleads.v12.common.types.criteria",
    "ProductChannelInfo": "airflow.providers.google_vendor.googleads.v12.common.types.criteria",
    "ProductConditionInfo": "airflow.providers.google_vendor.googleads.v12.common.types.criteria",
    "ProductCustomAttributeInfo": "airflow.providers.google_vendor.googleads.v12.common.types.criteria",
    "ProductGroupingInfo": "airflow.providers.google_vendor.googleads.v12.common.types.criteria",
    "ProductItemIdInfo": "airflow.providers.google_vendor.googleads.v12.common.types.criteria",
    "ProductLabelsInfo": "airflow.providers.google_vendor.googleads.v12.common.types.criteria",
    "ProductLegacyConditionInfo": "airflow.providers.google_vendor.googleads.v12.common.types.criteria",
    "ProductTypeFullInfo": "airflow.providers.google_vendor.googleads.v12.common.types.criteria",
    "ProductTypeInfo": "airflow.providers.google_vendor.googleads.v12.common.types.criteria",
    "PromotionAsset": "airflow.providers.google_vendor.googleads.v12.common.types.asset_types",
    "PromotionFeedItem": "airflow.providers.google_vendor.googleads.v12.common.types.extensions",
    "ProximityInfo": "airflow.providers.google_vendor.googleads.v12.common.types.criteria",
    "RealTimeBiddingSetting": "airflow.providers.google_vendor.googleads.v12.common.types.real_time_bidding_setting",
    "ResponsiveDisplayAdControlSpec": "airflow.providers.google_vendor.googleads.v12.common.types.ad_type_infos",
    "ResponsiveDisplayAdInfo": "airflow.providers.google_vendor.googleads.v12.common.types.ad_type_infos",
    "ResponsiveSearchAdInfo": "airflow.providers.google_vendor.googleads.v12.common.types.ad_type_infos",
    "RuleBasedUserListInfo": "airflow.providers.google_vendor.googleads.v12.common.types.user_lists",
    "Segments": "airflow.providers.google_vendor.googleads.v12.common.types.segments",
    "ShoppingComparisonListingAdInfo": "airflow.providers.google_vendor.googleads.v12.common.types.ad_type_infos",
    "ShoppingLoyalty": "airflow.providers.google_vendor.googleads.v12.common.types.offline_user_data",
    "ShoppingProductAdInfo": "airflow.providers.google_vendor.googleads.v12.common.types.ad_type_infos",
    "ShoppingSmartAdInfo": "airflow.providers.google_vendor.googleads.v12.common.types.ad_type_infos",
    "SimilarUserListInfo": "airflow.providers.google_vendor.googleads.v12.common.types.user_lists",
    "SitelinkAsset": "airflow.providers.google_vendor.googleads.v12.common.types.asset_types",
    "SitelinkFeedItem": "airflow.providers.google_vendor.googleads.v12.common.types.extensions",
    "SkAdNetworkSourceApp": "airflow.providers.google_vendor.googleads.v12.common.types.segments",
    "SmartCampaignAdInfo": "airflow.providers.google_vendor.googleads.v12.common.types.ad_type_infos",
    "StoreAttribute": "airflow.providers.google_vendor.googleads.v12.common.types.offline_user_data",
    "StoreSalesMetadata": "airflow.providers.google_vendor.googleads.v12.common.types.offline_user_data",
    "StoreSalesThirdPartyMetadata": "airflow.providers.google_vendor.googleads.v12.common.types.offline_user_data",
    "StructuredSnippetAsset": "airflow.providers.google_vendor.googleads.v12.common.types.asset_types",
    "StructuredSnippetFeedItem": "airflow.providers.google_vendor.googleads.v12.common.types.extensions",
    "TagSnippet": "airflow.providers.google_vendor.googleads.v12.common.types.tag_snippet",
    "TargetCpa": "airflow.providers.google_vendor.googleads.v12.common.types.bidding",
    "TargetCpaSimulationPoint": "airflow.providers.google_vendor.googleads.v12.common.types.simulation",
    "TargetCpaSimulationPointList": "airflow.providers.google_vendor.googleads.v12.common.types.simulation",
    "TargetCpm": "airflow.providers.google_vendor.googleads.v12.common.types.bidding",
    "TargetImpressionShare": "airflow.providers.google_vendor.googleads.v12.common.types.bidding",
    "TargetImpressionShareSimulationPoint": "airflow.providers.google_vendor.googleads.v12.common.types.simulation",
    "TargetImpressionShareSimulationPointList": "airflow.providers.google_vendor.googleads.v12.common.types.simulation",
    "TargetingSetting": "airflow.providers.google_vendor.googleads.v12.common.types.targeting_setting",
    "TargetRestriction": "airflow.providers.google_vendor.googleads.v12.common.types.targeting_setting",
    "TargetRestrictionOperation": "airflow.providers.google_vendor.googleads.v12.common.types.targeting_setting",
    "TargetRoas": "airflow.providers.google_vendor.googleads.v12.common.types.bidding",
    "TargetRoasSimulationPoint": "airflow.providers.google_vendor.googleads.v12.common.types.simulation",
    "TargetRoasSimulationPointList": "airflow.providers.google_vendor.googleads.v12.common.types.simulation",
    "TargetSpend": "airflow.providers.google_vendor.googleads.v12.common.types.bidding",
    "TextAdInfo": "airflow.providers.google_vendor.googleads.v12.common.types.ad_type_infos",
    "TextAsset": "airflow.providers.google_vendor.googleads.v12.common.types.asset_types",
    "TextLabel": "airflow.providers.google_vendor.googleads.v12.common.types.text_label",
    "TextMessageFeedItem": "airflow.providers.google_vendor.googleads.v12.common.types.extensions",
    "TopicInfo": "airflow.providers.google_vendor.googleads.v12.common.types.criteria",
    "TransactionAttribute": "airflow.providers.google_vendor.googleads.v12.common.types.offline_user_data",
    "UnknownListingDimensionInfo": "airflow.providers.google_vendor.googleads.v12.common.types.criteria",
    "UrlCollection": "airflow.providers.google_vendor.googleads.v12.common.types.url_collection",
    "UserAttribute": "airflow.providers.google_vendor.googleads.v12.common.types.offline_user_data",
    "UserData": "airflow.providers.google_vendor.googleads.v12.common.types.offline_user_data",
    "UserIdentifier": "airflow.providers.google_vendor.googleads.v12.common.types.offline_user_data",
    "UserInterestInfo": "airflow.providers.google_vendor.googleads.v12.common.types.criteria",
    "UserInterestSegment": "airflow.providers.google_vendor.googleads.v12.common.types.audiences",
    "UserListActionInfo": "airflow.providers.google_vendor.googleads.v12.common.types.user_lists",
    "UserListDateRuleItemInfo": "airflow.providers.google_vendor.googleads.v12.common.types.user_lists",
    "UserListInfo": "airflow.providers.google_vendor.googleads.v12.common.types.criteria",
    "UserListLogicalRuleInfo": "airflow.providers.google_vendor.googleads.v12.common.types.user_lists",
    "UserListNumberRuleItemInfo": "airflow.providers.google_vendor.googleads.v12.common.types.user_lists",
    "UserListRuleInfo": "airflow.providers.google_vendor.googleads.v12.common.types.user_lists",
    "UserListRuleItemGroupInfo": "airflow.providers.google_vendor.googleads.v12.common.types.user_lists",
    "UserListRuleItemInfo": "airflow.providers.google_vendor.googleads.v12.common.types.user_lists",
    "UserListSegment": "airflow.providers.google_vendor.googleads.v12.common.types.audiences",
    "UserListStringRuleItemInfo": "airflow.providers.google_vendor.googleads.v12.common.types.user_lists",
    "Value": "airflow.providers.google_vendor.googleads.v12.common.types.value",
    "VideoAdInfo": "airflow.providers.google_vendor.googleads.v12.common.types.ad_type_infos",
    "VideoBumperInStreamAdInfo": "airflow.providers.google_vendor.googleads.v12.common.types.ad_type_infos",
    "VideoNonSkippableInStreamAdInfo": "airflow.providers.google_vendor.googleads.v12.common.types.ad_type_infos",
    "VideoOutstreamAdInfo": "airflow.providers.google_vendor.googleads.v12.common.types.ad_type_infos",
    "VideoResponsiveAdInfo": "airflow.providers.google_vendor.googleads.v12.common.types.ad_type_infos",
    "VideoTrueViewInStreamAdInfo": "airflow.providers.google_vendor.googleads.v12.common.types.ad_type_infos",
    "WebhookDelivery": "airflow.providers.google_vendor.googleads.v12.common.types.asset_types",
    "WebpageConditionInfo": "airflow.providers.google_vendor.googleads.v12.common.types.criteria",
    "WebpageInfo": "airflow.providers.google_vendor.googleads.v12.common.types.criteria",
    "WebpageSampleInfo": "airflow.providers.google_vendor.googleads.v12.common.types.criteria",
    "YearMonth": "airflow.providers.google_vendor.googleads.v12.common.types.dates",
    "YearMonthRange": "airflow.providers.google_vendor.googleads.v12.common.types.dates",
    "YouTubeChannelInfo": "airflow.providers.google_vendor.googleads.v12.common.types.criteria",
    "YoutubeVideoAsset": "airflow.providers.google_vendor.googleads.v12.common.types.asset_types",
    "YouTubeVideoInfo": "airflow.providers.google_vendor.googleads.v12.common.types.criteria",
    "AccessInvitationStatusEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.access_invitation_status",
    "AccessReasonEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.access_reason",
    "AccessRoleEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.access_role",
    "AccountBudgetProposalStatusEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.account_budget_proposal_status",
    "AccountBudgetProposalTypeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.account_budget_proposal_type",
    "AccountBudgetStatusEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.account_budget_status",
    "AccountLinkStatusEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.account_link_status",
    "AdCustomizerPlaceholderFieldEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.ad_customizer_placeholder_field",
    "AdDestinationTypeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.ad_destination_type",
    "AdGroupAdRotationModeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.ad_group_ad_rotation_mode",
    "AdGroupAdStatusEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.ad_group_ad_status",
    "AdGroupCriterionApprovalStatusEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.ad_group_criterion_approval_status",
    "AdGroupCriterionStatusEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.ad_group_criterion_status",
    "AdGroupStatusEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.ad_group_status",
    "AdGroupTypeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.ad_group_type",
    "AdNetworkTypeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.ad_network_type",
    "AdServingOptimizationStatusEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.ad_serving_optimization_status",
    "AdStrengthEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.ad_strength",
    "AdTypeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.ad_type",
    "AdvertisingChannelSubTypeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.advertising_channel_sub_type",
    "AdvertisingChannelTypeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.advertising_channel_type",
    "AffiliateLocationFeedRelationshipTypeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.affiliate_location_feed_relationship_type",
    "AffiliateLocationPlaceholderFieldEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.affiliate_location_placeholder_field",
    "AgeRangeTypeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.age_range_type",
    "AppCampaignAppStoreEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.app_campaign_app_store",
    "AppCampaignBiddingStrategyGoalTypeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.app_campaign_bidding_strategy_goal_type",
    "AppPaymentModelTypeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.app_payment_model_type",
    "AppPlaceholderFieldEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.app_placeholder_field",
    "AppStoreEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.app_store",
    "AppUrlOperatingSystemTypeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.app_url_operating_system_type",
    "AssetFieldTypeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.asset_field_type",
    "AssetGroupStatusEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.asset_group_status",
    "AssetLinkStatusEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.asset_link_status",
    "AssetPerformanceLabelEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.asset_performance_label",
    "AssetSetAssetStatusEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.asset_set_asset_status",
    "AssetSetLinkStatusEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.asset_set_link_status",
    "AssetSetStatusEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.asset_set_status",
    "AssetSetTypeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.asset_set_type",
    "AssetSourceEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.asset_source",
    "AssetTypeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.asset_type",
    "AsyncActionStatusEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.async_action_status",
    "AttributionModelEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.attribution_model",
    "AudienceInsightsDimensionEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.audience_insights_dimension",
    "AudienceStatusEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.audience_status",
    "BatchJobStatusEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.batch_job_status",
    "BiddingSourceEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.bidding_source",
    "BiddingStrategyStatusEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.bidding_strategy_status",
    "BiddingStrategySystemStatusEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.bidding_strategy_system_status",
    "BiddingStrategyTypeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.bidding_strategy_type",
    "BidModifierSourceEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.bid_modifier_source",
    "BillingSetupStatusEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.billing_setup_status",
    "BrandSafetySuitabilityEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.brand_safety_suitability",
    "BudgetCampaignAssociationStatusEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.budget_campaign_association_status",
    "BudgetDeliveryMethodEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.budget_delivery_method",
    "BudgetPeriodEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.budget_period",
    "BudgetStatusEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.budget_status",
    "BudgetTypeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.budget_type",
    "CallConversionReportingStateEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.call_conversion_reporting_state",
    "CalloutPlaceholderFieldEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.callout_placeholder_field",
    "CallPlaceholderFieldEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.call_placeholder_field",
    "CallToActionTypeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.call_to_action_type",
    "CallTrackingDisplayLocationEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.call_tracking_display_location",
    "CallTypeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.call_type",
    "CampaignCriterionStatusEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.campaign_criterion_status",
    "CampaignDraftStatusEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.campaign_draft_status",
    "CampaignExperimentTypeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.campaign_experiment_type",
    "CampaignGroupStatusEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.campaign_group_status",
    "CampaignPrimaryStatusEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.campaign_primary_status",
    "CampaignPrimaryStatusReasonEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.campaign_primary_status_reason",
    "CampaignServingStatusEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.campaign_serving_status",
    "CampaignSharedSetStatusEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.campaign_shared_set_status",
    "CampaignStatusEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.campaign_status",
    "ChainRelationshipTypeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.chain_relationship_type",
    "ChangeClientTypeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.change_client_type",
    "ChangeEventResourceTypeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.change_event_resource_type",
    "ChangeStatusOperationEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.change_status_operation",
    "ChangeStatusResourceTypeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.change_status_resource_type",
    "ClickTypeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.click_type",
    "CombinedAudienceStatusEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.combined_audience_status",
    "ContentLabelTypeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.content_label_type",
    "ConversionActionCategoryEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.conversion_action_category",
    "ConversionActionCountingTypeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.conversion_action_counting_type",
    "ConversionActionStatusEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.conversion_action_status",
    "ConversionActionTypeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.conversion_action_type",
    "ConversionAdjustmentTypeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.conversion_adjustment_type",
    "ConversionAttributionEventTypeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.conversion_attribution_event_type",
    "ConversionCustomVariableStatusEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.conversion_custom_variable_status",
    "ConversionEnvironmentEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.conversion_environment_enum",
    "ConversionLagBucketEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.conversion_lag_bucket",
    "ConversionOrAdjustmentLagBucketEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.conversion_or_adjustment_lag_bucket",
    "ConversionOriginEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.conversion_origin",
    "ConversionTrackingStatusEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.conversion_tracking_status_enum",
    "ConversionValueRulePrimaryDimensionEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.conversion_value_rule_primary_dimension",
    "ConversionValueRuleSetStatusEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.conversion_value_rule_set_status",
    "ConversionValueRuleStatusEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.conversion_value_rule_status",
    "CriterionCategoryChannelAvailabilityModeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.criterion_category_channel_availability_mode",
    "CriterionCategoryLocaleAvailabilityModeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.criterion_category_locale_availability_mode",
    "CriterionSystemServingStatusEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.criterion_system_serving_status",
    "CriterionTypeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.criterion_type",
    "CustomAudienceMemberTypeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.custom_audience_member_type",
    "CustomAudienceStatusEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.custom_audience_status",
    "CustomAudienceTypeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.custom_audience_type",
    "CustomConversionGoalStatusEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.custom_conversion_goal_status",
    "CustomerMatchUploadKeyTypeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.customer_match_upload_key_type",
    "CustomerPayPerConversionEligibilityFailureReasonEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.customer_pay_per_conversion_eligibility_failure_reason",
    "CustomerStatusEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.customer_status",
    "CustomInterestMemberTypeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.custom_interest_member_type",
    "CustomInterestStatusEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.custom_interest_status",
    "CustomInterestTypeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.custom_interest_type",
    "CustomizerAttributeStatusEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.customizer_attribute_status",
    "CustomizerAttributeTypeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.customizer_attribute_type",
    "CustomizerValueStatusEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.customizer_value_status",
    "CustomPlaceholderFieldEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.custom_placeholder_field",
    "DataDrivenModelStatusEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.data_driven_model_status",
    "DayOfWeekEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.day_of_week",
    "DeviceEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.device",
    "DisplayAdFormatSettingEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.display_ad_format_setting",
    "DisplayUploadProductTypeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.display_upload_product_type",
    "DistanceBucketEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.distance_bucket",
    "DsaPageFeedCriterionFieldEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.dsa_page_feed_criterion_field",
    "EducationPlaceholderFieldEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.education_placeholder_field",
    "ExperimentMetricDirectionEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.experiment_metric_direction",
    "ExperimentMetricEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.experiment_metric",
    "ExperimentStatusEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.experiment_status",
    "ExperimentTypeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.experiment_type",
    "ExtensionSettingDeviceEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.extension_setting_device",
    "ExtensionTypeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.extension_type",
    "ExternalConversionSourceEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.external_conversion_source",
    "FeedAttributeTypeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.feed_attribute_type",
    "FeedItemQualityApprovalStatusEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.feed_item_quality_approval_status",
    "FeedItemQualityDisapprovalReasonEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.feed_item_quality_disapproval_reason",
    "FeedItemSetStatusEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.feed_item_set_status",
    "FeedItemSetStringFilterTypeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.feed_item_set_string_filter_type",
    "FeedItemStatusEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.feed_item_status",
    "FeedItemTargetDeviceEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.feed_item_target_device",
    "FeedItemTargetStatusEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.feed_item_target_status",
    "FeedItemTargetTypeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.feed_item_target_type",
    "FeedItemValidationStatusEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.feed_item_validation_status",
    "FeedLinkStatusEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.feed_link_status",
    "FeedMappingCriterionTypeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.feed_mapping_criterion_type",
    "FeedMappingStatusEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.feed_mapping_status",
    "FeedOriginEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.feed_origin",
    "FeedStatusEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.feed_status",
    "FlightPlaceholderFieldEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.flight_placeholder_field",
    "FrequencyCapEventTypeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.frequency_cap_event_type",
    "FrequencyCapLevelEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.frequency_cap_level",
    "FrequencyCapTimeUnitEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.frequency_cap_time_unit",
    "GenderTypeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.gender_type",
    "GeoTargetConstantStatusEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.geo_target_constant_status",
    "GeoTargetingRestrictionEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.geo_targeting_restriction",
    "GeoTargetingTypeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.geo_targeting_type",
    "GoalConfigLevelEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.goal_config_level",
    "GoogleAdsFieldCategoryEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.google_ads_field_category",
    "GoogleAdsFieldDataTypeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.google_ads_field_data_type",
    "GoogleVoiceCallStatusEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.google_voice_call_status",
    "HotelDateSelectionTypeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.hotel_date_selection_type",
    "HotelPlaceholderFieldEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.hotel_placeholder_field",
    "HotelPriceBucketEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.hotel_price_bucket",
    "HotelRateTypeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.hotel_rate_type",
    "HotelReconciliationStatusEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.hotel_reconciliation_status",
    "ImagePlaceholderFieldEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.image_placeholder_field",
    "IncomeRangeTypeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.income_range_type",
    "InteractionEventTypeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.interaction_event_type",
    "InteractionTypeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.interaction_type",
    "InvoiceTypeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.invoice_type",
    "JobPlaceholderFieldEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.job_placeholder_field",
    "KeywordMatchTypeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.keyword_match_type",
    "KeywordPlanAggregateMetricTypeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.keyword_plan_aggregate_metric_type",
    "KeywordPlanCompetitionLevelEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.keyword_plan_competition_level",
    "KeywordPlanConceptGroupTypeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.keyword_plan_concept_group_type",
    "KeywordPlanForecastIntervalEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.keyword_plan_forecast_interval",
    "KeywordPlanKeywordAnnotationEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.keyword_plan_keyword_annotation",
    "KeywordPlanNetworkEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.keyword_plan_network",
    "LabelStatusEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.label_status",
    "LeadFormCallToActionTypeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.lead_form_call_to_action_type",
    "LeadFormDesiredIntentEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.lead_form_desired_intent",
    "LeadFormFieldUserInputTypeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.lead_form_field_user_input_type",
    "LeadFormPostSubmitCallToActionTypeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.lead_form_post_submit_call_to_action_type",
    "LegacyAppInstallAdAppStoreEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.legacy_app_install_ad_app_store",
    "LinkedAccountTypeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.linked_account_type",
    "ListingGroupFilterBiddingCategoryLevelEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.listing_group_filter_bidding_category_level",
    "ListingGroupFilterCustomAttributeIndexEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.listing_group_filter_custom_attribute_index",
    "ListingGroupFilterProductChannelEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.listing_group_filter_product_channel",
    "ListingGroupFilterProductConditionEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.listing_group_filter_product_condition",
    "ListingGroupFilterProductTypeLevelEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.listing_group_filter_product_type_level",
    "ListingGroupFilterTypeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.listing_group_filter_type_enum",
    "ListingGroupFilterVerticalEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.listing_group_filter_vertical",
    "ListingGroupTypeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.listing_group_type",
    "LocalPlaceholderFieldEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.local_placeholder_field",
    "LocationExtensionTargetingCriterionFieldEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.location_extension_targeting_criterion_field",
    "LocationGroupRadiusUnitsEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.location_group_radius_units",
    "LocationOwnershipTypeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.location_ownership_type",
    "LocationPlaceholderFieldEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.location_placeholder_field",
    "LocationSourceTypeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.location_source_type",
    "LocationStringFilterTypeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.location_string_filter_type",
    "ManagerLinkStatusEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.manager_link_status",
    "MatchingFunctionContextTypeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.matching_function_context_type",
    "MatchingFunctionOperatorEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.matching_function_operator",
    "MediaTypeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.media_type",
    "MerchantCenterLinkStatusEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.merchant_center_link_status",
    "MessagePlaceholderFieldEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.message_placeholder_field",
    "MimeTypeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.mime_type",
    "MinuteOfHourEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.minute_of_hour",
    "MobileAppVendorEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.mobile_app_vendor",
    "MobileDeviceTypeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.mobile_device_type",
    "MonthOfYearEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.month_of_year",
    "NegativeGeoTargetTypeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.negative_geo_target_type",
    "OfflineUserDataJobFailureReasonEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.offline_user_data_job_failure_reason",
    "OfflineUserDataJobMatchRateRangeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.offline_user_data_job_match_rate_range",
    "OfflineUserDataJobStatusEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.offline_user_data_job_status",
    "OfflineUserDataJobTypeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.offline_user_data_job_type",
    "OperatingSystemVersionOperatorTypeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.operating_system_version_operator_type",
    "OptimizationGoalTypeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.optimization_goal_type",
    "ParentalStatusTypeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.parental_status_type",
    "PaymentModeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.payment_mode",
    "PerformanceMaxUpgradeStatusEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.performance_max_upgrade_status",
    "PlaceholderTypeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.placeholder_type",
    "PlacementTypeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.placement_type",
    "PolicyApprovalStatusEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.policy_approval_status",
    "PolicyReviewStatusEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.policy_review_status",
    "PolicyTopicEntryTypeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.policy_topic_entry_type",
    "PolicyTopicEvidenceDestinationMismatchUrlTypeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.policy_topic_evidence_destination_mismatch_url_type",
    "PolicyTopicEvidenceDestinationNotWorkingDeviceEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.policy_topic_evidence_destination_not_working_device",
    "PolicyTopicEvidenceDestinationNotWorkingDnsErrorTypeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.policy_topic_evidence_destination_not_working_dns_error_type",
    "PositiveGeoTargetTypeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.positive_geo_target_type",
    "PreferredContentTypeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.preferred_content_type",
    "PriceExtensionPriceQualifierEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.price_extension_price_qualifier",
    "PriceExtensionPriceUnitEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.price_extension_price_unit",
    "PriceExtensionTypeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.price_extension_type",
    "PricePlaceholderFieldEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.price_placeholder_field",
    "ProductBiddingCategoryLevelEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.product_bidding_category_level",
    "ProductBiddingCategoryStatusEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.product_bidding_category_status",
    "ProductChannelEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.product_channel",
    "ProductChannelExclusivityEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.product_channel_exclusivity",
    "ProductConditionEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.product_condition",
    "ProductCustomAttributeIndexEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.product_custom_attribute_index",
    "ProductTypeLevelEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.product_type_level",
    "PromotionExtensionDiscountModifierEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.promotion_extension_discount_modifier",
    "PromotionExtensionOccasionEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.promotion_extension_occasion",
    "PromotionPlaceholderFieldEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.promotion_placeholder_field",
    "ProximityRadiusUnitsEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.proximity_radius_units",
    "QualityScoreBucketEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.quality_score_bucket",
    "ReachPlanAgeRangeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.reach_plan_age_range",
    "ReachPlanNetworkEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.reach_plan_network",
    "RealEstatePlaceholderFieldEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.real_estate_placeholder_field",
    "RecommendationTypeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.recommendation_type",
    "ResourceChangeOperationEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.resource_change_operation",
    "ResourceLimitTypeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.resource_limit_type",
    "ResponseContentTypeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.response_content_type",
    "SearchEngineResultsPageTypeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.search_engine_results_page_type",
    "SearchTermMatchTypeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.search_term_match_type",
    "SearchTermTargetingStatusEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.search_term_targeting_status",
    "SeasonalityEventScopeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.seasonality_event_scope",
    "SeasonalityEventStatusEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.seasonality_event_status",
    "ServedAssetFieldTypeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.served_asset_field_type",
    "SharedSetStatusEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.shared_set_status",
    "SharedSetTypeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.shared_set_type",
    "SimulationModificationMethodEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.simulation_modification_method",
    "SimulationTypeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.simulation_type",
    "SitelinkPlaceholderFieldEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.sitelink_placeholder_field",
    "SkAdNetworkAdEventTypeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.sk_ad_network_ad_event_type",
    "SkAdNetworkAttributionCreditEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.sk_ad_network_attribution_credit",
    "SkAdNetworkUserTypeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.sk_ad_network_user_type",
    "SlotEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.slot",
    "SpendingLimitTypeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.spending_limit_type",
    "StructuredSnippetPlaceholderFieldEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.structured_snippet_placeholder_field",
    "SummaryRowSettingEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.summary_row_setting",
    "SystemManagedResourceSourceEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.system_managed_entity_source",
    "TargetCpaOptInRecommendationGoalEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.target_cpa_opt_in_recommendation_goal",
    "TargetImpressionShareLocationEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.target_impression_share_location",
    "TargetingDimensionEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.targeting_dimension",
    "TimeTypeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.time_type",
    "TrackingCodePageFormatEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.tracking_code_page_format",
    "TrackingCodeTypeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.tracking_code_type",
    "TravelPlaceholderFieldEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.travel_placeholder_field",
    "UserIdentifierSourceEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.user_identifier_source",
    "UserInterestTaxonomyTypeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.user_interest_taxonomy_type",
    "UserListAccessStatusEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.user_list_access_status",
    "UserListClosingReasonEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.user_list_closing_reason",
    "UserListCombinedRuleOperatorEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.user_list_combined_rule_operator",
    "UserListCrmDataSourceTypeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.user_list_crm_data_source_type",
    "UserListDateRuleItemOperatorEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.user_list_date_rule_item_operator",
    "UserListFlexibleRuleOperatorEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.user_list_flexible_rule_operator",
    "UserListLogicalRuleOperatorEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.user_list_logical_rule_operator",
    "UserListMembershipStatusEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.user_list_membership_status",
    "UserListNumberRuleItemOperatorEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.user_list_number_rule_item_operator",
    "UserListPrepopulationStatusEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.user_list_prepopulation_status",
    "UserListRuleTypeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.user_list_rule_type",
    "UserListSizeRangeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.user_list_size_range",
    "UserListStringRuleItemOperatorEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.user_list_string_rule_item_operator",
    "UserListTypeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.user_list_type",
    "ValueRuleDeviceTypeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.value_rule_device_type",
    "ValueRuleGeoLocationMatchTypeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.value_rule_geo_location_match_type",
    "ValueRuleOperationEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.value_rule_operation",
    "ValueRuleSetAttachmentTypeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.value_rule_set_attachment_type",
    "ValueRuleSetDimensionEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.value_rule_set_dimension",
    "VanityPharmaDisplayUrlModeEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.vanity_pharma_display_url_mode",
    "VanityPharmaTextEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.vanity_pharma_text",
    "VideoThumbnailEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.video_thumbnail",
    "WebpageConditionOperandEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.webpage_condition_operand",
    "WebpageConditionOperatorEnum": "airflow.providers.google_vendor.googleads.v12.enums.types.webpage_condition_operator",
    "AccessInvitationErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.access_invitation_error",
    "AccountBudgetProposalErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.account_budget_proposal_error",
    "AccountLinkErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.account_link_error",
    "AdCustomizerErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.ad_customizer_error",
    "AdErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.ad_error",
    "AdGroupAdErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.ad_group_ad_error",
    "AdGroupBidModifierErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.ad_group_bid_modifier_error",
    "AdGroupCriterionCustomizerErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.ad_group_criterion_customizer_error",
    "AdGroupCriterionErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.ad_group_criterion_error",
    "AdGroupCustomizerErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.ad_group_customizer_error",
    "AdGroupErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.ad_group_error",
    "AdGroupFeedErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.ad_group_feed_error",
    "AdParameterErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.ad_parameter_error",
    "AdSharingErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.ad_sharing_error",
    "AdxErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.adx_error",
    "AssetErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.asset_error",
    "AssetGroupAssetErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.asset_group_asset_error",
    "AssetGroupErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.asset_group_error",
    "AssetGroupListingGroupFilterErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.asset_group_listing_group_filter_error",
    "AssetLinkErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.asset_link_error",
    "AssetSetAssetErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.asset_set_asset_error",
    "AssetSetErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.asset_set_error",
    "AssetSetLinkErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.asset_set_link_error",
    "AudienceErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.audience_error",
    "AudienceInsightsErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.audience_insights_error",
    "AuthenticationErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.authentication_error",
    "AuthorizationErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.authorization_error",
    "BatchJobErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.batch_job_error",
    "BiddingErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.bidding_error",
    "BiddingStrategyErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.bidding_strategy_error",
    "BillingSetupErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.billing_setup_error",
    "CampaignBudgetErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.campaign_budget_error",
    "CampaignConversionGoalErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.campaign_conversion_goal_error",
    "CampaignCriterionErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.campaign_criterion_error",
    "CampaignCustomizerErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.campaign_customizer_error",
    "CampaignDraftErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.campaign_draft_error",
    "CampaignErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.campaign_error",
    "CampaignExperimentErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.campaign_experiment_error",
    "CampaignFeedErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.campaign_feed_error",
    "CampaignSharedSetErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.campaign_shared_set_error",
    "ChangeEventErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.change_event_error",
    "ChangeStatusErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.change_status_error",
    "CollectionSizeErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.collection_size_error",
    "ContextErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.context_error",
    "ConversionActionErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.conversion_action_error",
    "ConversionAdjustmentUploadErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.conversion_adjustment_upload_error",
    "ConversionCustomVariableErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.conversion_custom_variable_error",
    "ConversionGoalCampaignConfigErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.conversion_goal_campaign_config_error",
    "ConversionUploadErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.conversion_upload_error",
    "ConversionValueRuleErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.conversion_value_rule_error",
    "ConversionValueRuleSetErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.conversion_value_rule_set_error",
    "CountryCodeErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.country_code_error",
    "CriterionErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.criterion_error",
    "CurrencyCodeErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.currency_code_error",
    "CustomAudienceErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.custom_audience_error",
    "CustomConversionGoalErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.custom_conversion_goal_error",
    "CustomerClientLinkErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.customer_client_link_error",
    "CustomerCustomizerErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.customer_customizer_error",
    "CustomerErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.customer_error",
    "CustomerFeedErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.customer_feed_error",
    "CustomerManagerLinkErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.customer_manager_link_error",
    "CustomerUserAccessErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.customer_user_access_error",
    "CustomInterestErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.custom_interest_error",
    "CustomizerAttributeErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.customizer_attribute_error",
    "DatabaseErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.database_error",
    "DateErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.date_error",
    "DateRangeErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.date_range_error",
    "DistinctErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.distinct_error",
    "EnumErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.enum_error",
    "ErrorCode": "airflow.providers.google_vendor.googleads.v12.errors.types.errors",
    "ErrorDetails": "airflow.providers.google_vendor.googleads.v12.errors.types.errors",
    "ErrorLocation": "airflow.providers.google_vendor.googleads.v12.errors.types.errors",
    "ExperimentArmErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.experiment_arm_error",
    "ExperimentErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.experiment_error",
    "ExtensionFeedItemErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.extension_feed_item_error",
    "ExtensionSettingErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.extension_setting_error",
    "FeedAttributeReferenceErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.feed_attribute_reference_error",
    "FeedErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.feed_error",
    "FeedItemErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.feed_item_error",
    "FeedItemSetErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.feed_item_set_error",
    "FeedItemSetLinkErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.feed_item_set_link_error",
    "FeedItemTargetErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.feed_item_target_error",
    "FeedItemValidationErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.feed_item_validation_error",
    "FeedMappingErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.feed_mapping_error",
    "FieldErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.field_error",
    "FieldMaskErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.field_mask_error",
    "FunctionErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.function_error",
    "FunctionParsingErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.function_parsing_error",
    "GeoTargetConstantSuggestionErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.geo_target_constant_suggestion_error",
    "GoogleAdsError": "airflow.providers.google_vendor.googleads.v12.errors.types.errors",
    "GoogleAdsFailure": "airflow.providers.google_vendor.googleads.v12.errors.types.errors",
    "HeaderErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.header_error",
    "IdErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.id_error",
    "ImageErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.image_error",
    "InternalErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.internal_error",
    "InvoiceErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.invoice_error",
    "KeywordPlanAdGroupErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.keyword_plan_ad_group_error",
    "KeywordPlanAdGroupKeywordErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.keyword_plan_ad_group_keyword_error",
    "KeywordPlanCampaignErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.keyword_plan_campaign_error",
    "KeywordPlanCampaignKeywordErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.keyword_plan_campaign_keyword_error",
    "KeywordPlanErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.keyword_plan_error",
    "KeywordPlanIdeaErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.keyword_plan_idea_error",
    "LabelErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.label_error",
    "LanguageCodeErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.language_code_error",
    "ListOperationErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.list_operation_error",
    "ManagerLinkErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.manager_link_error",
    "MediaBundleErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.media_bundle_error",
    "MediaFileErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.media_file_error",
    "MediaUploadErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.media_upload_error",
    "MerchantCenterErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.merchant_center_error",
    "MultiplierErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.multiplier_error",
    "MutateErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.mutate_error",
    "NewResourceCreationErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.new_resource_creation_error",
    "NotAllowlistedErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.not_allowlisted_error",
    "NotEmptyErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.not_empty_error",
    "NullErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.null_error",
    "OfflineUserDataJobErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.offline_user_data_job_error",
    "OperationAccessDeniedErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.operation_access_denied_error",
    "OperatorErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.operator_error",
    "PartialFailureErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.partial_failure_error",
    "PaymentsAccountErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.payments_account_error",
    "PolicyFindingDetails": "airflow.providers.google_vendor.googleads.v12.errors.types.errors",
    "PolicyFindingErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.policy_finding_error",
    "PolicyValidationParameterErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.policy_validation_parameter_error",
    "PolicyViolationDetails": "airflow.providers.google_vendor.googleads.v12.errors.types.errors",
    "PolicyViolationErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.policy_violation_error",
    "QueryErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.query_error",
    "QuotaErrorDetails": "airflow.providers.google_vendor.googleads.v12.errors.types.errors",
    "QuotaErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.quota_error",
    "RangeErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.range_error",
    "ReachPlanErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.reach_plan_error",
    "RecommendationErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.recommendation_error",
    "RegionCodeErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.region_code_error",
    "RequestErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.request_error",
    "ResourceAccessDeniedErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.resource_access_denied_error",
    "ResourceCountDetails": "airflow.providers.google_vendor.googleads.v12.errors.types.errors",
    "ResourceCountLimitExceededErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.resource_count_limit_exceeded_error",
    "SettingErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.setting_error",
    "SharedCriterionErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.shared_criterion_error",
    "SharedSetErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.shared_set_error",
    "SizeLimitErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.size_limit_error",
    "SmartCampaignErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.smart_campaign_error",
    "StringFormatErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.string_format_error",
    "StringLengthErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.string_length_error",
    "ThirdPartyAppAnalyticsLinkErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.third_party_app_analytics_link_error",
    "TimeZoneErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.time_zone_error",
    "UrlFieldErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.url_field_error",
    "UserDataErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.user_data_error",
    "UserListErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.user_list_error",
    "YoutubeVideoRegistrationErrorEnum": "airflow.providers.google_vendor.googleads.v12.errors.types.youtube_video_registration_error",
    "AccessibleBiddingStrategy": "airflow.providers.google_vendor.googleads.v12.resources.types.accessible_bidding_strategy",
    "AccountBudget": "airflow.providers.google_vendor.googleads.v12.resources.types.account_budget",
    "AccountBudgetProposal": "airflow.providers.google_vendor.googleads.v12.resources.types.account_budget_proposal",
    "AccountLink": "airflow.providers.google_vendor.googleads.v12.resources.types.account_link",
    "Ad": "airflow.providers.google_vendor.googleads.v12.resources.types.ad",
    "AdGroup": "airflow.providers.google_vendor.googleads.v12.resources.types.ad_group",
    "AdGroupAd": "airflow.providers.google_vendor.googleads.v12.resources.types.ad_group_ad",
    "AdGroupAdAssetCombinationView": "airflow.providers.google_vendor.googleads.v12.resources.types.ad_group_ad_asset_combination_view",
    "AdGroupAdAssetPolicySummary": "airflow.providers.google_vendor.googleads.v12.resources.types.ad_group_ad_asset_view",
    "AdGroupAdAssetView": "airflow.providers.google_vendor.googleads.v12.resources.types.ad_group_ad_asset_view",
    "AdGroupAdLabel": "airflow.providers.google_vendor.googleads.v12.resources.types.ad_group_ad_label",
    "AdGroupAdPolicySummary": "airflow.providers.google_vendor.googleads.v12.resources.types.ad_group_ad",
    "AdGroupAsset": "airflow.providers.google_vendor.googleads.v12.resources.types.ad_group_asset",
    "AdGroupAssetSet": "airflow.providers.google_vendor.googleads.v12.resources.types.ad_group_asset_set",
    "AdGroupAudienceView": "airflow.providers.google_vendor.googleads.v12.resources.types.ad_group_audience_view",
    "AdGroupBidModifier": "airflow.providers.google_vendor.googleads.v12.resources.types.ad_group_bid_modifier",
    "AdGroupCriterion": "airflow.providers.google_vendor.googleads.v12.resources.types.ad_group_criterion",
    "AdGroupCriterionCustomizer": "airflow.providers.google_vendor.googleads.v12.resources.types.ad_group_criterion_customizer",
    "AdGroupCriterionLabel": "airflow.providers.google_vendor.googleads.v12.resources.types.ad_group_criterion_label",
    "AdGroupCriterionSimulation": "airflow.providers.google_vendor.googleads.v12.resources.types.ad_group_criterion_simulation",
    "AdGroupCustomizer": "airflow.providers.google_vendor.googleads.v12.resources.types.ad_group_customizer",
    "AdGroupExtensionSetting": "airflow.providers.google_vendor.googleads.v12.resources.types.ad_group_extension_setting",
    "AdGroupFeed": "airflow.providers.google_vendor.googleads.v12.resources.types.ad_group_feed",
    "AdGroupLabel": "airflow.providers.google_vendor.googleads.v12.resources.types.ad_group_label",
    "AdGroupSimulation": "airflow.providers.google_vendor.googleads.v12.resources.types.ad_group_simulation",
    "AdParameter": "airflow.providers.google_vendor.googleads.v12.resources.types.ad_parameter",
    "AdScheduleView": "airflow.providers.google_vendor.googleads.v12.resources.types.ad_schedule_view",
    "AdvertisingPartnerLinkIdentifier": "airflow.providers.google_vendor.googleads.v12.resources.types.account_link",
    "AgeRangeView": "airflow.providers.google_vendor.googleads.v12.resources.types.age_range_view",
    "Asset": "airflow.providers.google_vendor.googleads.v12.resources.types.asset",
    "AssetFieldTypeView": "airflow.providers.google_vendor.googleads.v12.resources.types.asset_field_type_view",
    "AssetGroup": "airflow.providers.google_vendor.googleads.v12.resources.types.asset_group",
    "AssetGroupAsset": "airflow.providers.google_vendor.googleads.v12.resources.types.asset_group_asset",
    "AssetGroupListingGroupFilter": "airflow.providers.google_vendor.googleads.v12.resources.types.asset_group_listing_group_filter",
    "AssetGroupProductGroupView": "airflow.providers.google_vendor.googleads.v12.resources.types.asset_group_product_group_view",
    "AssetGroupSignal": "airflow.providers.google_vendor.googleads.v12.resources.types.asset_group_signal",
    "AssetPolicySummary": "airflow.providers.google_vendor.googleads.v12.resources.types.asset",
    "AssetSet": "airflow.providers.google_vendor.googleads.v12.resources.types.asset_set",
    "AssetSetAsset": "airflow.providers.google_vendor.googleads.v12.resources.types.asset_set_asset",
    "AssetSetTypeView": "airflow.providers.google_vendor.googleads.v12.resources.types.asset_set_type_view",
    "AttributeFieldMapping": "airflow.providers.google_vendor.googleads.v12.resources.types.feed_mapping",
    "Audience": "airflow.providers.google_vendor.googleads.v12.resources.types.audience",
    "BatchJob": "airflow.providers.google_vendor.googleads.v12.resources.types.batch_job",
    "BiddingDataExclusion": "airflow.providers.google_vendor.googleads.v12.resources.types.bidding_data_exclusion",
    "BiddingSeasonalityAdjustment": "airflow.providers.google_vendor.googleads.v12.resources.types.bidding_seasonality_adjustment",
    "BiddingStrategy": "airflow.providers.google_vendor.googleads.v12.resources.types.bidding_strategy",
    "BiddingStrategySimulation": "airflow.providers.google_vendor.googleads.v12.resources.types.bidding_strategy_simulation",
    "BillingSetup": "airflow.providers.google_vendor.googleads.v12.resources.types.billing_setup",
    "CallReportingSetting": "airflow.providers.google_vendor.googleads.v12.resources.types.customer",
    "CallView": "airflow.providers.google_vendor.googleads.v12.resources.types.call_view",
    "Campaign": "airflow.providers.google_vendor.googleads.v12.resources.types.campaign",
    "CampaignAsset": "airflow.providers.google_vendor.googleads.v12.resources.types.campaign_asset",
    "CampaignAssetSet": "airflow.providers.google_vendor.googleads.v12.resources.types.campaign_asset_set",
    "CampaignAudienceView": "airflow.providers.google_vendor.googleads.v12.resources.types.campaign_audience_view",
    "CampaignBidModifier": "airflow.providers.google_vendor.googleads.v12.resources.types.campaign_bid_modifier",
    "CampaignBudget": "airflow.providers.google_vendor.googleads.v12.resources.types.campaign_budget",
    "CampaignConversionGoal": "airflow.providers.google_vendor.googleads.v12.resources.types.campaign_conversion_goal",
    "CampaignCriterion": "airflow.providers.google_vendor.googleads.v12.resources.types.campaign_criterion",
    "CampaignCriterionSimulation": "airflow.providers.google_vendor.googleads.v12.resources.types.campaign_criterion_simulation",
    "CampaignCustomizer": "airflow.providers.google_vendor.googleads.v12.resources.types.campaign_customizer",
    "CampaignDraft": "airflow.providers.google_vendor.googleads.v12.resources.types.campaign_draft",
    "CampaignExtensionSetting": "airflow.providers.google_vendor.googleads.v12.resources.types.campaign_extension_setting",
    "CampaignFeed": "airflow.providers.google_vendor.googleads.v12.resources.types.campaign_feed",
    "CampaignGroup": "airflow.providers.google_vendor.googleads.v12.resources.types.campaign_group",
    "CampaignLabel": "airflow.providers.google_vendor.googleads.v12.resources.types.campaign_label",
    "CampaignSharedSet": "airflow.providers.google_vendor.googleads.v12.resources.types.campaign_shared_set",
    "CampaignSimulation": "airflow.providers.google_vendor.googleads.v12.resources.types.campaign_simulation",
    "CarrierConstant": "airflow.providers.google_vendor.googleads.v12.resources.types.carrier_constant",
    "ChangeEvent": "airflow.providers.google_vendor.googleads.v12.resources.types.change_event",
    "ChangeStatus": "airflow.providers.google_vendor.googleads.v12.resources.types.change_status",
    "ClickView": "airflow.providers.google_vendor.googleads.v12.resources.types.click_view",
    "CombinedAudience": "airflow.providers.google_vendor.googleads.v12.resources.types.combined_audience",
    "ConversionAction": "airflow.providers.google_vendor.googleads.v12.resources.types.conversion_action",
    "ConversionCustomVariable": "airflow.providers.google_vendor.googleads.v12.resources.types.conversion_custom_variable",
    "ConversionGoalCampaignConfig": "airflow.providers.google_vendor.googleads.v12.resources.types.conversion_goal_campaign_config",
    "ConversionTrackingSetting": "airflow.providers.google_vendor.googleads.v12.resources.types.customer",
    "ConversionValueRule": "airflow.providers.google_vendor.googleads.v12.resources.types.conversion_value_rule",
    "ConversionValueRuleSet": "airflow.providers.google_vendor.googleads.v12.resources.types.conversion_value_rule_set",
    "CurrencyConstant": "airflow.providers.google_vendor.googleads.v12.resources.types.currency_constant",
    "CustomAudience": "airflow.providers.google_vendor.googleads.v12.resources.types.custom_audience",
    "CustomAudienceMember": "airflow.providers.google_vendor.googleads.v12.resources.types.custom_audience",
    "CustomConversionGoal": "airflow.providers.google_vendor.googleads.v12.resources.types.custom_conversion_goal",
    "Customer": "airflow.providers.google_vendor.googleads.v12.resources.types.customer",
    "CustomerAsset": "airflow.providers.google_vendor.googleads.v12.resources.types.customer_asset",
    "CustomerAssetSet": "airflow.providers.google_vendor.googleads.v12.resources.types.customer_asset_set",
    "CustomerClient": "airflow.providers.google_vendor.googleads.v12.resources.types.customer_client",
    "CustomerClientLink": "airflow.providers.google_vendor.googleads.v12.resources.types.customer_client_link",
    "CustomerConversionGoal": "airflow.providers.google_vendor.googleads.v12.resources.types.customer_conversion_goal",
    "CustomerCustomizer": "airflow.providers.google_vendor.googleads.v12.resources.types.customer_customizer",
    "CustomerExtensionSetting": "airflow.providers.google_vendor.googleads.v12.resources.types.customer_extension_setting",
    "CustomerFeed": "airflow.providers.google_vendor.googleads.v12.resources.types.customer_feed",
    "CustomerLabel": "airflow.providers.google_vendor.googleads.v12.resources.types.customer_label",
    "CustomerManagerLink": "airflow.providers.google_vendor.googleads.v12.resources.types.customer_manager_link",
    "CustomerNegativeCriterion": "airflow.providers.google_vendor.googleads.v12.resources.types.customer_negative_criterion",
    "CustomerUserAccess": "airflow.providers.google_vendor.googleads.v12.resources.types.customer_user_access",
    "CustomerUserAccessInvitation": "airflow.providers.google_vendor.googleads.v12.resources.types.customer_user_access_invitation",
    "CustomInterest": "airflow.providers.google_vendor.googleads.v12.resources.types.custom_interest",
    "CustomInterestMember": "airflow.providers.google_vendor.googleads.v12.resources.types.custom_interest",
    "CustomizerAttribute": "airflow.providers.google_vendor.googleads.v12.resources.types.customizer_attribute",
    "CustomLeadFormSubmissionField": "airflow.providers.google_vendor.googleads.v12.resources.types.lead_form_submission_data",
    "DataPartnerLinkIdentifier": "airflow.providers.google_vendor.googleads.v12.resources.types.account_link",
    "DetailedDemographic": "airflow.providers.google_vendor.googleads.v12.resources.types.detailed_demographic",
    "DetailPlacementView": "airflow.providers.google_vendor.googleads.v12.resources.types.detail_placement_view",
    "DisplayKeywordView": "airflow.providers.google_vendor.googleads.v12.resources.types.display_keyword_view",
    "DistanceView": "airflow.providers.google_vendor.googleads.v12.resources.types.distance_view",
    "DomainCategory": "airflow.providers.google_vendor.googleads.v12.resources.types.domain_category",
    "DynamicSearchAdsSearchTermView": "airflow.providers.google_vendor.googleads.v12.resources.types.dynamic_search_ads_search_term_view",
    "ExpandedLandingPageView": "airflow.providers.google_vendor.googleads.v12.resources.types.expanded_landing_page_view",
    "Experiment": "airflow.providers.google_vendor.googleads.v12.resources.types.experiment",
    "ExperimentArm": "airflow.providers.google_vendor.googleads.v12.resources.types.experiment_arm",
    "ExtensionFeedItem": "airflow.providers.google_vendor.googleads.v12.resources.types.extension_feed_item",
    "Feed": "airflow.providers.google_vendor.googleads.v12.resources.types.feed",
    "FeedAttribute": "airflow.providers.google_vendor.googleads.v12.resources.types.feed",
    "FeedAttributeOperation": "airflow.providers.google_vendor.googleads.v12.resources.types.feed",
    "FeedItem": "airflow.providers.google_vendor.googleads.v12.resources.types.feed_item",
    "FeedItemAttributeValue": "airflow.providers.google_vendor.googleads.v12.resources.types.feed_item",
    "FeedItemPlaceholderPolicyInfo": "airflow.providers.google_vendor.googleads.v12.resources.types.feed_item",
    "FeedItemSet": "airflow.providers.google_vendor.googleads.v12.resources.types.feed_item_set",
    "FeedItemSetLink": "airflow.providers.google_vendor.googleads.v12.resources.types.feed_item_set_link",
    "FeedItemTarget": "airflow.providers.google_vendor.googleads.v12.resources.types.feed_item_target",
    "FeedItemValidationError": "airflow.providers.google_vendor.googleads.v12.resources.types.feed_item",
    "FeedMapping": "airflow.providers.google_vendor.googleads.v12.resources.types.feed_mapping",
    "FeedPlaceholderView": "airflow.providers.google_vendor.googleads.v12.resources.types.feed_placeholder_view",
    "GenderView": "airflow.providers.google_vendor.googleads.v12.resources.types.gender_view",
    "GeographicView": "airflow.providers.google_vendor.googleads.v12.resources.types.geographic_view",
    "GeoTargetConstant": "airflow.providers.google_vendor.googleads.v12.resources.types.geo_target_constant",
    "GoogleAdsField": "airflow.providers.google_vendor.googleads.v12.resources.types.google_ads_field",
    "GoogleAdsLinkIdentifier": "airflow.providers.google_vendor.googleads.v12.resources.types.account_link",
    "GroupPlacementView": "airflow.providers.google_vendor.googleads.v12.resources.types.group_placement_view",
    "HotelCenterLinkIdentifier": "airflow.providers.google_vendor.googleads.v12.resources.types.account_link",
    "HotelGroupView": "airflow.providers.google_vendor.googleads.v12.resources.types.hotel_group_view",
    "HotelPerformanceView": "airflow.providers.google_vendor.googleads.v12.resources.types.hotel_performance_view",
    "HotelReconciliation": "airflow.providers.google_vendor.googleads.v12.resources.types.hotel_reconciliation",
    "IncomeRangeView": "airflow.providers.google_vendor.googleads.v12.resources.types.income_range_view",
    "Invoice": "airflow.providers.google_vendor.googleads.v12.resources.types.invoice",
    "KeywordPlan": "airflow.providers.google_vendor.googleads.v12.resources.types.keyword_plan",
    "KeywordPlanAdGroup": "airflow.providers.google_vendor.googleads.v12.resources.types.keyword_plan_ad_group",
    "KeywordPlanAdGroupKeyword": "airflow.providers.google_vendor.googleads.v12.resources.types.keyword_plan_ad_group_keyword",
    "KeywordPlanCampaign": "airflow.providers.google_vendor.googleads.v12.resources.types.keyword_plan_campaign",
    "KeywordPlanCampaignKeyword": "airflow.providers.google_vendor.googleads.v12.resources.types.keyword_plan_campaign_keyword",
    "KeywordPlanForecastPeriod": "airflow.providers.google_vendor.googleads.v12.resources.types.keyword_plan",
    "KeywordPlanGeoTarget": "airflow.providers.google_vendor.googleads.v12.resources.types.keyword_plan_campaign",
    "KeywordThemeConstant": "airflow.providers.google_vendor.googleads.v12.resources.types.keyword_theme_constant",
    "KeywordView": "airflow.providers.google_vendor.googleads.v12.resources.types.keyword_view",
    "Label": "airflow.providers.google_vendor.googleads.v12.resources.types.label",
    "LandingPageView": "airflow.providers.google_vendor.googleads.v12.resources.types.landing_page_view",
    "LanguageConstant": "airflow.providers.google_vendor.googleads.v12.resources.types.language_constant",
    "LeadFormSubmissionData": "airflow.providers.google_vendor.googleads.v12.resources.types.lead_form_submission_data",
    "LeadFormSubmissionField": "airflow.providers.google_vendor.googleads.v12.resources.types.lead_form_submission_data",
    "LifeEvent": "airflow.providers.google_vendor.googleads.v12.resources.types.life_event",
    "ListingGroupFilterDimension": "airflow.providers.google_vendor.googleads.v12.resources.types.asset_group_listing_group_filter",
    "LocationView": "airflow.providers.google_vendor.googleads.v12.resources.types.location_view",
    "ManagedPlacementView": "airflow.providers.google_vendor.googleads.v12.resources.types.managed_placement_view",
    "MediaAudio": "airflow.providers.google_vendor.googleads.v12.resources.types.media_file",
    "MediaBundle": "airflow.providers.google_vendor.googleads.v12.resources.types.media_file",
    "MediaFile": "airflow.providers.google_vendor.googleads.v12.resources.types.media_file",
    "MediaImage": "airflow.providers.google_vendor.googleads.v12.resources.types.media_file",
    "MediaVideo": "airflow.providers.google_vendor.googleads.v12.resources.types.media_file",
    "MerchantCenterLink": "airflow.providers.google_vendor.googleads.v12.resources.types.merchant_center_link",
    "MobileAppCategoryConstant": "airflow.providers.google_vendor.googleads.v12.resources.types.mobile_app_category_constant",
    "MobileDeviceConstant": "airflow.providers.google_vendor.googleads.v12.resources.types.mobile_device_constant",
    "OfflineUserDataJob": "airflow.providers.google_vendor.googleads.v12.resources.types.offline_user_data_job",
    "OfflineUserDataJobMetadata": "airflow.providers.google_vendor.googleads.v12.resources.types.offline_user_data_job",
    "OperatingSystemVersionConstant": "airflow.providers.google_vendor.googleads.v12.resources.types.operating_system_version_constant",
    "PaidOrganicSearchTermView": "airflow.providers.google_vendor.googleads.v12.resources.types.paid_organic_search_term_view",
    "ParentalStatusView": "airflow.providers.google_vendor.googleads.v12.resources.types.parental_status_view",
    "PaymentsAccount": "airflow.providers.google_vendor.googleads.v12.resources.types.payments_account",
    "PerStoreView": "airflow.providers.google_vendor.googleads.v12.resources.types.per_store_view",
    "ProductBiddingCategoryConstant": "airflow.providers.google_vendor.googleads.v12.resources.types.product_bidding_category_constant",
    "ProductGroupView": "airflow.providers.google_vendor.googleads.v12.resources.types.product_group_view",
    "Recommendation": "airflow.providers.google_vendor.googleads.v12.resources.types.recommendation",
    "RemarketingAction": "airflow.providers.google_vendor.googleads.v12.resources.types.remarketing_action",
    "RemarketingSetting": "airflow.providers.google_vendor.googleads.v12.resources.types.customer",
    "SearchTermView": "airflow.providers.google_vendor.googleads.v12.resources.types.search_term_view",
    "SharedCriterion": "airflow.providers.google_vendor.googleads.v12.resources.types.shared_criterion",
    "SharedSet": "airflow.providers.google_vendor.googleads.v12.resources.types.shared_set",
    "ShoppingPerformanceView": "airflow.providers.google_vendor.googleads.v12.resources.types.shopping_performance_view",
    "SmartCampaignSearchTermView": "airflow.providers.google_vendor.googleads.v12.resources.types.smart_campaign_search_term_view",
    "SmartCampaignSetting": "airflow.providers.google_vendor.googleads.v12.resources.types.smart_campaign_setting",
    "ThirdPartyAppAnalyticsLink": "airflow.providers.google_vendor.googleads.v12.resources.types.third_party_app_analytics_link",
    "ThirdPartyAppAnalyticsLinkIdentifier": "airflow.providers.google_vendor.googleads.v12.resources.types.account_link",
    "TopicConstant": "airflow.providers.google_vendor.googleads.v12.resources.types.topic_constant",
    "TopicView": "airflow.providers.google_vendor.googleads.v12.resources.types.topic_view",
    "UserInterest": "airflow.providers.google_vendor.googleads.v12.resources.types.user_interest",
    "UserList": "airflow.providers.google_vendor.googleads.v12.resources.types.user_list",
    "UserLocationView": "airflow.providers.google_vendor.googleads.v12.resources.types.user_location_view",
    "Video": "airflow.providers.google_vendor.googleads.v12.resources.types.video",
    "WebpageView": "airflow.providers.google_vendor.googleads.v12.resources.types.webpage_view",
    "AccountBudgetProposalOperation": "airflow.providers.google_vendor.googleads.v12.services.types.account_budget_proposal_service",
    "AccountLinkOperation": "airflow.providers.google_vendor.googleads.v12.services.types.account_link_service",
    "AddBatchJobOperationsRequest": "airflow.providers.google_vendor.googleads.v12.services.types.batch_job_service",
    "AddBatchJobOperationsResponse": "airflow.providers.google_vendor.googleads.v12.services.types.batch_job_service",
    "AddOfflineUserDataJobOperationsRequest": "airflow.providers.google_vendor.googleads.v12.services.types.offline_user_data_job_service",
    "AddOfflineUserDataJobOperationsResponse": "airflow.providers.google_vendor.googleads.v12.services.types.offline_user_data_job_service",
    "AdGroupAdLabelOperation": "airflow.providers.google_vendor.googleads.v12.services.types.ad_group_ad_label_service",
    "AdGroupAdOperation": "airflow.providers.google_vendor.googleads.v12.services.types.ad_group_ad_service",
    "AdGroupAssetOperation": "airflow.providers.google_vendor.googleads.v12.services.types.ad_group_asset_service",
    "AdGroupAssetSetOperation": "airflow.providers.google_vendor.googleads.v12.services.types.ad_group_asset_set_service",
    "AdGroupBidModifierOperation": "airflow.providers.google_vendor.googleads.v12.services.types.ad_group_bid_modifier_service",
    "AdGroupCriterionCustomizerOperation": "airflow.providers.google_vendor.googleads.v12.services.types.ad_group_criterion_customizer_service",
    "AdGroupCriterionLabelOperation": "airflow.providers.google_vendor.googleads.v12.services.types.ad_group_criterion_label_service",
    "AdGroupCriterionOperation": "airflow.providers.google_vendor.googleads.v12.services.types.ad_group_criterion_service",
    "AdGroupCustomizerOperation": "airflow.providers.google_vendor.googleads.v12.services.types.ad_group_customizer_service",
    "AdGroupExtensionSettingOperation": "airflow.providers.google_vendor.googleads.v12.services.types.ad_group_extension_setting_service",
    "AdGroupFeedOperation": "airflow.providers.google_vendor.googleads.v12.services.types.ad_group_feed_service",
    "AdGroupKeywordSuggestion": "airflow.providers.google_vendor.googleads.v12.services.types.keyword_plan_idea_service",
    "AdGroupLabelOperation": "airflow.providers.google_vendor.googleads.v12.services.types.ad_group_label_service",
    "AdGroupOperation": "airflow.providers.google_vendor.googleads.v12.services.types.ad_group_service",
    "AdOperation": "airflow.providers.google_vendor.googleads.v12.services.types.ad_service",
    "AdParameterOperation": "airflow.providers.google_vendor.googleads.v12.services.types.ad_parameter_service",
    "AdvancedProductTargeting": "airflow.providers.google_vendor.googleads.v12.services.types.reach_plan_service",
    "ApplyRecommendationOperation": "airflow.providers.google_vendor.googleads.v12.services.types.recommendation_service",
    "ApplyRecommendationRequest": "airflow.providers.google_vendor.googleads.v12.services.types.recommendation_service",
    "ApplyRecommendationResponse": "airflow.providers.google_vendor.googleads.v12.services.types.recommendation_service",
    "ApplyRecommendationResult": "airflow.providers.google_vendor.googleads.v12.services.types.recommendation_service",
    "AssetGroupAssetOperation": "airflow.providers.google_vendor.googleads.v12.services.types.asset_group_asset_service",
    "AssetGroupListingGroupFilterOperation": "airflow.providers.google_vendor.googleads.v12.services.types.asset_group_listing_group_filter_service",
    "AssetGroupOperation": "airflow.providers.google_vendor.googleads.v12.services.types.asset_group_service",
    "AssetGroupSignalOperation": "airflow.providers.google_vendor.googleads.v12.services.types.asset_group_signal_service",
    "AssetOperation": "airflow.providers.google_vendor.googleads.v12.services.types.asset_service",
    "AssetSetAssetOperation": "airflow.providers.google_vendor.googleads.v12.services.types.asset_set_asset_service",
    "AssetSetOperation": "airflow.providers.google_vendor.googleads.v12.services.types.asset_set_service",
    "AudienceCompositionAttribute": "airflow.providers.google_vendor.googleads.v12.services.types.audience_insights_service",
    "AudienceCompositionAttributeCluster": "airflow.providers.google_vendor.googleads.v12.services.types.audience_insights_service",
    "AudienceCompositionMetrics": "airflow.providers.google_vendor.googleads.v12.services.types.audience_insights_service",
    "AudienceCompositionSection": "airflow.providers.google_vendor.googleads.v12.services.types.audience_insights_service",
    "AudienceInsightsAttribute": "airflow.providers.google_vendor.googleads.v12.services.types.audience_insights_service",
    "AudienceInsightsAttributeMetadata": "airflow.providers.google_vendor.googleads.v12.services.types.audience_insights_service",
    "AudienceInsightsCategory": "airflow.providers.google_vendor.googleads.v12.services.types.audience_insights_service",
    "AudienceInsightsDynamicLineup": "airflow.providers.google_vendor.googleads.v12.services.types.audience_insights_service",
    "AudienceInsightsEntity": "airflow.providers.google_vendor.googleads.v12.services.types.audience_insights_service",
    "AudienceInsightsTopic": "airflow.providers.google_vendor.googleads.v12.services.types.audience_insights_service",
    "AudienceOperation": "airflow.providers.google_vendor.googleads.v12.services.types.audience_service",
    "AudienceTargeting": "airflow.providers.google_vendor.googleads.v12.services.types.reach_plan_service",
    "BasicInsightsAudience": "airflow.providers.google_vendor.googleads.v12.services.types.audience_insights_service",
    "BatchJobOperation": "airflow.providers.google_vendor.googleads.v12.services.types.batch_job_service",
    "BatchJobResult": "airflow.providers.google_vendor.googleads.v12.services.types.batch_job_service",
    "BiddingDataExclusionOperation": "airflow.providers.google_vendor.googleads.v12.services.types.bidding_data_exclusion_service",
    "BiddingSeasonalityAdjustmentOperation": "airflow.providers.google_vendor.googleads.v12.services.types.bidding_seasonality_adjustment_service",
    "BiddingStrategyOperation": "airflow.providers.google_vendor.googleads.v12.services.types.bidding_strategy_service",
    "BillingSetupOperation": "airflow.providers.google_vendor.googleads.v12.services.types.billing_setup_service",
    "CallConversion": "airflow.providers.google_vendor.googleads.v12.services.types.conversion_upload_service",
    "CallConversionResult": "airflow.providers.google_vendor.googleads.v12.services.types.conversion_upload_service",
    "CampaignAssetOperation": "airflow.providers.google_vendor.googleads.v12.services.types.campaign_asset_service",
    "CampaignAssetSetOperation": "airflow.providers.google_vendor.googleads.v12.services.types.campaign_asset_set_service",
    "CampaignBidModifierOperation": "airflow.providers.google_vendor.googleads.v12.services.types.campaign_bid_modifier_service",
    "CampaignBudgetMapping": "airflow.providers.google_vendor.googleads.v12.services.types.experiment_service",
    "CampaignBudgetOperation": "airflow.providers.google_vendor.googleads.v12.services.types.campaign_budget_service",
    "CampaignConversionGoalOperation": "airflow.providers.google_vendor.googleads.v12.services.types.campaign_conversion_goal_service",
    "CampaignCriterionOperation": "airflow.providers.google_vendor.googleads.v12.services.types.campaign_criterion_service",
    "CampaignCustomizerOperation": "airflow.providers.google_vendor.googleads.v12.services.types.campaign_customizer_service",
    "CampaignDraftOperation": "airflow.providers.google_vendor.googleads.v12.services.types.campaign_draft_service",
    "CampaignDuration": "airflow.providers.google_vendor.googleads.v12.services.types.reach_plan_service",
    "CampaignExtensionSettingOperation": "airflow.providers.google_vendor.googleads.v12.services.types.campaign_extension_setting_service",
    "CampaignFeedOperation": "airflow.providers.google_vendor.googleads.v12.services.types.campaign_feed_service",
    "CampaignGroupOperation": "airflow.providers.google_vendor.googleads.v12.services.types.campaign_group_service",
    "CampaignLabelOperation": "airflow.providers.google_vendor.googleads.v12.services.types.campaign_label_service",
    "CampaignOperation": "airflow.providers.google_vendor.googleads.v12.services.types.campaign_service",
    "CampaignSharedSetOperation": "airflow.providers.google_vendor.googleads.v12.services.types.campaign_shared_set_service",
    "CartData": "airflow.providers.google_vendor.googleads.v12.services.types.conversion_upload_service",
    "ClickConversion": "airflow.providers.google_vendor.googleads.v12.services.types.conversion_upload_service",
    "ClickConversionResult": "airflow.providers.google_vendor.googleads.v12.services.types.conversion_upload_service",
    "ConversionActionOperation": "airflow.providers.google_vendor.googleads.v12.services.types.conversion_action_service",
    "ConversionAdjustment": "airflow.providers.google_vendor.googleads.v12.services.types.conversion_adjustment_upload_service",
    "ConversionAdjustmentResult": "airflow.providers.google_vendor.googleads.v12.services.types.conversion_adjustment_upload_service",
    "ConversionCustomVariableOperation": "airflow.providers.google_vendor.googleads.v12.services.types.conversion_custom_variable_service",
    "ConversionGoalCampaignConfigOperation": "airflow.providers.google_vendor.googleads.v12.services.types.conversion_goal_campaign_config_service",
    "ConversionValueRuleOperation": "airflow.providers.google_vendor.googleads.v12.services.types.conversion_value_rule_service",
    "ConversionValueRuleSetOperation": "airflow.providers.google_vendor.googleads.v12.services.types.conversion_value_rule_set_service",
    "CreateAccountLinkRequest": "airflow.providers.google_vendor.googleads.v12.services.types.account_link_service",
    "CreateAccountLinkResponse": "airflow.providers.google_vendor.googleads.v12.services.types.account_link_service",
    "CreateCustomerClientRequest": "airflow.providers.google_vendor.googleads.v12.services.types.customer_service",
    "CreateCustomerClientResponse": "airflow.providers.google_vendor.googleads.v12.services.types.customer_service",
    "CreateOfflineUserDataJobRequest": "airflow.providers.google_vendor.googleads.v12.services.types.offline_user_data_job_service",
    "CreateOfflineUserDataJobResponse": "airflow.providers.google_vendor.googleads.v12.services.types.offline_user_data_job_service",
    "CustomAudienceOperation": "airflow.providers.google_vendor.googleads.v12.services.types.custom_audience_service",
    "CustomConversionGoalOperation": "airflow.providers.google_vendor.googleads.v12.services.types.custom_conversion_goal_service",
    "CustomerAssetOperation": "airflow.providers.google_vendor.googleads.v12.services.types.customer_asset_service",
    "CustomerAssetSetOperation": "airflow.providers.google_vendor.googleads.v12.services.types.customer_asset_set_service",
    "CustomerClientLinkOperation": "airflow.providers.google_vendor.googleads.v12.services.types.customer_client_link_service",
    "CustomerConversionGoalOperation": "airflow.providers.google_vendor.googleads.v12.services.types.customer_conversion_goal_service",
    "CustomerCustomizerOperation": "airflow.providers.google_vendor.googleads.v12.services.types.customer_customizer_service",
    "CustomerExtensionSettingOperation": "airflow.providers.google_vendor.googleads.v12.services.types.customer_extension_setting_service",
    "CustomerFeedOperation": "airflow.providers.google_vendor.googleads.v12.services.types.customer_feed_service",
    "CustomerLabelOperation": "airflow.providers.google_vendor.googleads.v12.services.types.customer_label_service",
    "CustomerManagerLinkOperation": "airflow.providers.google_vendor.googleads.v12.services.types.customer_manager_link_service",
    "CustomerNegativeCriterionOperation": "airflow.providers.google_vendor.googleads.v12.services.types.customer_negative_criterion_service",
    "CustomerOperation": "airflow.providers.google_vendor.googleads.v12.services.types.customer_service",
    "CustomerUserAccessInvitationOperation": "airflow.providers.google_vendor.googleads.v12.services.types.customer_user_access_invitation_service",
    "CustomerUserAccessOperation": "airflow.providers.google_vendor.googleads.v12.services.types.customer_user_access_service",
    "CustomInterestOperation": "airflow.providers.google_vendor.googleads.v12.services.types.custom_interest_service",
    "CustomizerAttributeOperation": "airflow.providers.google_vendor.googleads.v12.services.types.customizer_attribute_service",
    "CustomVariable": "airflow.providers.google_vendor.googleads.v12.services.types.conversion_upload_service",
    "DismissRecommendationRequest": "airflow.providers.google_vendor.googleads.v12.services.types.recommendation_service",
    "DismissRecommendationResponse": "airflow.providers.google_vendor.googleads.v12.services.types.recommendation_service",
    "DynamicLineupAttributeMetadata": "airflow.providers.google_vendor.googleads.v12.services.types.audience_insights_service",
    "EffectiveFrequencyBreakdown": "airflow.providers.google_vendor.googleads.v12.services.types.reach_plan_service",
    "EffectiveFrequencyLimit": "airflow.providers.google_vendor.googleads.v12.services.types.reach_plan_service",
    "EndExperimentRequest": "airflow.providers.google_vendor.googleads.v12.services.types.experiment_service",
    "ExperimentArmOperation": "airflow.providers.google_vendor.googleads.v12.services.types.experiment_arm_service",
    "ExperimentOperation": "airflow.providers.google_vendor.googleads.v12.services.types.experiment_service",
    "ExtensionFeedItemOperation": "airflow.providers.google_vendor.googleads.v12.services.types.extension_feed_item_service",
    "ExternalAttributionData": "airflow.providers.google_vendor.googleads.v12.services.types.conversion_upload_service",
    "FeedItemOperation": "airflow.providers.google_vendor.googleads.v12.services.types.feed_item_service",
    "FeedItemSetLinkOperation": "airflow.providers.google_vendor.googleads.v12.services.types.feed_item_set_link_service",
    "FeedItemSetOperation": "airflow.providers.google_vendor.googleads.v12.services.types.feed_item_set_service",
    "FeedItemTargetOperation": "airflow.providers.google_vendor.googleads.v12.services.types.feed_item_target_service",
    "FeedMappingOperation": "airflow.providers.google_vendor.googleads.v12.services.types.feed_mapping_service",
    "FeedOperation": "airflow.providers.google_vendor.googleads.v12.services.types.feed_service",
    "Forecast": "airflow.providers.google_vendor.googleads.v12.services.types.reach_plan_service",
    "ForecastMetricOptions": "airflow.providers.google_vendor.googleads.v12.services.types.reach_plan_service",
    "ForecastMetrics": "airflow.providers.google_vendor.googleads.v12.services.types.keyword_plan_service",
    "FrequencyCap": "airflow.providers.google_vendor.googleads.v12.services.types.reach_plan_service",
    "GclidDateTimePair": "airflow.providers.google_vendor.googleads.v12.services.types.conversion_adjustment_upload_service",
    "GenerateAdGroupThemesRequest": "airflow.providers.google_vendor.googleads.v12.services.types.keyword_plan_idea_service",
    "GenerateAdGroupThemesResponse": "airflow.providers.google_vendor.googleads.v12.services.types.keyword_plan_idea_service",
    "GenerateAudienceCompositionInsightsRequest": "airflow.providers.google_vendor.googleads.v12.services.types.audience_insights_service",
    "GenerateAudienceCompositionInsightsResponse": "airflow.providers.google_vendor.googleads.v12.services.types.audience_insights_service",
    "GenerateForecastCurveRequest": "airflow.providers.google_vendor.googleads.v12.services.types.keyword_plan_service",
    "GenerateForecastCurveResponse": "airflow.providers.google_vendor.googleads.v12.services.types.keyword_plan_service",
    "GenerateForecastMetricsRequest": "airflow.providers.google_vendor.googleads.v12.services.types.keyword_plan_service",
    "GenerateForecastMetricsResponse": "airflow.providers.google_vendor.googleads.v12.services.types.keyword_plan_service",
    "GenerateForecastTimeSeriesRequest": "airflow.providers.google_vendor.googleads.v12.services.types.keyword_plan_service",
    "GenerateForecastTimeSeriesResponse": "airflow.providers.google_vendor.googleads.v12.services.types.keyword_plan_service",
    "GenerateHistoricalMetricsRequest": "airflow.providers.google_vendor.googleads.v12.services.types.keyword_plan_service",
    "GenerateHistoricalMetricsResponse": "airflow.providers.google_vendor.googleads.v12.services.types.keyword_plan_service",
    "GenerateInsightsFinderReportRequest": "airflow.providers.google_vendor.googleads.v12.services.types.audience_insights_service",
    "GenerateInsightsFinderReportResponse": "airflow.providers.google_vendor.googleads.v12.services.types.audience_insights_service",
    "GenerateKeywordHistoricalMetricsRequest": "airflow.providers.google_vendor.googleads.v12.services.types.keyword_plan_idea_service",
    "GenerateKeywordHistoricalMetricsResponse": "airflow.providers.google_vendor.googleads.v12.services.types.keyword_plan_idea_service",
    "GenerateKeywordHistoricalMetricsResult": "airflow.providers.google_vendor.googleads.v12.services.types.keyword_plan_idea_service",
    "GenerateKeywordIdeaResponse": "airflow.providers.google_vendor.googleads.v12.services.types.keyword_plan_idea_service",
    "GenerateKeywordIdeaResult": "airflow.providers.google_vendor.googleads.v12.services.types.keyword_plan_idea_service",
    "GenerateKeywordIdeasRequest": "airflow.providers.google_vendor.googleads.v12.services.types.keyword_plan_idea_service",
    "GenerateReachForecastRequest": "airflow.providers.google_vendor.googleads.v12.services.types.reach_plan_service",
    "GenerateReachForecastResponse": "airflow.providers.google_vendor.googleads.v12.services.types.reach_plan_service",
    "GeoTargetConstantSuggestion": "airflow.providers.google_vendor.googleads.v12.services.types.geo_target_constant_service",
    "GetAdRequest": "airflow.providers.google_vendor.googleads.v12.services.types.ad_service",
    "GetGoogleAdsFieldRequest": "airflow.providers.google_vendor.googleads.v12.services.types.google_ads_field_service",
    "GetMerchantCenterLinkRequest": "airflow.providers.google_vendor.googleads.v12.services.types.merchant_center_link_service",
    "GoogleAdsRow": "airflow.providers.google_vendor.googleads.v12.services.types.google_ads_service",
    "GraduateExperimentRequest": "airflow.providers.google_vendor.googleads.v12.services.types.experiment_service",
    "InsightsAudience": "airflow.providers.google_vendor.googleads.v12.services.types.audience_insights_service",
    "InsightsAudienceAttributeGroup": "airflow.providers.google_vendor.googleads.v12.services.types.audience_insights_service",
    "KeywordAndUrlSeed": "airflow.providers.google_vendor.googleads.v12.services.types.keyword_plan_idea_service",
    "KeywordPlanAdGroupForecast": "airflow.providers.google_vendor.googleads.v12.services.types.keyword_plan_service",
    "KeywordPlanAdGroupKeywordOperation": "airflow.providers.google_vendor.googleads.v12.services.types.keyword_plan_ad_group_keyword_service",
    "KeywordPlanAdGroupOperation": "airflow.providers.google_vendor.googleads.v12.services.types.keyword_plan_ad_group_service",
    "KeywordPlanCampaignForecast": "airflow.providers.google_vendor.googleads.v12.services.types.keyword_plan_service",
    "KeywordPlanCampaignForecastCurve": "airflow.providers.google_vendor.googleads.v12.services.types.keyword_plan_service",
    "KeywordPlanCampaignKeywordOperation": "airflow.providers.google_vendor.googleads.v12.services.types.keyword_plan_campaign_keyword_service",
    "KeywordPlanCampaignOperation": "airflow.providers.google_vendor.googleads.v12.services.types.keyword_plan_campaign_service",
    "KeywordPlanKeywordForecast": "airflow.providers.google_vendor.googleads.v12.services.types.keyword_plan_service",
    "KeywordPlanKeywordHistoricalMetrics": "airflow.providers.google_vendor.googleads.v12.services.types.keyword_plan_service",
    "KeywordPlanMaxCpcBidForecast": "airflow.providers.google_vendor.googleads.v12.services.types.keyword_plan_service",
    "KeywordPlanMaxCpcBidForecastCurve": "airflow.providers.google_vendor.googleads.v12.services.types.keyword_plan_service",
    "KeywordPlanOperation": "airflow.providers.google_vendor.googleads.v12.services.types.keyword_plan_service",
    "KeywordPlanWeeklyForecast": "airflow.providers.google_vendor.googleads.v12.services.types.keyword_plan_service",
    "KeywordPlanWeeklyTimeSeriesForecast": "airflow.providers.google_vendor.googleads.v12.services.types.keyword_plan_service",
    "KeywordSeed": "airflow.providers.google_vendor.googleads.v12.services.types.keyword_plan_idea_service",
    "LabelOperation": "airflow.providers.google_vendor.googleads.v12.services.types.label_service",
    "ListAccessibleCustomersRequest": "airflow.providers.google_vendor.googleads.v12.services.types.customer_service",
    "ListAccessibleCustomersResponse": "airflow.providers.google_vendor.googleads.v12.services.types.customer_service",
    "ListAudienceInsightsAttributesRequest": "airflow.providers.google_vendor.googleads.v12.services.types.audience_insights_service",
    "ListAudienceInsightsAttributesResponse": "airflow.providers.google_vendor.googleads.v12.services.types.audience_insights_service",
    "ListBatchJobResultsRequest": "airflow.providers.google_vendor.googleads.v12.services.types.batch_job_service",
    "ListBatchJobResultsResponse": "airflow.providers.google_vendor.googleads.v12.services.types.batch_job_service",
    "ListCampaignDraftAsyncErrorsRequest": "airflow.providers.google_vendor.googleads.v12.services.types.campaign_draft_service",
    "ListCampaignDraftAsyncErrorsResponse": "airflow.providers.google_vendor.googleads.v12.services.types.campaign_draft_service",
    "ListExperimentAsyncErrorsRequest": "airflow.providers.google_vendor.googleads.v12.services.types.experiment_service",
    "ListExperimentAsyncErrorsResponse": "airflow.providers.google_vendor.googleads.v12.services.types.experiment_service",
    "ListInsightsEligibleDatesRequest": "airflow.providers.google_vendor.googleads.v12.services.types.audience_insights_service",
    "ListInsightsEligibleDatesResponse": "airflow.providers.google_vendor.googleads.v12.services.types.audience_insights_service",
    "ListInvoicesRequest": "airflow.providers.google_vendor.googleads.v12.services.types.invoice_service",
    "ListInvoicesResponse": "airflow.providers.google_vendor.googleads.v12.services.types.invoice_service",
    "ListMerchantCenterLinksRequest": "airflow.providers.google_vendor.googleads.v12.services.types.merchant_center_link_service",
    "ListMerchantCenterLinksResponse": "airflow.providers.google_vendor.googleads.v12.services.types.merchant_center_link_service",
    "ListPaymentsAccountsRequest": "airflow.providers.google_vendor.googleads.v12.services.types.payments_account_service",
    "ListPaymentsAccountsResponse": "airflow.providers.google_vendor.googleads.v12.services.types.payments_account_service",
    "ListPlannableLocationsRequest": "airflow.providers.google_vendor.googleads.v12.services.types.reach_plan_service",
    "ListPlannableLocationsResponse": "airflow.providers.google_vendor.googleads.v12.services.types.reach_plan_service",
    "ListPlannableProductsRequest": "airflow.providers.google_vendor.googleads.v12.services.types.reach_plan_service",
    "ListPlannableProductsResponse": "airflow.providers.google_vendor.googleads.v12.services.types.reach_plan_service",
    "LocationAttributeMetadata": "airflow.providers.google_vendor.googleads.v12.services.types.audience_insights_service",
    "MediaFileOperation": "airflow.providers.google_vendor.googleads.v12.services.types.media_file_service",
    "MerchantCenterLinkOperation": "airflow.providers.google_vendor.googleads.v12.services.types.merchant_center_link_service",
    "MoveManagerLinkRequest": "airflow.providers.google_vendor.googleads.v12.services.types.customer_manager_link_service",
    "MoveManagerLinkResponse": "airflow.providers.google_vendor.googleads.v12.services.types.customer_manager_link_service",
    "MutateAccountBudgetProposalRequest": "airflow.providers.google_vendor.googleads.v12.services.types.account_budget_proposal_service",
    "MutateAccountBudgetProposalResponse": "airflow.providers.google_vendor.googleads.v12.services.types.account_budget_proposal_service",
    "MutateAccountBudgetProposalResult": "airflow.providers.google_vendor.googleads.v12.services.types.account_budget_proposal_service",
    "MutateAccountLinkRequest": "airflow.providers.google_vendor.googleads.v12.services.types.account_link_service",
    "MutateAccountLinkResponse": "airflow.providers.google_vendor.googleads.v12.services.types.account_link_service",
    "MutateAccountLinkResult": "airflow.providers.google_vendor.googleads.v12.services.types.account_link_service",
    "MutateAdGroupAdLabelResult": "airflow.providers.google_vendor.googleads.v12.services.types.ad_group_ad_label_service",
    "MutateAdGroupAdLabelsRequest": "airflow.providers.google_vendor.googleads.v12.services.types.ad_group_ad_label_service",
    "MutateAdGroupAdLabelsResponse": "airflow.providers.google_vendor.googleads.v12.services.types.ad_group_ad_label_service",
    "MutateAdGroupAdResult": "airflow.providers.google_vendor.googleads.v12.services.types.ad_group_ad_service",
    "MutateAdGroupAdsRequest": "airflow.providers.google_vendor.googleads.v12.services.types.ad_group_ad_service",
    "MutateAdGroupAdsResponse": "airflow.providers.google_vendor.googleads.v12.services.types.ad_group_ad_service",
    "MutateAdGroupAssetResult": "airflow.providers.google_vendor.googleads.v12.services.types.ad_group_asset_service",
    "MutateAdGroupAssetSetResult": "airflow.providers.google_vendor.googleads.v12.services.types.ad_group_asset_set_service",
    "MutateAdGroupAssetSetsRequest": "airflow.providers.google_vendor.googleads.v12.services.types.ad_group_asset_set_service",
    "MutateAdGroupAssetSetsResponse": "airflow.providers.google_vendor.googleads.v12.services.types.ad_group_asset_set_service",
    "MutateAdGroupAssetsRequest": "airflow.providers.google_vendor.googleads.v12.services.types.ad_group_asset_service",
    "MutateAdGroupAssetsResponse": "airflow.providers.google_vendor.googleads.v12.services.types.ad_group_asset_service",
    "MutateAdGroupBidModifierResult": "airflow.providers.google_vendor.googleads.v12.services.types.ad_group_bid_modifier_service",
    "MutateAdGroupBidModifiersRequest": "airflow.providers.google_vendor.googleads.v12.services.types.ad_group_bid_modifier_service",
    "MutateAdGroupBidModifiersResponse": "airflow.providers.google_vendor.googleads.v12.services.types.ad_group_bid_modifier_service",
    "MutateAdGroupCriteriaRequest": "airflow.providers.google_vendor.googleads.v12.services.types.ad_group_criterion_service",
    "MutateAdGroupCriteriaResponse": "airflow.providers.google_vendor.googleads.v12.services.types.ad_group_criterion_service",
    "MutateAdGroupCriterionCustomizerResult": "airflow.providers.google_vendor.googleads.v12.services.types.ad_group_criterion_customizer_service",
    "MutateAdGroupCriterionCustomizersRequest": "airflow.providers.google_vendor.googleads.v12.services.types.ad_group_criterion_customizer_service",
    "MutateAdGroupCriterionCustomizersResponse": "airflow.providers.google_vendor.googleads.v12.services.types.ad_group_criterion_customizer_service",
    "MutateAdGroupCriterionLabelResult": "airflow.providers.google_vendor.googleads.v12.services.types.ad_group_criterion_label_service",
    "MutateAdGroupCriterionLabelsRequest": "airflow.providers.google_vendor.googleads.v12.services.types.ad_group_criterion_label_service",
    "MutateAdGroupCriterionLabelsResponse": "airflow.providers.google_vendor.googleads.v12.services.types.ad_group_criterion_label_service",
    "MutateAdGroupCriterionResult": "airflow.providers.google_vendor.googleads.v12.services.types.ad_group_criterion_service",
    "MutateAdGroupCustomizerResult": "airflow.providers.google_vendor.googleads.v12.services.types.ad_group_customizer_service",
    "MutateAdGroupCustomizersRequest": "airflow.providers.google_vendor.googleads.v12.services.types.ad_group_customizer_service",
    "MutateAdGroupCustomizersResponse": "airflow.providers.google_vendor.googleads.v12.services.types.ad_group_customizer_service",
    "MutateAdGroupExtensionSettingResult": "airflow.providers.google_vendor.googleads.v12.services.types.ad_group_extension_setting_service",
    "MutateAdGroupExtensionSettingsRequest": "airflow.providers.google_vendor.googleads.v12.services.types.ad_group_extension_setting_service",
    "MutateAdGroupExtensionSettingsResponse": "airflow.providers.google_vendor.googleads.v12.services.types.ad_group_extension_setting_service",
    "MutateAdGroupFeedResult": "airflow.providers.google_vendor.googleads.v12.services.types.ad_group_feed_service",
    "MutateAdGroupFeedsRequest": "airflow.providers.google_vendor.googleads.v12.services.types.ad_group_feed_service",
    "MutateAdGroupFeedsResponse": "airflow.providers.google_vendor.googleads.v12.services.types.ad_group_feed_service",
    "MutateAdGroupLabelResult": "airflow.providers.google_vendor.googleads.v12.services.types.ad_group_label_service",
    "MutateAdGroupLabelsRequest": "airflow.providers.google_vendor.googleads.v12.services.types.ad_group_label_service",
    "MutateAdGroupLabelsResponse": "airflow.providers.google_vendor.googleads.v12.services.types.ad_group_label_service",
    "MutateAdGroupResult": "airflow.providers.google_vendor.googleads.v12.services.types.ad_group_service",
    "MutateAdGroupsRequest": "airflow.providers.google_vendor.googleads.v12.services.types.ad_group_service",
    "MutateAdGroupsResponse": "airflow.providers.google_vendor.googleads.v12.services.types.ad_group_service",
    "MutateAdParameterResult": "airflow.providers.google_vendor.googleads.v12.services.types.ad_parameter_service",
    "MutateAdParametersRequest": "airflow.providers.google_vendor.googleads.v12.services.types.ad_parameter_service",
    "MutateAdParametersResponse": "airflow.providers.google_vendor.googleads.v12.services.types.ad_parameter_service",
    "MutateAdResult": "airflow.providers.google_vendor.googleads.v12.services.types.ad_service",
    "MutateAdsRequest": "airflow.providers.google_vendor.googleads.v12.services.types.ad_service",
    "MutateAdsResponse": "airflow.providers.google_vendor.googleads.v12.services.types.ad_service",
    "MutateAssetGroupAssetResult": "airflow.providers.google_vendor.googleads.v12.services.types.asset_group_asset_service",
    "MutateAssetGroupAssetsRequest": "airflow.providers.google_vendor.googleads.v12.services.types.asset_group_asset_service",
    "MutateAssetGroupAssetsResponse": "airflow.providers.google_vendor.googleads.v12.services.types.asset_group_asset_service",
    "MutateAssetGroupListingGroupFilterResult": "airflow.providers.google_vendor.googleads.v12.services.types.asset_group_listing_group_filter_service",
    "MutateAssetGroupListingGroupFiltersRequest": "airflow.providers.google_vendor.googleads.v12.services.types.asset_group_listing_group_filter_service",
    "MutateAssetGroupListingGroupFiltersResponse": "airflow.providers.google_vendor.googleads.v12.services.types.asset_group_listing_group_filter_service",
    "MutateAssetGroupResult": "airflow.providers.google_vendor.googleads.v12.services.types.asset_group_service",
    "MutateAssetGroupSignalResult": "airflow.providers.google_vendor.googleads.v12.services.types.asset_group_signal_service",
    "MutateAssetGroupSignalsRequest": "airflow.providers.google_vendor.googleads.v12.services.types.asset_group_signal_service",
    "MutateAssetGroupSignalsResponse": "airflow.providers.google_vendor.googleads.v12.services.types.asset_group_signal_service",
    "MutateAssetGroupsRequest": "airflow.providers.google_vendor.googleads.v12.services.types.asset_group_service",
    "MutateAssetGroupsResponse": "airflow.providers.google_vendor.googleads.v12.services.types.asset_group_service",
    "MutateAssetResult": "airflow.providers.google_vendor.googleads.v12.services.types.asset_service",
    "MutateAssetSetAssetResult": "airflow.providers.google_vendor.googleads.v12.services.types.asset_set_asset_service",
    "MutateAssetSetAssetsRequest": "airflow.providers.google_vendor.googleads.v12.services.types.asset_set_asset_service",
    "MutateAssetSetAssetsResponse": "airflow.providers.google_vendor.googleads.v12.services.types.asset_set_asset_service",
    "MutateAssetSetResult": "airflow.providers.google_vendor.googleads.v12.services.types.asset_set_service",
    "MutateAssetSetsRequest": "airflow.providers.google_vendor.googleads.v12.services.types.asset_set_service",
    "MutateAssetSetsResponse": "airflow.providers.google_vendor.googleads.v12.services.types.asset_set_service",
    "MutateAssetsRequest": "airflow.providers.google_vendor.googleads.v12.services.types.asset_service",
    "MutateAssetsResponse": "airflow.providers.google_vendor.googleads.v12.services.types.asset_service",
    "MutateAudienceResult": "airflow.providers.google_vendor.googleads.v12.services.types.audience_service",
    "MutateAudiencesRequest": "airflow.providers.google_vendor.googleads.v12.services.types.audience_service",
    "MutateAudiencesResponse": "airflow.providers.google_vendor.googleads.v12.services.types.audience_service",
    "MutateBatchJobRequest": "airflow.providers.google_vendor.googleads.v12.services.types.batch_job_service",
    "MutateBatchJobResponse": "airflow.providers.google_vendor.googleads.v12.services.types.batch_job_service",
    "MutateBatchJobResult": "airflow.providers.google_vendor.googleads.v12.services.types.batch_job_service",
    "MutateBiddingDataExclusionsRequest": "airflow.providers.google_vendor.googleads.v12.services.types.bidding_data_exclusion_service",
    "MutateBiddingDataExclusionsResponse": "airflow.providers.google_vendor.googleads.v12.services.types.bidding_data_exclusion_service",
    "MutateBiddingDataExclusionsResult": "airflow.providers.google_vendor.googleads.v12.services.types.bidding_data_exclusion_service",
    "MutateBiddingSeasonalityAdjustmentsRequest": "airflow.providers.google_vendor.googleads.v12.services.types.bidding_seasonality_adjustment_service",
    "MutateBiddingSeasonalityAdjustmentsResponse": "airflow.providers.google_vendor.googleads.v12.services.types.bidding_seasonality_adjustment_service",
    "MutateBiddingSeasonalityAdjustmentsResult": "airflow.providers.google_vendor.googleads.v12.services.types.bidding_seasonality_adjustment_service",
    "MutateBiddingStrategiesRequest": "airflow.providers.google_vendor.googleads.v12.services.types.bidding_strategy_service",
    "MutateBiddingStrategiesResponse": "airflow.providers.google_vendor.googleads.v12.services.types.bidding_strategy_service",
    "MutateBiddingStrategyResult": "airflow.providers.google_vendor.googleads.v12.services.types.bidding_strategy_service",
    "MutateBillingSetupRequest": "airflow.providers.google_vendor.googleads.v12.services.types.billing_setup_service",
    "MutateBillingSetupResponse": "airflow.providers.google_vendor.googleads.v12.services.types.billing_setup_service",
    "MutateBillingSetupResult": "airflow.providers.google_vendor.googleads.v12.services.types.billing_setup_service",
    "MutateCampaignAssetResult": "airflow.providers.google_vendor.googleads.v12.services.types.campaign_asset_service",
    "MutateCampaignAssetSetResult": "airflow.providers.google_vendor.googleads.v12.services.types.campaign_asset_set_service",
    "MutateCampaignAssetSetsRequest": "airflow.providers.google_vendor.googleads.v12.services.types.campaign_asset_set_service",
    "MutateCampaignAssetSetsResponse": "airflow.providers.google_vendor.googleads.v12.services.types.campaign_asset_set_service",
    "MutateCampaignAssetsRequest": "airflow.providers.google_vendor.googleads.v12.services.types.campaign_asset_service",
    "MutateCampaignAssetsResponse": "airflow.providers.google_vendor.googleads.v12.services.types.campaign_asset_service",
    "MutateCampaignBidModifierResult": "airflow.providers.google_vendor.googleads.v12.services.types.campaign_bid_modifier_service",
    "MutateCampaignBidModifiersRequest": "airflow.providers.google_vendor.googleads.v12.services.types.campaign_bid_modifier_service",
    "MutateCampaignBidModifiersResponse": "airflow.providers.google_vendor.googleads.v12.services.types.campaign_bid_modifier_service",
    "MutateCampaignBudgetResult": "airflow.providers.google_vendor.googleads.v12.services.types.campaign_budget_service",
    "MutateCampaignBudgetsRequest": "airflow.providers.google_vendor.googleads.v12.services.types.campaign_budget_service",
    "MutateCampaignBudgetsResponse": "airflow.providers.google_vendor.googleads.v12.services.types.campaign_budget_service",
    "MutateCampaignConversionGoalResult": "airflow.providers.google_vendor.googleads.v12.services.types.campaign_conversion_goal_service",
    "MutateCampaignConversionGoalsRequest": "airflow.providers.google_vendor.googleads.v12.services.types.campaign_conversion_goal_service",
    "MutateCampaignConversionGoalsResponse": "airflow.providers.google_vendor.googleads.v12.services.types.campaign_conversion_goal_service",
    "MutateCampaignCriteriaRequest": "airflow.providers.google_vendor.googleads.v12.services.types.campaign_criterion_service",
    "MutateCampaignCriteriaResponse": "airflow.providers.google_vendor.googleads.v12.services.types.campaign_criterion_service",
    "MutateCampaignCriterionResult": "airflow.providers.google_vendor.googleads.v12.services.types.campaign_criterion_service",
    "MutateCampaignCustomizerResult": "airflow.providers.google_vendor.googleads.v12.services.types.campaign_customizer_service",
    "MutateCampaignCustomizersRequest": "airflow.providers.google_vendor.googleads.v12.services.types.campaign_customizer_service",
    "MutateCampaignCustomizersResponse": "airflow.providers.google_vendor.googleads.v12.services.types.campaign_customizer_service",
    "MutateCampaignDraftResult": "airflow.providers.google_vendor.googleads.v12.services.types.campaign_draft_service",
    "MutateCampaignDraftsRequest": "airflow.providers.google_vendor.googleads.v12.services.types.campaign_draft_service",
    "MutateCampaignDraftsResponse": "airflow.providers.google_vendor.googleads.v12.services.types.campaign_draft_service",
    "MutateCampaignExtensionSettingResult": "airflow.providers.google_vendor.googleads.v12.services.types.campaign_extension_setting_service",
    "MutateCampaignExtensionSettingsRequest": "airflow.providers.google_vendor.googleads.v12.services.types.campaign_extension_setting_service",
    "MutateCampaignExtensionSettingsResponse": "airflow.providers.google_vendor.googleads.v12.services.types.campaign_extension_setting_service",
    "MutateCampaignFeedResult": "airflow.providers.google_vendor.googleads.v12.services.types.campaign_feed_service",
    "MutateCampaignFeedsRequest": "airflow.providers.google_vendor.googleads.v12.services.types.campaign_feed_service",
    "MutateCampaignFeedsResponse": "airflow.providers.google_vendor.googleads.v12.services.types.campaign_feed_service",
    "MutateCampaignGroupResult": "airflow.providers.google_vendor.googleads.v12.services.types.campaign_group_service",
    "MutateCampaignGroupsRequest": "airflow.providers.google_vendor.googleads.v12.services.types.campaign_group_service",
    "MutateCampaignGroupsResponse": "airflow.providers.google_vendor.googleads.v12.services.types.campaign_group_service",
    "MutateCampaignLabelResult": "airflow.providers.google_vendor.googleads.v12.services.types.campaign_label_service",
    "MutateCampaignLabelsRequest": "airflow.providers.google_vendor.googleads.v12.services.types.campaign_label_service",
    "MutateCampaignLabelsResponse": "airflow.providers.google_vendor.googleads.v12.services.types.campaign_label_service",
    "MutateCampaignResult": "airflow.providers.google_vendor.googleads.v12.services.types.campaign_service",
    "MutateCampaignSharedSetResult": "airflow.providers.google_vendor.googleads.v12.services.types.campaign_shared_set_service",
    "MutateCampaignSharedSetsRequest": "airflow.providers.google_vendor.googleads.v12.services.types.campaign_shared_set_service",
    "MutateCampaignSharedSetsResponse": "airflow.providers.google_vendor.googleads.v12.services.types.campaign_shared_set_service",
    "MutateCampaignsRequest": "airflow.providers.google_vendor.googleads.v12.services.types.campaign_service",
    "MutateCampaignsResponse": "airflow.providers.google_vendor.googleads.v12.services.types.campaign_service",
    "MutateConversionActionResult": "airflow.providers.google_vendor.googleads.v12.services.types.conversion_action_service",
    "MutateConversionActionsRequest": "airflow.providers.google_vendor.googleads.v12.services.types.conversion_action_service",
    "MutateConversionActionsResponse": "airflow.providers.google_vendor.googleads.v12.services.types.conversion_action_service",
    "MutateConversionCustomVariableResult": "airflow.providers.google_vendor.googleads.v12.services.types.conversion_custom_variable_service",
    "MutateConversionCustomVariablesRequest": "airflow.providers.google_vendor.googleads.v12.services.types.conversion_custom_variable_service",
    "MutateConversionCustomVariablesResponse": "airflow.providers.google_vendor.googleads.v12.services.types.conversion_custom_variable_service",
    "MutateConversionGoalCampaignConfigResult": "airflow.providers.google_vendor.googleads.v12.services.types.conversion_goal_campaign_config_service",
    "MutateConversionGoalCampaignConfigsRequest": "airflow.providers.google_vendor.googleads.v12.services.types.conversion_goal_campaign_config_service",
    "MutateConversionGoalCampaignConfigsResponse": "airflow.providers.google_vendor.googleads.v12.services.types.conversion_goal_campaign_config_service",
    "MutateConversionValueRuleResult": "airflow.providers.google_vendor.googleads.v12.services.types.conversion_value_rule_service",
    "MutateConversionValueRuleSetResult": "airflow.providers.google_vendor.googleads.v12.services.types.conversion_value_rule_set_service",
    "MutateConversionValueRuleSetsRequest": "airflow.providers.google_vendor.googleads.v12.services.types.conversion_value_rule_set_service",
    "MutateConversionValueRuleSetsResponse": "airflow.providers.google_vendor.googleads.v12.services.types.conversion_value_rule_set_service",
    "MutateConversionValueRulesRequest": "airflow.providers.google_vendor.googleads.v12.services.types.conversion_value_rule_service",
    "MutateConversionValueRulesResponse": "airflow.providers.google_vendor.googleads.v12.services.types.conversion_value_rule_service",
    "MutateCustomAudienceResult": "airflow.providers.google_vendor.googleads.v12.services.types.custom_audience_service",
    "MutateCustomAudiencesRequest": "airflow.providers.google_vendor.googleads.v12.services.types.custom_audience_service",
    "MutateCustomAudiencesResponse": "airflow.providers.google_vendor.googleads.v12.services.types.custom_audience_service",
    "MutateCustomConversionGoalResult": "airflow.providers.google_vendor.googleads.v12.services.types.custom_conversion_goal_service",
    "MutateCustomConversionGoalsRequest": "airflow.providers.google_vendor.googleads.v12.services.types.custom_conversion_goal_service",
    "MutateCustomConversionGoalsResponse": "airflow.providers.google_vendor.googleads.v12.services.types.custom_conversion_goal_service",
    "MutateCustomerAssetResult": "airflow.providers.google_vendor.googleads.v12.services.types.customer_asset_service",
    "MutateCustomerAssetSetResult": "airflow.providers.google_vendor.googleads.v12.services.types.customer_asset_set_service",
    "MutateCustomerAssetSetsRequest": "airflow.providers.google_vendor.googleads.v12.services.types.customer_asset_set_service",
    "MutateCustomerAssetSetsResponse": "airflow.providers.google_vendor.googleads.v12.services.types.customer_asset_set_service",
    "MutateCustomerAssetsRequest": "airflow.providers.google_vendor.googleads.v12.services.types.customer_asset_service",
    "MutateCustomerAssetsResponse": "airflow.providers.google_vendor.googleads.v12.services.types.customer_asset_service",
    "MutateCustomerClientLinkRequest": "airflow.providers.google_vendor.googleads.v12.services.types.customer_client_link_service",
    "MutateCustomerClientLinkResponse": "airflow.providers.google_vendor.googleads.v12.services.types.customer_client_link_service",
    "MutateCustomerClientLinkResult": "airflow.providers.google_vendor.googleads.v12.services.types.customer_client_link_service",
    "MutateCustomerConversionGoalResult": "airflow.providers.google_vendor.googleads.v12.services.types.customer_conversion_goal_service",
    "MutateCustomerConversionGoalsRequest": "airflow.providers.google_vendor.googleads.v12.services.types.customer_conversion_goal_service",
    "MutateCustomerConversionGoalsResponse": "airflow.providers.google_vendor.googleads.v12.services.types.customer_conversion_goal_service",
    "MutateCustomerCustomizerResult": "airflow.providers.google_vendor.googleads.v12.services.types.customer_customizer_service",
    "MutateCustomerCustomizersRequest": "airflow.providers.google_vendor.googleads.v12.services.types.customer_customizer_service",
    "MutateCustomerCustomizersResponse": "airflow.providers.google_vendor.googleads.v12.services.types.customer_customizer_service",
    "MutateCustomerExtensionSettingResult": "airflow.providers.google_vendor.googleads.v12.services.types.customer_extension_setting_service",
    "MutateCustomerExtensionSettingsRequest": "airflow.providers.google_vendor.googleads.v12.services.types.customer_extension_setting_service",
    "MutateCustomerExtensionSettingsResponse": "airflow.providers.google_vendor.googleads.v12.services.types.customer_extension_setting_service",
    "MutateCustomerFeedResult": "airflow.providers.google_vendor.googleads.v12.services.types.customer_feed_service",
    "MutateCustomerFeedsRequest": "airflow.providers.google_vendor.googleads.v12.services.types.customer_feed_service",
    "MutateCustomerFeedsResponse": "airflow.providers.google_vendor.googleads.v12.services.types.customer_feed_service",
    "MutateCustomerLabelResult": "airflow.providers.google_vendor.googleads.v12.services.types.customer_label_service",
    "MutateCustomerLabelsRequest": "airflow.providers.google_vendor.googleads.v12.services.types.customer_label_service",
    "MutateCustomerLabelsResponse": "airflow.providers.google_vendor.googleads.v12.services.types.customer_label_service",
    "MutateCustomerManagerLinkRequest": "airflow.providers.google_vendor.googleads.v12.services.types.customer_manager_link_service",
    "MutateCustomerManagerLinkResponse": "airflow.providers.google_vendor.googleads.v12.services.types.customer_manager_link_service",
    "MutateCustomerManagerLinkResult": "airflow.providers.google_vendor.googleads.v12.services.types.customer_manager_link_service",
    "MutateCustomerNegativeCriteriaRequest": "airflow.providers.google_vendor.googleads.v12.services.types.customer_negative_criterion_service",
    "MutateCustomerNegativeCriteriaResponse": "airflow.providers.google_vendor.googleads.v12.services.types.customer_negative_criterion_service",
    "MutateCustomerNegativeCriteriaResult": "airflow.providers.google_vendor.googleads.v12.services.types.customer_negative_criterion_service",
    "MutateCustomerRequest": "airflow.providers.google_vendor.googleads.v12.services.types.customer_service",
    "MutateCustomerResponse": "airflow.providers.google_vendor.googleads.v12.services.types.customer_service",
    "MutateCustomerResult": "airflow.providers.google_vendor.googleads.v12.services.types.customer_service",
    "MutateCustomerUserAccessInvitationRequest": "airflow.providers.google_vendor.googleads.v12.services.types.customer_user_access_invitation_service",
    "MutateCustomerUserAccessInvitationResponse": "airflow.providers.google_vendor.googleads.v12.services.types.customer_user_access_invitation_service",
    "MutateCustomerUserAccessInvitationResult": "airflow.providers.google_vendor.googleads.v12.services.types.customer_user_access_invitation_service",
    "MutateCustomerUserAccessRequest": "airflow.providers.google_vendor.googleads.v12.services.types.customer_user_access_service",
    "MutateCustomerUserAccessResponse": "airflow.providers.google_vendor.googleads.v12.services.types.customer_user_access_service",
    "MutateCustomerUserAccessResult": "airflow.providers.google_vendor.googleads.v12.services.types.customer_user_access_service",
    "MutateCustomInterestResult": "airflow.providers.google_vendor.googleads.v12.services.types.custom_interest_service",
    "MutateCustomInterestsRequest": "airflow.providers.google_vendor.googleads.v12.services.types.custom_interest_service",
    "MutateCustomInterestsResponse": "airflow.providers.google_vendor.googleads.v12.services.types.custom_interest_service",
    "MutateCustomizerAttributeResult": "airflow.providers.google_vendor.googleads.v12.services.types.customizer_attribute_service",
    "MutateCustomizerAttributesRequest": "airflow.providers.google_vendor.googleads.v12.services.types.customizer_attribute_service",
    "MutateCustomizerAttributesResponse": "airflow.providers.google_vendor.googleads.v12.services.types.customizer_attribute_service",
    "MutateExperimentArmResult": "airflow.providers.google_vendor.googleads.v12.services.types.experiment_arm_service",
    "MutateExperimentArmsRequest": "airflow.providers.google_vendor.googleads.v12.services.types.experiment_arm_service",
    "MutateExperimentArmsResponse": "airflow.providers.google_vendor.googleads.v12.services.types.experiment_arm_service",
    "MutateExperimentResult": "airflow.providers.google_vendor.googleads.v12.services.types.experiment_service",
    "MutateExperimentsRequest": "airflow.providers.google_vendor.googleads.v12.services.types.experiment_service",
    "MutateExperimentsResponse": "airflow.providers.google_vendor.googleads.v12.services.types.experiment_service",
    "MutateExtensionFeedItemResult": "airflow.providers.google_vendor.googleads.v12.services.types.extension_feed_item_service",
    "MutateExtensionFeedItemsRequest": "airflow.providers.google_vendor.googleads.v12.services.types.extension_feed_item_service",
    "MutateExtensionFeedItemsResponse": "airflow.providers.google_vendor.googleads.v12.services.types.extension_feed_item_service",
    "MutateFeedItemResult": "airflow.providers.google_vendor.googleads.v12.services.types.feed_item_service",
    "MutateFeedItemSetLinkResult": "airflow.providers.google_vendor.googleads.v12.services.types.feed_item_set_link_service",
    "MutateFeedItemSetLinksRequest": "airflow.providers.google_vendor.googleads.v12.services.types.feed_item_set_link_service",
    "MutateFeedItemSetLinksResponse": "airflow.providers.google_vendor.googleads.v12.services.types.feed_item_set_link_service",
    "MutateFeedItemSetResult": "airflow.providers.google_vendor.googleads.v12.services.types.feed_item_set_service",
    "MutateFeedItemSetsRequest": "airflow.providers.google_vendor.googleads.v12.services.types.feed_item_set_service",
    "MutateFeedItemSetsResponse": "airflow.providers.google_vendor.googleads.v12.services.types.feed_item_set_service",
    "MutateFeedItemsRequest": "airflow.providers.google_vendor.googleads.v12.services.types.feed_item_service",
    "MutateFeedItemsResponse": "airflow.providers.google_vendor.googleads.v12.services.types.feed_item_service",
    "MutateFeedItemTargetResult": "airflow.providers.google_vendor.googleads.v12.services.types.feed_item_target_service",
    "MutateFeedItemTargetsRequest": "airflow.providers.google_vendor.googleads.v12.services.types.feed_item_target_service",
    "MutateFeedItemTargetsResponse": "airflow.providers.google_vendor.googleads.v12.services.types.feed_item_target_service",
    "MutateFeedMappingResult": "airflow.providers.google_vendor.googleads.v12.services.types.feed_mapping_service",
    "MutateFeedMappingsRequest": "airflow.providers.google_vendor.googleads.v12.services.types.feed_mapping_service",
    "MutateFeedMappingsResponse": "airflow.providers.google_vendor.googleads.v12.services.types.feed_mapping_service",
    "MutateFeedResult": "airflow.providers.google_vendor.googleads.v12.services.types.feed_service",
    "MutateFeedsRequest": "airflow.providers.google_vendor.googleads.v12.services.types.feed_service",
    "MutateFeedsResponse": "airflow.providers.google_vendor.googleads.v12.services.types.feed_service",
    "MutateGoogleAdsRequest": "airflow.providers.google_vendor.googleads.v12.services.types.google_ads_service",
    "MutateGoogleAdsResponse": "airflow.providers.google_vendor.googleads.v12.services.types.google_ads_service",
    "MutateKeywordPlanAdGroupKeywordResult": "airflow.providers.google_vendor.googleads.v12.services.types.keyword_plan_ad_group_keyword_service",
    "MutateKeywordPlanAdGroupKeywordsRequest": "airflow.providers.google_vendor.googleads.v12.services.types.keyword_plan_ad_group_keyword_service",
    "MutateKeywordPlanAdGroupKeywordsResponse": "airflow.providers.google_vendor.googleads.v12.services.types.keyword_plan_ad_group_keyword_service",
    "MutateKeywordPlanAdGroupResult": "airflow.providers.google_vendor.googleads.v12.services.types.keyword_plan_ad_group_service",
    "MutateKeywordPlanAdGroupsRequest": "airflow.providers.google_vendor.googleads.v12.services.types.keyword_plan_ad_group_service",
    "MutateKeywordPlanAdGroupsResponse": "airflow.providers.google_vendor.googleads.v12.services.types.keyword_plan_ad_group_service",
    "MutateKeywordPlanCampaignKeywordResult": "airflow.providers.google_vendor.googleads.v12.services.types.keyword_plan_campaign_keyword_service",
    "MutateKeywordPlanCampaignKeywordsRequest": "airflow.providers.google_vendor.googleads.v12.services.types.keyword_plan_campaign_keyword_service",
    "MutateKeywordPlanCampaignKeywordsResponse": "airflow.providers.google_vendor.googleads.v12.services.types.keyword_plan_campaign_keyword_service",
    "MutateKeywordPlanCampaignResult": "airflow.providers.google_vendor.googleads.v12.services.types.keyword_plan_campaign_service",
    "MutateKeywordPlanCampaignsRequest": "airflow.providers.google_vendor.googleads.v12.services.types.keyword_plan_campaign_service",
    "MutateKeywordPlanCampaignsResponse": "airflow.providers.google_vendor.googleads.v12.services.types.keyword_plan_campaign_service",
    "MutateKeywordPlansRequest": "airflow.providers.google_vendor.googleads.v12.services.types.keyword_plan_service",
    "MutateKeywordPlansResponse": "airflow.providers.google_vendor.googleads.v12.services.types.keyword_plan_service",
    "MutateKeywordPlansResult": "airflow.providers.google_vendor.googleads.v12.services.types.keyword_plan_service",
    "MutateLabelResult": "airflow.providers.google_vendor.googleads.v12.services.types.label_service",
    "MutateLabelsRequest": "airflow.providers.google_vendor.googleads.v12.services.types.label_service",
    "MutateLabelsResponse": "airflow.providers.google_vendor.googleads.v12.services.types.label_service",
    "MutateMediaFileResult": "airflow.providers.google_vendor.googleads.v12.services.types.media_file_service",
    "MutateMediaFilesRequest": "airflow.providers.google_vendor.googleads.v12.services.types.media_file_service",
    "MutateMediaFilesResponse": "airflow.providers.google_vendor.googleads.v12.services.types.media_file_service",
    "MutateMerchantCenterLinkRequest": "airflow.providers.google_vendor.googleads.v12.services.types.merchant_center_link_service",
    "MutateMerchantCenterLinkResponse": "airflow.providers.google_vendor.googleads.v12.services.types.merchant_center_link_service",
    "MutateMerchantCenterLinkResult": "airflow.providers.google_vendor.googleads.v12.services.types.merchant_center_link_service",
    "MutateOperation": "airflow.providers.google_vendor.googleads.v12.services.types.google_ads_service",
    "MutateOperationResponse": "airflow.providers.google_vendor.googleads.v12.services.types.google_ads_service",
    "MutateRemarketingActionResult": "airflow.providers.google_vendor.googleads.v12.services.types.remarketing_action_service",
    "MutateRemarketingActionsRequest": "airflow.providers.google_vendor.googleads.v12.services.types.remarketing_action_service",
    "MutateRemarketingActionsResponse": "airflow.providers.google_vendor.googleads.v12.services.types.remarketing_action_service",
    "MutateSharedCriteriaRequest": "airflow.providers.google_vendor.googleads.v12.services.types.shared_criterion_service",
    "MutateSharedCriteriaResponse": "airflow.providers.google_vendor.googleads.v12.services.types.shared_criterion_service",
    "MutateSharedCriterionResult": "airflow.providers.google_vendor.googleads.v12.services.types.shared_criterion_service",
    "MutateSharedSetResult": "airflow.providers.google_vendor.googleads.v12.services.types.shared_set_service",
    "MutateSharedSetsRequest": "airflow.providers.google_vendor.googleads.v12.services.types.shared_set_service",
    "MutateSharedSetsResponse": "airflow.providers.google_vendor.googleads.v12.services.types.shared_set_service",
    "MutateSmartCampaignSettingResult": "airflow.providers.google_vendor.googleads.v12.services.types.smart_campaign_setting_service",
    "MutateSmartCampaignSettingsRequest": "airflow.providers.google_vendor.googleads.v12.services.types.smart_campaign_setting_service",
    "MutateSmartCampaignSettingsResponse": "airflow.providers.google_vendor.googleads.v12.services.types.smart_campaign_setting_service",
    "MutateUserListResult": "airflow.providers.google_vendor.googleads.v12.services.types.user_list_service",
    "MutateUserListsRequest": "airflow.providers.google_vendor.googleads.v12.services.types.user_list_service",
    "MutateUserListsResponse": "airflow.providers.google_vendor.googleads.v12.services.types.user_list_service",
    "OfflineUserDataJobOperation": "airflow.providers.google_vendor.googleads.v12.services.types.offline_user_data_job_service",
    "OnTargetAudienceMetrics": "airflow.providers.google_vendor.googleads.v12.services.types.reach_plan_service",
    "PlannableLocation": "airflow.providers.google_vendor.googleads.v12.services.types.reach_plan_service",
    "PlannableTargeting": "airflow.providers.google_vendor.googleads.v12.services.types.reach_plan_service",
    "PlannedProduct": "airflow.providers.google_vendor.googleads.v12.services.types.reach_plan_service",
    "PlannedProductForecast": "airflow.providers.google_vendor.googleads.v12.services.types.reach_plan_service",
    "PlannedProductReachForecast": "airflow.providers.google_vendor.googleads.v12.services.types.reach_plan_service",
    "ProductMetadata": "airflow.providers.google_vendor.googleads.v12.services.types.reach_plan_service",
    "PromoteCampaignDraftRequest": "airflow.providers.google_vendor.googleads.v12.services.types.campaign_draft_service",
    "PromoteExperimentMetadata": "airflow.providers.google_vendor.googleads.v12.services.types.experiment_service",
    "PromoteExperimentRequest": "airflow.providers.google_vendor.googleads.v12.services.types.experiment_service",
    "ReachCurve": "airflow.providers.google_vendor.googleads.v12.services.types.reach_plan_service",
    "ReachForecast": "airflow.providers.google_vendor.googleads.v12.services.types.reach_plan_service",
    "RegenerateShareableLinkIdRequest": "airflow.providers.google_vendor.googleads.v12.services.types.third_party_app_analytics_link_service",
    "RegenerateShareableLinkIdResponse": "airflow.providers.google_vendor.googleads.v12.services.types.third_party_app_analytics_link_service",
    "RemarketingActionOperation": "airflow.providers.google_vendor.googleads.v12.services.types.remarketing_action_service",
    "RestatementValue": "airflow.providers.google_vendor.googleads.v12.services.types.conversion_adjustment_upload_service",
    "RunBatchJobRequest": "airflow.providers.google_vendor.googleads.v12.services.types.batch_job_service",
    "RunOfflineUserDataJobRequest": "airflow.providers.google_vendor.googleads.v12.services.types.offline_user_data_job_service",
    "ScheduleExperimentMetadata": "airflow.providers.google_vendor.googleads.v12.services.types.experiment_service",
    "ScheduleExperimentRequest": "airflow.providers.google_vendor.googleads.v12.services.types.experiment_service",
    "SearchGoogleAdsFieldsRequest": "airflow.providers.google_vendor.googleads.v12.services.types.google_ads_field_service",
    "SearchGoogleAdsFieldsResponse": "airflow.providers.google_vendor.googleads.v12.services.types.google_ads_field_service",
    "SearchGoogleAdsRequest": "airflow.providers.google_vendor.googleads.v12.services.types.google_ads_service",
    "SearchGoogleAdsResponse": "airflow.providers.google_vendor.googleads.v12.services.types.google_ads_service",
    "SearchGoogleAdsStreamRequest": "airflow.providers.google_vendor.googleads.v12.services.types.google_ads_service",
    "SearchGoogleAdsStreamResponse": "airflow.providers.google_vendor.googleads.v12.services.types.google_ads_service",
    "SharedCriterionOperation": "airflow.providers.google_vendor.googleads.v12.services.types.shared_criterion_service",
    "SharedSetOperation": "airflow.providers.google_vendor.googleads.v12.services.types.shared_set_service",
    "SiteSeed": "airflow.providers.google_vendor.googleads.v12.services.types.keyword_plan_idea_service",
    "SmartCampaignSettingOperation": "airflow.providers.google_vendor.googleads.v12.services.types.smart_campaign_setting_service",
    "SmartCampaignSuggestionInfo": "airflow.providers.google_vendor.googleads.v12.services.types.smart_campaign_suggest_service",
    "SuggestGeoTargetConstantsRequest": "airflow.providers.google_vendor.googleads.v12.services.types.geo_target_constant_service",
    "SuggestGeoTargetConstantsResponse": "airflow.providers.google_vendor.googleads.v12.services.types.geo_target_constant_service",
    "SuggestKeywordThemeConstantsRequest": "airflow.providers.google_vendor.googleads.v12.services.types.keyword_theme_constant_service",
    "SuggestKeywordThemeConstantsResponse": "airflow.providers.google_vendor.googleads.v12.services.types.keyword_theme_constant_service",
    "SuggestKeywordThemesRequest": "airflow.providers.google_vendor.googleads.v12.services.types.smart_campaign_suggest_service",
    "SuggestKeywordThemesResponse": "airflow.providers.google_vendor.googleads.v12.services.types.smart_campaign_suggest_service",
    "SuggestSmartCampaignAdRequest": "airflow.providers.google_vendor.googleads.v12.services.types.smart_campaign_suggest_service",
    "SuggestSmartCampaignAdResponse": "airflow.providers.google_vendor.googleads.v12.services.types.smart_campaign_suggest_service",
    "SuggestSmartCampaignBudgetOptionsRequest": "airflow.providers.google_vendor.googleads.v12.services.types.smart_campaign_suggest_service",
    "SuggestSmartCampaignBudgetOptionsResponse": "airflow.providers.google_vendor.googleads.v12.services.types.smart_campaign_suggest_service",
    "Targeting": "airflow.providers.google_vendor.googleads.v12.services.types.reach_plan_service",
    "UnusableAdGroup": "airflow.providers.google_vendor.googleads.v12.services.types.keyword_plan_idea_service",
    "UploadCallConversionsRequest": "airflow.providers.google_vendor.googleads.v12.services.types.conversion_upload_service",
    "UploadCallConversionsResponse": "airflow.providers.google_vendor.googleads.v12.services.types.conversion_upload_service",
    "UploadClickConversionsRequest": "airflow.providers.google_vendor.googleads.v12.services.types.conversion_upload_service",
    "UploadClickConversionsResponse": "airflow.providers.google_vendor.googleads.v12.services.types.conversion_upload_service",
    "UploadConversionAdjustmentsRequest": "airflow.providers.google_vendor.googleads.v12.services.types.conversion_adjustment_upload_service",
    "UploadConversionAdjustmentsResponse": "airflow.providers.google_vendor.googleads.v12.services.types.conversion_adjustment_upload_service",
    "UploadUserDataRequest": "airflow.providers.google_vendor.googleads.v12.services.types.user_data_service",
    "UploadUserDataResponse": "airflow.providers.google_vendor.googleads.v12.services.types.user_data_service",
    "UrlSeed": "airflow.providers.google_vendor.googleads.v12.services.types.keyword_plan_idea_service",
    "UserDataOperation": "airflow.providers.google_vendor.googleads.v12.services.types.user_data_service",
    "UserListOperation": "airflow.providers.google_vendor.googleads.v12.services.types.user_list_service",
    "YouTubeChannelAttributeMetadata": "airflow.providers.google_vendor.googleads.v12.services.types.audience_insights_service",
    "YouTubeSelectLineUp": "airflow.providers.google_vendor.googleads.v12.services.types.reach_plan_service",
    "YouTubeSelectSettings": "airflow.providers.google_vendor.googleads.v12.services.types.reach_plan_service",
    # Enum types
    # Client classes and transports
    "AccountBudgetProposalServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.account_budget_proposal_service",
    "AccountBudgetProposalServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.account_budget_proposal_service.transports",
    "AccountBudgetProposalServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.account_budget_proposal_service.transports",
    "AccountLinkServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.account_link_service",
    "AccountLinkServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.account_link_service.transports",
    "AccountLinkServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.account_link_service.transports",
    "AdGroupAdLabelServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.ad_group_ad_label_service",
    "AdGroupAdLabelServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.ad_group_ad_label_service.transports",
    "AdGroupAdLabelServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.ad_group_ad_label_service.transports",
    "AdGroupAdServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.ad_group_ad_service",
    "AdGroupAdServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.ad_group_ad_service.transports",
    "AdGroupAdServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.ad_group_ad_service.transports",
    "AdGroupAssetServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.ad_group_asset_service",
    "AdGroupAssetServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.ad_group_asset_service.transports",
    "AdGroupAssetServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.ad_group_asset_service.transports",
    "AdGroupAssetSetServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.ad_group_asset_set_service",
    "AdGroupAssetSetServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.ad_group_asset_set_service.transports",
    "AdGroupAssetSetServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.ad_group_asset_set_service.transports",
    "AdGroupBidModifierServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.ad_group_bid_modifier_service",
    "AdGroupBidModifierServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.ad_group_bid_modifier_service.transports",
    "AdGroupBidModifierServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.ad_group_bid_modifier_service.transports",
    "AdGroupCriterionCustomizerServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.ad_group_criterion_customizer_service",
    "AdGroupCriterionCustomizerServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.ad_group_criterion_customizer_service.transports",
    "AdGroupCriterionCustomizerServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.ad_group_criterion_customizer_service.transports",
    "AdGroupCriterionLabelServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.ad_group_criterion_label_service",
    "AdGroupCriterionLabelServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.ad_group_criterion_label_service.transports",
    "AdGroupCriterionLabelServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.ad_group_criterion_label_service.transports",
    "AdGroupCriterionServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.ad_group_criterion_service",
    "AdGroupCriterionServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.ad_group_criterion_service.transports",
    "AdGroupCriterionServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.ad_group_criterion_service.transports",
    "AdGroupCustomizerServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.ad_group_customizer_service",
    "AdGroupCustomizerServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.ad_group_customizer_service.transports",
    "AdGroupCustomizerServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.ad_group_customizer_service.transports",
    "AdGroupExtensionSettingServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.ad_group_extension_setting_service",
    "AdGroupExtensionSettingServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.ad_group_extension_setting_service.transports",
    "AdGroupExtensionSettingServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.ad_group_extension_setting_service.transports",
    "AdGroupFeedServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.ad_group_feed_service",
    "AdGroupFeedServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.ad_group_feed_service.transports",
    "AdGroupFeedServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.ad_group_feed_service.transports",
    "AdGroupLabelServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.ad_group_label_service",
    "AdGroupLabelServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.ad_group_label_service.transports",
    "AdGroupLabelServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.ad_group_label_service.transports",
    "AdGroupServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.ad_group_service",
    "AdGroupServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.ad_group_service.transports",
    "AdGroupServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.ad_group_service.transports",
    "AdParameterServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.ad_parameter_service",
    "AdParameterServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.ad_parameter_service.transports",
    "AdParameterServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.ad_parameter_service.transports",
    "AdServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.ad_service",
    "AdServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.ad_service.transports",
    "AdServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.ad_service.transports",
    "AssetGroupAssetServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.asset_group_asset_service",
    "AssetGroupAssetServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.asset_group_asset_service.transports",
    "AssetGroupAssetServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.asset_group_asset_service.transports",
    "AssetGroupListingGroupFilterServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.asset_group_listing_group_filter_service",
    "AssetGroupListingGroupFilterServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.asset_group_listing_group_filter_service.transports",
    "AssetGroupListingGroupFilterServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.asset_group_listing_group_filter_service.transports",
    "AssetGroupServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.asset_group_service",
    "AssetGroupServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.asset_group_service.transports",
    "AssetGroupServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.asset_group_service.transports",
    "AssetGroupSignalServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.asset_group_signal_service",
    "AssetGroupSignalServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.asset_group_signal_service.transports",
    "AssetGroupSignalServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.asset_group_signal_service.transports",
    "AssetServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.asset_service",
    "AssetServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.asset_service.transports",
    "AssetServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.asset_service.transports",
    "AssetSetAssetServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.asset_set_asset_service",
    "AssetSetAssetServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.asset_set_asset_service.transports",
    "AssetSetAssetServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.asset_set_asset_service.transports",
    "AssetSetServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.asset_set_service",
    "AssetSetServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.asset_set_service.transports",
    "AssetSetServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.asset_set_service.transports",
    "AudienceInsightsServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.audience_insights_service",
    "AudienceInsightsServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.audience_insights_service.transports",
    "AudienceInsightsServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.audience_insights_service.transports",
    "AudienceServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.audience_service",
    "AudienceServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.audience_service.transports",
    "AudienceServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.audience_service.transports",
    "BatchJobServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.batch_job_service",
    "BatchJobServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.batch_job_service.transports",
    "BatchJobServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.batch_job_service.transports",
    "BiddingDataExclusionServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.bidding_data_exclusion_service",
    "BiddingDataExclusionServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.bidding_data_exclusion_service.transports",
    "BiddingDataExclusionServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.bidding_data_exclusion_service.transports",
    "BiddingSeasonalityAdjustmentServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.bidding_seasonality_adjustment_service",
    "BiddingSeasonalityAdjustmentServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.bidding_seasonality_adjustment_service.transports",
    "BiddingSeasonalityAdjustmentServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.bidding_seasonality_adjustment_service.transports",
    "BiddingStrategyServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.bidding_strategy_service",
    "BiddingStrategyServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.bidding_strategy_service.transports",
    "BiddingStrategyServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.bidding_strategy_service.transports",
    "BillingSetupServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.billing_setup_service",
    "BillingSetupServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.billing_setup_service.transports",
    "BillingSetupServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.billing_setup_service.transports",
    "CampaignAssetServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.campaign_asset_service",
    "CampaignAssetServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.campaign_asset_service.transports",
    "CampaignAssetServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.campaign_asset_service.transports",
    "CampaignAssetSetServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.campaign_asset_set_service",
    "CampaignAssetSetServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.campaign_asset_set_service.transports",
    "CampaignAssetSetServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.campaign_asset_set_service.transports",
    "CampaignBidModifierServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.campaign_bid_modifier_service",
    "CampaignBidModifierServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.campaign_bid_modifier_service.transports",
    "CampaignBidModifierServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.campaign_bid_modifier_service.transports",
    "CampaignBudgetServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.campaign_budget_service",
    "CampaignBudgetServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.campaign_budget_service.transports",
    "CampaignBudgetServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.campaign_budget_service.transports",
    "CampaignConversionGoalServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.campaign_conversion_goal_service",
    "CampaignConversionGoalServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.campaign_conversion_goal_service.transports",
    "CampaignConversionGoalServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.campaign_conversion_goal_service.transports",
    "CampaignCriterionServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.campaign_criterion_service",
    "CampaignCriterionServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.campaign_criterion_service.transports",
    "CampaignCriterionServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.campaign_criterion_service.transports",
    "CampaignCustomizerServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.campaign_customizer_service",
    "CampaignCustomizerServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.campaign_customizer_service.transports",
    "CampaignCustomizerServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.campaign_customizer_service.transports",
    "CampaignDraftServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.campaign_draft_service",
    "CampaignDraftServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.campaign_draft_service.transports",
    "CampaignDraftServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.campaign_draft_service.transports",
    "CampaignExtensionSettingServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.campaign_extension_setting_service",
    "CampaignExtensionSettingServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.campaign_extension_setting_service.transports",
    "CampaignExtensionSettingServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.campaign_extension_setting_service.transports",
    "CampaignFeedServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.campaign_feed_service",
    "CampaignFeedServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.campaign_feed_service.transports",
    "CampaignFeedServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.campaign_feed_service.transports",
    "CampaignGroupServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.campaign_group_service",
    "CampaignGroupServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.campaign_group_service.transports",
    "CampaignGroupServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.campaign_group_service.transports",
    "CampaignLabelServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.campaign_label_service",
    "CampaignLabelServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.campaign_label_service.transports",
    "CampaignLabelServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.campaign_label_service.transports",
    "CampaignServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.campaign_service",
    "CampaignServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.campaign_service.transports",
    "CampaignServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.campaign_service.transports",
    "CampaignSharedSetServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.campaign_shared_set_service",
    "CampaignSharedSetServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.campaign_shared_set_service.transports",
    "CampaignSharedSetServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.campaign_shared_set_service.transports",
    "ConversionActionServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.conversion_action_service",
    "ConversionActionServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.conversion_action_service.transports",
    "ConversionActionServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.conversion_action_service.transports",
    "ConversionAdjustmentUploadServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.conversion_adjustment_upload_service",
    "ConversionAdjustmentUploadServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.conversion_adjustment_upload_service.transports",
    "ConversionAdjustmentUploadServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.conversion_adjustment_upload_service.transports",
    "ConversionCustomVariableServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.conversion_custom_variable_service",
    "ConversionCustomVariableServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.conversion_custom_variable_service.transports",
    "ConversionCustomVariableServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.conversion_custom_variable_service.transports",
    "ConversionGoalCampaignConfigServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.conversion_goal_campaign_config_service",
    "ConversionGoalCampaignConfigServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.conversion_goal_campaign_config_service.transports",
    "ConversionGoalCampaignConfigServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.conversion_goal_campaign_config_service.transports",
    "ConversionUploadServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.conversion_upload_service",
    "ConversionUploadServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.conversion_upload_service.transports",
    "ConversionUploadServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.conversion_upload_service.transports",
    "ConversionValueRuleServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.conversion_value_rule_service",
    "ConversionValueRuleServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.conversion_value_rule_service.transports",
    "ConversionValueRuleServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.conversion_value_rule_service.transports",
    "ConversionValueRuleSetServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.conversion_value_rule_set_service",
    "ConversionValueRuleSetServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.conversion_value_rule_set_service.transports",
    "ConversionValueRuleSetServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.conversion_value_rule_set_service.transports",
    "CustomAudienceServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.custom_audience_service",
    "CustomAudienceServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.custom_audience_service.transports",
    "CustomAudienceServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.custom_audience_service.transports",
    "CustomConversionGoalServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.custom_conversion_goal_service",
    "CustomConversionGoalServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.custom_conversion_goal_service.transports",
    "CustomConversionGoalServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.custom_conversion_goal_service.transports",
    "CustomerAssetServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.customer_asset_service",
    "CustomerAssetServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.customer_asset_service.transports",
    "CustomerAssetServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.customer_asset_service.transports",
    "CustomerAssetSetServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.customer_asset_set_service",
    "CustomerAssetSetServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.customer_asset_set_service.transports",
    "CustomerAssetSetServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.customer_asset_set_service.transports",
    "CustomerClientLinkServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.customer_client_link_service",
    "CustomerClientLinkServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.customer_client_link_service.transports",
    "CustomerClientLinkServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.customer_client_link_service.transports",
    "CustomerConversionGoalServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.customer_conversion_goal_service",
    "CustomerConversionGoalServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.customer_conversion_goal_service.transports",
    "CustomerConversionGoalServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.customer_conversion_goal_service.transports",
    "CustomerCustomizerServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.customer_customizer_service",
    "CustomerCustomizerServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.customer_customizer_service.transports",
    "CustomerCustomizerServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.customer_customizer_service.transports",
    "CustomerExtensionSettingServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.customer_extension_setting_service",
    "CustomerExtensionSettingServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.customer_extension_setting_service.transports",
    "CustomerExtensionSettingServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.customer_extension_setting_service.transports",
    "CustomerFeedServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.customer_feed_service",
    "CustomerFeedServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.customer_feed_service.transports",
    "CustomerFeedServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.customer_feed_service.transports",
    "CustomerLabelServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.customer_label_service",
    "CustomerLabelServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.customer_label_service.transports",
    "CustomerLabelServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.customer_label_service.transports",
    "CustomerManagerLinkServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.customer_manager_link_service",
    "CustomerManagerLinkServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.customer_manager_link_service.transports",
    "CustomerManagerLinkServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.customer_manager_link_service.transports",
    "CustomerNegativeCriterionServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.customer_negative_criterion_service",
    "CustomerNegativeCriterionServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.customer_negative_criterion_service.transports",
    "CustomerNegativeCriterionServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.customer_negative_criterion_service.transports",
    "CustomerServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.customer_service",
    "CustomerServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.customer_service.transports",
    "CustomerServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.customer_service.transports",
    "CustomerUserAccessInvitationServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.customer_user_access_invitation_service",
    "CustomerUserAccessInvitationServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.customer_user_access_invitation_service.transports",
    "CustomerUserAccessInvitationServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.customer_user_access_invitation_service.transports",
    "CustomerUserAccessServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.customer_user_access_service",
    "CustomerUserAccessServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.customer_user_access_service.transports",
    "CustomerUserAccessServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.customer_user_access_service.transports",
    "CustomInterestServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.custom_interest_service",
    "CustomInterestServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.custom_interest_service.transports",
    "CustomInterestServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.custom_interest_service.transports",
    "CustomizerAttributeServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.customizer_attribute_service",
    "CustomizerAttributeServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.customizer_attribute_service.transports",
    "CustomizerAttributeServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.customizer_attribute_service.transports",
    "ExperimentArmServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.experiment_arm_service",
    "ExperimentArmServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.experiment_arm_service.transports",
    "ExperimentArmServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.experiment_arm_service.transports",
    "ExperimentServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.experiment_service",
    "ExperimentServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.experiment_service.transports",
    "ExperimentServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.experiment_service.transports",
    "ExtensionFeedItemServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.extension_feed_item_service",
    "ExtensionFeedItemServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.extension_feed_item_service.transports",
    "ExtensionFeedItemServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.extension_feed_item_service.transports",
    "FeedItemServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.feed_item_service",
    "FeedItemServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.feed_item_service.transports",
    "FeedItemServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.feed_item_service.transports",
    "FeedItemSetLinkServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.feed_item_set_link_service",
    "FeedItemSetLinkServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.feed_item_set_link_service.transports",
    "FeedItemSetLinkServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.feed_item_set_link_service.transports",
    "FeedItemSetServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.feed_item_set_service",
    "FeedItemSetServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.feed_item_set_service.transports",
    "FeedItemSetServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.feed_item_set_service.transports",
    "FeedItemTargetServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.feed_item_target_service",
    "FeedItemTargetServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.feed_item_target_service.transports",
    "FeedItemTargetServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.feed_item_target_service.transports",
    "FeedMappingServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.feed_mapping_service",
    "FeedMappingServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.feed_mapping_service.transports",
    "FeedMappingServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.feed_mapping_service.transports",
    "FeedServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.feed_service",
    "FeedServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.feed_service.transports",
    "FeedServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.feed_service.transports",
    "GeoTargetConstantServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.geo_target_constant_service",
    "GeoTargetConstantServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.geo_target_constant_service.transports",
    "GeoTargetConstantServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.geo_target_constant_service.transports",
    "GoogleAdsFieldServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.google_ads_field_service",
    "GoogleAdsFieldServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.google_ads_field_service.transports",
    "GoogleAdsFieldServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.google_ads_field_service.transports",
    "GoogleAdsServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.google_ads_service",
    "GoogleAdsServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.google_ads_service.transports",
    "GoogleAdsServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.google_ads_service.transports",
    "InvoiceServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.invoice_service",
    "InvoiceServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.invoice_service.transports",
    "InvoiceServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.invoice_service.transports",
    "KeywordPlanAdGroupKeywordServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.keyword_plan_ad_group_keyword_service",
    "KeywordPlanAdGroupKeywordServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.keyword_plan_ad_group_keyword_service.transports",
    "KeywordPlanAdGroupKeywordServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.keyword_plan_ad_group_keyword_service.transports",
    "KeywordPlanAdGroupServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.keyword_plan_ad_group_service",
    "KeywordPlanAdGroupServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.keyword_plan_ad_group_service.transports",
    "KeywordPlanAdGroupServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.keyword_plan_ad_group_service.transports",
    "KeywordPlanCampaignKeywordServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.keyword_plan_campaign_keyword_service",
    "KeywordPlanCampaignKeywordServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.keyword_plan_campaign_keyword_service.transports",
    "KeywordPlanCampaignKeywordServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.keyword_plan_campaign_keyword_service.transports",
    "KeywordPlanCampaignServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.keyword_plan_campaign_service",
    "KeywordPlanCampaignServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.keyword_plan_campaign_service.transports",
    "KeywordPlanCampaignServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.keyword_plan_campaign_service.transports",
    "KeywordPlanIdeaServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.keyword_plan_idea_service",
    "KeywordPlanIdeaServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.keyword_plan_idea_service.transports",
    "KeywordPlanIdeaServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.keyword_plan_idea_service.transports",
    "KeywordPlanServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.keyword_plan_service",
    "KeywordPlanServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.keyword_plan_service.transports",
    "KeywordPlanServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.keyword_plan_service.transports",
    "KeywordThemeConstantServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.keyword_theme_constant_service",
    "KeywordThemeConstantServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.keyword_theme_constant_service.transports",
    "KeywordThemeConstantServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.keyword_theme_constant_service.transports",
    "LabelServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.label_service",
    "LabelServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.label_service.transports",
    "LabelServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.label_service.transports",
    "MediaFileServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.media_file_service",
    "MediaFileServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.media_file_service.transports",
    "MediaFileServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.media_file_service.transports",
    "MerchantCenterLinkServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.merchant_center_link_service",
    "MerchantCenterLinkServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.merchant_center_link_service.transports",
    "MerchantCenterLinkServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.merchant_center_link_service.transports",
    "OfflineUserDataJobServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.offline_user_data_job_service",
    "OfflineUserDataJobServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.offline_user_data_job_service.transports",
    "OfflineUserDataJobServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.offline_user_data_job_service.transports",
    "PaymentsAccountServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.payments_account_service",
    "PaymentsAccountServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.payments_account_service.transports",
    "PaymentsAccountServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.payments_account_service.transports",
    "ReachPlanServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.reach_plan_service",
    "ReachPlanServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.reach_plan_service.transports",
    "ReachPlanServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.reach_plan_service.transports",
    "RecommendationServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.recommendation_service",
    "RecommendationServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.recommendation_service.transports",
    "RecommendationServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.recommendation_service.transports",
    "RemarketingActionServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.remarketing_action_service",
    "RemarketingActionServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.remarketing_action_service.transports",
    "RemarketingActionServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.remarketing_action_service.transports",
    "SharedCriterionServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.shared_criterion_service",
    "SharedCriterionServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.shared_criterion_service.transports",
    "SharedCriterionServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.shared_criterion_service.transports",
    "SharedSetServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.shared_set_service",
    "SharedSetServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.shared_set_service.transports",
    "SharedSetServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.shared_set_service.transports",
    "SmartCampaignSettingServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.smart_campaign_setting_service",
    "SmartCampaignSettingServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.smart_campaign_setting_service.transports",
    "SmartCampaignSettingServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.smart_campaign_setting_service.transports",
    "SmartCampaignSuggestServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.smart_campaign_suggest_service",
    "SmartCampaignSuggestServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.smart_campaign_suggest_service.transports",
    "SmartCampaignSuggestServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.smart_campaign_suggest_service.transports",
    "ThirdPartyAppAnalyticsLinkServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.third_party_app_analytics_link_service",
    "ThirdPartyAppAnalyticsLinkServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.third_party_app_analytics_link_service.transports",
    "ThirdPartyAppAnalyticsLinkServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.third_party_app_analytics_link_service.transports",
    "UserDataServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.user_data_service",
    "UserDataServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.user_data_service.transports",
    "UserDataServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.user_data_service.transports",
    "UserListServiceClient": "airflow.providers.google_vendor.googleads.v12.services.services.user_list_service",
    "UserListServiceTransport": "airflow.providers.google_vendor.googleads.v12.services.services.user_list_service.transports",
    "UserListServiceGrpcTransport": "airflow.providers.google_vendor.googleads.v12.services.services.user_list_service.transports",
}


# Background on how this behaves: https://www.python.org/dev/peps/pep-0562/
def __getattr__(name):  # Requires Python >= 3.7
    if name == "__all__":
        all_names = globals()["__all__"] = sorted(_lazy_type_to_package_map)
        return all_names
    elif name in _lazy_type_to_package_map:
        module = importlib.import_module(f"{_lazy_type_to_package_map[name]}")
        klass = getattr(module, name)
        globals()[name] = klass
        return klass
    else:
        raise AttributeError(f"unknown type {name!r}.")


def __dir__():
    return globals().get("__all__") or __getattr__("__all__")
