#
# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.

# NOTE! THIS FILE IS AUTOMATICALLY GENERATED AND WILL BE
# OVERWRITTEN WHEN PREPARING PACKAGES.
#
# IF YOU WANT TO MODIFY IT, YOU SHOULD MODIFY THE TEMPLATE
# `SETUP_TEMPLATE.py.jinja2` IN the `dev/provider_packages` DIRECTORY

"""Setup.py for the apache-airflow-providers-google package."""

from setuptools import find_namespace_packages, setup

version = "10.10.0"


def do_setup():
    """Perform the package apache-airflow-providers-google setup."""
    setup(
        version=version,
        extras_require={
            "amazon": ["apache-airflow-providers-amazon>=2.6.0"],
            "apache.beam": ["apache-airflow-providers-apache-beam", "apache-beam[gcp]"],
            "apache.cassandra": ["apache-airflow-providers-apache-cassandra"],
            "cncf.kubernetes": ["apache-airflow-providers-cncf-kubernetes>=7.2.0"],
            "common.sql": ["apache-airflow-providers-common-sql"],
            "facebook": ["apache-airflow-providers-facebook>=2.2.0"],
            "microsoft.azure": ["apache-airflow-providers-microsoft-azure"],
            "microsoft.mssql": ["apache-airflow-providers-microsoft-mssql"],
            "mysql": ["apache-airflow-providers-mysql"],
            "openlineage": ["apache-airflow-providers-openlineage"],
            "oracle": ["apache-airflow-providers-oracle>=3.1.0"],
            "postgres": ["apache-airflow-providers-postgres"],
            "presto": ["apache-airflow-providers-presto"],
            "salesforce": ["apache-airflow-providers-salesforce"],
            "sftp": ["apache-airflow-providers-sftp"],
            "ssh": ["apache-airflow-providers-ssh"],
            "trino": ["apache-airflow-providers-trino"],
            "leveldb": ["plyvel"],
        },
        packages=find_namespace_packages(
            include=[
                "airflow.providers.google",
                "airflow.providers.google.*",
                "airflow.providers.google_vendor",
                "airflow.providers.google_vendor.*",
            ],
        ),
    )


if __name__ == "__main__":
    do_setup()
