# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.

# NOTE! THIS FILE IS AUTOMATICALLY GENERATED AND WILL BE
# OVERWRITTEN WHEN PREPARING PACKAGES.
#
# IF YOU WANT TO MODIFY IT, YOU SHOULD MODIFY THE TEMPLATE
# `get_provider_info_TEMPLATE.py.jinja2` IN the `provider_packages` DIRECTORY

def get_provider_info():
    return {
        'package-name': 'apache-airflow-providers-dbt-cloud',
        'name': 'dbt Cloud',
        'description': '`dbt Cloud <https://www.getdbt.com/product/what-is-dbt/>`__\n',
        'versions': ['2.1.0', '2.0.1', '2.0.0', '1.0.2', '1.0.1'],
        'dependencies': ['apache-airflow>=2.2.0', 'apache-airflow-providers-http'],
        'integrations': [
            {
                'integration-name': 'dbt Cloud',
                'external-doc-url': 'https://docs.getdbt.com/docs/dbt-cloud/cloud-overview',
                'logo': '/integration-logos/dbt/dbt.png',
                'how-to-guide': ['/docs/apache-airflow-providers-dbt-cloud/operators.rst'],
                'tags': ['dbt'],
            }
        ],
        'operators': [
            {'integration-name': 'dbt Cloud', 'python-modules': ['airflow.providers.dbt.cloud.operators.dbt']}
        ],
        'sensors': [
            {'integration-name': 'dbt Cloud', 'python-modules': ['airflow.providers.dbt.cloud.sensors.dbt']}
        ],
        'hooks': [
            {'integration-name': 'dbt Cloud', 'python-modules': ['airflow.providers.dbt.cloud.hooks.dbt']}
        ],
        'connection-types': [
            {
                'hook-class-name': 'airflow.providers.dbt.cloud.hooks.dbt.DbtCloudHook',
                'connection-type': 'dbt_cloud',
            }
        ],
        'extra-links': ['airflow.providers.dbt.cloud.operators.dbt.DbtCloudRunJobOperatorLink'],
    }
