# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.

# NOTE! THIS FILE IS AUTOMATICALLY GENERATED AND WILL BE
# OVERWRITTEN WHEN PREPARING PACKAGES.
#
# IF YOU WANT TO MODIFY IT, YOU SHOULD MODIFY THE TEMPLATE
# `get_provider_info_TEMPLATE.py.jinja2` IN the `provider_packages` DIRECTORY


def get_provider_info():
    return {
        "package-name": "apache-airflow-providers-daskexecutor",
        "name": "Dask Executor",
        "description": "`Dask <https://www.dask.org/>`__\n",
        "suspended": False,
        "versions": ["1.0.1", "1.0.0"],
        "dependencies": [
            "apache-airflow>=2.4.0",
            "cloudpickle>=1.4.1",
            "dask>=2.9.0,!=2022.10.1,!=2023.5.0",
            "distributed>=2.11.1,!=2023.5.0",
        ],
        "integrations": [
            {
                "integration-name": "Dask",
                "external-doc-url": "https://www.dask.org/",
                "logo": "/integration-logos/dask/dask.png",
                "tags": ["service"],
            }
        ],
        "executors": ["airflow.providers.daskexecutor.executors.dask_executor.DaskExecutor"],
        "config": {
            "dask": {
                "description": "This section only applies if you are using DaskExecutor.\n",
                "options": {
                    "cluster_address": {
                        "description": "The IP address and port of the Dask cluster's scheduler.\n",
                        "version_added": None,
                        "type": "string",
                        "example": None,
                        "default": "127.0.0.1:8786",
                    },
                    "tls_ca": {
                        "description": "Path to a CA certificate file encoded in PEM format to access a secured Dask scheduler.\n",
                        "version_added": None,
                        "type": "string",
                        "example": None,
                        "default": "",
                    },
                    "tls_cert": {
                        "description": "Path to a certificate file for the client, encoded in PEM format.\n",
                        "version_added": None,
                        "type": "string",
                        "example": None,
                        "default": "",
                    },
                    "tls_key": {
                        "description": "Path to a key file for the client, encoded in PEM format.\n",
                        "version_added": None,
                        "type": "string",
                        "example": None,
                        "default": "",
                    },
                },
            }
        },
    }
