# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.

# NOTE! THIS FILE IS AUTOMATICALLY GENERATED AND WILL BE
# OVERWRITTEN WHEN PREPARING PACKAGES.
#
# IF YOU WANT TO MODIFY IT, YOU SHOULD MODIFY THE TEMPLATE
# `get_provider_info_TEMPLATE.py.jinja2` IN the `provider_packages` DIRECTORY

def get_provider_info():
    return {
        'package-name': 'apache-airflow-providers-cncf-kubernetes',
        'name': 'Kubernetes',
        'description': '`Kubernetes <https://kubernetes.io/>`__\n',
        'versions': [
            '3.0.2',
            '3.0.1',
            '3.0.0',
            '2.2.0',
            '2.1.0',
            '2.0.3',
            '2.0.2',
            '2.0.1',
            '2.0.0',
            '1.2.0',
            '1.1.0',
            '1.0.2',
            '1.0.1',
            '1.0.0',
        ],
        'additional-dependencies': ['apache-airflow>=2.1.0'],
        'integrations': [
            {
                'integration-name': 'Kubernetes',
                'external-doc-url': 'https://kubernetes.io/',
                'how-to-guide': ['/docs/apache-airflow-providers-cncf-kubernetes/operators.rst'],
                'logo': '/integration-logos/kubernetes/Kubernetes.png',
                'tags': ['software'],
            },
            {
                'integration-name': 'Spark on Kubernetes',
                'external-doc-url': 'https://github.com/GoogleCloudPlatform/spark-on-k8s-operator',
                'logo': '/integration-logos/kubernetes/Spark-On-Kubernetes.png',
                'tags': ['software'],
            },
        ],
        'operators': [
            {
                'integration-name': 'Kubernetes',
                'python-modules': [
                    'airflow.providers.cncf.kubernetes.operators.kubernetes_pod',
                    'airflow.providers.cncf.kubernetes.operators.spark_kubernetes',
                ],
            }
        ],
        'sensors': [
            {
                'integration-name': 'Kubernetes',
                'python-modules': ['airflow.providers.cncf.kubernetes.sensors.spark_kubernetes'],
            }
        ],
        'hooks': [
            {
                'integration-name': 'Kubernetes',
                'python-modules': ['airflow.providers.cncf.kubernetes.hooks.kubernetes'],
            }
        ],
        'hook-class-names': ['airflow.providers.cncf.kubernetes.hooks.kubernetes.KubernetesHook'],
        'connection-types': [
            {
                'hook-class-name': 'airflow.providers.cncf.kubernetes.hooks.kubernetes.KubernetesHook',
                'connection-type': 'kubernetes',
            }
        ],
    }
