# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.

# NOTE! THIS FILE IS AUTOMATICALLY GENERATED AND WILL BE
# OVERWRITTEN WHEN PREPARING PACKAGES.
#
# IF YOU WANT TO MODIFY IT, YOU SHOULD MODIFY THE TEMPLATE
# `get_provider_info_TEMPLATE.py.jinja2` IN the `provider_packages` DIRECTORY


def get_provider_info():
    return {
        "package-name": "apache-airflow-providers-apache-beam",
        "name": "Apache Beam",
        "description": "`Apache Beam <https://beam.apache.org/>`__.\n",
        "suspended": False,
        "versions": [
            "5.2.3",
            "5.2.2",
            "5.2.1",
            "5.2.0",
            "5.1.1",
            "5.1.0",
            "5.0.0",
            "4.3.0",
            "4.2.0",
            "4.1.1",
            "4.1.0",
            "4.0.0",
            "3.4.0",
            "3.3.0",
            "3.2.1",
            "3.2.0",
            "3.1.0",
            "3.0.1",
            "3.0.0",
            "2.0.0",
            "1.0.1",
            "1.0.0",
        ],
        "dependencies": ["apache-airflow>=2.4.0", "apache-beam>=2.47.0"],
        "integrations": [
            {
                "integration-name": "Apache Beam",
                "external-doc-url": "https://beam.apache.org/",
                "how-to-guide": ["/docs/apache-airflow-providers-apache-beam/operators.rst"],
                "tags": ["apache"],
            }
        ],
        "operators": [
            {
                "integration-name": "Apache Beam",
                "python-modules": ["airflow.providers.apache.beam.operators.beam"],
            }
        ],
        "hooks": [
            {
                "integration-name": "Apache Beam",
                "python-modules": ["airflow.providers.apache.beam.hooks.beam"],
            }
        ],
        "triggers": [
            {
                "integration-name": "Apache Beam",
                "python-modules": ["airflow.providers.apache.beam.triggers.beam"],
            }
        ],
        "additional-extras": [{"name": "google", "dependencies": ["apache-beam[gcp]"]}],
    }
