# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.

# NOTE! THIS FILE IS AUTOMATICALLY GENERATED AND WILL BE
# OVERWRITTEN WHEN PREPARING PACKAGES.
#
# IF YOU WANT TO MODIFY IT, YOU SHOULD MODIFY THE TEMPLATE
# `get_provider_info_TEMPLATE.py.jinja2` IN the `provider_packages` DIRECTORY


def get_provider_info():
    return {
        'package-name': 'apache-airflow-providers-alibaba',
        'name': 'Alibaba',
        'description': 'Alibaba Cloud integration (including `Alibaba Cloud <https://www.alibabacloud.com//>`__).\n',
        'versions': ['1.0.0'],
        'additional-dependencies': ['apache-airflow>=2.1.0'],
        'integrations': [
            {
                'integration-name': 'Alibaba Cloud OSS',
                'external-doc-url': 'https://www.alibabacloud.com/help/product/31815.htm',
                'logo': '/integration-logos/alibaba/cloud/alibabacloud-oss.png',
                'how-to-guide': ['/docs/apache-airflow-providers-alibaba/operators/oss.rst'],
                'tags': ['alibaba'],
            }
        ],
        'operators': [
            {
                'integration-name': 'Alibaba Cloud OSS',
                'python-modules': ['airflow.providers.alibaba.cloud.operators.oss'],
            }
        ],
        'sensors': [
            {
                'integration-name': 'Alibaba Cloud OSS',
                'python-modules': ['airflow.providers.alibaba.cloud.sensors.oss_key'],
            }
        ],
        'hooks': [
            {
                'integration-name': 'Alibaba Cloud OSS',
                'python-modules': ['airflow.providers.alibaba.cloud.hooks.oss'],
            }
        ],
        'hook-class-names': ['airflow.providers.alibaba.cloud.hooks.oss.OSSHook'],
        'connection-types': [
            {'hook-class-name': 'airflow.providers.alibaba.cloud.hooks.oss.OSSHook', 'connection-type': 'oss'}
        ],
    }
