/*!
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/* eslint-disable */
import type { CamelCasedPropertiesDeep } from "type-fest";
/**
 * This file was auto-generated by openapi-typescript.
 * Do not make direct changes to the file.
 */

export interface paths {
  "/connections": {
    get: operations["get_connections"];
    post: operations["post_connection"];
  };
  "/connections/{connection_id}": {
    get: operations["get_connection"];
    delete: operations["delete_connection"];
    patch: operations["patch_connection"];
    parameters: {
      path: {
        /** The connection ID. */
        connection_id: components["parameters"]["ConnectionID"];
      };
    };
  };
  "/connections/test": {
    /**
     * Test a connection.
     *
     * *New in version 2.2.0*
     */
    post: operations["test_connection"];
  };
  "/dags": {
    /**
     * List DAGs in the database.
     * `dag_id_pattern` can be set to match dags of a specific pattern
     */
    get: operations["get_dags"];
    /**
     * Update DAGs of a given dag_id_pattern using UpdateMask.
     * This endpoint allows specifying `~` as the dag_id_pattern to update all DAGs.
     * *New in version 2.3.0*
     */
    patch: operations["patch_dags"];
  };
  "/dags/{dag_id}": {
    /**
     * Presents only information available in database (DAGModel).
     * If you need detailed information, consider using GET /dags/{dag_id}/details.
     */
    get: operations["get_dag"];
    /**
     * Deletes all metadata related to the DAG, including finished DAG Runs and Tasks.
     * Logs are not deleted. This action cannot be undone.
     *
     * *New in version 2.2.0*
     */
    delete: operations["delete_dag"];
    patch: operations["patch_dag"];
    parameters: {
      path: {
        /** The DAG ID. */
        dag_id: components["parameters"]["DAGID"];
      };
    };
  };
  "/dags/{dag_id}/clearTaskInstances": {
    /** Clears a set of task instances associated with the DAG for a specified date range. */
    post: operations["post_clear_task_instances"];
    parameters: {
      path: {
        /** The DAG ID. */
        dag_id: components["parameters"]["DAGID"];
      };
    };
  };
  "/dags/{dag_id}/dagRuns/{dag_run_id}/taskInstances/{task_id}/setNote": {
    /**
     * Update the manual user note of a non-mapped Task Instance.
     *
     * *New in version 2.5.0*
     */
    patch: operations["set_task_instance_note"];
    parameters: {
      path: {
        /** The DAG ID. */
        dag_id: components["parameters"]["DAGID"];
        /** The DAG run ID. */
        dag_run_id: components["parameters"]["DAGRunID"];
        /** The task ID. */
        task_id: components["parameters"]["TaskID"];
      };
    };
  };
  "/dags/{dag_id}/dagRuns/{dag_run_id}/taskInstances/{task_id}/{map_index}/setNote": {
    /**
     * Update the manual user note of a mapped Task Instance.
     *
     * *New in version 2.5.0*
     */
    patch: operations["set_mapped_task_instance_note"];
    parameters: {
      path: {
        /** The DAG ID. */
        dag_id: components["parameters"]["DAGID"];
        /** The DAG run ID. */
        dag_run_id: components["parameters"]["DAGRunID"];
        /** The task ID. */
        task_id: components["parameters"]["TaskID"];
        /** The map index. */
        map_index: components["parameters"]["MapIndex"];
      };
    };
  };
  "/dags/{dag_id}/updateTaskInstancesState": {
    /** Updates the state for multiple task instances simultaneously. */
    post: operations["post_set_task_instances_state"];
    parameters: {
      path: {
        /** The DAG ID. */
        dag_id: components["parameters"]["DAGID"];
      };
    };
  };
  "/dags/{dag_id}/dagRuns": {
    /** This endpoint allows specifying `~` as the dag_id to retrieve DAG runs for all DAGs. */
    get: operations["get_dag_runs"];
    post: operations["post_dag_run"];
    parameters: {
      path: {
        /** The DAG ID. */
        dag_id: components["parameters"]["DAGID"];
      };
    };
  };
  "/dags/~/dagRuns/list": {
    /** This endpoint is a POST to allow filtering across a large number of DAG IDs, where as a GET it would run in to maximum HTTP request URL length limit. */
    post: operations["get_dag_runs_batch"];
  };
  "/dags/{dag_id}/dagRuns/{dag_run_id}": {
    get: operations["get_dag_run"];
    delete: operations["delete_dag_run"];
    /**
     * Modify a DAG run.
     *
     * *New in version 2.2.0*
     */
    patch: operations["update_dag_run_state"];
    parameters: {
      path: {
        /** The DAG ID. */
        dag_id: components["parameters"]["DAGID"];
        /** The DAG run ID. */
        dag_run_id: components["parameters"]["DAGRunID"];
      };
    };
  };
  "/dags/{dag_id}/dagRuns/{dag_run_id}/clear": {
    /**
     * Clear a DAG run.
     *
     * *New in version 2.4.0*
     */
    post: operations["clear_dag_run"];
    parameters: {
      path: {
        /** The DAG ID. */
        dag_id: components["parameters"]["DAGID"];
        /** The DAG run ID. */
        dag_run_id: components["parameters"]["DAGRunID"];
      };
    };
  };
  "/dags/{dag_id}/dagRuns/{dag_run_id}/upstreamDatasetEvents": {
    /**
     * Get datasets for a dag run.
     *
     * *New in version 2.4.0*
     */
    get: operations["get_upstream_dataset_events"];
    parameters: {
      path: {
        /** The DAG ID. */
        dag_id: components["parameters"]["DAGID"];
        /** The DAG run ID. */
        dag_run_id: components["parameters"]["DAGRunID"];
      };
    };
  };
  "/dags/{dag_id}/dagRuns/{dag_run_id}/setNote": {
    /**
     * Update the manual user note of a DagRun.
     *
     * *New in version 2.5.0*
     */
    patch: operations["set_dag_run_note"];
    parameters: {
      path: {
        /** The DAG ID. */
        dag_id: components["parameters"]["DAGID"];
        /** The DAG run ID. */
        dag_run_id: components["parameters"]["DAGRunID"];
      };
    };
  };
  "/eventLogs": {
    /** List log entries from event log. */
    get: operations["get_event_logs"];
  };
  "/eventLogs/{event_log_id}": {
    get: operations["get_event_log"];
    parameters: {
      path: {
        /** The event log ID. */
        event_log_id: components["parameters"]["EventLogID"];
      };
    };
  };
  "/importErrors": {
    get: operations["get_import_errors"];
  };
  "/importErrors/{import_error_id}": {
    get: operations["get_import_error"];
    parameters: {
      path: {
        /** The import error ID. */
        import_error_id: components["parameters"]["ImportErrorID"];
      };
    };
  };
  "/pools": {
    get: operations["get_pools"];
    post: operations["post_pool"];
  };
  "/pools/{pool_name}": {
    get: operations["get_pool"];
    delete: operations["delete_pool"];
    patch: operations["patch_pool"];
    parameters: {
      path: {
        /** The pool name. */
        pool_name: components["parameters"]["PoolName"];
      };
    };
  };
  "/providers": {
    /**
     * Get a list of providers.
     *
     * *New in version 2.1.0*
     */
    get: operations["get_providers"];
  };
  "/dags/{dag_id}/dagRuns/{dag_run_id}/taskInstances": {
    /** This endpoint allows specifying `~` as the dag_id, dag_run_id to retrieve DAG runs for all DAGs and DAG runs. */
    get: operations["get_task_instances"];
    parameters: {
      path: {
        /** The DAG ID. */
        dag_id: components["parameters"]["DAGID"];
        /** The DAG run ID. */
        dag_run_id: components["parameters"]["DAGRunID"];
      };
      query: {
        /**
         * Returns objects greater or equal to the specified date.
         *
         * This can be combined with execution_date_lte parameter to receive only the selected period.
         */
        execution_date_gte?: components["parameters"]["FilterExecutionDateGTE"];
        /**
         * Returns objects less than or equal to the specified date.
         *
         * This can be combined with execution_date_gte parameter to receive only the selected period.
         */
        execution_date_lte?: components["parameters"]["FilterExecutionDateLTE"];
        /**
         * Returns objects greater or equal the specified date.
         *
         * This can be combined with start_date_lte parameter to receive only the selected period.
         */
        start_date_gte?: components["parameters"]["FilterStartDateGTE"];
        /**
         * Returns objects less or equal the specified date.
         *
         * This can be combined with start_date_gte parameter to receive only the selected period.
         */
        start_date_lte?: components["parameters"]["FilterStartDateLTE"];
        /**
         * Returns objects greater or equal the specified date.
         *
         * This can be combined with start_date_lte parameter to receive only the selected period.
         */
        end_date_gte?: components["parameters"]["FilterEndDateGTE"];
        /**
         * Returns objects less than or equal to the specified date.
         *
         * This can be combined with start_date_gte parameter to receive only the selected period.
         */
        end_date_lte?: components["parameters"]["FilterEndDateLTE"];
        /**
         * Returns objects greater or equal the specified date.
         *
         * This can be combined with updated_at_lte parameter to receive only the selected period.
         *
         * *New in version 2.6.0*
         */
        updated_at_gte?: components["parameters"]["FilterUpdatedAtGTE"];
        /**
         * Returns objects less or equal the specified date.
         *
         * This can be combined with updated_at_gte parameter to receive only the selected period.
         *
         * *New in version 2.6.0*
         */
        updated_at_lte?: components["parameters"]["FilterUpdatedAtLTE"];
        /**
         * Returns objects greater than or equal to the specified values.
         *
         * This can be combined with duration_lte parameter to receive only the selected period.
         */
        duration_gte?: components["parameters"]["FilterDurationGTE"];
        /**
         * Returns objects less than or equal to the specified values.
         *
         * This can be combined with duration_gte parameter to receive only the selected range.
         */
        duration_lte?: components["parameters"]["FilterDurationLTE"];
        /** The value can be repeated to retrieve multiple matching values (OR condition). */
        state?: components["parameters"]["FilterState"];
        /** The value can be repeated to retrieve multiple matching values (OR condition). */
        pool?: components["parameters"]["FilterPool"];
        /** The value can be repeated to retrieve multiple matching values (OR condition). */
        queue?: components["parameters"]["FilterQueue"];
      };
    };
  };
  "/dags/{dag_id}/dagRuns/{dag_run_id}/taskInstances/{task_id}": {
    get: operations["get_task_instance"];
    /**
     * Updates the state for single task instance.
     * *New in version 2.5.0*
     */
    patch: operations["patch_task_instance"];
    parameters: {
      path: {
        /** The DAG ID. */
        dag_id: components["parameters"]["DAGID"];
        /** The DAG run ID. */
        dag_run_id: components["parameters"]["DAGRunID"];
        /** The task ID. */
        task_id: components["parameters"]["TaskID"];
      };
    };
  };
  "/dags/{dag_id}/dagRuns/{dag_run_id}/taskInstances/{task_id}/{map_index}": {
    /**
     * Get details of a mapped task instance.
     *
     * *New in version 2.3.0*
     */
    get: operations["get_mapped_task_instance"];
    /**
     * Updates the state for single mapped task instance.
     * *New in version 2.5.0*
     */
    patch: operations["patch_mapped_task_instance"];
    parameters: {
      path: {
        /** The DAG ID. */
        dag_id: components["parameters"]["DAGID"];
        /** The DAG run ID. */
        dag_run_id: components["parameters"]["DAGRunID"];
        /** The task ID. */
        task_id: components["parameters"]["TaskID"];
        /** The map index. */
        map_index: components["parameters"]["MapIndex"];
      };
    };
  };
  "/dags/{dag_id}/dagRuns/{dag_run_id}/taskInstances/{task_id}/listMapped": {
    /**
     * Get details of all mapped task instances.
     *
     * *New in version 2.3.0*
     */
    get: operations["get_mapped_task_instances"];
    parameters: {
      path: {
        /** The DAG ID. */
        dag_id: components["parameters"]["DAGID"];
        /** The DAG run ID. */
        dag_run_id: components["parameters"]["DAGRunID"];
        /** The task ID. */
        task_id: components["parameters"]["TaskID"];
      };
    };
  };
  "/dags/~/dagRuns/~/taskInstances/list": {
    /**
     * List task instances from all DAGs and DAG runs.
     * This endpoint is a POST to allow filtering across a large number of DAG IDs, where as a GET it would run in to maximum HTTP request URL length limits.
     */
    post: operations["get_task_instances_batch"];
  };
  "/variables": {
    /** The collection does not contain data. To get data, you must get a single entity. */
    get: operations["get_variables"];
    post: operations["post_variables"];
  };
  "/variables/{variable_key}": {
    /** Get a variable by key. */
    get: operations["get_variable"];
    delete: operations["delete_variable"];
    /** Update a variable by key. */
    patch: operations["patch_variable"];
    parameters: {
      path: {
        /** The variable Key. */
        variable_key: components["parameters"]["VariableKey"];
      };
    };
  };
  "/dags/{dag_id}/dagRuns/{dag_run_id}/taskInstances/{task_id}/xcomEntries": {
    /** This endpoint allows specifying `~` as the dag_id, dag_run_id, task_id to retrieve XCOM entries for for all DAGs, DAG runs and task instances. XCom values won't be returned as they can be large. Use this endpoint to get a list of XCom entries and then fetch individual entry to get value. */
    get: operations["get_xcom_entries"];
    parameters: {
      path: {
        /** The DAG ID. */
        dag_id: components["parameters"]["DAGID"];
        /** The DAG run ID. */
        dag_run_id: components["parameters"]["DAGRunID"];
        /** The task ID. */
        task_id: components["parameters"]["TaskID"];
      };
    };
  };
  "/dags/{dag_id}/dagRuns/{dag_run_id}/taskInstances/{task_id}/xcomEntries/{xcom_key}": {
    get: operations["get_xcom_entry"];
    parameters: {
      path: {
        /** The DAG ID. */
        dag_id: components["parameters"]["DAGID"];
        /** The DAG run ID. */
        dag_run_id: components["parameters"]["DAGRunID"];
        /** The task ID. */
        task_id: components["parameters"]["TaskID"];
        /** The XCom key. */
        xcom_key: components["parameters"]["XComKey"];
      };
    };
  };
  "/dags/{dag_id}/dagRuns/{dag_run_id}/taskInstances/{task_id}/links": {
    /** List extra links for task instance. */
    get: operations["get_extra_links"];
    parameters: {
      path: {
        /** The DAG ID. */
        dag_id: components["parameters"]["DAGID"];
        /** The DAG run ID. */
        dag_run_id: components["parameters"]["DAGRunID"];
        /** The task ID. */
        task_id: components["parameters"]["TaskID"];
      };
    };
  };
  "/dags/{dag_id}/dagRuns/{dag_run_id}/taskInstances/{task_id}/logs/{task_try_number}": {
    /** Get logs for a specific task instance and its try number. */
    get: operations["get_log"];
    parameters: {
      path: {
        /** The DAG ID. */
        dag_id: components["parameters"]["DAGID"];
        /** The DAG run ID. */
        dag_run_id: components["parameters"]["DAGRunID"];
        /** The task ID. */
        task_id: components["parameters"]["TaskID"];
        /** The task try number. */
        task_try_number: components["parameters"]["TaskTryNumber"];
      };
      query: {
        /**
         * A full content will be returned.
         * By default, only the first fragment will be returned.
         */
        full_content?: components["parameters"]["FullContent"];
        /** Filter on map index for mapped task. */
        map_index?: components["parameters"]["FilterMapIndex"];
        /**
         * A token that allows you to continue fetching logs.
         * If passed, it will specify the location from which the download should be continued.
         */
        token?: components["parameters"]["ContinuationToken"];
      };
    };
  };
  "/dags/{dag_id}/details": {
    /** The response contains many DAG attributes, so the response can be large. If possible, consider using GET /dags/{dag_id}. */
    get: operations["get_dag_details"];
    parameters: {
      path: {
        /** The DAG ID. */
        dag_id: components["parameters"]["DAGID"];
      };
    };
  };
  "/dags/{dag_id}/tasks": {
    get: operations["get_tasks"];
    parameters: {
      path: {
        /** The DAG ID. */
        dag_id: components["parameters"]["DAGID"];
      };
      query: {
        /**
         * The name of the field to order the results by.
         * Prefix a field name with `-` to reverse the sort order.
         *
         * *New in version 2.1.0*
         */
        order_by?: components["parameters"]["OrderBy"];
      };
    };
  };
  "/dags/{dag_id}/tasks/{task_id}": {
    get: operations["get_task"];
    parameters: {
      path: {
        /** The DAG ID. */
        dag_id: components["parameters"]["DAGID"];
        /** The task ID. */
        task_id: components["parameters"]["TaskID"];
      };
    };
  };
  "/dagSources/{file_token}": {
    /** Get a source code using file token. */
    get: operations["get_dag_source"];
    parameters: {
      path: {
        /**
         * The key containing the encrypted path to the file. Encryption and decryption take place only on
         * the server. This prevents the client from reading an non-DAG file. This also ensures API
         * extensibility, because the format of encrypted data may change.
         */
        file_token: components["parameters"]["FileToken"];
      };
    };
  };
  "/dagWarnings": {
    get: operations["get_dag_warnings"];
  };
  "/datasets": {
    get: operations["get_datasets"];
  };
  "/datasets/{uri}": {
    /** Get a dataset by uri. */
    get: operations["get_dataset"];
    parameters: {
      path: {
        /** The encoded Dataset URI */
        uri: components["parameters"]["DatasetURI"];
      };
    };
  };
  "/datasets/events": {
    /** Get dataset events */
    get: operations["get_dataset_events"];
    parameters: {
      query: {
        /** The numbers of items to return. */
        limit?: components["parameters"]["PageLimit"];
        /** The number of items to skip before starting to collect the result set. */
        offset?: components["parameters"]["PageOffset"];
        /**
         * The name of the field to order the results by.
         * Prefix a field name with `-` to reverse the sort order.
         *
         * *New in version 2.1.0*
         */
        order_by?: components["parameters"]["OrderBy"];
        /** The Dataset ID that updated the dataset. */
        dataset_id?: components["parameters"]["FilterDatasetID"];
        /** The DAG ID that updated the dataset. */
        source_dag_id?: components["parameters"]["FilterSourceDAGID"];
        /** The task ID that updated the dataset. */
        source_task_id?: components["parameters"]["FilterSourceTaskID"];
        /** The DAG run ID that updated the dataset. */
        source_run_id?: components["parameters"]["FilterSourceRunID"];
        /** The map index that updated the dataset. */
        source_map_index?: components["parameters"]["FilterSourceMapIndex"];
      };
    };
  };
  "/config": {
    get: operations["get_config"];
  };
  "/health": {
    /**
     * Get the status of Airflow's metadatabase and scheduler. It includes info about
     * metadatabase and last heartbeat of scheduler.
     */
    get: operations["get_health"];
  };
  "/version": {
    get: operations["get_version"];
  };
  "/plugins": {
    /**
     * Get a list of loaded plugins.
     *
     * *New in version 2.1.0*
     */
    get: operations["get_plugins"];
  };
  "/roles": {
    /**
     * Get a list of roles.
     *
     * *New in version 2.1.0*
     */
    get: operations["get_roles"];
    /**
     * Create a new role.
     *
     * *New in version 2.1.0*
     */
    post: operations["post_role"];
  };
  "/roles/{role_name}": {
    /**
     * Get a role.
     *
     * *New in version 2.1.0*
     */
    get: operations["get_role"];
    /**
     * Delete a role.
     *
     * *New in version 2.1.0*
     */
    delete: operations["delete_role"];
    /**
     * Update a role.
     *
     * *New in version 2.1.0*
     */
    patch: operations["patch_role"];
    parameters: {
      path: {
        /** The role name */
        role_name: components["parameters"]["RoleName"];
      };
    };
  };
  "/permissions": {
    /**
     * Get a list of permissions.
     *
     * *New in version 2.1.0*
     */
    get: operations["get_permissions"];
  };
  "/users": {
    /**
     * Get a list of users.
     *
     * *New in version 2.1.0*
     */
    get: operations["get_users"];
    /**
     * Create a new user with unique username and email.
     *
     * *New in version 2.2.0*
     */
    post: operations["post_user"];
  };
  "/users/{username}": {
    /**
     * Get a user with a specific username.
     *
     * *New in version 2.1.0*
     */
    get: operations["get_user"];
    /**
     * Delete a user with a specific username.
     *
     * *New in version 2.2.0*
     */
    delete: operations["delete_user"];
    /**
     * Update fields for a user.
     *
     * *New in version 2.2.0*
     */
    patch: operations["patch_user"];
    parameters: {
      path: {
        /**
         * The username of the user.
         *
         * *New in version 2.1.0*
         */
        username: components["parameters"]["Username"];
      };
    };
  };
}

export interface components {
  schemas: {
    /**
     * @description A user object.
     *
     * *New in version 2.1.0*
     */
    UserCollectionItem: {
      /**
       * @description The user's first name.
       *
       * *Changed in version 2.4.0*&#58; The requirement for this to be non-empty was removed.
       */
      first_name?: string;
      /**
       * @description The user's last name.
       *
       * *Changed in version 2.4.0*&#58; The requirement for this to be non-empty was removed.
       */
      last_name?: string;
      /**
       * @description The username.
       *
       * *Changed in version 2.2.0*&#58; A minimum character length requirement ('minLength') is added.
       */
      username?: string;
      /**
       * @description The user's email.
       *
       * *Changed in version 2.2.0*&#58; A minimum character length requirement ('minLength') is added.
       */
      email?: string;
      /** @description Whether the user is active */
      active?: boolean | null;
      /**
       * Format: datetime
       * @description The last user login
       */
      last_login?: string | null;
      /** @description The login count */
      login_count?: number | null;
      /** @description The number of times the login failed */
      failed_login_count?: number | null;
      /**
       * @description User roles.
       *
       * *Changed in version 2.2.0*&#58; Field is no longer read-only.
       */
      roles?: ({
        name?: string;
      } | null)[];
      /**
       * Format: datetime
       * @description The date user was created
       */
      created_on?: string | null;
      /**
       * Format: datetime
       * @description The date user was changed
       */
      changed_on?: string | null;
    };
    /**
     * @description A user object with sensitive data.
     *
     * *New in version 2.1.0*
     */
    User: components["schemas"]["UserCollectionItem"] & {
      password?: string;
    };
    /**
     * @description Collection of users.
     *
     * *New in version 2.1.0*
     */
    UserCollection: {
      users?: components["schemas"]["UserCollectionItem"][];
    } & components["schemas"]["CollectionInfo"];
    /**
     * @description Connection collection item.
     * The password and extra fields are only available when retrieving a single object due to the sensitivity of this data.
     */
    ConnectionCollectionItem: {
      /** @description The connection ID. */
      connection_id?: string;
      /** @description The connection type. */
      conn_type?: string;
      /** @description The description of the connection. */
      description?: string | null;
      /** @description Host of the connection. */
      host?: string | null;
      /** @description Login of the connection. */
      login?: string | null;
      /** @description Schema of the connection. */
      schema?: string | null;
      /** @description Port of the connection. */
      port?: number | null;
    };
    /**
     * @description Collection of connections.
     *
     * *Changed in version 2.1.0*&#58; 'total_entries' field is added.
     */
    ConnectionCollection: {
      connections?: components["schemas"]["ConnectionCollectionItem"][];
    } & components["schemas"]["CollectionInfo"];
    /** @description Full representation of the connection. */
    Connection: components["schemas"]["ConnectionCollectionItem"] & {
      /**
       * Format: password
       * @description Password of the connection.
       */
      password?: string;
      /** @description Other values that cannot be put into another field, e.g. RSA keys. */
      extra?: string | null;
    };
    /**
     * @description Connection test results.
     *
     * *New in version 2.2.0*
     */
    ConnectionTest: {
      /** @description The status of the request. */
      status?: boolean;
      /** @description The success or failure message of the request. */
      message?: string;
    };
    /** @description DAG */
    DAG: {
      /** @description The ID of the DAG. */
      dag_id?: string;
      /** @description If the DAG is SubDAG then it is the top level DAG identifier. Otherwise, null. */
      root_dag_id?: string | null;
      /** @description Whether the DAG is paused. */
      is_paused?: boolean | null;
      /**
       * @description Whether the DAG is currently seen by the scheduler(s).
       *
       * *New in version 2.1.1*
       *
       * *Changed in version 2.2.0*&#58; Field is read-only.
       */
      is_active?: boolean | null;
      /** @description Whether the DAG is SubDAG. */
      is_subdag?: boolean;
      /**
       * Format: date-time
       * @description The last time the DAG was parsed.
       *
       * *New in version 2.3.0*
       */
      last_parsed_time?: string | null;
      /**
       * Format: date-time
       * @description The last time the DAG was pickled.
       *
       * *New in version 2.3.0*
       */
      last_pickled?: string | null;
      /**
       * Format: date-time
       * @description Time when the DAG last received a refresh signal
       * (e.g. the DAG's "refresh" button was clicked in the web UI)
       *
       * *New in version 2.3.0*
       */
      last_expired?: string | null;
      /**
       * @description Whether (one of) the scheduler is scheduling this DAG at the moment
       *
       * *New in version 2.3.0*
       */
      scheduler_lock?: boolean | null;
      /**
       * @description Foreign key to the latest pickle_id
       *
       * *New in version 2.3.0*
       */
      pickle_id?: string | null;
      /**
       * @description Default view of the DAG inside the webserver
       *
       * *New in version 2.3.0*
       */
      default_view?: string | null;
      /** @description The absolute path to the file. */
      fileloc?: string;
      /** @description The key containing the encrypted path to the file. Encryption and decryption take place only on the server. This prevents the client from reading an non-DAG file. This also ensures API extensibility, because the format of encrypted data may change. */
      file_token?: string;
      owners?: string[];
      /** @description User-provided DAG description, which can consist of several sentences or paragraphs that describe DAG contents. */
      description?: string | null;
      schedule_interval?: components["schemas"]["ScheduleInterval"];
      /**
       * @description Timetable/Schedule Interval description.
       *
       * *New in version 2.3.0*
       */
      timetable_description?: string | null;
      /** @description List of tags. */
      tags?: components["schemas"]["Tag"][] | null;
      /**
       * @description Maximum number of active tasks that can be run on the DAG
       *
       * *New in version 2.3.0*
       */
      max_active_tasks?: number | null;
      /**
       * @description Maximum number of active DAG runs for the DAG
       *
       * *New in version 2.3.0*
       */
      max_active_runs?: number | null;
      /**
       * @description Whether the DAG has task concurrency limits
       *
       * *New in version 2.3.0*
       */
      has_task_concurrency_limits?: boolean | null;
      /**
       * @description Whether the DAG has import errors
       *
       * *New in version 2.3.0*
       */
      has_import_errors?: boolean | null;
      /**
       * Format: date-time
       * @description The logical date of the next dag run.
       *
       * *New in version 2.3.0*
       */
      next_dagrun?: string | null;
      /**
       * Format: date-time
       * @description The start of the interval of the next dag run.
       *
       * *New in version 2.3.0*
       */
      next_dagrun_data_interval_start?: string | null;
      /**
       * Format: date-time
       * @description The end of the interval of the next dag run.
       *
       * *New in version 2.3.0*
       */
      next_dagrun_data_interval_end?: string | null;
      /**
       * Format: date-time
       * @description Earliest time at which this ``next_dagrun`` can be created.
       *
       * *New in version 2.3.0*
       */
      next_dagrun_create_after?: string | null;
    };
    /**
     * @description Collection of DAGs.
     *
     * *Changed in version 2.1.0*&#58; 'total_entries' field is added.
     */
    DAGCollection: {
      dags?: components["schemas"]["DAG"][];
    } & components["schemas"]["CollectionInfo"];
    DAGRun: {
      /**
       * @description Run ID.
       *
       * The value of this field can be set only when creating the object. If you try to modify the
       * field of an existing object, the request fails with an BAD_REQUEST error.
       *
       * If not provided, a value will be generated based on execution_date.
       *
       * If the specified dag_run_id is in use, the creation request fails with an ALREADY_EXISTS error.
       *
       * This together with DAG_ID are a unique key.
       */
      dag_run_id?: string | null;
      dag_id?: string;
      /**
       * Format: date-time
       * @description The logical date (previously called execution date). This is the time or interval covered by
       * this DAG run, according to the DAG definition.
       *
       * The value of this field can be set only when creating the object. If you try to modify the
       * field of an existing object, the request fails with an BAD_REQUEST error.
       *
       * This together with DAG_ID are a unique key.
       *
       * *New in version 2.2.0*
       */
      logical_date?: string | null;
      /**
       * Format: date-time
       * @deprecated
       * @description The execution date. This is the same as logical_date, kept for backwards compatibility.
       * If both this field and logical_date are provided but with different values, the request
       * will fail with an BAD_REQUEST error.
       *
       * *Changed in version 2.2.0*&#58; Field becomes nullable.
       *
       * *Deprecated since version 2.2.0*&#58; Use 'logical_date' instead.
       */
      execution_date?: string | null;
      /**
       * Format: date-time
       * @description The start time. The time when DAG run was actually created.
       *
       * *Changed in version 2.1.3*&#58; Field becomes nullable.
       */
      start_date?: string | null;
      /** Format: date-time */
      end_date?: string | null;
      /** Format: date-time */
      data_interval_start?: string | null;
      /** Format: date-time */
      data_interval_end?: string | null;
      /** Format: date-time */
      last_scheduling_decision?: string | null;
      /** @enum {string} */
      run_type?: "backfill" | "manual" | "scheduled" | "dataset_triggered";
      state?: components["schemas"]["DagState"];
      /** @default true */
      external_trigger?: boolean;
      /**
       * @description JSON object describing additional configuration parameters.
       *
       * The value of this field can be set only when creating the object. If you try to modify the
       * field of an existing object, the request fails with an BAD_REQUEST error.
       */
      conf?: { [key: string]: unknown };
      /**
       * @description Contains manually entered notes by the user about the DagRun.
       *
       * *New in version 2.5.0*
       */
      note?: string | null;
    };
    /**
     * @description Modify the state of a DAG run.
     *
     * *New in version 2.2.0*
     */
    UpdateDagRunState: {
      /**
       * @description The state to set this DagRun
       * @enum {string}
       */
      state?: "success" | "failed" | "queued";
    };
    /**
     * @description Collection of DAG runs.
     *
     * *Changed in version 2.1.0*&#58; 'total_entries' field is added.
     */
    DAGRunCollection: {
      dag_runs?: components["schemas"]["DAGRun"][];
    } & components["schemas"]["CollectionInfo"];
    DagWarning: {
      /** @description The dag_id. */
      dag_id?: string;
      /** @description The warning type for the dag warning. */
      warning_type?: string;
      /** @description The message for the dag warning. */
      message?: string;
      /**
       * Format: datetime
       * @description The time when this warning was logged.
       */
      timestamp?: string;
    };
    /** @description Collection of DAG warnings. */
    DagWarningCollection: {
      import_errors?: components["schemas"]["DagWarning"][];
    } & components["schemas"]["CollectionInfo"];
    SetDagRunNote: {
      /** @description Custom notes left by users for this Dag Run. */
      note?: string;
    };
    /** @description Log of user operations via CLI or Web UI. */
    EventLog: {
      /** @description The event log ID */
      event_log_id?: number;
      /**
       * Format: date-time
       * @description The time when these events happened.
       */
      when?: string;
      /** @description The DAG ID */
      dag_id?: string | null;
      /** @description The DAG ID */
      task_id?: string | null;
      /** @description A key describing the type of event. */
      event?: string;
      /**
       * Format: date-time
       * @description When the event was dispatched for an object having execution_date, the value of this field.
       */
      execution_date?: string | null;
      /** @description Name of the user who triggered these events a. */
      owner?: string;
      /** @description Other information that was not included in the other fields, e.g. the complete CLI command. */
      extra?: string | null;
    };
    /**
     * @description Collection of event logs.
     *
     * *Changed in version 2.1.0*&#58; 'total_entries' field is added.
     */
    EventLogCollection: {
      event_logs?: components["schemas"]["EventLog"][];
    } & components["schemas"]["CollectionInfo"];
    ImportError: {
      /** @description The import error ID. */
      import_error_id?: number;
      /**
       * Format: datetime
       * @description The time when this error was created.
       */
      timestamp?: string;
      /** @description The filename */
      filename?: string;
      /** @description The full stackstrace.. */
      stack_trace?: string;
    };
    /**
     * @description Collection of import errors.
     *
     * *Changed in version 2.1.0*&#58; 'total_entries' field is added.
     */
    ImportErrorCollection: {
      import_errors?: components["schemas"]["ImportError"][];
    } & components["schemas"]["CollectionInfo"];
    /** @description Instance status information. */
    HealthInfo: {
      metadatabase?: components["schemas"]["MetadatabaseStatus"];
      scheduler?: components["schemas"]["SchedulerStatus"];
    };
    /** @description The status of the metadatabase. */
    MetadatabaseStatus: {
      status?: components["schemas"]["HealthStatus"];
    };
    /** @description The status and the latest scheduler heartbeat. */
    SchedulerStatus: {
      status?: components["schemas"]["HealthStatus"];
      /**
       * Format: datetime
       * @description The time the scheduler last do a heartbeat.
       */
      latest_scheduler_heartbeat?: string | null;
    };
    /** @description The pool */
    Pool: {
      /** @description The name of pool. */
      name?: string;
      /** @description The maximum number of slots that can be assigned to tasks. One job may occupy one or more slots. */
      slots?: number;
      /** @description The number of slots used by running/queued tasks at the moment. */
      occupied_slots?: number;
      /** @description The number of slots used by running tasks at the moment. */
      running_slots?: number;
      /** @description The number of slots used by queued tasks at the moment. */
      queued_slots?: number;
      /** @description The number of free slots at the moment. */
      open_slots?: number;
      /** @description The number of slots used by scheduled tasks at the moment. */
      scheduled_slots?: number;
      /**
       * @description The description of the pool.
       *
       * *New in version 2.3.0*
       */
      description?: string | null;
    };
    /**
     * @description Collection of pools.
     *
     * *Changed in version 2.1.0*&#58; 'total_entries' field is added.
     */
    PoolCollection: {
      pools?: components["schemas"]["Pool"][];
    } & components["schemas"]["CollectionInfo"];
    /**
     * @description The provider
     *
     * *New in version 2.1.0*
     */
    Provider: {
      /** @description The package name of the provider. */
      package_name?: string;
      /** @description The description of the provider. */
      description?: string;
      /** @description The version of the provider. */
      version?: string;
    };
    /**
     * @description Collection of providers.
     *
     * *New in version 2.1.0*
     */
    ProviderCollection: {
      providers?: components["schemas"]["Provider"][];
    };
    SLAMiss: {
      /** @description The task ID. */
      task_id?: string;
      /** @description The DAG ID. */
      dag_id?: string;
      /** Format: datetime */
      execution_date?: string;
      email_sent?: boolean;
      /** Format: datetime */
      timestamp?: string;
      description?: string | null;
      notification_sent?: boolean;
    } | null;
    Trigger: {
      id?: number;
      classpath?: string;
      kwargs?: string;
      /** Format: datetime */
      created_date?: string;
      triggerer_id?: number | null;
    };
    Job: {
      id?: number;
      dag_id?: string | null;
      state?: string | null;
      job_type?: string | null;
      /** Format: datetime */
      start_date?: string | null;
      /** Format: datetime */
      end_date?: string | null;
      /** Format: datetime */
      latest_heartbeat?: string | null;
      executor_class?: string | null;
      hostname?: string | null;
      unixname?: string | null;
    };
    TaskInstance: {
      task_id?: string;
      dag_id?: string;
      /**
       * @description The DagRun ID for this task instance
       *
       * *New in version 2.3.0*
       */
      dag_run_id?: string;
      /** Format: datetime */
      execution_date?: string;
      /** Format: datetime */
      start_date?: string | null;
      /** Format: datetime */
      end_date?: string | null;
      duration?: number | null;
      state?: components["schemas"]["TaskState"] | null;
      try_number?: number;
      map_index?: number;
      max_tries?: number;
      hostname?: string;
      unixname?: string;
      pool?: string;
      pool_slots?: number;
      queue?: string | null;
      priority_weight?: number | null;
      /** @description *Changed in version 2.1.1*&#58; Field becomes nullable. */
      operator?: string | null;
      queued_when?: string | null;
      pid?: number | null;
      executor_config?: string;
      sla_miss?: components["schemas"]["SLAMiss"] | null;
      /**
       * @description JSON object describing rendered fields.
       *
       * *New in version 2.3.0*
       */
      rendered_fields?: { [key: string]: unknown };
      trigger?: components["schemas"]["Trigger"] | null;
      triggerer_job?: components["schemas"]["Job"] | null;
      /**
       * @description Contains manually entered notes by the user about the TaskInstance.
       *
       * *New in version 2.5.0*
       */
      note?: string | null;
    };
    /**
     * @description Collection of task instances.
     *
     * *Changed in version 2.1.0*&#58; 'total_entries' field is added.
     */
    TaskInstanceCollection: {
      task_instances?: components["schemas"]["TaskInstance"][];
    } & components["schemas"]["CollectionInfo"];
    TaskInstanceReference: {
      /** @description The task ID. */
      task_id?: string;
      /** @description The DAG ID. */
      dag_id?: string;
      /** Format: datetime */
      execution_date?: string;
      /** @description The DAG run ID. */
      dag_run_id?: string;
    };
    TaskInstanceReferenceCollection: {
      task_instances?: components["schemas"]["TaskInstanceReference"][];
    };
    /**
     * @description XCom entry collection item.
     * The value field are only available when retrieving a single object due to the sensitivity of this data.
     */
    VariableCollectionItem: {
      key?: string;
      /**
       * @description The description of the variable.
       *
       * *New in version 2.4.0*
       */
      description?: string | null;
    };
    /**
     * @description Collection of variables.
     *
     * *Changed in version 2.1.0*&#58; 'total_entries' field is added.
     */
    VariableCollection: {
      variables?: components["schemas"]["VariableCollectionItem"][];
    } & components["schemas"]["CollectionInfo"];
    /** @description Full representation of Variable */
    Variable: components["schemas"]["VariableCollectionItem"] & {
      value?: string;
    };
    /**
     * @description XCom entry collection item.
     *
     * The value field is only available when reading a single object due to the size of the value.
     */
    XComCollectionItem: {
      key?: string;
      /** Format: datetime */
      timestamp?: string;
      /** Format: datetime */
      execution_date?: string;
      task_id?: string;
      dag_id?: string;
    };
    /**
     * @description Collection of XCom entries.
     *
     * *Changed in version 2.1.0*&#58; 'total_entries' field is added.
     */
    XComCollection: {
      xcom_entries?: components["schemas"]["XComCollectionItem"][];
    } & components["schemas"]["CollectionInfo"];
    /** @description Full representations of XCom entry. */
    XCom: components["schemas"]["XComCollectionItem"] & {
      /** @description The value */
      value?: string;
    };
    /**
     * @description DAG details.
     *
     * For details see:
     * [airflow.models.DAG](https://airflow.apache.org/docs/apache-airflow/stable/_api/airflow/models/index.html#airflow.models.DAG)
     */
    DAGDetail: components["schemas"]["DAG"] & {
      timezone?: components["schemas"]["Timezone"];
      catchup?: boolean;
      orientation?: string;
      concurrency?: number;
      /**
       * Format: date-time
       * @description The DAG's start date.
       *
       * *Changed in version 2.0.1*&#58; Field becomes nullable.
       */
      start_date?: string | null;
      dag_run_timeout?: components["schemas"]["TimeDelta"] | null;
      doc_md?: string | null;
      default_view?: string;
      /**
       * @description User-specified DAG params.
       *
       * *New in version 2.0.1*
       */
      params?: { [key: string]: unknown };
      /**
       * Format: date-time
       * @description The DAG's end date.
       *
       * *New in version 2.3.0*.
       */
      end_date?: string | null;
      /**
       * @description Whether the DAG is paused upon creation.
       *
       * *New in version 2.3.0*
       */
      is_paused_upon_creation?: boolean | null;
      /**
       * Format: date-time
       * @description The last time the DAG was parsed.
       *
       * *New in version 2.3.0*
       */
      last_parsed?: string | null;
      /**
       * @description The template search path.
       *
       * *New in version 2.3.0*
       */
      template_search_path?: string[] | null;
      /**
       * @description Whether to render templates as native Python objects.
       *
       * *New in version 2.3.0*
       */
      render_template_as_native_obj?: boolean | null;
    };
    /** @description Additional links containing additional information about the task. */
    ExtraLink: {
      class_ref?: components["schemas"]["ClassReference"];
      name?: string;
      href?: string;
    };
    /** @description The collection of extra links. */
    ExtraLinkCollection: {
      extra_links?: components["schemas"]["ExtraLink"][];
    };
    /**
     * @description For details see:
     * [airflow.models.BaseOperator](https://airflow.apache.org/docs/apache-airflow/stable/_api/airflow/models/index.html#airflow.models.BaseOperator)
     */
    Task: {
      class_ref?: components["schemas"]["ClassReference"];
      task_id?: string;
      owner?: string;
      /** Format: date-time */
      start_date?: string;
      /** Format: date-time */
      end_date?: string | null;
      trigger_rule?: components["schemas"]["TriggerRule"];
      extra_links?: {
        class_ref?: components["schemas"]["ClassReference"];
      }[];
      depends_on_past?: boolean;
      is_mapped?: boolean;
      wait_for_downstream?: boolean;
      retries?: number;
      queue?: string | null;
      pool?: string;
      pool_slots?: number;
      execution_timeout?: components["schemas"]["TimeDelta"] | null;
      retry_delay?: components["schemas"]["TimeDelta"] | null;
      retry_exponential_backoff?: boolean;
      priority_weight?: number;
      weight_rule?: components["schemas"]["WeightRule"];
      ui_color?: components["schemas"]["Color"];
      ui_fgcolor?: components["schemas"]["Color"];
      template_fields?: string[];
      sub_dag?: components["schemas"]["DAG"];
      downstream_task_ids?: string[];
    };
    /** @description Collection of tasks. */
    TaskCollection: {
      tasks?: components["schemas"]["Task"][];
    };
    /**
     * @description A plugin Item.
     *
     * *New in version 2.1.0*
     */
    PluginCollectionItem: {
      /** @description The name of the plugin */
      name?: string;
      /** @description The plugin hooks */
      hooks?: (string | null)[];
      /** @description The plugin executors */
      executors?: (string | null)[];
      /** @description The plugin macros */
      macros?: ({ [key: string]: unknown } | null)[];
      /** @description The flask blueprints */
      flask_blueprints?: ({ [key: string]: unknown } | null)[];
      /** @description The appuilder views */
      appbuilder_views?: ({ [key: string]: unknown } | null)[];
      /** @description The Flask Appbuilder menu items */
      appbuilder_menu_items?: ({ [key: string]: unknown } | null)[];
      /** @description The global operator extra links */
      global_operator_extra_links?: ({ [key: string]: unknown } | null)[];
      /** @description Operator extra links */
      operator_extra_links?: ({ [key: string]: unknown } | null)[];
      /** @description The plugin source */
      source?: string | null;
    };
    /**
     * @description A collection of plugin.
     *
     * *New in version 2.1.0*
     */
    PluginCollection: {
      plugins?: components["schemas"]["PluginCollectionItem"][];
    } & components["schemas"]["CollectionInfo"];
    /**
     * @description a role item.
     *
     * *New in version 2.1.0*
     */
    Role: {
      /**
       * @description The name of the role
       *
       * *Changed in version 2.3.0*&#58; A minimum character length requirement ('minLength') is added.
       */
      name?: string;
      actions?: components["schemas"]["ActionResource"][];
    };
    /**
     * @description A collection of roles.
     *
     * *New in version 2.1.0*
     */
    RoleCollection: {
      roles?: components["schemas"]["Role"][];
    } & components["schemas"]["CollectionInfo"];
    /**
     * @description An action Item.
     *
     * *New in version 2.1.0*
     */
    Action: {
      /** @description The name of the permission "action" */
      name?: string;
    };
    /**
     * @description A collection of actions.
     *
     * *New in version 2.1.0*
     */
    ActionCollection: {
      actions?: components["schemas"]["Action"][];
    } & components["schemas"]["CollectionInfo"];
    /**
     * @description A resource on which permissions are granted.
     *
     * *New in version 2.1.0*
     */
    Resource: {
      /** @description The name of the resource */
      name?: string;
    };
    /**
     * @description The Action-Resource item.
     *
     * *New in version 2.1.0*
     */
    ActionResource: {
      /** @description The permission action */
      action?: components["schemas"]["Action"];
      /** @description The permission resource */
      resource?: components["schemas"]["Resource"];
    };
    /**
     * @description A dataset item.
     *
     * *New in version 2.4.0*
     */
    Dataset: {
      /** @description The dataset id */
      id?: number;
      /** @description The dataset uri */
      uri?: string;
      /** @description The dataset extra */
      extra?: { [key: string]: unknown } | null;
      /** @description The dataset creation time */
      created_at?: string;
      /** @description The dataset update time */
      updated_at?: string;
      consuming_dags?: components["schemas"]["DagScheduleDatasetReference"][];
      producing_tasks?: components["schemas"]["TaskOutletDatasetReference"][];
    };
    /**
     * @description A datasets reference to an upstream task.
     *
     * *New in version 2.4.0*
     */
    TaskOutletDatasetReference: {
      /** @description The DAG ID that updates the dataset. */
      dag_id?: string | null;
      /** @description The task ID that updates the dataset. */
      task_id?: string | null;
      /** @description The dataset creation time */
      created_at?: string;
      /** @description The dataset update time */
      updated_at?: string;
    };
    /**
     * @description A datasets reference to a downstream DAG.
     *
     * *New in version 2.4.0*
     */
    DagScheduleDatasetReference: {
      /** @description The DAG ID that depends on the dataset. */
      dag_id?: string | null;
      /** @description The dataset reference creation time */
      created_at?: string;
      /** @description The dataset reference update time */
      updated_at?: string;
    };
    /**
     * @description A collection of datasets.
     *
     * *New in version 2.4.0*
     */
    DatasetCollection: {
      datasets?: components["schemas"]["Dataset"][];
    } & components["schemas"]["CollectionInfo"];
    /**
     * @description A dataset event.
     *
     * *New in version 2.4.0*
     */
    DatasetEvent: {
      /** @description The dataset id */
      dataset_id?: number;
      /** @description The URI of the dataset */
      dataset_uri?: string;
      /** @description The dataset event extra */
      extra?: { [key: string]: unknown } | null;
      /** @description The DAG ID that updated the dataset. */
      source_dag_id?: string | null;
      /** @description The task ID that updated the dataset. */
      source_task_id?: string | null;
      /** @description The DAG run ID that updated the dataset. */
      source_run_id?: string | null;
      /** @description The task map index that updated the dataset. */
      source_map_index?: number | null;
      created_dagruns?: components["schemas"]["BasicDAGRun"][];
      /** @description The dataset event creation time */
      timestamp?: string;
    };
    BasicDAGRun: {
      /** @description Run ID. */
      run_id?: string;
      dag_id?: string;
      /**
       * Format: date-time
       * @description The logical date (previously called execution date). This is the time or interval covered by
       * this DAG run, according to the DAG definition.
       *
       * The value of this field can be set only when creating the object. If you try to modify the
       * field of an existing object, the request fails with an BAD_REQUEST error.
       *
       * This together with DAG_ID are a unique key.
       *
       * *New in version 2.2.0*
       */
      logical_date?: string;
      /**
       * Format: date-time
       * @description The start time. The time when DAG run was actually created.
       *
       * *Changed in version 2.1.3*&#58; Field becomes nullable.
       */
      start_date?: string | null;
      /** Format: date-time */
      end_date?: string | null;
      /** Format: date-time */
      data_interval_start?: string | null;
      /** Format: date-time */
      data_interval_end?: string | null;
      state?: components["schemas"]["DagState"];
    };
    /**
     * @description A collection of dataset events.
     *
     * *New in version 2.4.0*
     */
    DatasetEventCollection: {
      dataset_events?: components["schemas"]["DatasetEvent"][];
    } & components["schemas"]["CollectionInfo"];
    /** @description The option of configuration. */
    ConfigOption: {
      key?: string;
      value?: string;
    };
    /** @description The section of configuration. */
    ConfigSection: {
      name?: string;
      options?: components["schemas"]["ConfigOption"][];
    };
    /** @description The configuration. */
    Config: {
      sections?: components["schemas"]["ConfigSection"][];
    };
    /** @description Version information. */
    VersionInfo: {
      /** @description The version of Airflow */
      version?: string;
      /** @description The git version (including git commit hash) */
      git_version?: string | null;
    };
    ClearDagRun: {
      /**
       * @description If set, don't actually run this operation. The response will contain a list of task instances
       * planned to be cleaned, but not modified in any way.
       *
       * @default true
       */
      dry_run?: boolean;
    };
    ClearTaskInstances: {
      /**
       * @description If set, don't actually run this operation. The response will contain a list of task instances
       * planned to be cleaned, but not modified in any way.
       *
       * @default true
       */
      dry_run?: boolean;
      /**
       * @description A list of task ids to clear.
       *
       * *New in version 2.1.0*
       */
      task_ids?: string[];
      /**
       * Format: datetime
       * @description The minimum execution date to clear.
       */
      start_date?: string;
      /**
       * Format: datetime
       * @description The maximum execution date to clear.
       */
      end_date?: string;
      /**
       * @description Only clear failed tasks.
       * @default true
       */
      only_failed?: boolean;
      /**
       * @description Only clear running tasks.
       * @default false
       */
      only_running?: boolean;
      /** @description Clear tasks in subdags and clear external tasks indicated by ExternalTaskMarker. */
      include_subdags?: boolean;
      /** @description Clear tasks in the parent dag of the subdag. */
      include_parentdag?: boolean;
      /** @description Set state of DAG runs to RUNNING. */
      reset_dag_runs?: boolean;
      /** @description The DagRun ID for this task instance */
      dag_run_id?: string | null;
      /**
       * @description If set to true, upstream tasks are also affected.
       * @default false
       */
      include_upstream?: boolean;
      /**
       * @description If set to true, downstream tasks are also affected.
       * @default false
       */
      include_downstream?: boolean;
      /**
       * @description If set to True, also tasks from future DAG Runs are affected.
       * @default false
       */
      include_future?: boolean;
      /**
       * @description If set to True, also tasks from past DAG Runs are affected.
       * @default false
       */
      include_past?: boolean;
    };
    UpdateTaskInstancesState: {
      /**
       * @description If set, don't actually run this operation. The response will contain a list of task instances
       * planned to be affected, but won't be modified in any way.
       *
       * @default true
       */
      dry_run?: boolean;
      /** @description The task ID. */
      task_id?: string;
      /**
       * Format: datetime
       * @description The execution date. Either set this or dag_run_id but not both.
       */
      execution_date?: string;
      /**
       * @description The task instance's DAG run ID. Either set this or execution_date but not both.
       *
       * *New in version 2.3.0*
       */
      dag_run_id?: string;
      /** @description If set to true, upstream tasks are also affected. */
      include_upstream?: boolean;
      /** @description If set to true, downstream tasks are also affected. */
      include_downstream?: boolean;
      /** @description If set to True, also tasks from future DAG Runs are affected. */
      include_future?: boolean;
      /** @description If set to True, also tasks from past DAG Runs are affected. */
      include_past?: boolean;
      /**
       * @description Expected new state.
       * @enum {string}
       */
      new_state?: "success" | "failed";
    };
    UpdateTaskInstance: {
      /**
       * @description If set, don't actually run this operation. The response will contain the task instance
       * planned to be affected, but won't be modified in any way.
       *
       * @default false
       */
      dry_run?: boolean;
      /**
       * @description Expected new state.
       * @enum {string}
       */
      new_state?: "success" | "failed";
    };
    SetTaskInstanceNote: {
      /** @description The custom note to set for this Task Instance. */
      note: string;
    };
    ListDagRunsForm: {
      /**
       * @description The name of the field to order the results by. Prefix a field name
       * with `-` to reverse the sort order.
       *
       * *New in version 2.1.0*
       */
      order_by?: string;
      /** @description The number of items to skip before starting to collect the result set. */
      page_offset?: number;
      /**
       * @description The numbers of items to return.
       * @default 100
       */
      page_limit?: number;
      /**
       * @description Return objects with specific DAG IDs.
       * The value can be repeated to retrieve multiple matching values (OR condition).
       */
      dag_ids?: string[];
      /**
       * @description Return objects with specific states.
       * The value can be repeated to retrieve multiple matching values (OR condition).
       */
      states?: string[];
      /**
       * Format: date-time
       * @description Returns objects greater or equal to the specified date.
       *
       * This can be combined with execution_date_lte key to receive only the selected period.
       */
      execution_date_gte?: string;
      /**
       * Format: date-time
       * @description Returns objects less than or equal to the specified date.
       *
       * This can be combined with execution_date_gte key to receive only the selected period.
       */
      execution_date_lte?: string;
      /**
       * Format: date-time
       * @description Returns objects greater or equal the specified date.
       *
       * This can be combined with start_date_lte key to receive only the selected period.
       */
      start_date_gte?: string;
      /**
       * Format: date-time
       * @description Returns objects less or equal the specified date.
       *
       * This can be combined with start_date_gte parameter to receive only the selected period
       */
      start_date_lte?: string;
      /**
       * Format: date-time
       * @description Returns objects greater or equal the specified date.
       *
       * This can be combined with end_date_lte parameter to receive only the selected period.
       */
      end_date_gte?: string;
      /**
       * Format: date-time
       * @description Returns objects less than or equal to the specified date.
       *
       * This can be combined with end_date_gte parameter to receive only the selected period.
       */
      end_date_lte?: string;
    };
    ListTaskInstanceForm: {
      /**
       * @description Return objects with specific DAG IDs.
       * The value can be repeated to retrieve multiple matching values (OR condition).
       */
      dag_ids?: string[];
      /**
       * Format: date-time
       * @description Returns objects greater or equal to the specified date.
       *
       * This can be combined with execution_date_lte parameter to receive only the selected period.
       */
      execution_date_gte?: string;
      /**
       * Format: date-time
       * @description Returns objects less than or equal to the specified date.
       *
       * This can be combined with execution_date_gte parameter to receive only the selected period.
       */
      execution_date_lte?: string;
      /**
       * Format: date-time
       * @description Returns objects greater or equal the specified date.
       *
       * This can be combined with start_date_lte parameter to receive only the selected period.
       */
      start_date_gte?: string;
      /**
       * Format: date-time
       * @description Returns objects less or equal the specified date.
       *
       * This can be combined with start_date_gte parameter to receive only the selected period.
       */
      start_date_lte?: string;
      /**
       * Format: date-time
       * @description Returns objects greater or equal the specified date.
       *
       * This can be combined with start_date_lte parameter to receive only the selected period.
       */
      end_date_gte?: string;
      /**
       * Format: date-time
       * @description Returns objects less than or equal to the specified date.
       *
       * This can be combined with start_date_gte parameter to receive only the selected period.
       */
      end_date_lte?: string;
      /**
       * @description Returns objects greater than or equal to the specified values.
       *
       * This can be combined with duration_lte parameter to receive only the selected period.
       */
      duration_gte?: number;
      /**
       * @description Returns objects less than or equal to the specified values.
       *
       * This can be combined with duration_gte parameter to receive only the selected range.
       */
      duration_lte?: number;
      /** @description The value can be repeated to retrieve multiple matching values (OR condition). */
      state?: components["schemas"]["TaskState"][];
      /** @description The value can be repeated to retrieve multiple matching values (OR condition). */
      pool?: string[];
      /** @description The value can be repeated to retrieve multiple matching values (OR condition). */
      queue?: string[];
    };
    /**
     * @description Schedule interval. Defines how often DAG runs, this object gets added to your latest task instance's
     * execution_date to figure out the next schedule.
     */
    ScheduleInterval:
      | (Partial<components["schemas"]["TimeDelta"]> &
          Partial<components["schemas"]["RelativeDelta"]> &
          Partial<components["schemas"]["CronExpression"]>)
      | null;
    /** @description Time delta */
    TimeDelta: {
      __type: string;
      days: number;
      seconds: number;
      microseconds: number;
    };
    /** @description Relative delta */
    RelativeDelta: {
      __type: string;
      years: number;
      months: number;
      days: number;
      leapdays: number;
      hours: number;
      minutes: number;
      seconds: number;
      microseconds: number;
      year: number;
      month: number;
      day: number;
      hour: number;
      minute: number;
      second: number;
      microsecond: number;
    };
    /** @description Cron expression */
    CronExpression: {
      __type: string;
      value: string;
    } | null;
    Timezone: string;
    /** @description Tag */
    Tag: {
      name?: string;
    };
    /** @description Color in hexadecimal notation. */
    Color: string;
    /** @description Class reference */
    ClassReference: {
      module_path?: string;
      class_name?: string;
    };
    /** @description [RFC7807](https://tools.ietf.org/html/rfc7807) compliant response. */
    Error: {
      /**
       * @description A URI reference [RFC3986] that identifies the problem type. This specification
       * encourages that, when dereferenced, it provide human-readable documentation for
       * the problem type.
       */
      type: string;
      /** @description A short, human-readable summary of the problem type. */
      title: string;
      /** @description The HTTP status code generated by the API server for this occurrence of the problem. */
      status: number;
      /** @description A human-readable explanation specific to this occurrence of the problem. */
      detail?: string;
      /**
       * @description A URI reference that identifies the specific occurrence of the problem. It may or may
       * not yield further information if dereferenced.
       */
      instance?: string;
    };
    /** @description Metadata about collection. */
    CollectionInfo: {
      /**
       * @description Count of total objects in the current result set before pagination parameters
       * (limit, offset) are applied.
       */
      total_entries?: number;
    };
    /**
     * @description Task state.
     *
     * *Changed in version 2.0.2*&#58; 'removed' is added as a possible value.
     *
     * *Changed in version 2.2.0*&#58; 'deferred' is added as a possible value.
     *
     * *Changed in version 2.4.0*&#58; 'sensing' state has been removed.
     * *Changed in version 2.4.2*&#58; 'restarting' is added as a possible value
     *
     * @enum {string}
     */
    TaskState:
      | "success"
      | "running"
      | "failed"
      | "upstream_failed"
      | "skipped"
      | "up_for_retry"
      | "up_for_reschedule"
      | "queued"
      | "none"
      | "scheduled"
      | "deferred"
      | "removed"
      | "restarting";
    /**
     * @description DAG State.
     *
     * *Changed in version 2.1.3*&#58; 'queued' is added as a possible value.
     *
     * @enum {string}
     */
    DagState: "queued" | "running" | "success" | "failed";
    /**
     * @description Trigger rule.
     *
     * *Changed in version 2.2.0*&#58; 'none_failed_min_one_success' is added as a possible value.
     *
     * @enum {string}
     */
    TriggerRule:
      | "all_success"
      | "all_failed"
      | "all_done"
      | "one_success"
      | "one_failed"
      | "none_failed"
      | "none_skipped"
      | "none_failed_or_skipped"
      | "none_failed_min_one_success"
      | "dummy";
    /**
     * @description Weight rule.
     * @enum {string}
     */
    WeightRule: "downstream" | "upstream" | "absolute";
    /**
     * @description Health status
     * @enum {string}
     */
    HealthStatus: "healthy" | "unhealthy";
  };
  responses: {
    /** Client specified an invalid argument. */
    BadRequest: {
      content: {
        "application/json": components["schemas"]["Error"];
      };
    };
    /** Request not authenticated due to missing, invalid, authentication info. */
    Unauthenticated: {
      content: {
        "application/json": components["schemas"]["Error"];
      };
    };
    /** Client does not have sufficient permission. */
    PermissionDenied: {
      content: {
        "application/json": components["schemas"]["Error"];
      };
    };
    /** A specified resource is not found. */
    NotFound: {
      content: {
        "application/json": components["schemas"]["Error"];
      };
    };
    /** Request method is known by the server but is not supported by the target resource. */
    MethodNotAllowed: {
      content: {
        "application/json": components["schemas"]["Error"];
      };
    };
    /** A specified Accept header is not allowed. */
    NotAcceptable: {
      content: {
        "application/json": components["schemas"]["Error"];
      };
    };
    /** An existing resource conflicts with the request. */
    AlreadyExists: {
      content: {
        "application/json": components["schemas"]["Error"];
      };
    };
    /** Unknown server error. */
    Unknown: {
      content: {
        "application/json": components["schemas"]["Error"];
      };
    };
  };
  parameters: {
    /** @description The number of items to skip before starting to collect the result set. */
    PageOffset: number;
    /** @description The numbers of items to return. */
    PageLimit: number;
    /**
     * @description The username of the user.
     *
     * *New in version 2.1.0*
     */
    Username: string;
    /** @description The role name */
    RoleName: string;
    /** @description The connection ID. */
    ConnectionID: string;
    /** @description The DAG ID. */
    DAGID: string;
    /** @description The task ID. */
    TaskID: string;
    /** @description The map index. */
    MapIndex: number;
    /** @description The DAG run ID. */
    DAGRunID: string;
    /** @description The task try number. */
    TaskTryNumber: number;
    /** @description The event log ID. */
    EventLogID: number;
    /** @description The import error ID. */
    ImportErrorID: number;
    /** @description The encoded Dataset URI */
    DatasetURI: string;
    /** @description The pool name. */
    PoolName: string;
    /** @description The variable Key. */
    VariableKey: string;
    /**
     * @description A full content will be returned.
     * By default, only the first fragment will be returned.
     */
    FullContent: boolean;
    /**
     * @description A token that allows you to continue fetching logs.
     * If passed, it will specify the location from which the download should be continued.
     */
    ContinuationToken: string;
    /** @description The XCom key. */
    XComKey: string;
    /**
     * @description Returns objects greater or equal to the specified date.
     *
     * This can be combined with execution_date_lte parameter to receive only the selected period.
     */
    FilterExecutionDateGTE: string;
    /**
     * @description Returns objects less than or equal to the specified date.
     *
     * This can be combined with execution_date_gte parameter to receive only the selected period.
     */
    FilterExecutionDateLTE: string;
    /**
     * @description Returns objects greater or equal the specified date.
     *
     * This can be combined with start_date_lte parameter to receive only the selected period.
     */
    FilterStartDateGTE: string;
    /**
     * @description Returns objects less or equal the specified date.
     *
     * This can be combined with start_date_gte parameter to receive only the selected period.
     */
    FilterStartDateLTE: string;
    /**
     * @description Returns objects greater or equal the specified date.
     *
     * This can be combined with start_date_lte parameter to receive only the selected period.
     */
    FilterEndDateGTE: string;
    /**
     * @description Returns objects less than or equal to the specified date.
     *
     * This can be combined with start_date_gte parameter to receive only the selected period.
     */
    FilterEndDateLTE: string;
    /**
     * @description Returns objects greater than or equal to the specified values.
     *
     * This can be combined with duration_lte parameter to receive only the selected period.
     */
    FilterDurationGTE: number;
    /**
     * @description Returns objects less than or equal to the specified values.
     *
     * This can be combined with duration_gte parameter to receive only the selected range.
     */
    FilterDurationLTE: number;
    /** @description The value can be repeated to retrieve multiple matching values (OR condition). */
    FilterState: string[];
    /** @description The value can be repeated to retrieve multiple matching values (OR condition). */
    FilterPool: string[];
    /** @description The value can be repeated to retrieve multiple matching values (OR condition). */
    FilterQueue: string[];
    /**
     * @description List of tags to filter results.
     *
     * *New in version 2.2.0*
     */
    FilterTags: string[];
    /** @description The Dataset ID that updated the dataset. */
    FilterDatasetID: number;
    /** @description The DAG ID that updated the dataset. */
    FilterSourceDAGID: string;
    /** @description The task ID that updated the dataset. */
    FilterSourceTaskID: string;
    /** @description The DAG run ID that updated the dataset. */
    FilterSourceRunID: string;
    /** @description The map index that updated the dataset. */
    FilterSourceMapIndex: number;
    /** @description Filter on map index for mapped task. */
    FilterMapIndex: number;
    /**
     * @description The name of the field to order the results by.
     * Prefix a field name with `-` to reverse the sort order.
     *
     * *New in version 2.1.0*
     */
    OrderBy: string;
    /**
     * @description Only filter active DAGs.
     *
     * *New in version 2.1.1*
     */
    OnlyActive: boolean;
    /**
     * @description Returns objects less or equal the specified date.
     *
     * This can be combined with updated_at_gte parameter to receive only the selected period.
     *
     * *New in version 2.6.0*
     */
    FilterUpdatedAtLTE: string;
    /**
     * @description Returns objects greater or equal the specified date.
     *
     * This can be combined with updated_at_lte parameter to receive only the selected period.
     *
     * *New in version 2.6.0*
     */
    FilterUpdatedAtGTE: string;
    /**
     * @description Only filter paused/unpaused DAGs. If absent or null, it returns paused and unpaused DAGs.
     *
     * *New in version 2.6.0*
     */
    Paused: boolean;
    /**
     * @description The key containing the encrypted path to the file. Encryption and decryption take place only on
     * the server. This prevents the client from reading an non-DAG file. This also ensures API
     * extensibility, because the format of encrypted data may change.
     */
    FileToken: string;
    /**
     * @description The fields to update on the resource. If absent or empty, all modifiable fields are updated.
     * A comma-separated list of fully qualified names of fields.
     */
    UpdateMask: string[];
  };
  requestBodies: {};
  headers: {};
}

export interface operations {
  get_connections: {
    parameters: {
      query: {
        /** The numbers of items to return. */
        limit?: components["parameters"]["PageLimit"];
        /** The number of items to skip before starting to collect the result set. */
        offset?: components["parameters"]["PageOffset"];
        /**
         * The name of the field to order the results by.
         * Prefix a field name with `-` to reverse the sort order.
         *
         * *New in version 2.1.0*
         */
        order_by?: components["parameters"]["OrderBy"];
      };
    };
    responses: {
      /** Success. */
      200: {
        content: {
          "application/json": components["schemas"]["ConnectionCollection"];
        };
      };
      401: components["responses"]["Unauthenticated"];
      403: components["responses"]["PermissionDenied"];
    };
  };
  post_connection: {
    responses: {
      /** Success. */
      200: {
        content: {
          "application/json": components["schemas"]["Connection"];
        };
      };
      400: components["responses"]["BadRequest"];
      401: components["responses"]["Unauthenticated"];
      403: components["responses"]["PermissionDenied"];
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["Connection"];
      };
    };
  };
  get_connection: {
    parameters: {
      path: {
        /** The connection ID. */
        connection_id: components["parameters"]["ConnectionID"];
      };
    };
    responses: {
      /** Success. */
      200: {
        content: {
          "application/json": components["schemas"]["Connection"];
        };
      };
      401: components["responses"]["Unauthenticated"];
      403: components["responses"]["PermissionDenied"];
      404: components["responses"]["NotFound"];
    };
  };
  delete_connection: {
    parameters: {
      path: {
        /** The connection ID. */
        connection_id: components["parameters"]["ConnectionID"];
      };
    };
    responses: {
      /** Success. */
      204: never;
      400: components["responses"]["BadRequest"];
      401: components["responses"]["Unauthenticated"];
      403: components["responses"]["PermissionDenied"];
      404: components["responses"]["NotFound"];
    };
  };
  patch_connection: {
    parameters: {
      path: {
        /** The connection ID. */
        connection_id: components["parameters"]["ConnectionID"];
      };
      query: {
        /**
         * The fields to update on the resource. If absent or empty, all modifiable fields are updated.
         * A comma-separated list of fully qualified names of fields.
         */
        update_mask?: components["parameters"]["UpdateMask"];
      };
    };
    responses: {
      /** Success. */
      200: {
        content: {
          "application/json": components["schemas"]["Connection"];
        };
      };
      400: components["responses"]["BadRequest"];
      401: components["responses"]["Unauthenticated"];
      403: components["responses"]["PermissionDenied"];
      404: components["responses"]["NotFound"];
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["Connection"];
      };
    };
  };
  /**
   * Test a connection.
   *
   * *New in version 2.2.0*
   */
  test_connection: {
    responses: {
      /** Success. */
      200: {
        content: {
          "application/json": components["schemas"]["ConnectionTest"];
        };
      };
      400: components["responses"]["BadRequest"];
      401: components["responses"]["Unauthenticated"];
      403: components["responses"]["PermissionDenied"];
      404: components["responses"]["NotFound"];
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["Connection"];
      };
    };
  };
  /**
   * List DAGs in the database.
   * `dag_id_pattern` can be set to match dags of a specific pattern
   */
  get_dags: {
    parameters: {
      query: {
        /** The numbers of items to return. */
        limit?: components["parameters"]["PageLimit"];
        /** The number of items to skip before starting to collect the result set. */
        offset?: components["parameters"]["PageOffset"];
        /**
         * The name of the field to order the results by.
         * Prefix a field name with `-` to reverse the sort order.
         *
         * *New in version 2.1.0*
         */
        order_by?: components["parameters"]["OrderBy"];
        /**
         * List of tags to filter results.
         *
         * *New in version 2.2.0*
         */
        tags?: components["parameters"]["FilterTags"];
        /**
         * Only filter active DAGs.
         *
         * *New in version 2.1.1*
         */
        only_active?: components["parameters"]["OnlyActive"];
        /**
         * Only filter paused/unpaused DAGs. If absent or null, it returns paused and unpaused DAGs.
         *
         * *New in version 2.6.0*
         */
        paused?: components["parameters"]["Paused"];
        /** If set, only return DAGs with dag_ids matching this pattern. */
        dag_id_pattern?: string;
      };
    };
    responses: {
      /** Success. */
      200: {
        content: {
          "application/json": components["schemas"]["DAGCollection"];
        };
      };
      401: components["responses"]["Unauthenticated"];
    };
  };
  /**
   * Update DAGs of a given dag_id_pattern using UpdateMask.
   * This endpoint allows specifying `~` as the dag_id_pattern to update all DAGs.
   * *New in version 2.3.0*
   */
  patch_dags: {
    parameters: {
      query: {
        /** The numbers of items to return. */
        limit?: components["parameters"]["PageLimit"];
        /** The number of items to skip before starting to collect the result set. */
        offset?: components["parameters"]["PageOffset"];
        /**
         * List of tags to filter results.
         *
         * *New in version 2.2.0*
         */
        tags?: components["parameters"]["FilterTags"];
        /**
         * The fields to update on the resource. If absent or empty, all modifiable fields are updated.
         * A comma-separated list of fully qualified names of fields.
         */
        update_mask?: components["parameters"]["UpdateMask"];
        /**
         * Only filter active DAGs.
         *
         * *New in version 2.1.1*
         */
        only_active?: components["parameters"]["OnlyActive"];
        /** If set, only update DAGs with dag_ids matching this pattern. */
        dag_id_pattern: string;
      };
    };
    responses: {
      /** Success. */
      200: {
        content: {
          "application/json": components["schemas"]["DAGCollection"];
        };
      };
      401: components["responses"]["Unauthenticated"];
      403: components["responses"]["PermissionDenied"];
      404: components["responses"]["NotFound"];
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["DAG"];
      };
    };
  };
  /**
   * Presents only information available in database (DAGModel).
   * If you need detailed information, consider using GET /dags/{dag_id}/details.
   */
  get_dag: {
    parameters: {
      path: {
        /** The DAG ID. */
        dag_id: components["parameters"]["DAGID"];
      };
    };
    responses: {
      /** Success. */
      200: {
        content: {
          "application/json": components["schemas"]["DAG"];
        };
      };
      401: components["responses"]["Unauthenticated"];
      403: components["responses"]["PermissionDenied"];
      404: components["responses"]["NotFound"];
    };
  };
  /**
   * Deletes all metadata related to the DAG, including finished DAG Runs and Tasks.
   * Logs are not deleted. This action cannot be undone.
   *
   * *New in version 2.2.0*
   */
  delete_dag: {
    parameters: {
      path: {
        /** The DAG ID. */
        dag_id: components["parameters"]["DAGID"];
      };
    };
    responses: {
      /** Success. */
      204: never;
      400: components["responses"]["BadRequest"];
      401: components["responses"]["Unauthenticated"];
      403: components["responses"]["PermissionDenied"];
      404: components["responses"]["NotFound"];
      409: components["responses"]["AlreadyExists"];
    };
  };
  patch_dag: {
    parameters: {
      path: {
        /** The DAG ID. */
        dag_id: components["parameters"]["DAGID"];
      };
      query: {
        /**
         * The fields to update on the resource. If absent or empty, all modifiable fields are updated.
         * A comma-separated list of fully qualified names of fields.
         */
        update_mask?: components["parameters"]["UpdateMask"];
      };
    };
    responses: {
      /** Success. */
      200: {
        content: {
          "application/json": components["schemas"]["DAG"];
        };
      };
      401: components["responses"]["Unauthenticated"];
      403: components["responses"]["PermissionDenied"];
      404: components["responses"]["NotFound"];
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["DAG"];
      };
    };
  };
  /** Clears a set of task instances associated with the DAG for a specified date range. */
  post_clear_task_instances: {
    parameters: {
      path: {
        /** The DAG ID. */
        dag_id: components["parameters"]["DAGID"];
      };
    };
    responses: {
      /** Success. */
      200: {
        content: {
          "application/json": components["schemas"]["TaskInstanceReferenceCollection"];
        };
      };
      401: components["responses"]["Unauthenticated"];
      403: components["responses"]["PermissionDenied"];
      404: components["responses"]["NotFound"];
    };
    /** Parameters of action */
    requestBody: {
      content: {
        "application/json": components["schemas"]["ClearTaskInstances"];
      };
    };
  };
  /**
   * Update the manual user note of a non-mapped Task Instance.
   *
   * *New in version 2.5.0*
   */
  set_task_instance_note: {
    parameters: {
      path: {
        /** The DAG ID. */
        dag_id: components["parameters"]["DAGID"];
        /** The DAG run ID. */
        dag_run_id: components["parameters"]["DAGRunID"];
        /** The task ID. */
        task_id: components["parameters"]["TaskID"];
      };
    };
    responses: {
      /** Success. */
      200: {
        content: {
          "application/json": components["schemas"]["TaskInstance"];
        };
      };
      400: components["responses"]["BadRequest"];
      401: components["responses"]["Unauthenticated"];
      403: components["responses"]["PermissionDenied"];
      404: components["responses"]["NotFound"];
    };
    /** Parameters of set Task Instance note. */
    requestBody: {
      content: {
        "application/json": components["schemas"]["SetTaskInstanceNote"];
      };
    };
  };
  /**
   * Update the manual user note of a mapped Task Instance.
   *
   * *New in version 2.5.0*
   */
  set_mapped_task_instance_note: {
    parameters: {
      path: {
        /** The DAG ID. */
        dag_id: components["parameters"]["DAGID"];
        /** The DAG run ID. */
        dag_run_id: components["parameters"]["DAGRunID"];
        /** The task ID. */
        task_id: components["parameters"]["TaskID"];
        /** The map index. */
        map_index: components["parameters"]["MapIndex"];
      };
    };
    responses: {
      /** Success. */
      200: {
        content: {
          "application/json": components["schemas"]["TaskInstance"];
        };
      };
      400: components["responses"]["BadRequest"];
      401: components["responses"]["Unauthenticated"];
      403: components["responses"]["PermissionDenied"];
      404: components["responses"]["NotFound"];
    };
    /** Parameters of set Task Instance note. */
    requestBody: {
      content: {
        "application/json": components["schemas"]["SetTaskInstanceNote"];
      };
    };
  };
  /** Updates the state for multiple task instances simultaneously. */
  post_set_task_instances_state: {
    parameters: {
      path: {
        /** The DAG ID. */
        dag_id: components["parameters"]["DAGID"];
      };
    };
    responses: {
      /** Success. */
      200: {
        content: {
          "application/json": components["schemas"]["TaskInstanceReferenceCollection"];
        };
      };
      401: components["responses"]["Unauthenticated"];
      403: components["responses"]["PermissionDenied"];
      404: components["responses"]["NotFound"];
    };
    /** Parameters of action */
    requestBody: {
      content: {
        "application/json": components["schemas"]["UpdateTaskInstancesState"];
      };
    };
  };
  /** This endpoint allows specifying `~` as the dag_id to retrieve DAG runs for all DAGs. */
  get_dag_runs: {
    parameters: {
      path: {
        /** The DAG ID. */
        dag_id: components["parameters"]["DAGID"];
      };
      query: {
        /** The numbers of items to return. */
        limit?: components["parameters"]["PageLimit"];
        /** The number of items to skip before starting to collect the result set. */
        offset?: components["parameters"]["PageOffset"];
        /**
         * Returns objects greater or equal to the specified date.
         *
         * This can be combined with execution_date_lte parameter to receive only the selected period.
         */
        execution_date_gte?: components["parameters"]["FilterExecutionDateGTE"];
        /**
         * Returns objects less than or equal to the specified date.
         *
         * This can be combined with execution_date_gte parameter to receive only the selected period.
         */
        execution_date_lte?: components["parameters"]["FilterExecutionDateLTE"];
        /**
         * Returns objects greater or equal the specified date.
         *
         * This can be combined with start_date_lte parameter to receive only the selected period.
         */
        start_date_gte?: components["parameters"]["FilterStartDateGTE"];
        /**
         * Returns objects less or equal the specified date.
         *
         * This can be combined with start_date_gte parameter to receive only the selected period.
         */
        start_date_lte?: components["parameters"]["FilterStartDateLTE"];
        /**
         * Returns objects greater or equal the specified date.
         *
         * This can be combined with start_date_lte parameter to receive only the selected period.
         */
        end_date_gte?: components["parameters"]["FilterEndDateGTE"];
        /**
         * Returns objects less than or equal to the specified date.
         *
         * This can be combined with start_date_gte parameter to receive only the selected period.
         */
        end_date_lte?: components["parameters"]["FilterEndDateLTE"];
        /**
         * Returns objects greater or equal the specified date.
         *
         * This can be combined with updated_at_lte parameter to receive only the selected period.
         *
         * *New in version 2.6.0*
         */
        updated_at_gte?: components["parameters"]["FilterUpdatedAtGTE"];
        /**
         * Returns objects less or equal the specified date.
         *
         * This can be combined with updated_at_gte parameter to receive only the selected period.
         *
         * *New in version 2.6.0*
         */
        updated_at_lte?: components["parameters"]["FilterUpdatedAtLTE"];
        /** The value can be repeated to retrieve multiple matching values (OR condition). */
        state?: components["parameters"]["FilterState"];
        /**
         * The name of the field to order the results by.
         * Prefix a field name with `-` to reverse the sort order.
         *
         * *New in version 2.1.0*
         */
        order_by?: components["parameters"]["OrderBy"];
      };
    };
    responses: {
      /** List of DAG runs. */
      200: {
        content: {
          "application/json": components["schemas"]["DAGRunCollection"];
        };
      };
      401: components["responses"]["Unauthenticated"];
    };
  };
  post_dag_run: {
    parameters: {
      path: {
        /** The DAG ID. */
        dag_id: components["parameters"]["DAGID"];
      };
    };
    responses: {
      /** Success. */
      200: {
        content: {
          "application/json": components["schemas"]["DAGRun"];
        };
      };
      400: components["responses"]["BadRequest"];
      401: components["responses"]["Unauthenticated"];
      403: components["responses"]["PermissionDenied"];
      404: components["responses"]["NotFound"];
      409: components["responses"]["AlreadyExists"];
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["DAGRun"];
      };
    };
  };
  /** This endpoint is a POST to allow filtering across a large number of DAG IDs, where as a GET it would run in to maximum HTTP request URL length limit. */
  get_dag_runs_batch: {
    responses: {
      /** Success. */
      200: {
        content: {
          "application/json": components["schemas"]["DAGRunCollection"];
        };
      };
      400: components["responses"]["BadRequest"];
      401: components["responses"]["Unauthenticated"];
      403: components["responses"]["PermissionDenied"];
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["ListDagRunsForm"];
      };
    };
  };
  get_dag_run: {
    parameters: {
      path: {
        /** The DAG ID. */
        dag_id: components["parameters"]["DAGID"];
        /** The DAG run ID. */
        dag_run_id: components["parameters"]["DAGRunID"];
      };
    };
    responses: {
      /** Success. */
      200: {
        content: {
          "application/json": components["schemas"]["DAGRun"];
        };
      };
      401: components["responses"]["Unauthenticated"];
      403: components["responses"]["PermissionDenied"];
      404: components["responses"]["NotFound"];
    };
  };
  delete_dag_run: {
    parameters: {
      path: {
        /** The DAG ID. */
        dag_id: components["parameters"]["DAGID"];
        /** The DAG run ID. */
        dag_run_id: components["parameters"]["DAGRunID"];
      };
    };
    responses: {
      /** Success. */
      204: never;
      400: components["responses"]["BadRequest"];
      401: components["responses"]["Unauthenticated"];
      403: components["responses"]["PermissionDenied"];
      404: components["responses"]["NotFound"];
    };
  };
  /**
   * Modify a DAG run.
   *
   * *New in version 2.2.0*
   */
  update_dag_run_state: {
    parameters: {
      path: {
        /** The DAG ID. */
        dag_id: components["parameters"]["DAGID"];
        /** The DAG run ID. */
        dag_run_id: components["parameters"]["DAGRunID"];
      };
    };
    responses: {
      /** Success. */
      200: {
        content: {
          "application/json": components["schemas"]["DAGRun"];
        };
      };
      400: components["responses"]["BadRequest"];
      401: components["responses"]["Unauthenticated"];
      403: components["responses"]["PermissionDenied"];
      404: components["responses"]["NotFound"];
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["UpdateDagRunState"];
      };
    };
  };
  /**
   * Clear a DAG run.
   *
   * *New in version 2.4.0*
   */
  clear_dag_run: {
    parameters: {
      path: {
        /** The DAG ID. */
        dag_id: components["parameters"]["DAGID"];
        /** The DAG run ID. */
        dag_run_id: components["parameters"]["DAGRunID"];
      };
    };
    responses: {
      /** Success. */
      200: {
        content: {
          "application/json": Partial<components["schemas"]["DAGRun"]> &
            Partial<components["schemas"]["TaskInstanceCollection"]>;
        };
      };
      400: components["responses"]["BadRequest"];
      401: components["responses"]["Unauthenticated"];
      403: components["responses"]["PermissionDenied"];
      404: components["responses"]["NotFound"];
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["ClearDagRun"];
      };
    };
  };
  /**
   * Get datasets for a dag run.
   *
   * *New in version 2.4.0*
   */
  get_upstream_dataset_events: {
    parameters: {
      path: {
        /** The DAG ID. */
        dag_id: components["parameters"]["DAGID"];
        /** The DAG run ID. */
        dag_run_id: components["parameters"]["DAGRunID"];
      };
    };
    responses: {
      /** Success. */
      200: {
        content: {
          "application/json": components["schemas"]["DatasetEventCollection"];
        };
      };
      401: components["responses"]["Unauthenticated"];
      403: components["responses"]["PermissionDenied"];
      404: components["responses"]["NotFound"];
    };
  };
  /**
   * Update the manual user note of a DagRun.
   *
   * *New in version 2.5.0*
   */
  set_dag_run_note: {
    parameters: {
      path: {
        /** The DAG ID. */
        dag_id: components["parameters"]["DAGID"];
        /** The DAG run ID. */
        dag_run_id: components["parameters"]["DAGRunID"];
      };
    };
    responses: {
      /** Success. */
      200: {
        content: {
          "application/json": components["schemas"]["DAGRun"];
        };
      };
      400: components["responses"]["BadRequest"];
      401: components["responses"]["Unauthenticated"];
      403: components["responses"]["PermissionDenied"];
      404: components["responses"]["NotFound"];
    };
    /** Parameters of set DagRun note. */
    requestBody: {
      content: {
        "application/json": components["schemas"]["SetDagRunNote"];
      };
    };
  };
  /** List log entries from event log. */
  get_event_logs: {
    parameters: {
      query: {
        /** The numbers of items to return. */
        limit?: components["parameters"]["PageLimit"];
        /** The number of items to skip before starting to collect the result set. */
        offset?: components["parameters"]["PageOffset"];
        /**
         * The name of the field to order the results by.
         * Prefix a field name with `-` to reverse the sort order.
         *
         * *New in version 2.1.0*
         */
        order_by?: components["parameters"]["OrderBy"];
      };
    };
    responses: {
      /** Success. */
      200: {
        content: {
          "application/json": components["schemas"]["EventLogCollection"];
        };
      };
      401: components["responses"]["Unauthenticated"];
      403: components["responses"]["PermissionDenied"];
    };
  };
  get_event_log: {
    parameters: {
      path: {
        /** The event log ID. */
        event_log_id: components["parameters"]["EventLogID"];
      };
    };
    responses: {
      /** Success. */
      200: {
        content: {
          "application/json": components["schemas"]["EventLog"];
        };
      };
      401: components["responses"]["Unauthenticated"];
      403: components["responses"]["PermissionDenied"];
      404: components["responses"]["NotFound"];
    };
  };
  get_import_errors: {
    parameters: {
      query: {
        /** The numbers of items to return. */
        limit?: components["parameters"]["PageLimit"];
        /** The number of items to skip before starting to collect the result set. */
        offset?: components["parameters"]["PageOffset"];
        /**
         * The name of the field to order the results by.
         * Prefix a field name with `-` to reverse the sort order.
         *
         * *New in version 2.1.0*
         */
        order_by?: components["parameters"]["OrderBy"];
      };
    };
    responses: {
      /** Success. */
      200: {
        content: {
          "application/json": components["schemas"]["ImportErrorCollection"];
        };
      };
      401: components["responses"]["Unauthenticated"];
      403: components["responses"]["PermissionDenied"];
    };
  };
  get_import_error: {
    parameters: {
      path: {
        /** The import error ID. */
        import_error_id: components["parameters"]["ImportErrorID"];
      };
    };
    responses: {
      /** Success. */
      200: {
        content: {
          "application/json": components["schemas"]["ImportError"];
        };
      };
      401: components["responses"]["Unauthenticated"];
      403: components["responses"]["PermissionDenied"];
      404: components["responses"]["NotFound"];
    };
  };
  get_pools: {
    parameters: {
      query: {
        /** The numbers of items to return. */
        limit?: components["parameters"]["PageLimit"];
        /** The number of items to skip before starting to collect the result set. */
        offset?: components["parameters"]["PageOffset"];
        /**
         * The name of the field to order the results by.
         * Prefix a field name with `-` to reverse the sort order.
         *
         * *New in version 2.1.0*
         */
        order_by?: components["parameters"]["OrderBy"];
      };
    };
    responses: {
      /** List of pools. */
      200: {
        content: {
          "application/json": components["schemas"]["PoolCollection"];
        };
      };
      401: components["responses"]["Unauthenticated"];
      403: components["responses"]["PermissionDenied"];
    };
  };
  post_pool: {
    responses: {
      /** Success. */
      200: {
        content: {
          "application/json": components["schemas"]["Pool"];
        };
      };
      400: components["responses"]["BadRequest"];
      401: components["responses"]["Unauthenticated"];
      403: components["responses"]["PermissionDenied"];
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["Pool"];
      };
    };
  };
  get_pool: {
    parameters: {
      path: {
        /** The pool name. */
        pool_name: components["parameters"]["PoolName"];
      };
    };
    responses: {
      /** Success. */
      200: {
        content: {
          "application/json": components["schemas"]["Pool"];
        };
      };
      401: components["responses"]["Unauthenticated"];
      403: components["responses"]["PermissionDenied"];
      404: components["responses"]["NotFound"];
    };
  };
  delete_pool: {
    parameters: {
      path: {
        /** The pool name. */
        pool_name: components["parameters"]["PoolName"];
      };
    };
    responses: {
      /** Success. */
      204: never;
      400: components["responses"]["BadRequest"];
      401: components["responses"]["Unauthenticated"];
      403: components["responses"]["PermissionDenied"];
      404: components["responses"]["NotFound"];
    };
  };
  patch_pool: {
    parameters: {
      path: {
        /** The pool name. */
        pool_name: components["parameters"]["PoolName"];
      };
      query: {
        /**
         * The fields to update on the resource. If absent or empty, all modifiable fields are updated.
         * A comma-separated list of fully qualified names of fields.
         */
        update_mask?: components["parameters"]["UpdateMask"];
      };
    };
    responses: {
      /** Success. */
      200: {
        content: {
          "application/json": components["schemas"]["Pool"];
        };
      };
      400: components["responses"]["BadRequest"];
      401: components["responses"]["Unauthenticated"];
      403: components["responses"]["PermissionDenied"];
      404: components["responses"]["NotFound"];
      409: components["responses"]["AlreadyExists"];
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["Pool"];
      };
    };
  };
  /**
   * Get a list of providers.
   *
   * *New in version 2.1.0*
   */
  get_providers: {
    responses: {
      /** List of providers. */
      200: {
        content: {
          "application/json": components["schemas"]["ProviderCollection"] &
            components["schemas"]["CollectionInfo"];
        };
      };
      401: components["responses"]["Unauthenticated"];
      403: components["responses"]["PermissionDenied"];
    };
  };
  /** This endpoint allows specifying `~` as the dag_id, dag_run_id to retrieve DAG runs for all DAGs and DAG runs. */
  get_task_instances: {
    parameters: {
      path: {
        /** The DAG ID. */
        dag_id: components["parameters"]["DAGID"];
        /** The DAG run ID. */
        dag_run_id: components["parameters"]["DAGRunID"];
      };
      query: {
        /**
         * Returns objects greater or equal to the specified date.
         *
         * This can be combined with execution_date_lte parameter to receive only the selected period.
         */
        execution_date_gte?: components["parameters"]["FilterExecutionDateGTE"];
        /**
         * Returns objects less than or equal to the specified date.
         *
         * This can be combined with execution_date_gte parameter to receive only the selected period.
         */
        execution_date_lte?: components["parameters"]["FilterExecutionDateLTE"];
        /**
         * Returns objects greater or equal the specified date.
         *
         * This can be combined with start_date_lte parameter to receive only the selected period.
         */
        start_date_gte?: components["parameters"]["FilterStartDateGTE"];
        /**
         * Returns objects less or equal the specified date.
         *
         * This can be combined with start_date_gte parameter to receive only the selected period.
         */
        start_date_lte?: components["parameters"]["FilterStartDateLTE"];
        /**
         * Returns objects greater or equal the specified date.
         *
         * This can be combined with start_date_lte parameter to receive only the selected period.
         */
        end_date_gte?: components["parameters"]["FilterEndDateGTE"];
        /**
         * Returns objects less than or equal to the specified date.
         *
         * This can be combined with start_date_gte parameter to receive only the selected period.
         */
        end_date_lte?: components["parameters"]["FilterEndDateLTE"];
        /**
         * Returns objects greater or equal the specified date.
         *
         * This can be combined with updated_at_lte parameter to receive only the selected period.
         *
         * *New in version 2.6.0*
         */
        updated_at_gte?: components["parameters"]["FilterUpdatedAtGTE"];
        /**
         * Returns objects less or equal the specified date.
         *
         * This can be combined with updated_at_gte parameter to receive only the selected period.
         *
         * *New in version 2.6.0*
         */
        updated_at_lte?: components["parameters"]["FilterUpdatedAtLTE"];
        /**
         * Returns objects greater than or equal to the specified values.
         *
         * This can be combined with duration_lte parameter to receive only the selected period.
         */
        duration_gte?: components["parameters"]["FilterDurationGTE"];
        /**
         * Returns objects less than or equal to the specified values.
         *
         * This can be combined with duration_gte parameter to receive only the selected range.
         */
        duration_lte?: components["parameters"]["FilterDurationLTE"];
        /** The value can be repeated to retrieve multiple matching values (OR condition). */
        state?: components["parameters"]["FilterState"];
        /** The value can be repeated to retrieve multiple matching values (OR condition). */
        pool?: components["parameters"]["FilterPool"];
        /** The value can be repeated to retrieve multiple matching values (OR condition). */
        queue?: components["parameters"]["FilterQueue"];
        /** The numbers of items to return. */
        limit?: components["parameters"]["PageLimit"];
        /** The number of items to skip before starting to collect the result set. */
        offset?: components["parameters"]["PageOffset"];
      };
    };
    responses: {
      /** Success. */
      200: {
        content: {
          "application/json": components["schemas"]["TaskInstanceCollection"];
        };
      };
      401: components["responses"]["Unauthenticated"];
      403: components["responses"]["PermissionDenied"];
    };
  };
  get_task_instance: {
    parameters: {
      path: {
        /** The DAG ID. */
        dag_id: components["parameters"]["DAGID"];
        /** The DAG run ID. */
        dag_run_id: components["parameters"]["DAGRunID"];
        /** The task ID. */
        task_id: components["parameters"]["TaskID"];
      };
    };
    responses: {
      /** Success. */
      200: {
        content: {
          "application/json": components["schemas"]["TaskInstance"];
        };
      };
      401: components["responses"]["Unauthenticated"];
      403: components["responses"]["PermissionDenied"];
      404: components["responses"]["NotFound"];
    };
  };
  /**
   * Updates the state for single task instance.
   * *New in version 2.5.0*
   */
  patch_task_instance: {
    parameters: {
      path: {
        /** The DAG ID. */
        dag_id: components["parameters"]["DAGID"];
        /** The DAG run ID. */
        dag_run_id: components["parameters"]["DAGRunID"];
        /** The task ID. */
        task_id: components["parameters"]["TaskID"];
      };
    };
    responses: {
      /** Success. */
      200: {
        content: {
          "application/json": components["schemas"]["TaskInstanceReference"];
        };
      };
      401: components["responses"]["Unauthenticated"];
      403: components["responses"]["PermissionDenied"];
      404: components["responses"]["NotFound"];
    };
    /** Parameters of action */
    requestBody: {
      content: {
        "application/json": components["schemas"]["UpdateTaskInstance"];
      };
    };
  };
  /**
   * Get details of a mapped task instance.
   *
   * *New in version 2.3.0*
   */
  get_mapped_task_instance: {
    parameters: {
      path: {
        /** The DAG ID. */
        dag_id: components["parameters"]["DAGID"];
        /** The DAG run ID. */
        dag_run_id: components["parameters"]["DAGRunID"];
        /** The task ID. */
        task_id: components["parameters"]["TaskID"];
        /** The map index. */
        map_index: components["parameters"]["MapIndex"];
      };
    };
    responses: {
      /** Success. */
      200: {
        content: {
          "application/json": components["schemas"]["TaskInstance"];
        };
      };
      401: components["responses"]["Unauthenticated"];
      403: components["responses"]["PermissionDenied"];
      404: components["responses"]["NotFound"];
    };
  };
  /**
   * Updates the state for single mapped task instance.
   * *New in version 2.5.0*
   */
  patch_mapped_task_instance: {
    parameters: {
      path: {
        /** The DAG ID. */
        dag_id: components["parameters"]["DAGID"];
        /** The DAG run ID. */
        dag_run_id: components["parameters"]["DAGRunID"];
        /** The task ID. */
        task_id: components["parameters"]["TaskID"];
        /** The map index. */
        map_index: components["parameters"]["MapIndex"];
      };
    };
    responses: {
      /** Success. */
      200: {
        content: {
          "application/json": components["schemas"]["TaskInstanceReference"];
        };
      };
      401: components["responses"]["Unauthenticated"];
      403: components["responses"]["PermissionDenied"];
      404: components["responses"]["NotFound"];
    };
    /** Parameters of action */
    requestBody: {
      content: {
        "application/json": components["schemas"]["UpdateTaskInstance"];
      };
    };
  };
  /**
   * Get details of all mapped task instances.
   *
   * *New in version 2.3.0*
   */
  get_mapped_task_instances: {
    parameters: {
      path: {
        /** The DAG ID. */
        dag_id: components["parameters"]["DAGID"];
        /** The DAG run ID. */
        dag_run_id: components["parameters"]["DAGRunID"];
        /** The task ID. */
        task_id: components["parameters"]["TaskID"];
      };
      query: {
        /** The numbers of items to return. */
        limit?: components["parameters"]["PageLimit"];
        /** The number of items to skip before starting to collect the result set. */
        offset?: components["parameters"]["PageOffset"];
        /**
         * Returns objects greater or equal to the specified date.
         *
         * This can be combined with execution_date_lte parameter to receive only the selected period.
         */
        execution_date_gte?: components["parameters"]["FilterExecutionDateGTE"];
        /**
         * Returns objects less than or equal to the specified date.
         *
         * This can be combined with execution_date_gte parameter to receive only the selected period.
         */
        execution_date_lte?: components["parameters"]["FilterExecutionDateLTE"];
        /**
         * Returns objects greater or equal the specified date.
         *
         * This can be combined with start_date_lte parameter to receive only the selected period.
         */
        start_date_gte?: components["parameters"]["FilterStartDateGTE"];
        /**
         * Returns objects less or equal the specified date.
         *
         * This can be combined with start_date_gte parameter to receive only the selected period.
         */
        start_date_lte?: components["parameters"]["FilterStartDateLTE"];
        /**
         * Returns objects greater or equal the specified date.
         *
         * This can be combined with start_date_lte parameter to receive only the selected period.
         */
        end_date_gte?: components["parameters"]["FilterEndDateGTE"];
        /**
         * Returns objects less than or equal to the specified date.
         *
         * This can be combined with start_date_gte parameter to receive only the selected period.
         */
        end_date_lte?: components["parameters"]["FilterEndDateLTE"];
        /**
         * Returns objects greater or equal the specified date.
         *
         * This can be combined with updated_at_lte parameter to receive only the selected period.
         *
         * *New in version 2.6.0*
         */
        updated_at_gte?: components["parameters"]["FilterUpdatedAtGTE"];
        /**
         * Returns objects less or equal the specified date.
         *
         * This can be combined with updated_at_gte parameter to receive only the selected period.
         *
         * *New in version 2.6.0*
         */
        updated_at_lte?: components["parameters"]["FilterUpdatedAtLTE"];
        /**
         * Returns objects greater than or equal to the specified values.
         *
         * This can be combined with duration_lte parameter to receive only the selected period.
         */
        duration_gte?: components["parameters"]["FilterDurationGTE"];
        /**
         * Returns objects less than or equal to the specified values.
         *
         * This can be combined with duration_gte parameter to receive only the selected range.
         */
        duration_lte?: components["parameters"]["FilterDurationLTE"];
        /** The value can be repeated to retrieve multiple matching values (OR condition). */
        state?: components["parameters"]["FilterState"];
        /** The value can be repeated to retrieve multiple matching values (OR condition). */
        pool?: components["parameters"]["FilterPool"];
        /** The value can be repeated to retrieve multiple matching values (OR condition). */
        queue?: components["parameters"]["FilterQueue"];
        /**
         * The name of the field to order the results by.
         * Prefix a field name with `-` to reverse the sort order.
         *
         * *New in version 2.1.0*
         */
        order_by?: components["parameters"]["OrderBy"];
      };
    };
    responses: {
      /** Success. */
      200: {
        content: {
          "application/json": components["schemas"]["TaskInstanceCollection"];
        };
      };
      401: components["responses"]["Unauthenticated"];
      403: components["responses"]["PermissionDenied"];
      404: components["responses"]["NotFound"];
    };
  };
  /**
   * List task instances from all DAGs and DAG runs.
   * This endpoint is a POST to allow filtering across a large number of DAG IDs, where as a GET it would run in to maximum HTTP request URL length limits.
   */
  get_task_instances_batch: {
    responses: {
      /** Success. */
      200: {
        content: {
          "application/json": components["schemas"]["TaskInstanceCollection"];
        };
      };
      401: components["responses"]["Unauthenticated"];
      403: components["responses"]["PermissionDenied"];
      404: components["responses"]["NotFound"];
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["ListTaskInstanceForm"];
      };
    };
  };
  /** The collection does not contain data. To get data, you must get a single entity. */
  get_variables: {
    parameters: {
      query: {
        /** The numbers of items to return. */
        limit?: components["parameters"]["PageLimit"];
        /** The number of items to skip before starting to collect the result set. */
        offset?: components["parameters"]["PageOffset"];
        /**
         * The name of the field to order the results by.
         * Prefix a field name with `-` to reverse the sort order.
         *
         * *New in version 2.1.0*
         */
        order_by?: components["parameters"]["OrderBy"];
      };
    };
    responses: {
      /** Success. */
      200: {
        content: {
          "application/json": components["schemas"]["VariableCollection"];
        };
      };
      401: components["responses"]["Unauthenticated"];
      403: components["responses"]["PermissionDenied"];
    };
  };
  post_variables: {
    responses: {
      /** Success. */
      200: {
        content: {
          "application/json": components["schemas"]["Variable"];
        };
      };
      400: components["responses"]["BadRequest"];
      401: components["responses"]["Unauthenticated"];
      403: components["responses"]["PermissionDenied"];
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["Variable"];
      };
    };
  };
  /** Get a variable by key. */
  get_variable: {
    parameters: {
      path: {
        /** The variable Key. */
        variable_key: components["parameters"]["VariableKey"];
      };
    };
    responses: {
      /** Success. */
      200: {
        content: {
          "application/json": components["schemas"]["Variable"];
        };
      };
      401: components["responses"]["Unauthenticated"];
      403: components["responses"]["PermissionDenied"];
      404: components["responses"]["NotFound"];
    };
  };
  delete_variable: {
    parameters: {
      path: {
        /** The variable Key. */
        variable_key: components["parameters"]["VariableKey"];
      };
    };
    responses: {
      /** Success. */
      204: never;
      400: components["responses"]["BadRequest"];
      401: components["responses"]["Unauthenticated"];
      403: components["responses"]["PermissionDenied"];
      404: components["responses"]["NotFound"];
    };
  };
  /** Update a variable by key. */
  patch_variable: {
    parameters: {
      path: {
        /** The variable Key. */
        variable_key: components["parameters"]["VariableKey"];
      };
      query: {
        /**
         * The fields to update on the resource. If absent or empty, all modifiable fields are updated.
         * A comma-separated list of fully qualified names of fields.
         */
        update_mask?: components["parameters"]["UpdateMask"];
      };
    };
    responses: {
      /** Success. */
      200: {
        content: {
          "application/json": components["schemas"]["Variable"];
        };
      };
      400: components["responses"]["BadRequest"];
      401: components["responses"]["Unauthenticated"];
      403: components["responses"]["PermissionDenied"];
      404: components["responses"]["NotFound"];
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["Variable"];
      };
    };
  };
  /** This endpoint allows specifying `~` as the dag_id, dag_run_id, task_id to retrieve XCOM entries for for all DAGs, DAG runs and task instances. XCom values won't be returned as they can be large. Use this endpoint to get a list of XCom entries and then fetch individual entry to get value. */
  get_xcom_entries: {
    parameters: {
      path: {
        /** The DAG ID. */
        dag_id: components["parameters"]["DAGID"];
        /** The DAG run ID. */
        dag_run_id: components["parameters"]["DAGRunID"];
        /** The task ID. */
        task_id: components["parameters"]["TaskID"];
      };
      query: {
        /** The numbers of items to return. */
        limit?: components["parameters"]["PageLimit"];
        /** The number of items to skip before starting to collect the result set. */
        offset?: components["parameters"]["PageOffset"];
      };
    };
    responses: {
      /** Success. */
      200: {
        content: {
          "application/json": components["schemas"]["XComCollection"];
        };
      };
      401: components["responses"]["Unauthenticated"];
      403: components["responses"]["PermissionDenied"];
    };
  };
  get_xcom_entry: {
    parameters: {
      path: {
        /** The DAG ID. */
        dag_id: components["parameters"]["DAGID"];
        /** The DAG run ID. */
        dag_run_id: components["parameters"]["DAGRunID"];
        /** The task ID. */
        task_id: components["parameters"]["TaskID"];
        /** The XCom key. */
        xcom_key: components["parameters"]["XComKey"];
      };
      query: {
        /**
         * Whether to deserialize an XCom value when using a custom XCom backend.
         *
         * The XCom API endpoint calls `orm_deserialize_value` by default since an XCom may contain value
         * that is potentially expensive to deserialize in the web server. Setting this to true overrides
         * the consideration, and calls `deserialize_value` instead.
         *
         * This parameter is not meaningful when using the default XCom backend.
         *
         * *New in version 2.4.0*
         */
        deserialize?: boolean;
      };
    };
    responses: {
      /** Success. */
      200: {
        content: {
          "application/json": components["schemas"]["XCom"];
        };
      };
      401: components["responses"]["Unauthenticated"];
      403: components["responses"]["PermissionDenied"];
      404: components["responses"]["NotFound"];
    };
  };
  /** List extra links for task instance. */
  get_extra_links: {
    parameters: {
      path: {
        /** The DAG ID. */
        dag_id: components["parameters"]["DAGID"];
        /** The DAG run ID. */
        dag_run_id: components["parameters"]["DAGRunID"];
        /** The task ID. */
        task_id: components["parameters"]["TaskID"];
      };
    };
    responses: {
      /** Success. */
      200: {
        content: {
          "application/json": components["schemas"]["ExtraLinkCollection"];
        };
      };
      401: components["responses"]["Unauthenticated"];
      403: components["responses"]["PermissionDenied"];
      404: components["responses"]["NotFound"];
    };
  };
  /** Get logs for a specific task instance and its try number. */
  get_log: {
    parameters: {
      path: {
        /** The DAG ID. */
        dag_id: components["parameters"]["DAGID"];
        /** The DAG run ID. */
        dag_run_id: components["parameters"]["DAGRunID"];
        /** The task ID. */
        task_id: components["parameters"]["TaskID"];
        /** The task try number. */
        task_try_number: components["parameters"]["TaskTryNumber"];
      };
      query: {
        /**
         * A full content will be returned.
         * By default, only the first fragment will be returned.
         */
        full_content?: components["parameters"]["FullContent"];
        /** Filter on map index for mapped task. */
        map_index?: components["parameters"]["FilterMapIndex"];
        /**
         * A token that allows you to continue fetching logs.
         * If passed, it will specify the location from which the download should be continued.
         */
        token?: components["parameters"]["ContinuationToken"];
      };
    };
    responses: {
      /** Success. */
      200: {
        content: {
          "application/json": {
            continuation_token?: string;
            content?: string;
          };
          "text/plain": string;
        };
      };
      400: components["responses"]["BadRequest"];
      401: components["responses"]["Unauthenticated"];
      403: components["responses"]["PermissionDenied"];
      404: components["responses"]["NotFound"];
    };
  };
  /** The response contains many DAG attributes, so the response can be large. If possible, consider using GET /dags/{dag_id}. */
  get_dag_details: {
    parameters: {
      path: {
        /** The DAG ID. */
        dag_id: components["parameters"]["DAGID"];
      };
    };
    responses: {
      /** Success. */
      200: {
        content: {
          "application/json": components["schemas"]["DAGDetail"];
        };
      };
      401: components["responses"]["Unauthenticated"];
      403: components["responses"]["PermissionDenied"];
      404: components["responses"]["NotFound"];
    };
  };
  get_tasks: {
    parameters: {
      path: {
        /** The DAG ID. */
        dag_id: components["parameters"]["DAGID"];
      };
      query: {
        /**
         * The name of the field to order the results by.
         * Prefix a field name with `-` to reverse the sort order.
         *
         * *New in version 2.1.0*
         */
        order_by?: components["parameters"]["OrderBy"];
      };
    };
    responses: {
      /** Success. */
      200: {
        content: {
          "application/json": components["schemas"]["TaskCollection"];
        };
      };
      401: components["responses"]["Unauthenticated"];
      403: components["responses"]["PermissionDenied"];
      404: components["responses"]["NotFound"];
    };
  };
  get_task: {
    parameters: {
      path: {
        /** The DAG ID. */
        dag_id: components["parameters"]["DAGID"];
        /** The task ID. */
        task_id: components["parameters"]["TaskID"];
      };
    };
    responses: {
      /** Success. */
      200: {
        content: {
          "application/json": components["schemas"]["Task"];
        };
      };
      401: components["responses"]["Unauthenticated"];
      403: components["responses"]["PermissionDenied"];
      404: components["responses"]["NotFound"];
    };
  };
  /** Get a source code using file token. */
  get_dag_source: {
    parameters: {
      path: {
        /**
         * The key containing the encrypted path to the file. Encryption and decryption take place only on
         * the server. This prevents the client from reading an non-DAG file. This also ensures API
         * extensibility, because the format of encrypted data may change.
         */
        file_token: components["parameters"]["FileToken"];
      };
    };
    responses: {
      /** Success. */
      200: {
        content: {
          "application/json": {
            content?: string;
          };
          "plain/text": string;
        };
      };
      401: components["responses"]["Unauthenticated"];
      403: components["responses"]["PermissionDenied"];
      404: components["responses"]["NotFound"];
      406: components["responses"]["NotAcceptable"];
    };
  };
  get_dag_warnings: {
    parameters: {
      query: {
        /** If set, only return DAG warnings with this dag_id. */
        dag_id?: string;
        /** If set, only return DAG warnings with this type. */
        warning_type?: string;
        /** The numbers of items to return. */
        limit?: components["parameters"]["PageLimit"];
        /** The number of items to skip before starting to collect the result set. */
        offset?: components["parameters"]["PageOffset"];
        /**
         * The name of the field to order the results by.
         * Prefix a field name with `-` to reverse the sort order.
         *
         * *New in version 2.1.0*
         */
        order_by?: components["parameters"]["OrderBy"];
      };
    };
    responses: {
      /** Success. */
      200: {
        content: {
          "application/json": components["schemas"]["DagWarningCollection"];
        };
      };
      401: components["responses"]["Unauthenticated"];
      403: components["responses"]["PermissionDenied"];
    };
  };
  get_datasets: {
    parameters: {
      query: {
        /** The numbers of items to return. */
        limit?: components["parameters"]["PageLimit"];
        /** The number of items to skip before starting to collect the result set. */
        offset?: components["parameters"]["PageOffset"];
        /**
         * The name of the field to order the results by.
         * Prefix a field name with `-` to reverse the sort order.
         *
         * *New in version 2.1.0*
         */
        order_by?: components["parameters"]["OrderBy"];
        /** If set, only return datasets with uris matching this pattern. */
        uri_pattern?: string;
      };
    };
    responses: {
      /** Success. */
      200: {
        content: {
          "application/json": components["schemas"]["DatasetCollection"];
        };
      };
      401: components["responses"]["Unauthenticated"];
      403: components["responses"]["PermissionDenied"];
    };
  };
  /** Get a dataset by uri. */
  get_dataset: {
    parameters: {
      path: {
        /** The encoded Dataset URI */
        uri: components["parameters"]["DatasetURI"];
      };
    };
    responses: {
      /** Success. */
      200: {
        content: {
          "application/json": components["schemas"]["Dataset"];
        };
      };
      401: components["responses"]["Unauthenticated"];
      403: components["responses"]["PermissionDenied"];
      404: components["responses"]["NotFound"];
    };
  };
  /** Get dataset events */
  get_dataset_events: {
    parameters: {
      query: {
        /** The numbers of items to return. */
        limit?: components["parameters"]["PageLimit"];
        /** The number of items to skip before starting to collect the result set. */
        offset?: components["parameters"]["PageOffset"];
        /**
         * The name of the field to order the results by.
         * Prefix a field name with `-` to reverse the sort order.
         *
         * *New in version 2.1.0*
         */
        order_by?: components["parameters"]["OrderBy"];
        /** The Dataset ID that updated the dataset. */
        dataset_id?: components["parameters"]["FilterDatasetID"];
        /** The DAG ID that updated the dataset. */
        source_dag_id?: components["parameters"]["FilterSourceDAGID"];
        /** The task ID that updated the dataset. */
        source_task_id?: components["parameters"]["FilterSourceTaskID"];
        /** The DAG run ID that updated the dataset. */
        source_run_id?: components["parameters"]["FilterSourceRunID"];
        /** The map index that updated the dataset. */
        source_map_index?: components["parameters"]["FilterSourceMapIndex"];
      };
    };
    responses: {
      /** Success. */
      200: {
        content: {
          "application/json": components["schemas"]["DatasetEventCollection"];
        };
      };
      401: components["responses"]["Unauthenticated"];
      403: components["responses"]["PermissionDenied"];
      404: components["responses"]["NotFound"];
    };
  };
  get_config: {
    responses: {
      /** Success. */
      200: {
        content: {
          "application/json": components["schemas"]["Config"];
          "text/plain": string;
        };
      };
      401: components["responses"]["Unauthenticated"];
      403: components["responses"]["PermissionDenied"];
    };
  };
  /**
   * Get the status of Airflow's metadatabase and scheduler. It includes info about
   * metadatabase and last heartbeat of scheduler.
   */
  get_health: {
    responses: {
      /** Success. */
      200: {
        content: {
          "application/json": components["schemas"]["HealthInfo"];
        };
      };
    };
  };
  get_version: {
    responses: {
      /** Success. */
      200: {
        content: {
          "application/json": components["schemas"]["VersionInfo"];
        };
      };
    };
  };
  /**
   * Get a list of loaded plugins.
   *
   * *New in version 2.1.0*
   */
  get_plugins: {
    parameters: {
      query: {
        /** The numbers of items to return. */
        limit?: components["parameters"]["PageLimit"];
        /** The number of items to skip before starting to collect the result set. */
        offset?: components["parameters"]["PageOffset"];
      };
    };
    responses: {
      /** Success */
      200: {
        content: {
          "application/json": components["schemas"]["PluginCollection"];
        };
      };
      401: components["responses"]["Unauthenticated"];
      403: components["responses"]["PermissionDenied"];
      404: components["responses"]["NotFound"];
    };
  };
  /**
   * Get a list of roles.
   *
   * *New in version 2.1.0*
   */
  get_roles: {
    parameters: {
      query: {
        /** The numbers of items to return. */
        limit?: components["parameters"]["PageLimit"];
        /** The number of items to skip before starting to collect the result set. */
        offset?: components["parameters"]["PageOffset"];
        /**
         * The name of the field to order the results by.
         * Prefix a field name with `-` to reverse the sort order.
         *
         * *New in version 2.1.0*
         */
        order_by?: components["parameters"]["OrderBy"];
      };
    };
    responses: {
      /** Success. */
      200: {
        content: {
          "application/json": components["schemas"]["RoleCollection"];
        };
      };
      401: components["responses"]["Unauthenticated"];
      403: components["responses"]["PermissionDenied"];
    };
  };
  /**
   * Create a new role.
   *
   * *New in version 2.1.0*
   */
  post_role: {
    responses: {
      /** Success. */
      200: {
        content: {
          "application/json": components["schemas"]["Role"];
        };
      };
      400: components["responses"]["BadRequest"];
      401: components["responses"]["Unauthenticated"];
      403: components["responses"]["PermissionDenied"];
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["Role"];
      };
    };
  };
  /**
   * Get a role.
   *
   * *New in version 2.1.0*
   */
  get_role: {
    parameters: {
      path: {
        /** The role name */
        role_name: components["parameters"]["RoleName"];
      };
    };
    responses: {
      /** Success. */
      200: {
        content: {
          "application/json": components["schemas"]["Role"];
        };
      };
      401: components["responses"]["Unauthenticated"];
      403: components["responses"]["PermissionDenied"];
      404: components["responses"]["NotFound"];
    };
  };
  /**
   * Delete a role.
   *
   * *New in version 2.1.0*
   */
  delete_role: {
    parameters: {
      path: {
        /** The role name */
        role_name: components["parameters"]["RoleName"];
      };
    };
    responses: {
      /** Success. */
      204: never;
      400: components["responses"]["BadRequest"];
      401: components["responses"]["Unauthenticated"];
      403: components["responses"]["PermissionDenied"];
      404: components["responses"]["NotFound"];
    };
  };
  /**
   * Update a role.
   *
   * *New in version 2.1.0*
   */
  patch_role: {
    parameters: {
      path: {
        /** The role name */
        role_name: components["parameters"]["RoleName"];
      };
      query: {
        /**
         * The fields to update on the resource. If absent or empty, all modifiable fields are updated.
         * A comma-separated list of fully qualified names of fields.
         */
        update_mask?: components["parameters"]["UpdateMask"];
      };
    };
    responses: {
      /** Success. */
      200: {
        content: {
          "application/json": components["schemas"]["Role"];
        };
      };
      400: components["responses"]["BadRequest"];
      401: components["responses"]["Unauthenticated"];
      403: components["responses"]["PermissionDenied"];
      404: components["responses"]["NotFound"];
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["Role"];
      };
    };
  };
  /**
   * Get a list of permissions.
   *
   * *New in version 2.1.0*
   */
  get_permissions: {
    parameters: {
      query: {
        /** The numbers of items to return. */
        limit?: components["parameters"]["PageLimit"];
        /** The number of items to skip before starting to collect the result set. */
        offset?: components["parameters"]["PageOffset"];
      };
    };
    responses: {
      /** Success. */
      200: {
        content: {
          "application/json": components["schemas"]["ActionCollection"];
        };
      };
      401: components["responses"]["Unauthenticated"];
      403: components["responses"]["PermissionDenied"];
    };
  };
  /**
   * Get a list of users.
   *
   * *New in version 2.1.0*
   */
  get_users: {
    parameters: {
      query: {
        /** The numbers of items to return. */
        limit?: components["parameters"]["PageLimit"];
        /** The number of items to skip before starting to collect the result set. */
        offset?: components["parameters"]["PageOffset"];
        /**
         * The name of the field to order the results by.
         * Prefix a field name with `-` to reverse the sort order.
         *
         * *New in version 2.1.0*
         */
        order_by?: components["parameters"]["OrderBy"];
      };
    };
    responses: {
      /** Success. */
      200: {
        content: {
          "application/json": components["schemas"]["UserCollection"];
        };
      };
      401: components["responses"]["Unauthenticated"];
      403: components["responses"]["PermissionDenied"];
    };
  };
  /**
   * Create a new user with unique username and email.
   *
   * *New in version 2.2.0*
   */
  post_user: {
    responses: {
      /** Success. */
      200: {
        content: {
          "application/json": components["schemas"]["User"];
        };
      };
      400: components["responses"]["BadRequest"];
      401: components["responses"]["Unauthenticated"];
      403: components["responses"]["PermissionDenied"];
      409: components["responses"]["AlreadyExists"];
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["User"];
      };
    };
  };
  /**
   * Get a user with a specific username.
   *
   * *New in version 2.1.0*
   */
  get_user: {
    parameters: {
      path: {
        /**
         * The username of the user.
         *
         * *New in version 2.1.0*
         */
        username: components["parameters"]["Username"];
      };
    };
    responses: {
      /** Success. */
      200: {
        content: {
          "application/json": components["schemas"]["UserCollectionItem"];
        };
      };
      401: components["responses"]["Unauthenticated"];
      403: components["responses"]["PermissionDenied"];
      404: components["responses"]["NotFound"];
    };
  };
  /**
   * Delete a user with a specific username.
   *
   * *New in version 2.2.0*
   */
  delete_user: {
    parameters: {
      path: {
        /**
         * The username of the user.
         *
         * *New in version 2.1.0*
         */
        username: components["parameters"]["Username"];
      };
    };
    responses: {
      /** Success. */
      204: never;
      400: components["responses"]["BadRequest"];
      401: components["responses"]["Unauthenticated"];
      403: components["responses"]["PermissionDenied"];
      404: components["responses"]["NotFound"];
    };
  };
  /**
   * Update fields for a user.
   *
   * *New in version 2.2.0*
   */
  patch_user: {
    parameters: {
      path: {
        /**
         * The username of the user.
         *
         * *New in version 2.1.0*
         */
        username: components["parameters"]["Username"];
      };
      query: {
        /**
         * The fields to update on the resource. If absent or empty, all modifiable fields are updated.
         * A comma-separated list of fully qualified names of fields.
         */
        update_mask?: components["parameters"]["UpdateMask"];
      };
    };
    responses: {
      /** Success. */
      200: {
        content: {
          "application/json": components["schemas"]["UserCollectionItem"];
        };
      };
      400: components["responses"]["BadRequest"];
      401: components["responses"]["Unauthenticated"];
      403: components["responses"]["PermissionDenied"];
      404: components["responses"]["NotFound"];
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["User"];
      };
    };
  };
}

export interface external {}

/* Alias paths to PascalCase. */
export type Paths = paths;

/* Types for returned data  */
export type UserCollectionItem = CamelCasedPropertiesDeep<
  components["schemas"]["UserCollectionItem"]
>;
export type User = CamelCasedPropertiesDeep<components["schemas"]["User"]>;
export type UserCollection = CamelCasedPropertiesDeep<
  components["schemas"]["UserCollection"]
>;
export type ConnectionCollectionItem = CamelCasedPropertiesDeep<
  components["schemas"]["ConnectionCollectionItem"]
>;
export type ConnectionCollection = CamelCasedPropertiesDeep<
  components["schemas"]["ConnectionCollection"]
>;
export type Connection = CamelCasedPropertiesDeep<
  components["schemas"]["Connection"]
>;
export type ConnectionTest = CamelCasedPropertiesDeep<
  components["schemas"]["ConnectionTest"]
>;
export type DAG = CamelCasedPropertiesDeep<components["schemas"]["DAG"]>;
export type DAGCollection = CamelCasedPropertiesDeep<
  components["schemas"]["DAGCollection"]
>;
export type DAGRun = CamelCasedPropertiesDeep<components["schemas"]["DAGRun"]>;
export type UpdateDagRunState = CamelCasedPropertiesDeep<
  components["schemas"]["UpdateDagRunState"]
>;
export type DAGRunCollection = CamelCasedPropertiesDeep<
  components["schemas"]["DAGRunCollection"]
>;
export type DagWarning = CamelCasedPropertiesDeep<
  components["schemas"]["DagWarning"]
>;
export type DagWarningCollection = CamelCasedPropertiesDeep<
  components["schemas"]["DagWarningCollection"]
>;
export type SetDagRunNote = CamelCasedPropertiesDeep<
  components["schemas"]["SetDagRunNote"]
>;
export type EventLog = CamelCasedPropertiesDeep<
  components["schemas"]["EventLog"]
>;
export type EventLogCollection = CamelCasedPropertiesDeep<
  components["schemas"]["EventLogCollection"]
>;
export type ImportError = CamelCasedPropertiesDeep<
  components["schemas"]["ImportError"]
>;
export type ImportErrorCollection = CamelCasedPropertiesDeep<
  components["schemas"]["ImportErrorCollection"]
>;
export type HealthInfo = CamelCasedPropertiesDeep<
  components["schemas"]["HealthInfo"]
>;
export type MetadatabaseStatus = CamelCasedPropertiesDeep<
  components["schemas"]["MetadatabaseStatus"]
>;
export type SchedulerStatus = CamelCasedPropertiesDeep<
  components["schemas"]["SchedulerStatus"]
>;
export type Pool = CamelCasedPropertiesDeep<components["schemas"]["Pool"]>;
export type PoolCollection = CamelCasedPropertiesDeep<
  components["schemas"]["PoolCollection"]
>;
export type Provider = CamelCasedPropertiesDeep<
  components["schemas"]["Provider"]
>;
export type ProviderCollection = CamelCasedPropertiesDeep<
  components["schemas"]["ProviderCollection"]
>;
export type SLAMiss = CamelCasedPropertiesDeep<
  components["schemas"]["SLAMiss"]
>;
export type Trigger = CamelCasedPropertiesDeep<
  components["schemas"]["Trigger"]
>;
export type Job = CamelCasedPropertiesDeep<components["schemas"]["Job"]>;
export type TaskInstance = CamelCasedPropertiesDeep<
  components["schemas"]["TaskInstance"]
>;
export type TaskInstanceCollection = CamelCasedPropertiesDeep<
  components["schemas"]["TaskInstanceCollection"]
>;
export type TaskInstanceReference = CamelCasedPropertiesDeep<
  components["schemas"]["TaskInstanceReference"]
>;
export type TaskInstanceReferenceCollection = CamelCasedPropertiesDeep<
  components["schemas"]["TaskInstanceReferenceCollection"]
>;
export type VariableCollectionItem = CamelCasedPropertiesDeep<
  components["schemas"]["VariableCollectionItem"]
>;
export type VariableCollection = CamelCasedPropertiesDeep<
  components["schemas"]["VariableCollection"]
>;
export type Variable = CamelCasedPropertiesDeep<
  components["schemas"]["Variable"]
>;
export type XComCollectionItem = CamelCasedPropertiesDeep<
  components["schemas"]["XComCollectionItem"]
>;
export type XComCollection = CamelCasedPropertiesDeep<
  components["schemas"]["XComCollection"]
>;
export type XCom = CamelCasedPropertiesDeep<components["schemas"]["XCom"]>;
export type DAGDetail = CamelCasedPropertiesDeep<
  components["schemas"]["DAGDetail"]
>;
export type ExtraLink = CamelCasedPropertiesDeep<
  components["schemas"]["ExtraLink"]
>;
export type ExtraLinkCollection = CamelCasedPropertiesDeep<
  components["schemas"]["ExtraLinkCollection"]
>;
export type Task = CamelCasedPropertiesDeep<components["schemas"]["Task"]>;
export type TaskCollection = CamelCasedPropertiesDeep<
  components["schemas"]["TaskCollection"]
>;
export type PluginCollectionItem = CamelCasedPropertiesDeep<
  components["schemas"]["PluginCollectionItem"]
>;
export type PluginCollection = CamelCasedPropertiesDeep<
  components["schemas"]["PluginCollection"]
>;
export type Role = CamelCasedPropertiesDeep<components["schemas"]["Role"]>;
export type RoleCollection = CamelCasedPropertiesDeep<
  components["schemas"]["RoleCollection"]
>;
export type Action = CamelCasedPropertiesDeep<components["schemas"]["Action"]>;
export type ActionCollection = CamelCasedPropertiesDeep<
  components["schemas"]["ActionCollection"]
>;
export type Resource = CamelCasedPropertiesDeep<
  components["schemas"]["Resource"]
>;
export type ActionResource = CamelCasedPropertiesDeep<
  components["schemas"]["ActionResource"]
>;
export type Dataset = CamelCasedPropertiesDeep<
  components["schemas"]["Dataset"]
>;
export type TaskOutletDatasetReference = CamelCasedPropertiesDeep<
  components["schemas"]["TaskOutletDatasetReference"]
>;
export type DagScheduleDatasetReference = CamelCasedPropertiesDeep<
  components["schemas"]["DagScheduleDatasetReference"]
>;
export type DatasetCollection = CamelCasedPropertiesDeep<
  components["schemas"]["DatasetCollection"]
>;
export type DatasetEvent = CamelCasedPropertiesDeep<
  components["schemas"]["DatasetEvent"]
>;
export type BasicDAGRun = CamelCasedPropertiesDeep<
  components["schemas"]["BasicDAGRun"]
>;
export type DatasetEventCollection = CamelCasedPropertiesDeep<
  components["schemas"]["DatasetEventCollection"]
>;
export type ConfigOption = CamelCasedPropertiesDeep<
  components["schemas"]["ConfigOption"]
>;
export type ConfigSection = CamelCasedPropertiesDeep<
  components["schemas"]["ConfigSection"]
>;
export type Config = CamelCasedPropertiesDeep<components["schemas"]["Config"]>;
export type VersionInfo = CamelCasedPropertiesDeep<
  components["schemas"]["VersionInfo"]
>;
export type ClearDagRun = CamelCasedPropertiesDeep<
  components["schemas"]["ClearDagRun"]
>;
export type ClearTaskInstances = CamelCasedPropertiesDeep<
  components["schemas"]["ClearTaskInstances"]
>;
export type UpdateTaskInstancesState = CamelCasedPropertiesDeep<
  components["schemas"]["UpdateTaskInstancesState"]
>;
export type UpdateTaskInstance = CamelCasedPropertiesDeep<
  components["schemas"]["UpdateTaskInstance"]
>;
export type SetTaskInstanceNote = CamelCasedPropertiesDeep<
  components["schemas"]["SetTaskInstanceNote"]
>;
export type ListDagRunsForm = CamelCasedPropertiesDeep<
  components["schemas"]["ListDagRunsForm"]
>;
export type ListTaskInstanceForm = CamelCasedPropertiesDeep<
  components["schemas"]["ListTaskInstanceForm"]
>;
export type ScheduleInterval = CamelCasedPropertiesDeep<
  components["schemas"]["ScheduleInterval"]
>;
export type TimeDelta = CamelCasedPropertiesDeep<
  components["schemas"]["TimeDelta"]
>;
export type RelativeDelta = CamelCasedPropertiesDeep<
  components["schemas"]["RelativeDelta"]
>;
export type CronExpression = CamelCasedPropertiesDeep<
  components["schemas"]["CronExpression"]
>;
export type Timezone = CamelCasedPropertiesDeep<
  components["schemas"]["Timezone"]
>;
export type Tag = CamelCasedPropertiesDeep<components["schemas"]["Tag"]>;
export type Color = CamelCasedPropertiesDeep<components["schemas"]["Color"]>;
export type ClassReference = CamelCasedPropertiesDeep<
  components["schemas"]["ClassReference"]
>;
export type Error = CamelCasedPropertiesDeep<components["schemas"]["Error"]>;
export type CollectionInfo = CamelCasedPropertiesDeep<
  components["schemas"]["CollectionInfo"]
>;
export type TaskState = CamelCasedPropertiesDeep<
  components["schemas"]["TaskState"]
>;
export type DagState = CamelCasedPropertiesDeep<
  components["schemas"]["DagState"]
>;
export type TriggerRule = CamelCasedPropertiesDeep<
  components["schemas"]["TriggerRule"]
>;
export type WeightRule = CamelCasedPropertiesDeep<
  components["schemas"]["WeightRule"]
>;
export type HealthStatus = CamelCasedPropertiesDeep<
  components["schemas"]["HealthStatus"]
>;

/* Alias operations to PascalCase. */
export type Operations = operations;

/* Types for operation variables  */
export type GetConnectionsVariables = CamelCasedPropertiesDeep<
  operations["get_connections"]["parameters"]["query"]
>;
export type PostConnectionVariables = CamelCasedPropertiesDeep<
  operations["post_connection"]["requestBody"]["content"]["application/json"]
>;
export type GetConnectionVariables = CamelCasedPropertiesDeep<
  operations["get_connection"]["parameters"]["path"]
>;
export type DeleteConnectionVariables = CamelCasedPropertiesDeep<
  operations["delete_connection"]["parameters"]["path"]
>;
export type PatchConnectionVariables = CamelCasedPropertiesDeep<
  operations["patch_connection"]["parameters"]["path"] &
    operations["patch_connection"]["parameters"]["query"] &
    operations["patch_connection"]["requestBody"]["content"]["application/json"]
>;
export type TestConnectionVariables = CamelCasedPropertiesDeep<
  operations["test_connection"]["requestBody"]["content"]["application/json"]
>;
export type GetDagsVariables = CamelCasedPropertiesDeep<
  operations["get_dags"]["parameters"]["query"]
>;
export type PatchDagsVariables = CamelCasedPropertiesDeep<
  operations["patch_dags"]["parameters"]["query"] &
    operations["patch_dags"]["requestBody"]["content"]["application/json"]
>;
export type GetDagVariables = CamelCasedPropertiesDeep<
  operations["get_dag"]["parameters"]["path"]
>;
export type DeleteDagVariables = CamelCasedPropertiesDeep<
  operations["delete_dag"]["parameters"]["path"]
>;
export type PatchDagVariables = CamelCasedPropertiesDeep<
  operations["patch_dag"]["parameters"]["path"] &
    operations["patch_dag"]["parameters"]["query"] &
    operations["patch_dag"]["requestBody"]["content"]["application/json"]
>;
export type PostClearTaskInstancesVariables = CamelCasedPropertiesDeep<
  operations["post_clear_task_instances"]["parameters"]["path"] &
    operations["post_clear_task_instances"]["requestBody"]["content"]["application/json"]
>;
export type SetTaskInstanceNoteVariables = CamelCasedPropertiesDeep<
  operations["set_task_instance_note"]["parameters"]["path"] &
    operations["set_task_instance_note"]["requestBody"]["content"]["application/json"]
>;
export type SetMappedTaskInstanceNoteVariables = CamelCasedPropertiesDeep<
  operations["set_mapped_task_instance_note"]["parameters"]["path"] &
    operations["set_mapped_task_instance_note"]["requestBody"]["content"]["application/json"]
>;
export type PostSetTaskInstancesStateVariables = CamelCasedPropertiesDeep<
  operations["post_set_task_instances_state"]["parameters"]["path"] &
    operations["post_set_task_instances_state"]["requestBody"]["content"]["application/json"]
>;
export type GetDagRunsVariables = CamelCasedPropertiesDeep<
  operations["get_dag_runs"]["parameters"]["path"] &
    operations["get_dag_runs"]["parameters"]["query"]
>;
export type PostDagRunVariables = CamelCasedPropertiesDeep<
  operations["post_dag_run"]["parameters"]["path"] &
    operations["post_dag_run"]["requestBody"]["content"]["application/json"]
>;
export type GetDagRunsBatchVariables = CamelCasedPropertiesDeep<
  operations["get_dag_runs_batch"]["requestBody"]["content"]["application/json"]
>;
export type GetDagRunVariables = CamelCasedPropertiesDeep<
  operations["get_dag_run"]["parameters"]["path"]
>;
export type DeleteDagRunVariables = CamelCasedPropertiesDeep<
  operations["delete_dag_run"]["parameters"]["path"]
>;
export type UpdateDagRunStateVariables = CamelCasedPropertiesDeep<
  operations["update_dag_run_state"]["parameters"]["path"] &
    operations["update_dag_run_state"]["requestBody"]["content"]["application/json"]
>;
export type ClearDagRunVariables = CamelCasedPropertiesDeep<
  operations["clear_dag_run"]["parameters"]["path"] &
    operations["clear_dag_run"]["requestBody"]["content"]["application/json"]
>;
export type GetUpstreamDatasetEventsVariables = CamelCasedPropertiesDeep<
  operations["get_upstream_dataset_events"]["parameters"]["path"]
>;
export type SetDagRunNoteVariables = CamelCasedPropertiesDeep<
  operations["set_dag_run_note"]["parameters"]["path"] &
    operations["set_dag_run_note"]["requestBody"]["content"]["application/json"]
>;
export type GetEventLogsVariables = CamelCasedPropertiesDeep<
  operations["get_event_logs"]["parameters"]["query"]
>;
export type GetEventLogVariables = CamelCasedPropertiesDeep<
  operations["get_event_log"]["parameters"]["path"]
>;
export type GetImportErrorsVariables = CamelCasedPropertiesDeep<
  operations["get_import_errors"]["parameters"]["query"]
>;
export type GetImportErrorVariables = CamelCasedPropertiesDeep<
  operations["get_import_error"]["parameters"]["path"]
>;
export type GetPoolsVariables = CamelCasedPropertiesDeep<
  operations["get_pools"]["parameters"]["query"]
>;
export type PostPoolVariables = CamelCasedPropertiesDeep<
  operations["post_pool"]["requestBody"]["content"]["application/json"]
>;
export type GetPoolVariables = CamelCasedPropertiesDeep<
  operations["get_pool"]["parameters"]["path"]
>;
export type DeletePoolVariables = CamelCasedPropertiesDeep<
  operations["delete_pool"]["parameters"]["path"]
>;
export type PatchPoolVariables = CamelCasedPropertiesDeep<
  operations["patch_pool"]["parameters"]["path"] &
    operations["patch_pool"]["parameters"]["query"] &
    operations["patch_pool"]["requestBody"]["content"]["application/json"]
>;
export type GetTaskInstancesVariables = CamelCasedPropertiesDeep<
  operations["get_task_instances"]["parameters"]["path"] &
    operations["get_task_instances"]["parameters"]["query"]
>;
export type GetTaskInstanceVariables = CamelCasedPropertiesDeep<
  operations["get_task_instance"]["parameters"]["path"]
>;
export type PatchTaskInstanceVariables = CamelCasedPropertiesDeep<
  operations["patch_task_instance"]["parameters"]["path"] &
    operations["patch_task_instance"]["requestBody"]["content"]["application/json"]
>;
export type GetMappedTaskInstanceVariables = CamelCasedPropertiesDeep<
  operations["get_mapped_task_instance"]["parameters"]["path"]
>;
export type PatchMappedTaskInstanceVariables = CamelCasedPropertiesDeep<
  operations["patch_mapped_task_instance"]["parameters"]["path"] &
    operations["patch_mapped_task_instance"]["requestBody"]["content"]["application/json"]
>;
export type GetMappedTaskInstancesVariables = CamelCasedPropertiesDeep<
  operations["get_mapped_task_instances"]["parameters"]["path"] &
    operations["get_mapped_task_instances"]["parameters"]["query"]
>;
export type GetTaskInstancesBatchVariables = CamelCasedPropertiesDeep<
  operations["get_task_instances_batch"]["requestBody"]["content"]["application/json"]
>;
export type GetVariablesVariables = CamelCasedPropertiesDeep<
  operations["get_variables"]["parameters"]["query"]
>;
export type PostVariablesVariables = CamelCasedPropertiesDeep<
  operations["post_variables"]["requestBody"]["content"]["application/json"]
>;
export type GetVariableVariables = CamelCasedPropertiesDeep<
  operations["get_variable"]["parameters"]["path"]
>;
export type DeleteVariableVariables = CamelCasedPropertiesDeep<
  operations["delete_variable"]["parameters"]["path"]
>;
export type PatchVariableVariables = CamelCasedPropertiesDeep<
  operations["patch_variable"]["parameters"]["path"] &
    operations["patch_variable"]["parameters"]["query"] &
    operations["patch_variable"]["requestBody"]["content"]["application/json"]
>;
export type GetXcomEntriesVariables = CamelCasedPropertiesDeep<
  operations["get_xcom_entries"]["parameters"]["path"] &
    operations["get_xcom_entries"]["parameters"]["query"]
>;
export type GetXcomEntryVariables = CamelCasedPropertiesDeep<
  operations["get_xcom_entry"]["parameters"]["path"] &
    operations["get_xcom_entry"]["parameters"]["query"]
>;
export type GetExtraLinksVariables = CamelCasedPropertiesDeep<
  operations["get_extra_links"]["parameters"]["path"]
>;
export type GetLogVariables = CamelCasedPropertiesDeep<
  operations["get_log"]["parameters"]["path"] &
    operations["get_log"]["parameters"]["query"]
>;
export type GetDagDetailsVariables = CamelCasedPropertiesDeep<
  operations["get_dag_details"]["parameters"]["path"]
>;
export type GetTasksVariables = CamelCasedPropertiesDeep<
  operations["get_tasks"]["parameters"]["path"] &
    operations["get_tasks"]["parameters"]["query"]
>;
export type GetTaskVariables = CamelCasedPropertiesDeep<
  operations["get_task"]["parameters"]["path"]
>;
export type GetDagSourceVariables = CamelCasedPropertiesDeep<
  operations["get_dag_source"]["parameters"]["path"]
>;
export type GetDagWarningsVariables = CamelCasedPropertiesDeep<
  operations["get_dag_warnings"]["parameters"]["query"]
>;
export type GetDatasetsVariables = CamelCasedPropertiesDeep<
  operations["get_datasets"]["parameters"]["query"]
>;
export type GetDatasetVariables = CamelCasedPropertiesDeep<
  operations["get_dataset"]["parameters"]["path"]
>;
export type GetDatasetEventsVariables = CamelCasedPropertiesDeep<
  operations["get_dataset_events"]["parameters"]["query"]
>;
export type GetPluginsVariables = CamelCasedPropertiesDeep<
  operations["get_plugins"]["parameters"]["query"]
>;
export type GetRolesVariables = CamelCasedPropertiesDeep<
  operations["get_roles"]["parameters"]["query"]
>;
export type PostRoleVariables = CamelCasedPropertiesDeep<
  operations["post_role"]["requestBody"]["content"]["application/json"]
>;
export type GetRoleVariables = CamelCasedPropertiesDeep<
  operations["get_role"]["parameters"]["path"]
>;
export type DeleteRoleVariables = CamelCasedPropertiesDeep<
  operations["delete_role"]["parameters"]["path"]
>;
export type PatchRoleVariables = CamelCasedPropertiesDeep<
  operations["patch_role"]["parameters"]["path"] &
    operations["patch_role"]["parameters"]["query"] &
    operations["patch_role"]["requestBody"]["content"]["application/json"]
>;
export type GetPermissionsVariables = CamelCasedPropertiesDeep<
  operations["get_permissions"]["parameters"]["query"]
>;
export type GetUsersVariables = CamelCasedPropertiesDeep<
  operations["get_users"]["parameters"]["query"]
>;
export type PostUserVariables = CamelCasedPropertiesDeep<
  operations["post_user"]["requestBody"]["content"]["application/json"]
>;
export type GetUserVariables = CamelCasedPropertiesDeep<
  operations["get_user"]["parameters"]["path"]
>;
export type DeleteUserVariables = CamelCasedPropertiesDeep<
  operations["delete_user"]["parameters"]["path"]
>;
export type PatchUserVariables = CamelCasedPropertiesDeep<
  operations["patch_user"]["parameters"]["path"] &
    operations["patch_user"]["parameters"]["query"] &
    operations["patch_user"]["requestBody"]["content"]["application/json"]
>;
