/*!
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import React from 'react';
import { createIcon } from '@chakra-ui/react';

const PipelineIcon = createIcon({
  displayName: 'PipelineIcon',
  viewBox: '0 0 24 24',
  path: [
    <path key="a" d="M3.4 3C3.24295 3 3 3.15775 3 3.5V6.5C3 6.84225 3.24295 7 3.4 7H14.6C14.7571 7 15 6.84225 15 6.5V3.5C15 3.15776 14.7571 3 14.6 3H3.4ZM1 3.5C1 2.18539 2.01065 1 3.4 1H14.6C15.9893 1 17 2.18539 17 3.5V6.5C17 7.81461 15.9893 9 14.6 9H3.4C2.01065 9 1 7.81461 1 6.5V3.5ZM9.4 17C9.24295 17 9 17.1578 9 17.5V20.5C9 20.8422 9.24295 21 9.4 21H20.6C20.7571 21 21 20.8422 21 20.5V17.5C21 17.1578 20.7571 17 20.6 17H9.4ZM7 17.5C7 16.1854 8.01065 15 9.4 15H20.6C21.9893 15 23 16.1854 23 17.5V20.5C23 21.8146 21.9893 23 20.6 23H9.4C8.01065 23 7 21.8146 7 20.5V17.5Z" fill="currentColor" />,
    <path key="b" d="M7.99999 11.019L7.99999 8H8.99999L8.99999 11.019C8.99999 11.2952 9.22385 11.519 9.49999 11.519L14 11.519C14.8284 11.519 15.5 12.1906 15.5 13.019L15.5 15.5H14.5L14.5 13.019C14.5 12.7429 14.2761 12.519 14 12.519L9.49999 12.519C8.67157 12.519 7.99999 11.8475 7.99999 11.019Z" fill="currentColor" />,
  ],
});

export default PipelineIcon;
