/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.route53.model.RRType;
import com.amazonaws.services.route53.model.ResourceRecordSet;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListResourceRecordSetsResult
implements Serializable {
    private ListWithAutoConstructFlag<ResourceRecordSet> resourceRecordSets;
    private Boolean isTruncated;
    private String nextRecordName;
    private String nextRecordType;
    private String nextRecordIdentifier;
    private String maxItems;

    public List<ResourceRecordSet> getResourceRecordSets() {
        if (this.resourceRecordSets == null) {
            this.resourceRecordSets = new ListWithAutoConstructFlag();
            this.resourceRecordSets.setAutoConstruct(true);
        }
        return this.resourceRecordSets;
    }

    public void setResourceRecordSets(Collection<ResourceRecordSet> resourceRecordSets) {
        if (resourceRecordSets == null) {
            this.resourceRecordSets = null;
            return;
        }
        ListWithAutoConstructFlag resourceRecordSetsCopy = new ListWithAutoConstructFlag(resourceRecordSets.size());
        resourceRecordSetsCopy.addAll(resourceRecordSets);
        this.resourceRecordSets = resourceRecordSetsCopy;
    }

    public ListResourceRecordSetsResult withResourceRecordSets(ResourceRecordSet ... resourceRecordSets) {
        if (this.getResourceRecordSets() == null) {
            this.setResourceRecordSets(new ArrayList<ResourceRecordSet>(resourceRecordSets.length));
        }
        for (ResourceRecordSet value : resourceRecordSets) {
            this.getResourceRecordSets().add(value);
        }
        return this;
    }

    public ListResourceRecordSetsResult withResourceRecordSets(Collection<ResourceRecordSet> resourceRecordSets) {
        if (resourceRecordSets == null) {
            this.resourceRecordSets = null;
        } else {
            ListWithAutoConstructFlag resourceRecordSetsCopy = new ListWithAutoConstructFlag(resourceRecordSets.size());
            resourceRecordSetsCopy.addAll(resourceRecordSets);
            this.resourceRecordSets = resourceRecordSetsCopy;
        }
        return this;
    }

    public Boolean isTruncated() {
        return this.isTruncated;
    }

    public void setIsTruncated(Boolean isTruncated) {
        this.isTruncated = isTruncated;
    }

    public ListResourceRecordSetsResult withIsTruncated(Boolean isTruncated) {
        this.isTruncated = isTruncated;
        return this;
    }

    public Boolean getIsTruncated() {
        return this.isTruncated;
    }

    public String getNextRecordName() {
        return this.nextRecordName;
    }

    public void setNextRecordName(String nextRecordName) {
        this.nextRecordName = nextRecordName;
    }

    public ListResourceRecordSetsResult withNextRecordName(String nextRecordName) {
        this.nextRecordName = nextRecordName;
        return this;
    }

    public String getNextRecordType() {
        return this.nextRecordType;
    }

    public void setNextRecordType(String nextRecordType) {
        this.nextRecordType = nextRecordType;
    }

    public ListResourceRecordSetsResult withNextRecordType(String nextRecordType) {
        this.nextRecordType = nextRecordType;
        return this;
    }

    public void setNextRecordType(RRType nextRecordType) {
        this.nextRecordType = nextRecordType.toString();
    }

    public ListResourceRecordSetsResult withNextRecordType(RRType nextRecordType) {
        this.nextRecordType = nextRecordType.toString();
        return this;
    }

    public String getNextRecordIdentifier() {
        return this.nextRecordIdentifier;
    }

    public void setNextRecordIdentifier(String nextRecordIdentifier) {
        this.nextRecordIdentifier = nextRecordIdentifier;
    }

    public ListResourceRecordSetsResult withNextRecordIdentifier(String nextRecordIdentifier) {
        this.nextRecordIdentifier = nextRecordIdentifier;
        return this;
    }

    public String getMaxItems() {
        return this.maxItems;
    }

    public void setMaxItems(String maxItems) {
        this.maxItems = maxItems;
    }

    public ListResourceRecordSetsResult withMaxItems(String maxItems) {
        this.maxItems = maxItems;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getResourceRecordSets() != null) {
            sb.append("ResourceRecordSets: " + this.getResourceRecordSets() + ",");
        }
        if (this.isTruncated() != null) {
            sb.append("IsTruncated: " + this.isTruncated() + ",");
        }
        if (this.getNextRecordName() != null) {
            sb.append("NextRecordName: " + this.getNextRecordName() + ",");
        }
        if (this.getNextRecordType() != null) {
            sb.append("NextRecordType: " + this.getNextRecordType() + ",");
        }
        if (this.getNextRecordIdentifier() != null) {
            sb.append("NextRecordIdentifier: " + this.getNextRecordIdentifier() + ",");
        }
        if (this.getMaxItems() != null) {
            sb.append("MaxItems: " + this.getMaxItems());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getResourceRecordSets() == null ? 0 : this.getResourceRecordSets().hashCode());
        hashCode = 31 * hashCode + (this.isTruncated() == null ? 0 : this.isTruncated().hashCode());
        hashCode = 31 * hashCode + (this.getNextRecordName() == null ? 0 : this.getNextRecordName().hashCode());
        hashCode = 31 * hashCode + (this.getNextRecordType() == null ? 0 : this.getNextRecordType().hashCode());
        hashCode = 31 * hashCode + (this.getNextRecordIdentifier() == null ? 0 : this.getNextRecordIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getMaxItems() == null ? 0 : this.getMaxItems().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResourceRecordSetsResult)) {
            return false;
        }
        ListResourceRecordSetsResult other = (ListResourceRecordSetsResult)obj;
        if (other.getResourceRecordSets() == null ^ this.getResourceRecordSets() == null) {
            return false;
        }
        if (other.getResourceRecordSets() != null && !other.getResourceRecordSets().equals(this.getResourceRecordSets())) {
            return false;
        }
        if (other.isTruncated() == null ^ this.isTruncated() == null) {
            return false;
        }
        if (other.isTruncated() != null && !other.isTruncated().equals(this.isTruncated())) {
            return false;
        }
        if (other.getNextRecordName() == null ^ this.getNextRecordName() == null) {
            return false;
        }
        if (other.getNextRecordName() != null && !other.getNextRecordName().equals(this.getNextRecordName())) {
            return false;
        }
        if (other.getNextRecordType() == null ^ this.getNextRecordType() == null) {
            return false;
        }
        if (other.getNextRecordType() != null && !other.getNextRecordType().equals(this.getNextRecordType())) {
            return false;
        }
        if (other.getNextRecordIdentifier() == null ^ this.getNextRecordIdentifier() == null) {
            return false;
        }
        if (other.getNextRecordIdentifier() != null && !other.getNextRecordIdentifier().equals(this.getNextRecordIdentifier())) {
            return false;
        }
        if (other.getMaxItems() == null ^ this.getMaxItems() == null) {
            return false;
        }
        return other.getMaxItems() == null || other.getMaxItems().equals(this.getMaxItems());
    }
}

