/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.multitenancy;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.dispatchers.RequestURIBasedDispatcher;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.transport.RequestResponseTransport;
import org.apache.axis2.transport.TransportSender;
import org.apache.axis2.transport.http.AxisServlet;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.axis2.transport.http.ServletBasedOutTransportInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.core.multitenancy.transports.DummyTransportSender;
import org.wso2.carbon.utils.deployment.GhostDeployerUtils;

public class MultitenantRESTServlet
extends AxisServlet {
    private static final Log log = LogFactory.getLog(MultitenantRESTServlet.class);
    private String requestUri;
    private MessageContext inMessageContext;
    private String tenantDomain;

    public MultitenantRESTServlet(ConfigurationContext configCtx, String requestUri, String tenantDomain) {
        this.configContext = configCtx;
        this.axisConfiguration = configCtx.getAxisConfiguration();
        this.requestUri = requestUri;
        this.tenantDomain = tenantDomain;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        new CarbonRestRequestProcessor("GET", request, response).processURLRequest();
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        new AxisServlet.RestRequestProcessor((AxisServlet)this, "POST", request, response).processXMLRequest();
    }

    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        new AxisServlet.RestRequestProcessor((AxisServlet)this, "DELETE", request, response).processURLRequest();
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        new AxisServlet.RestRequestProcessor((AxisServlet)this, "PUT", request, response).processXMLRequest();
    }

    protected MessageContext createMessageContext(HttpServletRequest request, HttpServletResponse response, boolean isSoapRequest) throws IOException {
        String trsPrefix;
        this.inMessageContext = this.configContext.createMessageContext();
        try {
            trsPrefix = request.getRequestURL().toString();
        }
        catch (Throwable t) {
            log.info((Object)"Old Servlet API (Fallback to HttpServletRequest.getRequestURI) :", t);
            trsPrefix = request.getRequestURI();
        }
        int sepindex = trsPrefix.indexOf(58);
        if (sepindex > -1) {
            trsPrefix = trsPrefix.substring(0, sepindex);
            this.inMessageContext.setIncomingTransportName(trsPrefix);
        } else {
            this.inMessageContext.setIncomingTransportName("http");
        }
        TransportInDescription transportIn = this.axisConfiguration.getTransportIn(this.inMessageContext.getIncomingTransportName());
        TransportOutDescription transportOut = new TransportOutDescription("local");
        transportOut.setSender((TransportSender)new DummyTransportSender());
        this.inMessageContext.setTransportIn(transportIn);
        this.inMessageContext.setTransportOut(transportOut);
        this.inMessageContext.setServerSide(true);
        this.inMessageContext.setTo(new EndpointReference(this.requestUri));
        this.inMessageContext.setFrom(new EndpointReference(request.getRemoteAddr()));
        this.inMessageContext.setProperty("REMOTE_ADDR", (Object)request.getRemoteAddr());
        this.inMessageContext.setProperty("OutTransportInfo", (Object)new ServletBasedOutTransportInfo(response));
        this.inMessageContext.setProperty("TRANSPORT_HEADERS", (Object)this.getTransportHeaders(request));
        this.inMessageContext.setProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST, (Object)request);
        this.inMessageContext.setProperty(HTTPConstants.MC_HTTP_SERVLETRESPONSE, (Object)response);
        this.inMessageContext.setProperty("RequestResponseTransportControl", (Object)new ServletRequestResponseTransport());
        PrivilegedCarbonContext.getCurrentContext((MessageContext)this.inMessageContext).setTenantDomain(this.tenantDomain, true);
        return this.inMessageContext;
    }

    public MessageContext getOutMessageContext() throws AxisFault {
        OperationContext opCtx = this.inMessageContext.getOperationContext();
        if (opCtx != null) {
            return opCtx.getMessageContext("Out");
        }
        return null;
    }

    public MessageContext getOutFaultMessageContext() throws AxisFault {
        OperationContext opCtx = this.inMessageContext.getOperationContext();
        if (opCtx != null) {
            return opCtx.getMessageContext("Fault");
        }
        return null;
    }

    protected class CarbonRestRequestProcessor
    extends AxisServlet.RestRequestProcessor {
        public CarbonRestRequestProcessor(String httpMethodString, HttpServletRequest request, HttpServletResponse response) throws IOException {
            super((AxisServlet)MultitenantRESTServlet.this, httpMethodString, request, response);
        }

        public void processURLRequest() throws IOException, ServletException {
            RequestURIBasedDispatcher requestDispatcher = new RequestURIBasedDispatcher();
            requestDispatcher.invoke(this.messageContext);
            AxisService axisService = this.messageContext.getAxisService();
            if (GhostDeployerUtils.isGhostService((AxisService)axisService)) {
                axisService = GhostDeployerUtils.deployActualService((AxisConfiguration)MultitenantRESTServlet.this.configContext.getAxisConfiguration(), (AxisService)axisService);
                this.messageContext.setAxisService(axisService);
            }
            super.processURLRequest();
        }
    }

    protected static class ServletRequestResponseTransport
    implements RequestResponseTransport {
        private boolean responseWritten = false;
        private CountDownLatch responseReadySignal = new CountDownLatch(1);
        private RequestResponseTransport.RequestResponseTransportStatus status = RequestResponseTransport.RequestResponseTransportStatus.WAITING;
        AxisFault faultToBeThrownOut = null;

        ServletRequestResponseTransport() {
        }

        public void acknowledgeMessage(MessageContext msgContext) throws AxisFault {
            this.status = RequestResponseTransport.RequestResponseTransportStatus.ACKED;
            this.responseReadySignal.countDown();
        }

        public void awaitResponse() throws InterruptedException, AxisFault {
            log.debug((Object)"Blocking servlet thread -- awaiting response");
            this.responseReadySignal.await();
            if (this.faultToBeThrownOut != null) {
                throw this.faultToBeThrownOut;
            }
        }

        public void signalResponseReady() {
            log.debug((Object)"Signalling response available");
            this.status = RequestResponseTransport.RequestResponseTransportStatus.SIGNALLED;
            this.responseReadySignal.countDown();
        }

        public RequestResponseTransport.RequestResponseTransportStatus getStatus() {
            return this.status;
        }

        public void signalFaultReady(AxisFault fault) {
            this.faultToBeThrownOut = fault;
            this.signalResponseReady();
        }

        public boolean isResponseWritten() {
            return this.responseWritten;
        }

        public void setResponseWritten(boolean responseWritten) {
            this.responseWritten = responseWritten;
        }
    }
}

