/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.uftp.server;

import eu.unicore.uftp.server.FileAccess;
import eu.unicore.uftp.server.ServerThread;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import org.apache.log4j.Logger;

public class DefaultFileAccess
implements FileAccess {
    private static final Logger logger = Logger.getLogger(ServerThread.class);

    @Override
    public InputStream readFile(String canonicalPath, String userID, String groupID, int size) throws Exception {
        return new BufferedInputStream(new FileInputStream(new File(canonicalPath)), size);
    }

    @Override
    public void setUser(String canonicalPath, String user, String group) throws Exception {
        String chown = group != null && !"null".equals(group) ? "chown " + user + ":" + group + " " + canonicalPath : "chown " + user + " " + canonicalPath;
        Process p2 = Runtime.getRuntime().exec(chown);
        int exit = p2.waitFor();
        logger.info("Executed " + chown + " exit code=" + exit);
    }

    @Override
    public OutputStream writeFile(String canonicalPath, boolean append, String userID, String groupID, int size) throws Exception {
        return new BufferedOutputStream(new FileOutputStream(new File(canonicalPath), append), size);
    }

    @Override
    public RandomAccessFile getRandomAccessFile(File file, String userID, String groupID, String mode) throws IOException {
        return new RandomAccessFile(file, mode);
    }

    @Override
    public void mkdir(String canonicalPath, String user, String group) throws Exception {
        new File(canonicalPath).mkdir();
        this.setUser(canonicalPath, user, group);
    }

    @Override
    public void rm(String canonicalPath, String user, String group) throws Exception {
        new File(canonicalPath).delete();
        this.setUser(canonicalPath, user, group);
    }
}

