/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.common.utils;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public class StringUtil {
    public static final String DELIMETER = ",";
    public static final String QUOTE = "\"";
    private static final String ARG_DOT_REPLACE = "dot_replacement_value";

    public static Map<Integer, String> getContainedParameters(String s) {
        HashMap<Integer, String> parameterMap = new HashMap<Integer, String>();
        int i = 0;
        for (i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != '$' || i + 1 >= s.length() || s.charAt(i + 1) != '{') continue;
            int i2 = s.indexOf(123, i + 2);
            int e = s.indexOf(125, i + 2);
            if (e == -1 || i2 != -1 && e >= i2) continue;
            parameterMap.put(i, s.substring(i, e + 1));
            i = e;
        }
        return parameterMap;
    }

    public static List<String> getURLS(String text) {
        ArrayList<String> links = new ArrayList<String>();
        String regex = "\\(?\\b((http|https|ftp)://|www[.])[-A-Za-z0-9+&@#/%?=~_()|!:,.;]*[-A-Za-z0-9+&@#/%=~_()|]";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(text);
        while (m.find()) {
            String urlStr = m.group();
            if (urlStr.startsWith("(") && urlStr.endsWith(")")) {
                urlStr = urlStr.substring(1, urlStr.length() - 1);
            }
            if (links.contains(urlStr)) continue;
            links.add(urlStr);
        }
        return links;
    }

    public static String createHTMLUrlTaggedString2(String value, List<String> pullLinks) {
        for (String url : pullLinks) {
            String hyperlinkString = "<a href='" + url + "'>" + url + "</a>";
            value = value.replaceAll(Pattern.quote(url), hyperlinkString);
        }
        return value;
    }

    public static String createHTMLUrlTaggedString(String value) {
        String urledString = "";
        int lastIndex = 0;
        int index = 0;
        while (index != -1) {
            index = value.toLowerCase().indexOf("://", lastIndex);
            if (index == -1) continue;
            int beginIndex = value.lastIndexOf(" ", index);
            urledString = urledString + value.substring(lastIndex, beginIndex + 1);
            int endIndex = value.indexOf(" ", index);
            beginIndex = beginIndex == -1 ? 0 : ++beginIndex;
            if (endIndex == -1) {
                endIndex = value.length();
            }
            String url = value.substring(beginIndex, endIndex);
            urledString = urledString + "<a href='" + url + "'>" + url + "</a>";
            lastIndex = endIndex;
        }
        urledString = urledString + value.substring(lastIndex, value.length());
        return urledString;
    }

    private static boolean isQuoted(String s, String delimiter) {
        if (s.contains(delimiter)) {
            return (s = s.replaceAll("\"\"", "")).substring(0, 1).equals(QUOTE) && s.subSequence(s.length() - 1, s.length()).equals(QUOTE);
        }
        return true;
    }

    private static boolean isQuoted(String s) {
        return StringUtil.isQuoted(s, DELIMETER);
    }

    public static String createDelimiteredString(String[] list) {
        return StringUtil.createDelimiteredString(list, DELIMETER);
    }

    public static String createDelimiteredString(String[] list, String delimiter) {
        String s = null;
        for (String ss : list) {
            ss = StringUtil.quoteString(ss, delimiter);
            s = s == null ? ss : s + delimiter + ss;
        }
        return s;
    }

    public static String quoteString(String s) {
        return StringUtil.quoteString(s, DELIMETER);
    }

    public static String quoteString(String s, String delimiter) {
        if (StringUtil.isQuoted(s, delimiter)) {
            return s;
        }
        return QUOTE + s.replaceAll(QUOTE, "\"\"") + QUOTE;
    }

    public static String[] getElementsFromString(String s, String delimeter, String quote) {
        ArrayList<String> list = new ArrayList<String>();
        String currentItem = "";
        String previousChar = null;
        boolean insideQuote = false;
        for (int i = 0; i < s.length(); ++i) {
            String c = s.substring(i, i + 1);
            if (c.equals(delimeter)) {
                if (insideQuote) {
                    currentItem = currentItem + c;
                } else {
                    list.add(currentItem);
                    currentItem = "";
                }
            } else if (c.equals(quote)) {
                if (quote.equals(previousChar)) {
                    currentItem = currentItem + quote;
                    insideQuote = !insideQuote;
                } else {
                    insideQuote = !insideQuote;
                }
            } else {
                currentItem = currentItem + c;
            }
            previousChar = c;
        }
        list.add(currentItem);
        return list.toArray(new String[0]);
    }

    public static String[] getElementsFromString(String s) {
        return StringUtil.getElementsFromString(s, DELIMETER, QUOTE);
    }

    public static String toString(Object object) {
        if (object == null) {
            return "";
        }
        return object.toString();
    }

    public static String trimAndNullify(String string) {
        if (string != null && (string = string.trim()).equals("")) {
            string = null;
        }
        return string;
    }

    public static String trimSpaceInString(String oldName) {
        if (oldName == null) {
            return "";
        }
        return oldName.replace(" ", "");
    }

    public static String convertToJavaIdentifier(String name) {
        int REPLACE_CHAR = 95;
        if (name == null || name.length() == 0) {
            return "_";
        }
        StringBuilder buf = new StringBuilder();
        char c = name.charAt(0);
        if (!Character.isJavaIdentifierStart(c)) {
            buf.append('_');
        }
        for (int i = 0; i < name.length(); ++i) {
            c = name.charAt(i);
            if (Character.isJavaIdentifierPart(c)) {
                buf.append(c);
                continue;
            }
            buf.append('_');
        }
        return buf.toString();
    }

    public static String incrementName(String oldName) {
        String newName;
        int PREFIX = 95;
        if (oldName == null || oldName.length() == 0) {
            newName = "noName";
        } else {
            int lastDashIndex = oldName.lastIndexOf(95);
            if (lastDashIndex < 0) {
                newName = oldName + '_' + 2;
            } else {
                String suffix = oldName.substring(lastDashIndex + 1);
                try {
                    int number = Integer.parseInt(suffix);
                    int newNumber = number + 1;
                    newName = oldName.substring(0, lastDashIndex + 1) + newNumber;
                }
                catch (RuntimeException e) {
                    newName = oldName + '_' + 2;
                }
            }
        }
        return newName;
    }

    public static String getClassName(Class klass) {
        String fullName = klass.getName();
        int index = fullName.lastIndexOf(".");
        if (index < 0) {
            return fullName;
        }
        return fullName.substring(index + 1);
    }

    public static String getStackTraceInString(Throwable throwable) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        throwable.printStackTrace(printStream);
        printStream.flush();
        return byteArrayOutputStream.toString();
    }

    private static Options deriveCommandLineOptions(String[] args) {
        Options options = new Options();
        String[] argCopy = StringUtil.getChangedList(args);
        int i = 0;
        for (String arg : argCopy) {
            if (arg.startsWith("--")) {
                String opt;
                arg = arg.substring(2);
                int pos = arg.indexOf(61);
                boolean hasArgs = true;
                if (pos == -1) {
                    if (i == argCopy.length - 1 || argCopy[i + 1].startsWith("-")) {
                        hasArgs = false;
                    }
                    opt = arg;
                } else {
                    opt = arg.substring(0, pos);
                }
                options.addOption(opt, hasArgs, "");
            }
            ++i;
        }
        return options;
    }

    public static Map<String, String> parseCommandLineOptions(String[] args) {
        HashMap<String, String> commandLineOptions = new HashMap<String, String>();
        try {
            CommandLineParameters cmdParameters = StringUtil.getCommandLineParser(args);
            Map<String, String> parameters = cmdParameters.getParameters();
            for (String s : parameters.keySet()) {
                commandLineOptions.put(s, parameters.get(s) == null ? "" : parameters.get(s));
            }
        }
        catch (ParseException e1) {
            e1.printStackTrace();
        }
        return commandLineOptions;
    }

    public static CommandLineParameters getCommandLineParser(String[] args) throws ParseException {
        String[] argCopy = StringUtil.getChangedList(args);
        DynamicOptionPosixParser parser = new DynamicOptionPosixParser();
        CommandLine cmdLine = parser.parse(StringUtil.deriveCommandLineOptions(argCopy), argCopy);
        return new CommandLineParameters(cmdLine);
    }

    private static String[] getChangedList(String[] args) {
        String[] argCopy = Arrays.asList(args).toArray(new String[0]);
        for (int i = 0; i < argCopy.length; ++i) {
            argCopy[i] = StringUtil.changeOption(argCopy[i]);
        }
        return argCopy;
    }

    private static String revertOption(String option) {
        return option == null ? option : option.replaceAll(Pattern.quote(ARG_DOT_REPLACE), ".");
    }

    private static String changeOption(String option) {
        return option == null ? option : option.replaceAll(Pattern.quote("."), ARG_DOT_REPLACE);
    }

    public static class CommandLineParameters {
        private Map<String, String> parameters = new HashMap<String, String>();
        private List<String> arguments = new ArrayList<String>();

        protected CommandLineParameters(CommandLine cmd) {
            for (Option option : cmd.getOptions()) {
                this.parameters.put(StringUtil.revertOption(option.getOpt()), StringUtil.revertOption(option.getValue()));
            }
            for (String string : cmd.getArgs()) {
                this.arguments.add(StringUtil.revertOption(string));
            }
        }

        public List<String> getArguments() {
            return this.arguments;
        }

        public void setArguments(List<String> arguments) {
            this.arguments = arguments;
        }

        public Map<String, String> getParameters() {
            return this.parameters;
        }

        public void setParameters(Map<String, String> parameters) {
            this.parameters = parameters;
        }
    }

    private static class DynamicOptionPosixParser
    extends PosixParser {
        private DynamicOptionPosixParser() {
        }

        protected void processOption(String arg0, ListIterator arg1) throws ParseException {
            if (this.getOptions().hasOption(arg0)) {
                super.processOption(arg0, arg1);
            }
        }
    }
}

