/*
 * Decompiled with CFR 0.152.
 */
package org.globus.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;

public class GlobusResource {
    private File resourceFile = null;
    private String resourcePath = null;

    public GlobusResource(String resourcePath) {
        this.resourcePath = resourcePath;
        this.resourceFile = new File(resourcePath);
    }

    public String toURI() {
        return this.resourceFile.toURI().toASCIIString();
    }

    public String toURL() throws MalformedURLException {
        String fileURLPathString = null;
        fileURLPathString = this.resourceFile.toURI().toURL().toString();
        return fileURLPathString;
    }

    public URI getURI() throws IOException {
        return this.resourceFile.toURI();
    }

    public URL getURL() throws MalformedURLException {
        return this.resourceFile.toURI().toURL();
    }

    public File getFile() throws IOException {
        File duplicateFile = new File(this.resourceFile.getAbsolutePath());
        return duplicateFile;
    }

    public boolean exists() {
        return this.resourceFile.exists();
    }

    public long lastModified() throws IOException {
        return this.resourceFile.lastModified();
    }

    public boolean isReadable() {
        return this.resourceFile.canRead();
    }

    public InputStream getInputStream() throws FileNotFoundException, IOException {
        FileInputStream fileInputStream = new FileInputStream(this.getFile());
        return fileInputStream;
    }

    public String getFilename() {
        return this.resourcePath.substring(this.resourcePath.lastIndexOf("/") + 1, this.resourcePath.length());
    }

    public String toString() {
        return String.format("resourcePath: %s\nURI: %s\n", this.resourcePath, this.toURI());
    }
}

