/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import net.sf.saxon.event.LocationProvider;
import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.ErrorExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.PackageData;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.instruct.AttributeSet;
import net.sf.saxon.expr.instruct.Block;
import net.sf.saxon.expr.instruct.SavedNamespaceContext;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.instruct.TraceExpression;
import net.sf.saxon.expr.instruct.ValueOf;
import net.sf.saxon.expr.instruct.WithParam;
import net.sf.saxon.expr.parser.CodeInjector;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionLocation;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.XPathParser;
import net.sf.saxon.expr.sort.SortKeyDefinition;
import net.sf.saxon.functions.Current;
import net.sf.saxon.lib.NamespaceConstant;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.lib.Validation;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NamespaceException;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StandardNames;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTestPattern;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.pattern.PatternThatSetsCurrent;
import net.sf.saxon.pattern.PatternWithPredicate;
import net.sf.saxon.style.AbsentExtensionElement;
import net.sf.saxon.style.AttributeValueTemplate;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.ExpressionContext;
import net.sf.saxon.style.LiteralResultElement;
import net.sf.saxon.style.SourceBinding;
import net.sf.saxon.style.StylesheetComponent;
import net.sf.saxon.style.StylesheetPackage;
import net.sf.saxon.style.XSLAttributeSet;
import net.sf.saxon.style.XSLFallback;
import net.sf.saxon.style.XSLGeneralVariable;
import net.sf.saxon.style.XSLLocalParam;
import net.sf.saxon.style.XSLLocalVariable;
import net.sf.saxon.style.XSLModuleRoot;
import net.sf.saxon.style.XSLSort;
import net.sf.saxon.style.XSLSortOrMergeKey;
import net.sf.saxon.style.XSLStylesheet;
import net.sf.saxon.style.XSLWithParam;
import net.sf.saxon.trace.InstructionInfo;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.Visibility;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.linked.ElementImpl;
import net.sf.saxon.tree.linked.NodeImpl;
import net.sf.saxon.tree.linked.TextImpl;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.tree.util.NamespaceIterator;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.BuiltInType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Whitespace;
import org.xml.sax.Locator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StyleElement
extends ElementImpl
implements Locator,
Container,
InstructionInfo {
    protected String[] extensionNamespaces = null;
    private String[] excludedNamespaces = null;
    protected DecimalValue version = null;
    protected ExpressionContext staticContext = null;
    protected XPathException validationError = null;
    protected int reportingCircumstances = 1;
    protected String defaultXPathNamespace = null;
    protected String defaultCollationName = null;
    protected boolean expandText = false;
    private boolean explaining = false;
    private StructuredQName objectName;
    private Compilation compilation;
    public static final int REPORT_ALWAYS = 1;
    public static final int REPORT_UNLESS_FORWARDS_COMPATIBLE = 2;
    public static final int REPORT_IF_INSTANTIATED = 3;
    public static final int REPORT_UNLESS_FALLBACK_AVAILABLE = 4;
    protected int actionsCompleted = 0;
    public static final int ACTION_VALIDATE = 1;
    public static final int ACTION_COMPILE = 2;
    public static final int ACTION_TYPECHECK = 4;
    public static final int ACTION_OPTIMIZE = 8;
    public static final int ACTION_FIXUP = 16;
    public static final int ACTION_PROCESS_ATTRIBUTES = 32;
    protected static final String[] YES_NO = new String[]{"0", "1", "false", "no", "true", "yes"};

    public Compilation getCompilation() {
        return this.compilation;
    }

    public void setCompilation(Compilation compilation) {
        this.compilation = compilation;
    }

    @Override
    public PackageData getPackageData() {
        return this.compilation.getPackageData();
    }

    public LocationProvider getLocationProvider() {
        return this.getCompilation().getLocationMap();
    }

    public StaticContext getStaticContext() {
        if (this.staticContext == null) {
            this.staticContext = new ExpressionContext(this);
        }
        return this.staticContext;
    }

    @Override
    public int getContainerGranularity() {
        return 1;
    }

    public ExpressionVisitor makeExpressionVisitor() {
        return ExpressionVisitor.make(this.getStaticContext());
    }

    public boolean isSchemaAware() {
        return this.getCompilation().isSchemaAware();
    }

    protected boolean isExplaining() {
        return this.explaining;
    }

    public void substituteFor(StyleElement temp) {
        this.setRawParent(temp.getRawParent());
        this.setAttributeList(temp.getAttributeList());
        this.setNamespaceList(temp.getNamespaceList());
        this.setNameCode(temp.getNameCode());
        this.setRawSequenceNumber(temp.getRawSequenceNumber());
        this.extensionNamespaces = temp.extensionNamespaces;
        this.excludedNamespaces = temp.excludedNamespaces;
        this.version = temp.version;
        this.staticContext = temp.staticContext;
        this.validationError = temp.validationError;
        this.reportingCircumstances = temp.reportingCircumstances;
        this.compilation = temp.compilation;
    }

    public void setValidationError(TransformerException reason, int circumstances) {
        this.validationError = XPathException.makeXPathException(reason);
        this.reportingCircumstances = circumstances;
    }

    public boolean isInstruction() {
        return false;
    }

    public boolean isDeclaration() {
        return false;
    }

    public Visibility getVisibility() throws XPathException {
        String vis = this.getAttributeValue("visibility");
        if (vis == null) {
            return Visibility.PRIVATE;
        }
        return this.getVisibilityValue(vis, "");
    }

    protected ItemType getReturnedItemType() {
        return AnyItemType.getInstance();
    }

    protected ItemType getCommonChildItemType() {
        NodeInfo next;
        TypeHierarchy th = this.getConfiguration().getTypeHierarchy();
        ItemType t = ErrorType.getInstance();
        AxisIterator children = this.iterateAxis((byte)3);
        while ((next = children.next()) != null) {
            if (next instanceof StyleElement) {
                ItemType ret = ((StyleElement)next).getReturnedItemType();
                if (ret != null) {
                    t = Type.getCommonSuperType(t, ret, th);
                }
            } else {
                t = Type.getCommonSuperType(t, NodeKindTest.TEXT, th);
            }
            if (t != AnyItemType.getInstance()) continue;
            return t;
        }
        return t;
    }

    protected boolean markTailCalls() {
        return false;
    }

    protected boolean mayContainSequenceConstructor() {
        return false;
    }

    protected boolean mayContainFallback() {
        return this.mayContainSequenceConstructor();
    }

    protected boolean mayContainParam(String attName) {
        return false;
    }

    public XSLModuleRoot getContainingStylesheet() {
        NodeImpl parent = this.getParent();
        if (parent instanceof XSLModuleRoot) {
            return (XSLModuleRoot)parent;
        }
        if (parent instanceof StyleElement) {
            return ((StyleElement)parent).getContainingStylesheet();
        }
        return null;
    }

    public int getDefaultValidation() {
        XSLModuleRoot stylesheet = this.getContainingStylesheet();
        if (stylesheet != null) {
            return stylesheet.getDefaultValidation();
        }
        return 4;
    }

    public final StructuredQName makeQName(String lexicalQName) throws XPathException, NamespaceException {
        StructuredQName qName;
        try {
            qName = StructuredQName.fromLexicalQName(lexicalQName, false, this.isXslt30Processor(), this);
        }
        catch (XPathException e) {
            e.setIsStaticError(true);
            String code = e.getErrorCodeLocalPart();
            if ("FONS0004".equals(code)) {
                e.setErrorCode("XTSE0280");
            } else if ("FOCA0002".equals(code)) {
                e.setErrorCode("XTSE0020");
            } else if (code == null) {
                e.setErrorCode("XTSE0020");
            }
            e.setLocator(this);
            throw e;
        }
        if (NamespaceConstant.isReserved(qName.getURI())) {
            XPathException err = new XPathException("Namespace prefix " + qName.getPrefix() + " refers to a reserved namespace");
            err.setIsStaticError(true);
            err.setErrorCode("XTSE0080");
            throw err;
        }
        return qName;
    }

    public SavedNamespaceContext makeNamespaceContext() {
        return new SavedNamespaceContext(NamespaceIterator.iterateNamespaces(this));
    }

    public NamespaceResolver getNamespaceResolver() {
        return this;
    }

    public void processAllAttributes() throws XPathException {
        NodeInfo child;
        this.processDefaultCollationAttribute();
        this.staticContext = new ExpressionContext(this);
        this.processAttributes();
        AxisIterator kids = this.iterateAxis((byte)3);
        while ((child = kids.next()) != null) {
            if (!(child instanceof StyleElement)) continue;
            ((StyleElement)child).processAllAttributes();
            if (!((StyleElement)child).explaining) continue;
            this.explaining = true;
        }
    }

    public void processStandardAttributes(String namespace) throws XPathException {
        this.processExtensionElementAttribute(namespace);
        this.processExcludedNamespaces(namespace);
        this.processVersionAttribute(namespace);
        this.processDefaultXPathNamespaceAttribute(namespace);
        this.processExpandTextAttribute(namespace);
    }

    public String getAttributeValue(String clarkName) {
        FingerprintedQName nn = FingerprintedQName.fromClarkName(clarkName);
        return this.getAttributeValue(nn.getURI(), nn.getLocalPart());
    }

    protected final void processAttributes() throws XPathException {
        try {
            this.prepareAttributes();
        }
        catch (XPathException err) {
            this.compileError(err);
        }
    }

    protected void checkUnknownAttribute(NodeName nc) throws XPathException {
        String attributeURI = nc.getURI();
        String elementURI = this.getURI();
        String clarkName = nc.getStructuredQName().getClarkName();
        if (clarkName.equals("{http://saxon.sf.net/}explain")) {
            String value = this.getAttributeValue(clarkName);
            this.explaining = this.processBooleanAttribute("saxon:explain", value);
        }
        if (this.forwardsCompatibleModeIsEnabled()) {
            return;
        }
        if (this.isInstruction() && attributeURI.equals("http://www.w3.org/1999/XSL/Transform") && !elementURI.equals("http://www.w3.org/1999/XSL/Transform") && (clarkName.endsWith("}default-collation") || clarkName.endsWith("}xpath-default-namespace") || clarkName.endsWith("}expand-text") || clarkName.endsWith("}extension-element-prefixes") || clarkName.endsWith("}exclude-result-prefixes") || clarkName.endsWith("}version") || clarkName.endsWith("}use-when"))) {
            return;
        }
        if (elementURI.equals("http://www.w3.org/1999/XSL/Transform") && (clarkName.equals("default-collation") || clarkName.equals("expand-text") || clarkName.equals("xpath-default-namespace") || clarkName.equals("extension-element-prefixes") || clarkName.equals("exclude-result-prefixes") || clarkName.equals("version") || clarkName.equals("use-when") || clarkName.equals("static"))) {
            return;
        }
        if ("".equals(attributeURI) || "http://www.w3.org/1999/XSL/Transform".equals(attributeURI)) {
            this.compileError("Attribute " + Err.wrap(nc.getDisplayName(), 2) + " is not allowed on element " + Err.wrap(this.getDisplayName(), 1), "XTSE0090");
        }
    }

    protected abstract void prepareAttributes() throws XPathException;

    protected StyleElement getLastChildInstruction() {
        NodeInfo child;
        StyleElement last = null;
        AxisIterator kids = this.iterateAxis((byte)3);
        while ((child = kids.next()) != null) {
            if (child instanceof StyleElement) {
                last = (StyleElement)child;
                continue;
            }
            last = null;
        }
        return last;
    }

    public Expression makeExpression(String expression) throws XPathException {
        try {
            return ExpressionTool.make(expression, this.staticContext, this, 0, 0, this.getLineNumber(), this.getCompilation().getCompilerInfo().getCodeInjector());
        }
        catch (XPathException err) {
            err.setLocator(this);
            if (err.isReportableStatically()) {
                this.compileError(err);
            }
            ErrorExpression erexp = new ErrorExpression(err);
            erexp.setLocationId(this.allocateLocationId(this.getSystemId(), this.getLineNumber()));
            erexp.setContainer(this);
            return erexp;
        }
    }

    public Pattern makePattern(String pattern) throws XPathException {
        try {
            return Pattern.make(pattern, this.getStaticContext(), this.getCompilation().getPackageData());
        }
        catch (XPathException err) {
            if ("XPST0003".equals(err.getErrorCodeLocalPart())) {
                err.setErrorCode("XTSE0340");
            }
            this.compileError(err);
            NodeTestPattern nsp = new NodeTestPattern(AnyNodeTest.getInstance());
            nsp.setPackageData(this.getCompilation().getPackageData());
            return nsp;
        }
    }

    protected Expression makeAttributeValueTemplate(String expression) throws XPathException {
        try {
            return AttributeValueTemplate.make(expression, this.getLineNumber(), this.staticContext, this);
        }
        catch (XPathException err) {
            this.compileError(err);
            return new StringLiteral(expression, (Container)this);
        }
    }

    protected void checkAttributeValue(String name, String value, boolean avt, String[] allowed) throws XPathException {
        if (avt && value.contains("{")) {
            return;
        }
        if (Arrays.binarySearch(allowed, value) < 0) {
            FastStringBuffer sb = new FastStringBuffer(64);
            sb.append("Invalid value for ");
            sb.append("@");
            sb.append(name);
            sb.append(". Value must be one of (");
            for (int i = 0; i < allowed.length; ++i) {
                sb.append(i == 0 ? "" : "|");
                sb.append(allowed[i]);
            }
            sb.append(")");
            this.compileError(sb.toString(), "XTSE0020");
        }
    }

    public boolean processBooleanAttribute(String name, String value) throws XPathException {
        String s = Whitespace.trim(value);
        if (this.isXslt30Processor()) {
            if ("yes".equals(s) || "true".equals(s) || "1".equals(s)) {
                return true;
            }
            if ("no".equals(s) || "false".equals(s) || "0".equals(s)) {
                return false;
            }
            this.invalidAttribute(name, "yes|no|true|false|1|0");
            return false;
        }
        if ("yes".equals(s)) {
            return true;
        }
        if ("no".equals(s)) {
            return false;
        }
        this.invalidAttribute(name, "yes|no");
        return false;
    }

    public SequenceType makeSequenceType(String sequenceType) throws XPathException {
        this.getStaticContext();
        try {
            XPathParser parser = this.getConfiguration().newExpressionParser("XP", false, this.staticContext.getXPathLanguageLevel());
            parser.setLanguage(0, this.staticContext.getXPathLanguageLevel());
            return parser.parseSequenceType(sequenceType, this.staticContext);
        }
        catch (XPathException err) {
            this.compileError(err);
            return SequenceType.ANY_SEQUENCE;
        }
    }

    protected void processExtensionElementAttribute(String ns) throws XPathException {
        String ext = this.getAttributeValue(ns, "extension-element-prefixes");
        if (ext != null) {
            int count = 0;
            StringTokenizer st1 = new StringTokenizer(ext, " \t\n\r", false);
            while (st1.hasMoreTokens()) {
                st1.nextToken();
                ++count;
            }
            this.extensionNamespaces = new String[count];
            count = 0;
            StringTokenizer st2 = new StringTokenizer(ext, " \t\n\r", false);
            while (st2.hasMoreTokens()) {
                String uri;
                String s = st2.nextToken();
                if ("#default".equals(s)) {
                    s = "";
                }
                if ((uri = this.getURIForPrefix(s, false)) == null) {
                    this.extensionNamespaces = null;
                    this.compileError("Namespace prefix " + s + " is undeclared", "XTSE1430");
                    continue;
                }
                assert (this.extensionNamespaces != null);
                this.extensionNamespaces[count++] = uri;
            }
        }
    }

    protected void processExcludedNamespaces(String ns) throws XPathException {
        String ext = this.getAttributeValue(ns, "exclude-result-prefixes");
        if (ext != null) {
            if ("#all".equals(Whitespace.trim(ext))) {
                Iterator<NamespaceBinding> codes = NamespaceIterator.iterateNamespaces(this);
                ArrayList<String> excluded = new ArrayList<String>();
                while (codes.hasNext()) {
                    excluded.add(codes.next().getURI());
                }
                this.excludedNamespaces = excluded.toArray(new String[excluded.size()]);
            } else {
                int count = 0;
                StringTokenizer st1 = new StringTokenizer(ext, " \t\n\r", false);
                while (st1.hasMoreTokens()) {
                    st1.nextToken();
                    ++count;
                }
                this.excludedNamespaces = new String[count];
                count = 0;
                StringTokenizer st2 = new StringTokenizer(ext, " \t\n\r", false);
                while (st2.hasMoreTokens()) {
                    String s = st2.nextToken();
                    if ("#default".equals(s)) {
                        s = "";
                    } else if ("#all".equals(s)) {
                        this.compileError("In exclude-result-prefixes, cannot mix #all with other values", "XTSE0020");
                    }
                    String uri = this.getURIForPrefix(s, true);
                    if (uri == null) {
                        this.excludedNamespaces = null;
                        this.compileError("Namespace prefix " + s + " is not declared", "XTSE0808");
                        break;
                    }
                    this.excludedNamespaces[count++] = uri;
                    if (s.length() != 0 || uri.length() != 0) continue;
                    this.compileError("Cannot exclude the #default namespace when no default namespace is declared", "XTSE0809");
                }
            }
        }
    }

    protected void processVersionAttribute(String ns) throws XPathException {
        String v = Whitespace.trim(this.getAttributeValue(ns, "version"));
        if (v != null) {
            ConversionResult val = DecimalValue.makeDecimalValue(v, true);
            if (val instanceof ValidationFailure) {
                this.compileError("The version attribute must be a decimal literal", "XTSE0110");
                this.version = DecimalValue.TWO;
            } else {
                this.version = (DecimalValue)val;
            }
        }
    }

    public DecimalValue getEffectiveVersion() {
        if (this.version == null) {
            NodeImpl node = this.getParent();
            if (node instanceof StyleElement) {
                this.version = ((StyleElement)node).getEffectiveVersion();
            } else {
                return DecimalValue.TWO;
            }
        }
        return this.version;
    }

    protected int validateValidationAttribute(String value) throws XPathException {
        int code = Validation.getCode(value);
        if (code == -1) {
            String prefix = this instanceof LiteralResultElement ? "xsl:" : "";
            this.compileError("Invalid value of " + prefix + "validation attribute", "XTSE0020");
            code = this.getDefaultValidation();
        }
        if (!this.isSchemaAware()) {
            if (this.isXslt30Processor()) {
                if (code == 1) {
                    this.compileError("To perform validation, a schema-aware XSLT processor is needed", "XTSE1660");
                }
                code = 4;
            } else {
                if (code != 4) {
                    this.compileError("To perform validation, a schema-aware XSLT processor is needed", "XTSE1660");
                }
                code = 4;
            }
        }
        return code;
    }

    public boolean forwardsCompatibleModeIsEnabled() {
        return this.getEffectiveVersion().compareTo(this.getProcessorVersion()) > 0;
    }

    public boolean xPath10ModeIsEnabled() {
        return this.getEffectiveVersion().compareTo(DecimalValue.TWO) < 0;
    }

    public DecimalValue getProcessorVersion() {
        return this.getCompilation().getStyleNodeFactory(true).getXsltProcessorVersion();
    }

    public boolean isXslt30Processor() {
        return this.getProcessorVersion().compareTo(DecimalValue.THREE) >= 0;
    }

    protected void processDefaultCollationAttribute() throws XPathException {
        String ns = this.getURI().equals("http://www.w3.org/1999/XSL/Transform") ? "" : "http://www.w3.org/1999/XSL/Transform";
        String v = this.getAttributeValue(ns, "default-collation");
        if (v != null) {
            StringTokenizer st = new StringTokenizer(v, " \t\n\r", false);
            while (st.hasMoreTokens()) {
                String uri = st.nextToken();
                if (uri.equals("http://www.w3.org/2005/xpath-functions/collation/codepoint")) {
                    this.defaultCollationName = uri;
                    return;
                }
                if (uri.startsWith("http://saxon.sf.net/")) {
                    this.defaultCollationName = uri;
                    return;
                }
                try {
                    URI collationURI = new URI(uri);
                    if (!collationURI.isAbsolute()) {
                        URI base = new URI(this.getBaseURI());
                        collationURI = base.resolve(collationURI);
                        uri = collationURI.toString();
                    }
                }
                catch (URISyntaxException err) {
                    this.compileError("default collation '" + uri + "' is not a valid URI");
                    uri = "http://www.w3.org/2005/xpath-functions/collation/codepoint";
                }
                if (uri.startsWith("http://saxon.sf.net/")) {
                    this.defaultCollationName = uri;
                    return;
                }
                if (uri.startsWith("http://www.w3.org/2013/collation/UCA")) {
                    this.defaultCollationName = uri;
                    return;
                }
                if (this.getConfiguration().getCollation(uri) == null) continue;
                this.defaultCollationName = uri;
                return;
            }
            this.compileError("No recognized collation URI found in default-collation attribute", "XTSE0125");
        }
    }

    protected String getDefaultCollationName() {
        StyleElement e = this;
        while (true) {
            if (e.defaultCollationName != null) {
                return e.defaultCollationName;
            }
            NodeImpl p = e.getParent();
            if (!(p instanceof StyleElement)) break;
            e = (StyleElement)p;
        }
        return this.getConfiguration().getDefaultCollationName();
    }

    public StringCollator findCollation(String name, String baseURI) throws XPathException {
        return this.getConfiguration().getCollation(name, baseURI);
    }

    protected boolean definesExtensionElement(String uri) {
        if (this.extensionNamespaces == null) {
            return false;
        }
        for (String extensionNamespace : this.extensionNamespaces) {
            if (!extensionNamespace.equals(uri)) continue;
            return true;
        }
        return false;
    }

    public boolean isExtensionNamespace(String uri) {
        NodeInfo anc = this;
        while (anc instanceof StyleElement) {
            if (anc.definesExtensionElement(uri)) {
                return true;
            }
            anc = anc.getParent();
        }
        return false;
    }

    protected boolean definesExcludedNamespace(String uri) {
        if (this.excludedNamespaces == null) {
            return false;
        }
        for (String excludedNamespace : this.excludedNamespaces) {
            if (!excludedNamespace.equals(uri)) continue;
            return true;
        }
        return false;
    }

    public boolean isExcludedNamespace(String uri) {
        if (uri.equals("http://www.w3.org/1999/XSL/Transform") || uri.equals("http://www.w3.org/XML/1998/namespace")) {
            return true;
        }
        if (this.isExtensionNamespace(uri)) {
            return true;
        }
        NodeInfo anc = this;
        while (anc instanceof StyleElement) {
            if (anc.definesExcludedNamespace(uri)) {
                return true;
            }
            anc = anc.getParent();
        }
        return false;
    }

    protected void processDefaultXPathNamespaceAttribute(String ns) {
        String v = this.getAttributeValue(ns, "xpath-default-namespace");
        if (v != null) {
            this.defaultXPathNamespace = v;
        }
    }

    protected String getDefaultXPathNamespace() {
        NodeInfo anc = this;
        while (anc instanceof StyleElement) {
            String x = anc.defaultXPathNamespace;
            if (x != null) {
                return x;
            }
            anc = anc.getParent();
        }
        return "";
    }

    protected void processExpandTextAttribute(String ns) throws XPathException {
        NodeImpl parent;
        String v = this.getAttributeValue(ns, "expand-text");
        this.expandText = v != null ? this.processBooleanAttribute("expand-text", v) : (parent = this.getParent()) instanceof StyleElement && ((StyleElement)parent).expandText;
    }

    public boolean isExpandingText() {
        return this.expandText;
    }

    public SchemaType getSchemaType(String typeAtt) throws XPathException {
        try {
            int nc;
            String lname;
            String uri;
            if (typeAtt.startsWith("Q{")) {
                try {
                    StructuredQName q = this.makeQName(typeAtt);
                    uri = q.getURI();
                    lname = q.getLocalPart();
                    nc = this.getNamePool().allocate("", uri, lname);
                }
                catch (NamespaceException e) {
                    throw new XPathException(e);
                }
            } else {
                String[] parts = NameChecker.getQNameParts(typeAtt);
                lname = parts[1];
                if ("".equals(parts[0])) {
                    uri = this.getDefaultXPathNamespace();
                } else {
                    uri = this.getURIForPrefix(parts[0], false);
                    if (uri == null) {
                        this.compileError("Namespace prefix for type annotation is undeclared", "XTSE1520");
                        return null;
                    }
                }
                nc = this.getNamePool().allocate(parts[0], uri, lname);
            }
            if (uri.equals("http://www.w3.org/2001/XMLSchema")) {
                SchemaType t = BuiltInType.getSchemaType(StandardNames.getFingerprint(uri, lname));
                if (t == null) {
                    this.compileError("Unknown built-in type " + typeAtt, "XTSE1520");
                    return null;
                }
                return t;
            }
            if (!this.getContainingPackage().isImportedSchema(uri)) {
                this.compileError("There is no imported schema for the namespace of type " + typeAtt, "XTSE1520");
                return null;
            }
            SchemaType stype = this.getConfiguration().getSchemaType(nc & 0xFFFFF);
            if (stype == null) {
                this.compileError("There is no type named " + typeAtt + " in an imported schema", "XTSE1520");
            }
            return stype;
        }
        catch (QNameException err) {
            this.compileError("Invalid type name. " + err.getMessage(), "XTSE1520");
            return null;
        }
    }

    public SimpleType getTypeAnnotation(SchemaType schemaType) {
        return (SimpleType)schemaType;
    }

    public void validate(ComponentDeclaration decl) throws XPathException {
    }

    public void postValidate() throws XPathException {
    }

    public void index(ComponentDeclaration decl, StylesheetPackage top) throws XPathException {
    }

    public Expression typeCheck(String name, Expression exp) throws XPathException {
        if (exp == null) {
            return null;
        }
        exp.setContainer(this);
        try {
            exp = this.makeExpressionVisitor().typeCheck(exp, new ContextItemStaticInfo(Type.ITEM_TYPE, true));
            exp = ExpressionTool.resolveCallsToCurrentFunction(exp);
            CodeInjector injector = this.getCompilation().getCompilerInfo().getCodeInjector();
            if (injector != null) {
                return injector.inject(exp, this.getStaticContext(), 2011, new StructuredQName("", "", name));
            }
            return exp;
        }
        catch (XPathException err) {
            if (err.isReportableStatically()) {
                this.compileError(err);
                return exp;
            }
            ErrorExpression erexp = new ErrorExpression(err);
            erexp.setLocationId(this.allocateLocationId(this.getSystemId(), this.getLineNumber()));
            return erexp;
        }
    }

    public void allocateSlots(Expression exp) {
        SlotManager slotManager = this.getContainingSlotManager();
        if (slotManager == null) {
            throw new AssertionError((Object)"Slot manager has not been allocated");
        }
        int firstSlot = slotManager.getNumberOfVariables();
        int highWater = ExpressionTool.allocateSlots(exp, firstSlot, slotManager);
        if (highWater > firstSlot) {
            slotManager.setNumberOfVariables(highWater);
        }
    }

    public void allocatePatternSlots(int slots) {
        this.getContainingPackage().allocatePatternSlots(slots);
    }

    public Pattern typeCheck(String name, Pattern pattern) throws XPathException {
        if (pattern == null) {
            return null;
        }
        try {
            pattern = pattern.analyze(this.makeExpressionVisitor(), new ContextItemStaticInfo(Type.NODE_TYPE, true));
            boolean usesCurrent = false;
            Iterator<Expression> sub = pattern.iterateSubExpressions();
            while (sub.hasNext()) {
                Expression filter = sub.next();
                if (!ExpressionTool.callsFunction(filter, Current.FN_CURRENT)) continue;
                usesCurrent = true;
                break;
            }
            if (usesCurrent) {
                PatternThatSetsCurrent p2 = new PatternThatSetsCurrent(pattern);
                pattern.bindCurrent(p2.getCurrentBinding());
                pattern = p2;
            }
            return pattern;
        }
        catch (XPathException err) {
            if (err.isReportableStatically()) {
                XPathException e2 = new XPathException("Error in " + name + " pattern", err);
                e2.setLocator(this);
                e2.setErrorCodeQName(err.getErrorCodeQName());
                throw e2;
            }
            PatternWithPredicate p = new PatternWithPredicate(new NodeTestPattern(ErrorType.getInstance()), new ErrorExpression(err));
            ((Pattern)p).setPackageData(this.compilation.getPackageData());
            return p;
        }
    }

    public void fixupReferences() throws XPathException {
        NodeInfo child;
        AxisIterator kids = this.iterateAxis((byte)3);
        while ((child = kids.next()) != null) {
            if (!(child instanceof StyleElement)) continue;
            ((StyleElement)child).fixupReferences();
        }
    }

    public SlotManager getContainingSlotManager() {
        NodeInfo node = this;
        while (true) {
            NodeInfo next;
            if ((next = node.getParent()) instanceof XSLModuleRoot || next.getFingerprint() == 185) {
                if (node instanceof StylesheetComponent) {
                    return ((StylesheetComponent)((Object)node)).getSlotManager();
                }
                return null;
            }
            node = next;
        }
    }

    public void validateSubtree(ComponentDeclaration decl, boolean excludeStylesheet) throws XPathException {
        if (this.isActionCompleted(1)) {
            return;
        }
        this.setActionCompleted(1);
        if (this.validationError != null) {
            if (this.reportingCircumstances == 1) {
                this.compileError(this.validationError);
            } else if (this.reportingCircumstances == 2 && !this.forwardsCompatibleModeIsEnabled()) {
                this.compileError(this.validationError);
            } else if (this.reportingCircumstances == 4) {
                if (!this.forwardsCompatibleModeIsEnabled()) {
                    this.compileError(this.validationError);
                } else {
                    NodeInfo child;
                    boolean hasFallback = false;
                    AxisIterator kids = this.iterateAxis((byte)3);
                    while ((child = kids.next()) != null) {
                        if (!(child instanceof XSLFallback)) continue;
                        hasFallback = true;
                        ((XSLFallback)child).validateSubtree(decl, false);
                    }
                    if (!hasFallback) {
                        this.compileError(this.validationError);
                    }
                }
            }
        } else {
            try {
                this.validate(decl);
            }
            catch (XPathException err) {
                this.compileError(err);
            }
            this.validateChildren(decl, excludeStylesheet);
            if (this.getCompilation().getErrorCount() == 0) {
                this.postValidate();
            }
        }
    }

    protected void validateChildren(ComponentDeclaration decl, boolean excludeStylesheet) throws XPathException {
        NodeInfo child;
        boolean containsInstructions = this.mayContainSequenceConstructor();
        AxisIterator kids = this.iterateAxis((byte)3);
        StyleElement lastChild = null;
        boolean endsWithTextTemplate = false;
        while ((child = kids.next()) != null) {
            if (child instanceof StyleElement) {
                if (excludeStylesheet && child instanceof XSLStylesheet) continue;
                endsWithTextTemplate = false;
                if (containsInstructions && !((StyleElement)child).isInstruction() && !this.isPermittedChild((StyleElement)child)) {
                    ((StyleElement)child).compileError("An " + this.getDisplayName() + " element must not contain an " + child.getDisplayName() + " element", "XTSE0010");
                }
                ((StyleElement)child).validateSubtree(decl, excludeStylesheet);
                lastChild = (StyleElement)child;
                continue;
            }
            endsWithTextTemplate = this.getCompilation().getStyleNodeFactory(true).validateTextNode(child);
        }
        if (lastChild instanceof XSLLocalVariable && !(this instanceof XSLStylesheet) && !endsWithTextTemplate) {
            lastChild.compileWarning("A variable with no following sibling instructions has no effect", "SXWN9001");
        }
    }

    protected boolean isPermittedChild(StyleElement child) {
        return false;
    }

    public StylesheetPackage getContainingPackage() {
        return this.getCompilation().getStylesheetPackage();
    }

    protected void checkSortComesFirst(boolean sortRequired) throws XPathException {
        NodeInfo child;
        AxisIterator kids = this.iterateAxis((byte)3);
        boolean sortFound = false;
        boolean nonSortFound = false;
        while ((child = kids.next()) != null) {
            if (child instanceof XSLSort) {
                if (nonSortFound) {
                    ((XSLSort)child).compileError("Within " + this.getDisplayName() + ", xsl:sort elements must come before other instructions", "XTSE0010");
                }
                sortFound = true;
                continue;
            }
            if (child.getNodeKind() == 3) {
                if (Whitespace.isWhite(child.getStringValueCS())) continue;
                nonSortFound = true;
                continue;
            }
            nonSortFound = true;
        }
        if (sortRequired && !sortFound) {
            this.compileError(this.getDisplayName() + " must have at least one xsl:sort child", "XTSE0010");
        }
    }

    public void checkTopLevel(String errorCode, boolean allowOverride) throws XPathException {
        if (this.getParent().getFingerprint() == 185) {
            if (!allowOverride) {
                this.compileError("Element " + this.getDisplayName() + " is not allowed as a child of xsl:override");
            }
        } else if (!this.isTopLevel()) {
            this.compileError("Element " + this.getDisplayName() + " must be top-level (a child of xsl:stylesheet, xsl:transform, or xsl:package)", errorCode);
        }
    }

    public void checkEmpty() throws XPathException {
        if (this.hasChildNodes()) {
            this.compileError("Element must be empty", "XTSE0260");
        }
    }

    public void reportAbsence(String attribute) throws XPathException {
        this.compileError("Element must have an @" + attribute + " attribute", "XTSE0010");
    }

    public Expression compile(Compilation compilation, ComponentDeclaration decl) throws XPathException {
        return null;
    }

    public void compileDeclaration(Compilation compilation, ComponentDeclaration decl) throws XPathException {
    }

    public Expression compileSequenceConstructor(Compilation compilation, ComponentDeclaration decl, SequenceIterator iter, boolean includeParams) throws XPathException {
        NodeInfo node;
        int locationId = this.allocateLocationId(this.getSystemId(), this.getLineNumber());
        ArrayList<Expression> contents = new ArrayList<Expression>(10);
        int lineNumber = this.getLineNumber();
        while ((node = (NodeInfo)iter.next()) != null) {
            Expression child;
            if (node instanceof StyleElement) {
                lineNumber = node.getLineNumber();
            }
            if (node.getNodeKind() == 3) {
                if (this.isExpandingText()) {
                    this.getCompilation().getStyleNodeFactory(true).compileContentValueTemplate((TextImpl)node, contents, this);
                    continue;
                }
                AxisIterator lookahead = node.iterateAxis((byte)7);
                NodeInfo sibling = lookahead.next();
                if (sibling instanceof XSLLocalParam || sibling instanceof XSLSort) continue;
                Expression text = new ValueOf(new StringLiteral(node.getStringValue(), (Container)this), false, false);
                text.setLocationId(this.allocateLocationId(this.getSystemId(), lineNumber));
                CodeInjector injector = this.getCompilation().getCompilerInfo().getCodeInjector();
                if (injector != null) {
                    Expression tracer = injector.inject(text, this.getStaticContext(), 201, null);
                    tracer.setLocationId(text.getLocationId());
                    text = tracer;
                }
                contents.add(text);
                continue;
            }
            if (node instanceof XSLLocalVariable) {
                XSLLocalVariable var = (XSLLocalVariable)node;
                SourceBinding sourceBinding = var.getSourceBinding();
                var.compileLocalVariable(compilation, decl);
                Expression tail = this.compileSequenceConstructor(compilation, decl, iter, includeParams);
                if (tail == null || Literal.isEmptySequence(tail)) continue;
                LetExpression let = new LetExpression();
                let.setRequiredType(var.getRequiredType());
                let.setVariableQName(sourceBinding.getVariableQName());
                let.setSequence(sourceBinding.getSelectExpression());
                let.setAction(tail);
                sourceBinding.fixupBinding(let);
                locationId = this.allocateLocationId(node.getSystemId(), node.getLineNumber());
                let.setLocationId(locationId);
                if (this.getCompilation().getCompilerInfo().isCompileWithTracing()) {
                    TraceExpression t = new TraceExpression(let);
                    t.setConstructType(2013);
                    t.setObjectName(var.getSourceBinding().getVariableQName());
                    t.setNamespaceResolver(this.getNamespaceResolver());
                    contents.add(t);
                    continue;
                }
                contents.add(let);
                continue;
            }
            if (!(node instanceof StyleElement)) continue;
            StyleElement snode = (StyleElement)node;
            if (snode.validationError != null && !(this instanceof AbsentExtensionElement)) {
                child = this.fallbackProcessing(compilation, decl, snode);
            } else {
                child = snode.compile(compilation, decl);
                if (child != null) {
                    if (child.getContainer() == null) {
                        child.setContainer(this);
                    }
                    locationId = this.allocateLocationId(this.getSystemId(), snode.getLineNumber());
                    child.setLocationId(locationId);
                    if ((includeParams || !(node instanceof XSLLocalParam)) && this.getCompilation().getCompilerInfo().isCompileWithTracing()) {
                        child = StyleElement.makeTraceInstruction(snode, child);
                    }
                }
            }
            if (child == null) continue;
            contents.add(child);
        }
        Expression block = Block.makeBlock(contents, this);
        block.setLocationId(locationId);
        return block;
    }

    protected static Expression makeTraceInstruction(StyleElement source, Expression child) {
        if (child instanceof TraceExpression && !(source instanceof StylesheetComponent)) {
            return child;
        }
        CodeInjector injector = source.getCompilation().getCompilerInfo().getCodeInjector();
        if (injector != null) {
            int construct = source.getFingerprint();
            if (source instanceof LiteralResultElement) {
                construct = 2006;
            }
            Expression tracer = injector.inject(child, source.getStaticContext(), construct, source.getObjectName());
            tracer.setLocationId(source.allocateLocationId(source.getSystemId(), source.getLineNumber()));
            return tracer;
        }
        return child;
    }

    protected Expression fallbackProcessing(Compilation exec, ComponentDeclaration decl, StyleElement instruction) throws XPathException {
        NodeInfo child;
        Expression fallback = null;
        AxisIterator kids = instruction.iterateAxis((byte)3);
        while ((child = kids.next()) != null) {
            if (!(child instanceof XSLFallback)) continue;
            Expression b = ((XSLFallback)child).compileSequenceConstructor(exec, decl, child.iterateAxis((byte)3), true);
            if (b == null) {
                b = Literal.makeEmptySequence(this);
            }
            if (fallback == null) {
                fallback = b;
                continue;
            }
            fallback = Block.makeBlock(fallback, b);
            fallback.setLocationId(this.allocateLocationId(this.getSystemId(), this.getLineNumber()));
        }
        if (fallback != null) {
            return fallback;
        }
        return new ErrorExpression(instruction.validationError);
    }

    protected int allocateLocationId(String systemId, int lineNumber) {
        return this.getStaticContext().getLocationMap().allocateLocationId(systemId, lineNumber);
    }

    public SortKeyDefinition[] makeSortKeys(Compilation compilation, ComponentDeclaration decl) throws XPathException {
        NodeInfo child;
        int numberOfSortKeys = 0;
        AxisIterator kids = this.iterateAxis((byte)3);
        while ((child = kids.next()) != null) {
            if (!(child instanceof XSLSortOrMergeKey)) continue;
            ((XSLSortOrMergeKey)child).compile(compilation, decl);
            if (child instanceof XSLSort && numberOfSortKeys != 0 && ((XSLSort)child).getStable() != null) {
                this.compileError("stable attribute may appear only on the first xsl:sort element", "XTSE1017");
            }
            ++numberOfSortKeys;
        }
        if (numberOfSortKeys > 0) {
            SortKeyDefinition[] keys = new SortKeyDefinition[numberOfSortKeys];
            kids = this.iterateAxis((byte)3);
            int k = 0;
            while ((child = kids.next()) != null) {
                if (!(child instanceof XSLSortOrMergeKey)) continue;
                keys[k++] = ((XSLSortOrMergeKey)child).getSortKeyDefinition().simplify(this.makeExpressionVisitor());
            }
            return keys;
        }
        return null;
    }

    protected AttributeSet[] getAttributeSets(String use, List<ComponentDeclaration> list) throws XPathException {
        if (list == null) {
            list = new ArrayList<ComponentDeclaration>(4);
        }
        StylesheetPackage psm = this.getContainingPackage();
        StringTokenizer st = new StringTokenizer(use, " \t\n\r", false);
        while (st.hasMoreTokens()) {
            boolean found;
            StructuredQName name;
            String asetname = st.nextToken();
            try {
                name = this.makeQName(asetname);
            }
            catch (NamespaceException err) {
                this.compileError(err.getMessage(), "XTSE0710");
                name = null;
            }
            catch (XPathException err) {
                this.compileError(err.getMessage(), "XTSE0710");
                name = null;
            }
            if (found = psm.getAttributeSets(name, list)) continue;
            this.compileError("No attribute-set exists named " + asetname, "XTSE0710");
        }
        AttributeSet[] array = new AttributeSet[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            XSLAttributeSet aset = (XSLAttributeSet)list.get(i).getSourceElement();
            array[i] = aset.getInstruction();
        }
        return array;
    }

    protected Visibility getVisibilityValue(String s, String flags) throws XPathException {
        for (Visibility v : Visibility.values()) {
            if (!v.visibilityStr.equals(s) || !flags.contains("h") && s.equals("hidden") || !flags.contains("a") && s.equals("absent")) continue;
            return v;
        }
        this.invalidAttribute("visibility", "public|final|private|abstract" + (flags.contains("h") ? "|hidden" : "") + (flags.contains("a") ? "|absent" : ""));
        return null;
    }

    protected WithParam[] getWithParamInstructions(Compilation compilation, ComponentDeclaration decl, boolean tunnel) throws XPathException {
        NodeInfo child;
        int count = 0;
        AxisIterator kids = this.iterateAxis((byte)3);
        while ((child = kids.next()) != null) {
            XSLWithParam wp;
            if (!(child instanceof XSLWithParam) || (wp = (XSLWithParam)child).getSourceBinding().hasProperty(8) != tunnel) continue;
            ++count;
        }
        if (count == 0) {
            return WithParam.EMPTY_ARRAY;
        }
        WithParam[] array = new WithParam[count];
        count = 0;
        kids = this.iterateAxis((byte)3);
        while ((child = kids.next()) != null) {
            XSLWithParam wp;
            if (!(child instanceof XSLWithParam) || (wp = (XSLWithParam)child).getSourceBinding().hasProperty(8) != tunnel) continue;
            WithParam p = wp.compileWithParam(compilation, decl);
            array[count++] = p;
        }
        return array;
    }

    public void compileError(XPathException error) throws XPathException {
        error.setIsStaticError(true);
        if (error.getLocator() == null || (error.getLocator() instanceof ExpressionLocation || error.getLocator() instanceof Expression) && !(this instanceof StylesheetComponent)) {
            error.setLocator(this);
        }
        this.getCompilation().reportError(error);
    }

    public void compileError(String message) throws XPathException {
        this.compileError(message, "XTSE0010");
    }

    public void compileError(String message, StructuredQName errorCode) throws XPathException {
        XPathException tce = new XPathException(message);
        tce.setErrorCodeQName(errorCode);
        tce.setLocator(this);
        this.compileError(tce);
    }

    public void compileError(String message, String errorCode) throws XPathException {
        XPathException tce = new XPathException(message);
        tce.setErrorCode(errorCode);
        tce.setLocator(this);
        this.compileError(tce);
    }

    protected void invalidAttribute(String attributeName, String allowedValues) throws XPathException {
        this.compileError("Attribute " + this.getDisplayName() + "/@" + attributeName + " must be " + allowedValues, "XTSE0020");
    }

    protected void undeclaredNamespaceError(String prefix, String errorCode) throws XPathException {
        if (errorCode == null) {
            errorCode = "XTSE0280";
        }
        this.compileError("Undeclared namespace prefix " + Err.wrap(prefix), errorCode);
    }

    public void compileWarning(String message, StructuredQName errorCode) throws XPathException {
        XPathException tce = new XPathException(message);
        tce.setErrorCodeQName(errorCode);
        tce.setLocator(this);
        this.getCompilation().reportWarning(tce);
    }

    public void compileWarning(String message, String errorCode) throws XPathException {
        XPathException tce = new XPathException(message);
        tce.setErrorCode(errorCode);
        tce.setLocator(this);
        this.getCompilation().reportWarning(tce);
    }

    protected void issueWarning(XPathException error) {
        if (error.getLocator() == null) {
            error.setLocator(this);
        }
        this.getCompilation().reportWarning(error);
    }

    protected void issueWarning(String message, SourceLocator locator) {
        XPathException tce = new XPathException(message);
        if (locator == null) {
            tce.setLocator(this);
        } else {
            tce.setLocator(locator);
        }
        this.issueWarning(tce);
    }

    public boolean isTopLevel() {
        return this.getParent() instanceof XSLModuleRoot;
    }

    public SourceBinding getBindingInformation(StructuredQName name) {
        return null;
    }

    public SourceBinding bindVariable(StructuredQName qName) {
        SourceBinding decl = this.bindLocalVariable(qName);
        if (decl != null) {
            return decl;
        }
        SourceBinding binding = this.getContainingPackage().getGlobalVariableBinding(qName);
        if (binding == null || Navigator.isAncestorOrSelf(binding.getSourceElement(), this)) {
            return null;
        }
        return binding;
    }

    public SourceBinding bindLocalVariable(StructuredQName qName) {
        block6: {
            NodeInfo curr = this;
            NodeInfo prev = this;
            SourceBinding implicit = this.hasImplicitBinding(qName);
            if (implicit != null) {
                return implicit;
            }
            if (!this.isTopLevel()) {
                SourceBinding sourceBinding;
                AxisIterator preceding = curr.iterateAxis((byte)11);
                do {
                    curr = preceding.next();
                    while (curr == null) {
                        curr = prev.getParent();
                        if (curr instanceof StyleElement && (implicit = ((StyleElement)curr).hasImplicitBinding(qName)) != null) {
                            return implicit;
                        }
                        while (curr instanceof StyleElement && !((StyleElement)curr).seesAvuncularVariables()) {
                            curr = curr.getParent();
                        }
                        prev = curr;
                        if (curr.getParent() instanceof XSLModuleRoot) break;
                        preceding = curr.iterateAxis((byte)11);
                        curr = preceding.next();
                    }
                    if (curr.getParent() instanceof XSLModuleRoot) break block6;
                } while (!(curr instanceof XSLGeneralVariable) || (sourceBinding = ((XSLGeneralVariable)curr).getBindingInformation(qName)) == null);
                return sourceBinding;
            }
        }
        return null;
    }

    protected boolean seesAvuncularVariables() {
        return true;
    }

    protected SourceBinding hasImplicitBinding(StructuredQName name) {
        return null;
    }

    @Override
    public int getConstructType() {
        return this.getFingerprint();
    }

    @Override
    public StructuredQName getObjectName() {
        return this.objectName;
    }

    public void setObjectName(StructuredQName qName) {
        this.objectName = qName;
    }

    @Override
    public Object getProperty(String name) {
        return this.getAttributeValue("", name);
    }

    @Override
    public Iterator<String> getProperties() {
        NodeInfo a;
        NamePool pool = this.getNamePool();
        ArrayList<String> list = new ArrayList<String>(10);
        AxisIterator it = this.iterateAxis((byte)2);
        while ((a = it.next()) != null) {
            list.add(pool.getClarkName(a.getNameCode()));
        }
        return list.iterator();
    }

    @Override
    public int getHostLanguage() {
        return 50;
    }

    public boolean isActionCompleted(int action) {
        return (this.actionsCompleted & action) != 0;
    }

    public void setActionCompleted(int action) {
        this.actionsCompleted |= action;
    }
}

