/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.flwor;

import java.util.List;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.flwor.Clause;
import net.sf.saxon.expr.flwor.ExpressionProcessor;
import net.sf.saxon.expr.flwor.TuplePull;
import net.sf.saxon.expr.flwor.TuplePush;
import net.sf.saxon.expr.flwor.WhereClausePull;
import net.sf.saxon.expr.flwor.WhereClausePush;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WhereClause
extends Clause {
    private Expression predicate;

    public WhereClause(Expression predicate) {
        this.predicate = predicate;
    }

    @Override
    public int getClauseKey() {
        return 6;
    }

    public Expression getPredicate() {
        return this.predicate;
    }

    public void setPredicate(Expression predicate) {
        this.predicate = predicate;
    }

    @Override
    public WhereClause copy() {
        WhereClause w2 = new WhereClause(this.predicate.copy());
        w2.setLocationId(this.getLocationId());
        return w2;
    }

    @Override
    public void typeCheck(ExpressionVisitor visitor) throws XPathException {
        super.typeCheck(visitor);
    }

    @Override
    public TuplePull getPullStream(TuplePull base, XPathContext context) {
        return new WhereClausePull(base, this.predicate);
    }

    @Override
    public void gatherVariableReferences(ExpressionVisitor visitor, Binding binding, List<VariableReference> references) {
        ExpressionTool.gatherVariableReferences(this.predicate, binding, references);
    }

    @Override
    public void refineVariableType(ExpressionVisitor visitor, List<VariableReference> references, Expression returnExpr) {
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        ItemType actualItemType = this.predicate.getItemType();
        for (VariableReference ref : references) {
            ref.refineVariableType(actualItemType, this.predicate.getCardinality(), this.predicate instanceof Literal ? ((Literal)this.predicate).getValue() : null, this.predicate.getSpecialProperties(), visitor);
            visitor.resetStaticProperties();
        }
    }

    @Override
    public TuplePush getPushStream(TuplePush destination, XPathContext context) {
        return new WhereClausePush(destination, this.predicate);
    }

    @Override
    public void processSubExpressions(ExpressionProcessor processor) throws XPathException {
        this.predicate = processor.processExpression(this.predicate);
    }

    public Expression getBaseExpression() {
        return this.predicate;
    }

    @Override
    public void explain(ExpressionPresenter out) {
        out.startElement("where");
        this.predicate.explain(out);
        out.endElement();
    }

    public String toString() {
        FastStringBuffer fsb = new FastStringBuffer(64);
        fsb.append("where ");
        fsb.append(this.predicate.toString());
        return fsb.toString();
    }
}

