/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.authn.x509.helpers.pkipath.bc;

import eu.emi.security.authn.x509.ValidationErrorCode;
import eu.emi.security.authn.x509.helpers.pkipath.SimpleValidationErrorException;
import java.math.BigInteger;
import java.security.cert.CertificateParsingException;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.jce.provider.AnnotatedException;
import org.bouncycastle.x509.ExtendedPKIXBuilderParameters;
import org.bouncycastle.x509.ExtendedPKIXParameters;
import org.bouncycastle.x509.X509AttributeCertificate;

public class CertPathValidatorUtilities
extends org.bouncycastle.jce.provider.CertPathValidatorUtilities {
    public static TrustAnchor findTrustAnchor2(X509Certificate cert, Set<?> trustAnchors, String sigProvider) throws AnnotatedException {
        return org.bouncycastle.jce.provider.CertPathValidatorUtilities.findTrustAnchor((X509Certificate)cert, trustAnchors, (String)sigProvider);
    }

    public static void addAdditionalStoresFromAltNames(X509Certificate cert, ExtendedPKIXParameters pkixParams) throws CertificateParsingException {
        org.bouncycastle.jce.provider.CertPathValidatorUtilities.addAdditionalStoresFromAltNames((X509Certificate)cert, (ExtendedPKIXParameters)pkixParams);
    }

    public static Collection<?> findIssuerCerts(X509Certificate cert, ExtendedPKIXBuilderParameters pkixParams) throws AnnotatedException {
        return org.bouncycastle.jce.provider.CertPathValidatorUtilities.findIssuerCerts((X509Certificate)cert, (ExtendedPKIXBuilderParameters)pkixParams);
    }

    protected static Set<?> getCompleteCRLs2(DistributionPoint dp, X509Certificate cert, Date currentDate, ExtendedPKIXParameters paramsPKIX) throws SimpleValidationErrorException {
        try {
            return org.bouncycastle.jce.provider.CertPathValidatorUtilities.getCompleteCRLs((DistributionPoint)dp, (Object)cert, (Date)currentDate, (ExtendedPKIXParameters)paramsPKIX);
        }
        catch (AnnotatedException e) {
            if (e.getMessage().startsWith("No CRLs found for issuer")) {
                if (cert.getNotAfter().after(currentDate)) {
                    throw new SimpleValidationErrorException(ValidationErrorCode.noValidCrlFound, new Object[]{e});
                }
                throw new SimpleValidationErrorException(ValidationErrorCode.noCrlForExpiredCert, new Object[]{e});
            }
            throw new SimpleValidationErrorException(ValidationErrorCode.crlExtractionError, e.getCause().getMessage(), e.getCause(), e.getCause().getClass().getName());
        }
    }

    protected static Set<X509CRL> getDeltaCRLs2(Date currentDate, ExtendedPKIXParameters paramsPKIX, X509CRL completeCRL) throws SimpleValidationErrorException {
        try {
            return CertPathValidatorUtilities.getDeltaCRLs((Date)currentDate, (ExtendedPKIXParameters)paramsPKIX, (X509CRL)completeCRL);
        }
        catch (AnnotatedException e) {
            throw new SimpleValidationErrorException(ValidationErrorCode.crlDeltaProblem, e.getMessage(), e.getCause(), e.getCause().getClass().getName());
        }
    }

    protected static ASN1Primitive getExtensionValue(X509Extension ext, String oid) throws AnnotatedException {
        return org.bouncycastle.jce.provider.CertPathValidatorUtilities.getExtensionValue((X509Extension)ext, (String)oid);
    }

    protected static void addAdditionalStoresFromCRLDistributionPoint(CRLDistPoint crldp, ExtendedPKIXParameters pkixParams) throws AnnotatedException {
        org.bouncycastle.jce.provider.CertPathValidatorUtilities.addAdditionalStoresFromCRLDistributionPoint((CRLDistPoint)crldp, (ExtendedPKIXParameters)pkixParams);
    }

    public static BigInteger getSerialNumber(Object cert) {
        if (cert instanceof X509Certificate) {
            return ((X509Certificate)cert).getSerialNumber();
        }
        return ((X509AttributeCertificate)cert).getSerialNumber();
    }

    protected static X500Principal getEncodedIssuerPrincipal(Object cert) {
        return org.bouncycastle.jce.provider.CertPathValidatorUtilities.getEncodedIssuerPrincipal((Object)cert);
    }
}

