/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.service.profile.iam.admin.services.core.impl;

import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.core.Response;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.common.utils.ServerSettings;
import org.apache.airavata.model.credential.store.PasswordCredential;
import org.apache.airavata.model.user.Status;
import org.apache.airavata.model.user.UserProfile;
import org.apache.airavata.model.workspace.Gateway;
import org.apache.airavata.service.profile.iam.admin.services.core.interfaces.TenantManagementInterface;
import org.apache.airavata.service.profile.iam.admin.services.cpi.exception.IamAdminServicesException;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.KeycloakBuilder;
import org.keycloak.admin.client.resource.RoleResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.RolesRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TenantManagementKeycloakImpl
implements TenantManagementInterface {
    private static final Logger logger = LoggerFactory.getLogger(TenantManagementKeycloakImpl.class);
    private String superAdminRealmId = "master";

    private static Keycloak getClient(String adminUrl, String realm, PasswordCredential AdminPasswordCreds) {
        ResteasyClient resteasyClient = new ResteasyClientBuilder().connectionPoolSize(10).trustStore(TenantManagementKeycloakImpl.loadKeyStore()).build();
        return KeycloakBuilder.builder().serverUrl(adminUrl).realm(realm).username(AdminPasswordCreds.getLoginUserName()).password(AdminPasswordCreds.getPassword()).clientId("admin-cli").resteasyClient(resteasyClient).build();
    }

    private static KeyStore loadKeyStore() {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(ServerSettings.getTrustStorePath());
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            ks.load(fis, ServerSettings.getTrustStorePassword().toCharArray());
            KeyStore keyStore = ks;
            return keyStore;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load trust store KeyStore instance", e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    logger.error("Failed to close trust store FileInputStream", (Throwable)e);
                }
            }
        }
    }

    @Override
    public Gateway addTenant(PasswordCredential isSuperAdminPasswordCreds, Gateway gatewayDetails) throws IamAdminServicesException {
        try (Keycloak client = null;){
            client = TenantManagementKeycloakImpl.getClient(ServerSettings.getIamServerUrl(), this.superAdminRealmId, isSuperAdminPasswordCreds);
            RealmRepresentation newRealmDetails = new RealmRepresentation();
            newRealmDetails.setEnabled(Boolean.valueOf(true));
            newRealmDetails.setId(gatewayDetails.getGatewayId());
            newRealmDetails.setDisplayName(gatewayDetails.getGatewayName());
            newRealmDetails.setRealm(gatewayDetails.getGatewayId());
            newRealmDetails.setLoginWithEmailAllowed(Boolean.valueOf(false));
            newRealmDetails.setDuplicateEmailsAllowed(Boolean.valueOf(true));
            newRealmDetails.setAccessTokenLifespan(Integer.valueOf(1800));
            newRealmDetails.setSsoSessionIdleTimeout(Integer.valueOf(3600));
            RealmRepresentation realmWithRoles = TenantManagementKeycloakImpl.createDefaultRoles(newRealmDetails);
            client.realms().create(realmWithRoles);
            Gateway gateway = gatewayDetails;
            return gateway;
        }
    }

    public static RealmRepresentation createDefaultRoles(RealmRepresentation realmDetails) {
        ArrayList<RoleRepresentation> defaultRoles = new ArrayList<RoleRepresentation>();
        RoleRepresentation adminRole = new RoleRepresentation();
        adminRole.setName("admin");
        adminRole.setDescription("Admin role for PGA users");
        defaultRoles.add(adminRole);
        RoleRepresentation adminReadOnlyRole = new RoleRepresentation();
        adminReadOnlyRole.setName("admin-read-only");
        adminReadOnlyRole.setDescription("Read only role for PGA Admin users");
        defaultRoles.add(adminReadOnlyRole);
        RoleRepresentation gatewayUserRole = new RoleRepresentation();
        gatewayUserRole.setName("gateway-user");
        gatewayUserRole.setDescription("default role for PGA users");
        defaultRoles.add(gatewayUserRole);
        RoleRepresentation pendingUserRole = new RoleRepresentation();
        pendingUserRole.setName("user-pending");
        pendingUserRole.setDescription("role for newly registered PGA users");
        defaultRoles.add(pendingUserRole);
        RoleRepresentation gatewayProviderRole = new RoleRepresentation();
        gatewayProviderRole.setName("gateway-provider");
        gatewayProviderRole.setDescription("role for gateway providers in the super-admin PGA");
        defaultRoles.add(gatewayProviderRole);
        RolesRepresentation rolesRepresentation = new RolesRepresentation();
        rolesRepresentation.setRealm(defaultRoles);
        realmDetails.setRoles(rolesRepresentation);
        return realmDetails;
    }

    @Override
    public boolean createTenantAdminAccount(PasswordCredential isSuperAdminPasswordCreds, Gateway gatewayDetails, String tenantAdminPassword) throws IamAdminServicesException {
        IamAdminServicesException exception;
        try (Keycloak client = null;){
            client = TenantManagementKeycloakImpl.getClient(ServerSettings.getIamServerUrl(), this.superAdminRealmId, isSuperAdminPasswordCreds);
            UserRepresentation user = new UserRepresentation();
            user.setUsername(gatewayDetails.getIdentityServerUserName());
            user.setFirstName(gatewayDetails.getGatewayAdminFirstName());
            user.setLastName(gatewayDetails.getGatewayAdminLastName());
            user.setEmail(gatewayDetails.getGatewayAdminEmail());
            user.setEmailVerified(Boolean.valueOf(true));
            user.setEnabled(Boolean.valueOf(true));
            Response httpResponse = client.realm(gatewayDetails.getGatewayId()).users().create(user);
            logger.info("Tenant Admin account creation exited with code : " + httpResponse.getStatus() + " : " + httpResponse.getStatusInfo());
            if (httpResponse.getStatus() == 201) {
                List retrieveCreatedUserList = client.realm(gatewayDetails.getGatewayId()).users().search(user.getUsername(), user.getFirstName(), user.getLastName(), user.getEmail(), Integer.valueOf(0), Integer.valueOf(1));
                UserResource retrievedUser = client.realm(gatewayDetails.getGatewayId()).users().get(((UserRepresentation)retrieveCreatedUserList.get(0)).getId());
                RoleResource adminRoleResource = client.realm(gatewayDetails.getGatewayId()).roles().get("admin");
                retrievedUser.roles().realmLevel().add(Arrays.asList(adminRoleResource.toRepresentation()));
                CredentialRepresentation credential = new CredentialRepresentation();
                credential.setType("password");
                credential.setValue(tenantAdminPassword);
                credential.setTemporary(Boolean.valueOf(false));
                retrievedUser.resetPassword(credential);
                List realmClients = client.realm(gatewayDetails.getGatewayId()).clients().findAll();
                String realmManagementClientId = null;
                for (ClientRepresentation realmClient : realmClients) {
                    if (!realmClient.getClientId().equals("realm-management")) continue;
                    realmManagementClientId = realmClient.getId();
                }
                retrievedUser.roles().clientLevel(realmManagementClientId).add(retrievedUser.roles().clientLevel(realmManagementClientId).listAvailable());
                boolean bl = true;
                return bl;
            }
            logger.error("Request for Tenant Admin Account Creation failed with HTTP code : " + httpResponse.getStatus());
            logger.error("Reason for Tenant Admin account creation failure : " + httpResponse.getStatusInfo());
            boolean bl = false;
            return bl;
        }
    }

    @Override
    public Gateway configureClient(PasswordCredential isSuperAdminPasswordCreds, Gateway gatewayDetails) throws IamAdminServicesException {
        try (Keycloak client = null;){
            String gatewayURL;
            client = TenantManagementKeycloakImpl.getClient(ServerSettings.getIamServerUrl(), this.superAdminRealmId, isSuperAdminPasswordCreds);
            ClientRepresentation pgaClient = new ClientRepresentation();
            pgaClient.setName("pga");
            pgaClient.setClientId("pga");
            pgaClient.setProtocol("openid-connect");
            pgaClient.setStandardFlowEnabled(Boolean.valueOf(true));
            pgaClient.setEnabled(Boolean.valueOf(true));
            pgaClient.setAuthorizationServicesEnabled(Boolean.valueOf(true));
            pgaClient.setDirectAccessGrantsEnabled(Boolean.valueOf(true));
            pgaClient.setServiceAccountsEnabled(Boolean.valueOf(true));
            pgaClient.setFullScopeAllowed(Boolean.valueOf(true));
            pgaClient.setClientAuthenticatorType("client-secret");
            ArrayList<String> redirectUris = new ArrayList<String>();
            if (gatewayDetails.getGatewayURL() != null) {
                gatewayURL = gatewayDetails.getGatewayURL();
                if (gatewayURL.endsWith("/")) {
                    gatewayURL = gatewayURL.substring(0, gatewayURL.length() - 1);
                }
            } else {
                logger.error("Request for Realm Client Creation failed, callback URL not present");
                IamAdminServicesException ex = new IamAdminServicesException();
                ex.setMessage("Gateway Url field in GatewayProfile cannot be empty, Realm Client creation failed");
                throw ex;
            }
            redirectUris.add(gatewayURL + "/callback-url");
            redirectUris.add(gatewayURL);
            pgaClient.setRedirectUris(redirectUris);
            pgaClient.setPublicClient(Boolean.valueOf(false));
            Response httpResponse = client.realms().realm(gatewayDetails.getGatewayId()).clients().create(pgaClient);
            logger.info("Tenant Client configuration exited with code : " + httpResponse.getStatus() + " : " + httpResponse.getStatusInfo());
            if (httpResponse.getStatus() == 201) {
                String ClientUUID = ((ClientRepresentation)client.realms().realm(gatewayDetails.getGatewayId()).clients().findByClientId(pgaClient.getClientId()).get(0)).getId();
                CredentialRepresentation clientSecret = client.realms().realm(gatewayDetails.getGatewayId()).clients().get(ClientUUID).getSecret();
                gatewayDetails.setOauthClientId(pgaClient.getClientId());
                gatewayDetails.setOauthClientSecret(clientSecret.getValue());
                Gateway gateway = gatewayDetails;
                return gateway;
            }
            logger.error("Request for Realm Client Creation failed with HTTP code : " + httpResponse.getStatus());
            logger.error("Reason for Realm Client Creation failure : " + httpResponse.getStatusInfo());
            Gateway gateway = null;
            return gateway;
        }
    }

    @Override
    public boolean createUser(PasswordCredential realmAdminCreds, String tenantId, String username, String emailAddress, String firstName, String lastName, String newPassword) throws IamAdminServicesException {
        block7: {
            try (Keycloak client = null;){
                client = TenantManagementKeycloakImpl.getClient(ServerSettings.getIamServerUrl(), tenantId, realmAdminCreds);
                UserRepresentation user = new UserRepresentation();
                user.setUsername(username);
                user.setFirstName(firstName);
                user.setLastName(lastName);
                user.setEmail(emailAddress);
                user.setEnabled(Boolean.valueOf(false));
                Response httpResponse = client.realm(tenantId).users().create(user);
                if (httpResponse.getStatus() == 201) {
                    List retrieveCreatedUserList = client.realm(tenantId).users().search(user.getUsername(), user.getFirstName(), user.getLastName(), user.getEmail(), Integer.valueOf(0), Integer.valueOf(1));
                    UserResource retrievedUser = client.realm(tenantId).users().get(((UserRepresentation)retrieveCreatedUserList.get(0)).getId());
                    CredentialRepresentation credential = new CredentialRepresentation();
                    credential.setType("password");
                    credential.setValue(newPassword);
                    credential.setTemporary(Boolean.valueOf(false));
                    retrievedUser.resetPassword(credential);
                    break block7;
                }
                logger.error("Request for user Account Creation failed with HTTP code : " + httpResponse.getStatus());
                logger.error("Reason for user account creation failure : " + httpResponse.getStatusInfo());
                boolean bl = false;
                return bl;
            }
        }
        return false;
    }

    @Override
    public boolean enableUserAccount(PasswordCredential realmAdminCreds, String tenantId, String username) throws IamAdminServicesException {
        try (Keycloak client = null;){
            client = TenantManagementKeycloakImpl.getClient(ServerSettings.getIamServerUrl(), tenantId, realmAdminCreds);
            List userResourceList = client.realm(tenantId).users().search(username, Integer.valueOf(0), Integer.valueOf(1));
            UserResource userResource = client.realm(tenantId).users().get(((UserRepresentation)userResourceList.get(0)).getId());
            UserRepresentation profile = userResource.toRepresentation();
            profile.setEnabled(Boolean.valueOf(true));
            profile.setEmailVerified(Boolean.valueOf(true));
            userResource.update(profile);
            boolean bl = true;
            return bl;
        }
    }

    @Override
    public boolean isUserAccountEnabled(PasswordCredential realmAdminCreds, String tenantId, String username) throws IamAdminServicesException {
        try (Keycloak client = null;){
            client = TenantManagementKeycloakImpl.getClient(ServerSettings.getIamServerUrl(), tenantId, realmAdminCreds);
            List userResourceList = client.realm(tenantId).users().search(username, Integer.valueOf(0), Integer.valueOf(1));
            boolean bl = userResourceList.size() == 1 && ((UserRepresentation)userResourceList.get(0)).isEnabled() != false;
            return bl;
        }
    }

    @Override
    public boolean resetUserPassword(PasswordCredential realmAdminCreds, String tenantId, String username, String newPassword) throws IamAdminServicesException {
        try (Keycloak client = null;){
            client = TenantManagementKeycloakImpl.getClient(ServerSettings.getIamServerUrl(), tenantId, realmAdminCreds);
            List retrieveUserList = client.realm(tenantId).users().search(username, null, null, null, Integer.valueOf(0), Integer.valueOf(1));
            if (!retrieveUserList.isEmpty()) {
                UserResource retrievedUser = client.realm(tenantId).users().get(((UserRepresentation)retrieveUserList.get(0)).getId());
                CredentialRepresentation credential = new CredentialRepresentation();
                credential.setType("password");
                credential.setValue(newPassword);
                credential.setTemporary(Boolean.valueOf(false));
                retrievedUser.resetPassword(credential);
                UserRepresentation userRepresentation = retrievedUser.toRepresentation();
                userRepresentation.getRequiredActions().remove("UPDATE_PASSWORD");
                retrievedUser.update(userRepresentation);
                boolean bl = true;
                return bl;
            }
            logger.error("requested User not found");
            boolean retrievedUser = false;
            return retrievedUser;
        }
    }

    @Override
    public List<UserProfile> findUser(PasswordCredential realmAdminCreds, String tenantId, String email, String userName) throws IamAdminServicesException {
        try (Keycloak client = null;){
            client = TenantManagementKeycloakImpl.getClient(ServerSettings.getIamServerUrl(), tenantId, realmAdminCreds);
            List retrieveUserList = client.realm(tenantId).users().search(userName, null, null, email, Integer.valueOf(0), Integer.valueOf(1));
            if (!retrieveUserList.isEmpty()) {
                ArrayList<UserProfile> userList = new ArrayList<UserProfile>();
                for (UserRepresentation user : retrieveUserList) {
                    UserProfile profile = new UserProfile();
                    profile.setUserId(user.getUsername());
                    profile.setFirstName(user.getFirstName());
                    profile.setLastName(user.getLastName());
                    profile.setEmails(Arrays.asList(user.getEmail()));
                    userList.add(profile);
                }
                ArrayList<UserProfile> arrayList = userList;
                return arrayList;
            }
            logger.error("requested User not found");
            List<UserProfile> userList = null;
            return userList;
        }
    }

    @Override
    public void updateUserProfile(PasswordCredential realmAdminCreds, String tenantId, String username, UserProfile userDetails) throws IamAdminServicesException {
        block8: {
            try (Keycloak client = null;){
                client = TenantManagementKeycloakImpl.getClient(ServerSettings.getIamServerUrl(), tenantId, realmAdminCreds);
                List retrieveUserList = client.realm(tenantId).users().search(username, null, null, null, Integer.valueOf(0), Integer.valueOf(1));
                if (!retrieveUserList.isEmpty()) {
                    UserRepresentation userRepresentation = (UserRepresentation)retrieveUserList.get(0);
                    userRepresentation.setFirstName(userDetails.getFirstName());
                    userRepresentation.setLastName(userDetails.getLastName());
                    userRepresentation.setEmail((String)userDetails.getEmails().get(0));
                    UserResource userResource = client.realm(tenantId).users().get(userRepresentation.getId());
                    userResource.update(userRepresentation);
                    break block8;
                }
                throw new IamAdminServicesException("User [" + username + "] wasn't found in Keycloak!");
            }
        }
    }

    @Override
    public boolean addRoleToUser(PasswordCredential realmAdminCreds, String tenantId, String username, String roleName) throws IamAdminServicesException {
        try (Keycloak client = null;){
            client = TenantManagementKeycloakImpl.getClient(ServerSettings.getIamServerUrl(), tenantId, realmAdminCreds);
            List retrieveCreatedUserList = client.realm(tenantId).users().search(username, null, null, null, Integer.valueOf(0), Integer.valueOf(1));
            UserResource retrievedUser = client.realm(tenantId).users().get(((UserRepresentation)retrieveCreatedUserList.get(0)).getId());
            RoleResource roleResource = client.realm(tenantId).roles().get(roleName);
            retrievedUser.roles().realmLevel().add(Arrays.asList(roleResource.toRepresentation()));
            boolean bl = true;
            return bl;
        }
    }

    @Override
    public boolean removeRoleFromUser(PasswordCredential realmAdminCreds, String tenantId, String username, String roleName) throws IamAdminServicesException {
        try (Keycloak client = null;){
            client = TenantManagementKeycloakImpl.getClient(ServerSettings.getIamServerUrl(), tenantId, realmAdminCreds);
            List retrieveCreatedUserList = client.realm(tenantId).users().search(username, null, null, null, Integer.valueOf(0), Integer.valueOf(1));
            UserResource retrievedUser = client.realm(tenantId).users().get(((UserRepresentation)retrieveCreatedUserList.get(0)).getId());
            RoleResource roleResource = client.realm(tenantId).roles().get(roleName);
            retrievedUser.roles().realmLevel().remove(Arrays.asList(roleResource.toRepresentation()));
            boolean bl = true;
            return bl;
        }
    }

    @Override
    public List<UserProfile> getUsersWithRole(PasswordCredential realmAdminCreds, String tenantId, String roleName) throws IamAdminServicesException {
        Keycloak client = null;
        try {
            client = TenantManagementKeycloakImpl.getClient(ServerSettings.getIamServerUrl(), tenantId, realmAdminCreds);
            int totalUserCount = client.realm(tenantId).users().count();
            logger.debug("getUsersWithRole: totalUserCount=" + totalUserCount);
            ArrayList allUsers = new ArrayList();
            int userBatchSize = 100;
            for (int start = 0; start < totalUserCount; start += userBatchSize) {
                logger.debug("getUsersWithRole: fetching " + userBatchSize + " users...");
                allUsers.addAll(client.realm(tenantId).users().search(null, null, null, null, Integer.valueOf(start), Integer.valueOf(userBatchSize)));
            }
            logger.debug("getUsersWithRole: all users count=" + allUsers.size());
            allUsers.sort((a, b) -> a.getCreatedTimestamp() - b.getCreatedTimestamp() > 0L ? -1 : 1);
            List mostRecentUsers = allUsers.subList(0, Math.min(allUsers.size(), 100));
            logger.debug("getUsersWithRole: most recent users count=" + mostRecentUsers.size());
            ArrayList<UserProfile> usersWithRole = new ArrayList<UserProfile>();
            block6: for (UserRepresentation user : mostRecentUsers) {
                UserResource userResource = client.realm(tenantId).users().get(user.getId());
                List roleRepresentations = userResource.roles().realmLevel().listAll();
                for (RoleRepresentation roleRepresentation : roleRepresentations) {
                    if (!roleRepresentation.getName().equals(roleName)) continue;
                    usersWithRole.add(this.convertUserRepresentationToUserProfile(user, tenantId));
                    continue block6;
                }
            }
            logger.debug("getUsersWithRole: most recent users with role count=" + usersWithRole.size());
            ArrayList<UserProfile> arrayList = usersWithRole;
            return arrayList;
        }
        catch (ApplicationSettingsException ex) {
            logger.error("Error getting values from property file, reason: " + ex.getMessage(), (Throwable)ex);
            IamAdminServicesException exception = new IamAdminServicesException();
            exception.setMessage("Error getting values from property file, reason " + ex.getMessage());
            throw exception;
        }
        finally {
            if (client != null) {
                logger.debug("getUsersWithRole: closing client...");
                client.close();
                logger.debug("getUsersWithRole: client closed");
            }
        }
    }

    private UserProfile convertUserRepresentationToUserProfile(UserRepresentation userRepresentation, String tenantId) {
        UserProfile profile = new UserProfile();
        profile.setAiravataInternalUserId(userRepresentation.getUsername() + "@" + tenantId);
        profile.setGatewayId(tenantId);
        profile.setUserId(userRepresentation.getUsername());
        profile.setFirstName(userRepresentation.getFirstName());
        profile.setLastName(userRepresentation.getLastName());
        profile.setEmails(Arrays.asList(userRepresentation.getEmail()));
        profile.setLastAccessTime(0L);
        profile.setCreationTime(0L);
        profile.setValidUntil(0L);
        if (userRepresentation.isEnabled().booleanValue()) {
            profile.setState(Status.CONFIRMED);
        } else {
            profile.setState(Status.PENDING_CONFIRMATION);
        }
        return profile;
    }
}

