/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.model.data.movement;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.airavata.model.data.movement.SecurityProtocol;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.EnumMetaData;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class UnicoreDataMovement
implements TBase<UnicoreDataMovement, _Fields>,
Serializable,
Cloneable,
Comparable<UnicoreDataMovement> {
    private static final TStruct STRUCT_DESC = new TStruct("UnicoreDataMovement");
    private static final TField DATA_MOVEMENT_INTERFACE_ID_FIELD_DESC = new TField("dataMovementInterfaceId", 11, 1);
    private static final TField SECURITY_PROTOCOL_FIELD_DESC = new TField("securityProtocol", 8, 2);
    private static final TField UNICORE_END_POINT_URL_FIELD_DESC = new TField("unicoreEndPointURL", 11, 3);
    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    private String dataMovementInterfaceId;
    private SecurityProtocol securityProtocol;
    private String unicoreEndPointURL;
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public UnicoreDataMovement() {
        this.dataMovementInterfaceId = "DO_NOT_SET_AT_CLIENTS";
    }

    public UnicoreDataMovement(String dataMovementInterfaceId, SecurityProtocol securityProtocol, String unicoreEndPointURL) {
        this();
        this.dataMovementInterfaceId = dataMovementInterfaceId;
        this.securityProtocol = securityProtocol;
        this.unicoreEndPointURL = unicoreEndPointURL;
    }

    public UnicoreDataMovement(UnicoreDataMovement other) {
        if (other.isSetDataMovementInterfaceId()) {
            this.dataMovementInterfaceId = other.dataMovementInterfaceId;
        }
        if (other.isSetSecurityProtocol()) {
            this.securityProtocol = other.securityProtocol;
        }
        if (other.isSetUnicoreEndPointURL()) {
            this.unicoreEndPointURL = other.unicoreEndPointURL;
        }
    }

    public UnicoreDataMovement deepCopy() {
        return new UnicoreDataMovement(this);
    }

    public void clear() {
        this.dataMovementInterfaceId = "DO_NOT_SET_AT_CLIENTS";
        this.securityProtocol = null;
        this.unicoreEndPointURL = null;
    }

    public String getDataMovementInterfaceId() {
        return this.dataMovementInterfaceId;
    }

    public void setDataMovementInterfaceId(String dataMovementInterfaceId) {
        this.dataMovementInterfaceId = dataMovementInterfaceId;
    }

    public void unsetDataMovementInterfaceId() {
        this.dataMovementInterfaceId = null;
    }

    public boolean isSetDataMovementInterfaceId() {
        return this.dataMovementInterfaceId != null;
    }

    public void setDataMovementInterfaceIdIsSet(boolean value) {
        if (!value) {
            this.dataMovementInterfaceId = null;
        }
    }

    public SecurityProtocol getSecurityProtocol() {
        return this.securityProtocol;
    }

    public void setSecurityProtocol(SecurityProtocol securityProtocol) {
        this.securityProtocol = securityProtocol;
    }

    public void unsetSecurityProtocol() {
        this.securityProtocol = null;
    }

    public boolean isSetSecurityProtocol() {
        return this.securityProtocol != null;
    }

    public void setSecurityProtocolIsSet(boolean value) {
        if (!value) {
            this.securityProtocol = null;
        }
    }

    public String getUnicoreEndPointURL() {
        return this.unicoreEndPointURL;
    }

    public void setUnicoreEndPointURL(String unicoreEndPointURL) {
        this.unicoreEndPointURL = unicoreEndPointURL;
    }

    public void unsetUnicoreEndPointURL() {
        this.unicoreEndPointURL = null;
    }

    public boolean isSetUnicoreEndPointURL() {
        return this.unicoreEndPointURL != null;
    }

    public void setUnicoreEndPointURLIsSet(boolean value) {
        if (!value) {
            this.unicoreEndPointURL = null;
        }
    }

    public void setFieldValue(_Fields field, Object value) {
        switch (field) {
            case DATA_MOVEMENT_INTERFACE_ID: {
                if (value == null) {
                    this.unsetDataMovementInterfaceId();
                    break;
                }
                this.setDataMovementInterfaceId((String)value);
                break;
            }
            case SECURITY_PROTOCOL: {
                if (value == null) {
                    this.unsetSecurityProtocol();
                    break;
                }
                this.setSecurityProtocol((SecurityProtocol)((Object)value));
                break;
            }
            case UNICORE_END_POINT_URL: {
                if (value == null) {
                    this.unsetUnicoreEndPointURL();
                    break;
                }
                this.setUnicoreEndPointURL((String)value);
            }
        }
    }

    public Object getFieldValue(_Fields field) {
        switch (field) {
            case DATA_MOVEMENT_INTERFACE_ID: {
                return this.getDataMovementInterfaceId();
            }
            case SECURITY_PROTOCOL: {
                return this.getSecurityProtocol();
            }
            case UNICORE_END_POINT_URL: {
                return this.getUnicoreEndPointURL();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case DATA_MOVEMENT_INTERFACE_ID: {
                return this.isSetDataMovementInterfaceId();
            }
            case SECURITY_PROTOCOL: {
                return this.isSetSecurityProtocol();
            }
            case UNICORE_END_POINT_URL: {
                return this.isSetUnicoreEndPointURL();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof UnicoreDataMovement) {
            return this.equals((UnicoreDataMovement)that);
        }
        return false;
    }

    public boolean equals(UnicoreDataMovement that) {
        if (that == null) {
            return false;
        }
        boolean this_present_dataMovementInterfaceId = this.isSetDataMovementInterfaceId();
        boolean that_present_dataMovementInterfaceId = that.isSetDataMovementInterfaceId();
        if (this_present_dataMovementInterfaceId || that_present_dataMovementInterfaceId) {
            if (!this_present_dataMovementInterfaceId || !that_present_dataMovementInterfaceId) {
                return false;
            }
            if (!this.dataMovementInterfaceId.equals(that.dataMovementInterfaceId)) {
                return false;
            }
        }
        boolean this_present_securityProtocol = this.isSetSecurityProtocol();
        boolean that_present_securityProtocol = that.isSetSecurityProtocol();
        if (this_present_securityProtocol || that_present_securityProtocol) {
            if (!this_present_securityProtocol || !that_present_securityProtocol) {
                return false;
            }
            if (!this.securityProtocol.equals((Object)that.securityProtocol)) {
                return false;
            }
        }
        boolean this_present_unicoreEndPointURL = this.isSetUnicoreEndPointURL();
        boolean that_present_unicoreEndPointURL = that.isSetUnicoreEndPointURL();
        if (this_present_unicoreEndPointURL || that_present_unicoreEndPointURL) {
            if (!this_present_unicoreEndPointURL || !that_present_unicoreEndPointURL) {
                return false;
            }
            if (!this.unicoreEndPointURL.equals(that.unicoreEndPointURL)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        ArrayList<Object> list = new ArrayList<Object>();
        boolean present_dataMovementInterfaceId = this.isSetDataMovementInterfaceId();
        list.add(present_dataMovementInterfaceId);
        if (present_dataMovementInterfaceId) {
            list.add(this.dataMovementInterfaceId);
        }
        boolean present_securityProtocol = this.isSetSecurityProtocol();
        list.add(present_securityProtocol);
        if (present_securityProtocol) {
            list.add(this.securityProtocol.getValue());
        }
        boolean present_unicoreEndPointURL = this.isSetUnicoreEndPointURL();
        list.add(present_unicoreEndPointURL);
        if (present_unicoreEndPointURL) {
            list.add(this.unicoreEndPointURL);
        }
        return list.hashCode();
    }

    @Override
    public int compareTo(UnicoreDataMovement other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetDataMovementInterfaceId()).compareTo(other.isSetDataMovementInterfaceId());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetDataMovementInterfaceId() && (lastComparison = TBaseHelper.compareTo((String)this.dataMovementInterfaceId, (String)other.dataMovementInterfaceId)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetSecurityProtocol()).compareTo(other.isSetSecurityProtocol());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetSecurityProtocol() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.securityProtocol), (Comparable)((Object)other.securityProtocol))) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetUnicoreEndPointURL()).compareTo(other.isSetUnicoreEndPointURL());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetUnicoreEndPointURL() && (lastComparison = TBaseHelper.compareTo((String)this.unicoreEndPointURL, (String)other.unicoreEndPointURL)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        schemes.get(iprot.getScheme()).getScheme().read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        schemes.get(oprot.getScheme()).getScheme().write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("UnicoreDataMovement(");
        boolean first = true;
        sb.append("dataMovementInterfaceId:");
        if (this.dataMovementInterfaceId == null) {
            sb.append("null");
        } else {
            sb.append(this.dataMovementInterfaceId);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("securityProtocol:");
        if (this.securityProtocol == null) {
            sb.append("null");
        } else {
            sb.append((Object)this.securityProtocol);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("unicoreEndPointURL:");
        if (this.unicoreEndPointURL == null) {
            sb.append("null");
        } else {
            sb.append(this.unicoreEndPointURL);
        }
        first = false;
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (!this.isSetDataMovementInterfaceId()) {
            throw new TProtocolException("Required field 'dataMovementInterfaceId' is unset! Struct:" + this.toString());
        }
        if (!this.isSetSecurityProtocol()) {
            throw new TProtocolException("Required field 'securityProtocol' is unset! Struct:" + this.toString());
        }
        if (!this.isSetUnicoreEndPointURL()) {
            throw new TProtocolException("Required field 'unicoreEndPointURL' is unset! Struct:" + this.toString());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    static {
        schemes.put(StandardScheme.class, new UnicoreDataMovementStandardSchemeFactory());
        schemes.put(TupleScheme.class, new UnicoreDataMovementTupleSchemeFactory());
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.DATA_MOVEMENT_INTERFACE_ID, new FieldMetaData("dataMovementInterfaceId", 1, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.SECURITY_PROTOCOL, new FieldMetaData("securityProtocol", 1, (FieldValueMetaData)new EnumMetaData(16, SecurityProtocol.class)));
        tmpMap.put(_Fields.UNICORE_END_POINT_URL, new FieldMetaData("unicoreEndPointURL", 1, new FieldValueMetaData(11)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(UnicoreDataMovement.class, metaDataMap);
    }

    private static class UnicoreDataMovementTupleScheme
    extends TupleScheme<UnicoreDataMovement> {
        private UnicoreDataMovementTupleScheme() {
        }

        public void write(TProtocol prot, UnicoreDataMovement struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            oprot.writeString(struct.dataMovementInterfaceId);
            oprot.writeI32(struct.securityProtocol.getValue());
            oprot.writeString(struct.unicoreEndPointURL);
        }

        public void read(TProtocol prot, UnicoreDataMovement struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            struct.dataMovementInterfaceId = iprot.readString();
            struct.setDataMovementInterfaceIdIsSet(true);
            struct.securityProtocol = SecurityProtocol.findByValue(iprot.readI32());
            struct.setSecurityProtocolIsSet(true);
            struct.unicoreEndPointURL = iprot.readString();
            struct.setUnicoreEndPointURLIsSet(true);
        }
    }

    private static class UnicoreDataMovementTupleSchemeFactory
    implements SchemeFactory {
        private UnicoreDataMovementTupleSchemeFactory() {
        }

        public UnicoreDataMovementTupleScheme getScheme() {
            return new UnicoreDataMovementTupleScheme();
        }
    }

    private static class UnicoreDataMovementStandardScheme
    extends StandardScheme<UnicoreDataMovement> {
        private UnicoreDataMovementStandardScheme() {
        }

        public void read(TProtocol iprot, UnicoreDataMovement struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 11) {
                            struct.dataMovementInterfaceId = iprot.readString();
                            struct.setDataMovementInterfaceIdIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 8) {
                            struct.securityProtocol = SecurityProtocol.findByValue(iprot.readI32());
                            struct.setSecurityProtocolIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 11) {
                            struct.unicoreEndPointURL = iprot.readString();
                            struct.setUnicoreEndPointURLIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        public void write(TProtocol oprot, UnicoreDataMovement struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.dataMovementInterfaceId != null) {
                oprot.writeFieldBegin(DATA_MOVEMENT_INTERFACE_ID_FIELD_DESC);
                oprot.writeString(struct.dataMovementInterfaceId);
                oprot.writeFieldEnd();
            }
            if (struct.securityProtocol != null) {
                oprot.writeFieldBegin(SECURITY_PROTOCOL_FIELD_DESC);
                oprot.writeI32(struct.securityProtocol.getValue());
                oprot.writeFieldEnd();
            }
            if (struct.unicoreEndPointURL != null) {
                oprot.writeFieldBegin(UNICORE_END_POINT_URL_FIELD_DESC);
                oprot.writeString(struct.unicoreEndPointURL);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class UnicoreDataMovementStandardSchemeFactory
    implements SchemeFactory {
        private UnicoreDataMovementStandardSchemeFactory() {
        }

        public UnicoreDataMovementStandardScheme getScheme() {
            return new UnicoreDataMovementStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        DATA_MOVEMENT_INTERFACE_ID(1, "dataMovementInterfaceId"),
        SECURITY_PROTOCOL(2, "securityProtocol"),
        UNICORE_END_POINT_URL(3, "unicoreEndPointURL");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return DATA_MOVEMENT_INTERFACE_ID;
                }
                case 2: {
                    return SECURITY_PROTOCOL;
                }
                case 3: {
                    return UNICORE_END_POINT_URL;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

