/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.uftp.dpc;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

public class Utils {
    private static final String algo = "Blowfish";
    private static final String keyAlgo = "Blowfish";
    private static final String mode = "ECB";
    private static final String padding = "PKCS5Padding";
    private static KeyGenerator keyGenerator;
    private static final ScheduledExecutorService executor;
    private static Set<String> whiteList;
    private static final Pattern pattern;

    public static InputStream getDecryptStream(InputStream source, byte[] key) throws IOException {
        try {
            return new CipherInputStream(source, Utils.makeDecryptionCipher(key));
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }

    public static OutputStream getEncryptStream(OutputStream sink, byte[] key) throws IOException {
        try {
            return new CipherOutputStream(sink, Utils.makeEncryptionCipher(key));
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }

    public static OutputStream getCompressStream(OutputStream sink) throws IOException {
        try {
            return new GZIPOutputStream(sink);
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }

    public static InputStream getDecompressStream(InputStream source) throws IOException {
        try {
            return new GZIPInputStream(source);
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }

    public static String encodeBase64(byte[] data) {
        if (data == null) {
            return null;
        }
        return new String(Base64.encodeBase64((byte[])data));
    }

    public static byte[] decodeBase64(String base64) {
        if (base64 == null) {
            return null;
        }
        return Base64.decodeBase64((byte[])base64.getBytes());
    }

    public static Cipher makeEncryptionCipher(byte[] encodedKey) throws Exception {
        Cipher c = Cipher.getInstance("Blowfish/ECB/PKCS5Padding");
        SecretKeySpec keySpec = new SecretKeySpec(encodedKey, "Blowfish");
        c.init(1, keySpec);
        return c;
    }

    public static Cipher makeDecryptionCipher(byte[] encodedKey) throws Exception {
        Cipher c = Cipher.getInstance("Blowfish/ECB/PKCS5Padding");
        SecretKeySpec keySpec = new SecretKeySpec(encodedKey, "Blowfish");
        c.init(2, keySpec);
        return c;
    }

    public static byte[] createKey() throws InvalidKeySpecException, NoSuchAlgorithmException, NoSuchProviderException {
        SecretKey key = keyGenerator.generateKey();
        return key.getEncoded();
    }

    public static String md5(File file) throws Exception {
        return Utils.hexString(Utils.digest(file));
    }

    public static String md5(byte[] data) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(data);
            return Utils.hexString(md);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToFile(String content, File target) throws IOException {
        FileOutputStream o = new FileOutputStream(target);
        try {
            o.write(content.getBytes());
        }
        finally {
            o.close();
        }
    }

    private static MessageDigest digest(File file) throws Exception {
        FileInputStream fis = new FileInputStream(file);
        byte[] buf = new byte[1024];
        int r = 0;
        MessageDigest md = MessageDigest.getInstance("MD5");
        while ((r = fis.read(buf)) >= 0) {
            md.update(buf, 0, r);
        }
        fis.close();
        return md;
    }

    public static String hexString(MessageDigest digest) {
        return Utils.hexString(digest.digest());
    }

    public static String hexString(byte[] bytes) {
        StringBuilder hexString = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            String hex = Integer.toHexString(0xFF & bytes[i]);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }

    public static ScheduledExecutorService getExecutor() {
        return executor;
    }

    public static synchronized Set<String> getWhiteList() {
        if (whiteList == null) {
            whiteList = new HashSet<String>();
        }
        return whiteList;
    }

    public static String getDetailMessage(Throwable throwable) {
        StringBuilder sb = new StringBuilder();
        Throwable cause = throwable;
        String message = null;
        String type = null;
        type = cause.getClass().getName();
        do {
            type = cause.getClass().getName();
            message = cause.getMessage();
        } while ((cause = cause.getCause()) != null);
        sb.append(type).append(" ");
        if (message != null) {
            sb.append(message);
        } else {
            sb.append(" (no further message available)");
        }
        return sb.toString();
    }

    public static String createFaultMessage(String message, Throwable cause) {
        return message + ": " + Utils.getDetailMessage(cause);
    }

    public static String trim(String s) {
        int begin = s.startsWith("\"") ? 1 : 0;
        int end = s.endsWith("\"") ? s.length() - 1 : s.length();
        return s.substring(begin, end);
    }

    public static List<String> parseLine(String line) {
        ArrayList<String> result = new ArrayList<String>();
        Matcher matcher = pattern.matcher(line);
        while (matcher.find()) {
            if (matcher.group(1) != null) {
                result.add(matcher.group(1));
                continue;
            }
            if (matcher.group(2) != null) {
                result.add(matcher.group(2));
                continue;
            }
            result.add(matcher.group());
        }
        return result;
    }

    static {
        try {
            keyGenerator = KeyGenerator.getInstance("Blowfish");
            keyGenerator.init(new SecureRandom());
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        executor = new ScheduledThreadPoolExecutor(10);
        pattern = Pattern.compile("[^\\s\"']+|\"([^\"]*)\"|'([^']*)'");
    }
}

