/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.util;

import io.airlift.airline.Option;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;
import org.apache.activemq.artemis.cli.commands.Action;
import org.apache.activemq.artemis.cli.commands.InvalidOptionsError;

public class OptionsUtil {
    public static void findAllOptions(Set<String> options, Class<? extends Action> command) {
        for (Field field : command.getDeclaredFields()) {
            String[] names;
            if (!field.isAnnotationPresent(Option.class)) continue;
            Option annotation = field.getAnnotation(Option.class);
            for (String n : names = annotation.name()) {
                options.add(n);
            }
        }
        Class<? extends Action> parent = command.getSuperclass();
        if (Action.class.isAssignableFrom(parent)) {
            OptionsUtil.findAllOptions(options, parent);
        }
    }

    public static Set<String> findCommandOptions(Class<? extends Action> command) {
        HashSet<String> options = new HashSet<String>();
        OptionsUtil.findAllOptions(options, command);
        return options;
    }

    public static void checkCommandOptions(Class<? extends Action> cmdClass, String[] options) throws InvalidOptionsError {
        Set<String> definedOptions = OptionsUtil.findCommandOptions(cmdClass);
        for (String opt : options) {
            if (!opt.startsWith("--") || "--".equals(opt.trim())) continue;
            int index = opt.indexOf("=");
            if (index > 0) {
                opt = opt.substring(0, index);
            }
            if (definedOptions.contains(opt)) continue;
            throw new InvalidOptionsError("Found unexpected parameters: [" + opt + "]");
        }
    }
}

