/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.tools;

import io.airlift.airline.Command;
import io.airlift.airline.Option;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.stax.StAXSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientRequestor;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.api.core.management.ManagementHelper;
import org.apache.activemq.artemis.cli.commands.ActionAbstract;
import org.apache.activemq.artemis.cli.commands.ActionContext;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyConnectorFactory;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.utils.Base64;
import org.apache.activemq.artemis.utils.ClassloadingUtil;
import org.apache.activemq.artemis.utils.ListUtil;
import org.apache.activemq.artemis.utils.UUIDGenerator;
import org.jboss.logging.Logger;

@Command(name="imp", description="Import all message-data using an XML that could be interpreted by any system.")
public final class XmlDataImporter
extends ActionAbstract {
    private static final Logger logger = Logger.getLogger(XmlDataImporter.class);
    private XMLStreamReader reader;
    ClientSession managementSession;
    boolean localSession = false;
    final Map<String, String> addressMap = new HashMap<String, String>();
    final Map<String, Long> queueIDs = new HashMap<String, Long>();
    String tempFileName = "";
    private ClientSession session;
    @Option(name={"--host"}, description="The host used to import the data (default localhost)")
    public String host = "localhost";
    @Option(name={"--port"}, description="The port used to import the data (default 61616)")
    public int port = 61616;
    @Option(name={"--transaction"}, description="If this is set to true you will need a whole transaction to commit at the end. (default false)")
    public boolean transactional;
    @Option(name={"--user"}, description="User name used to import the data. (default null)")
    public String user = null;
    @Option(name={"--password"}, description="User name used to import the data. (default null)")
    public String password = null;
    @Option(name={"--input"}, description="The input file name (default=exp.dmp)", required=true)
    public String input = "exp.dmp";

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    @Override
    public Object execute(ActionContext context) throws Exception {
        this.process(this.input, this.host, this.port, this.transactional);
        return null;
    }

    public void process(String inputFile, String host, int port, boolean transactional) throws Exception {
        this.process(new FileInputStream(inputFile), host, port, transactional);
    }

    public void process(InputStream inputStream, ClientSession session) throws Exception {
        this.process(inputStream, session, null);
    }

    public void process(InputStream inputStream, ClientSession session, ClientSession managementSession) throws Exception {
        this.reader = XMLInputFactory.newInstance().createXMLStreamReader(inputStream);
        this.session = session;
        this.managementSession = managementSession != null ? managementSession : session;
        this.processXml();
    }

    public void process(InputStream inputStream, String host, int port, boolean transactional) throws Exception {
        ClientSession managementSession;
        ClientSession session;
        HashMap<String, String> connectionParams = new HashMap<String, String>();
        connectionParams.put("host", host);
        connectionParams.put("port", Integer.toString(port));
        ServerLocator serverLocator = ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{new TransportConfiguration(NettyConnectorFactory.class.getName(), connectionParams)});
        ClientSessionFactory sf = serverLocator.createSessionFactory();
        if (this.user != null || this.password != null) {
            session = sf.createSession(this.user, this.password, false, !transactional, true, false, 0);
            managementSession = sf.createSession(this.user, this.password, false, true, true, false, 0);
        } else {
            session = sf.createSession(false, !transactional, true);
            managementSession = sf.createSession(false, true, true);
        }
        this.localSession = true;
        this.process(inputStream, session, managementSession);
    }

    public void validate(String file) throws Exception {
        this.validate(new FileInputStream(file));
    }

    public void validate(InputStream inputStream) throws Exception {
        XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(inputStream);
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = factory.newSchema(XmlDataImporter.findResource("schema/artemis-import-export.xsd"));
        Validator validator = schema.newValidator();
        validator.validate(new StAXSource(reader));
        reader.close();
    }

    private static URL findResource(final String resourceName) {
        return AccessController.doPrivileged(new PrivilegedAction<URL>(){

            @Override
            public URL run() {
                return ClassloadingUtil.findResource((String)resourceName);
            }
        });
    }

    private void processXml() throws Exception {
        try {
            while (this.reader.hasNext()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("EVENT:[" + this.reader.getLocation().getLineNumber() + "][" + this.reader.getLocation().getColumnNumber() + "] "));
                }
                if (this.reader.getEventType() == 1) {
                    if ("queue-binding".equals(this.reader.getLocalName())) {
                        this.bindQueue();
                    } else if ("address-binding".equals(this.reader.getLocalName())) {
                        this.bindAddress();
                    } else if ("message".equals(this.reader.getLocalName())) {
                        this.processMessage();
                    }
                }
                this.reader.next();
            }
            if (!this.session.isAutoCommitSends()) {
                this.session.commit();
            }
        }
        finally {
            if (this.localSession) {
                this.session.close();
                this.managementSession.close();
            }
        }
    }

    private void processMessage() throws Exception {
        Byte type = 0;
        Byte priority = 0;
        Long expiration = 0L;
        Long timestamp = 0L;
        org.apache.activemq.artemis.utils.UUID userId = null;
        ArrayList<String> queues = new ArrayList<String>();
        block18: for (int i = 0; i < this.reader.getAttributeCount(); ++i) {
            String attributeName;
            switch (attributeName = this.reader.getAttributeLocalName(i)) {
                case "type": {
                    type = this.getMessageType(this.reader.getAttributeValue(i));
                    continue block18;
                }
                case "priority": {
                    priority = Byte.parseByte(this.reader.getAttributeValue(i));
                    continue block18;
                }
                case "expiration": {
                    expiration = Long.parseLong(this.reader.getAttributeValue(i));
                    continue block18;
                }
                case "timestamp": {
                    timestamp = Long.parseLong(this.reader.getAttributeValue(i));
                    continue block18;
                }
                case "user-id": {
                    userId = UUIDGenerator.getInstance().generateUUID();
                }
            }
        }
        ClientMessage message = this.session.createMessage(type.byteValue(), true, expiration.longValue(), timestamp.longValue(), priority.byteValue());
        message.setUserID(userId);
        boolean endLoop = false;
        while (this.reader.hasNext()) {
            int eventType = this.reader.getEventType();
            switch (eventType) {
                case 1: {
                    if ("body".equals(this.reader.getLocalName())) {
                        this.processMessageBody(message.toCore());
                        break;
                    }
                    if ("property".equals(this.reader.getLocalName())) {
                        this.processMessageProperties((Message)message);
                        break;
                    }
                    if (!"queue".equals(this.reader.getLocalName())) break;
                    this.processMessageQueues(queues);
                    break;
                }
                case 2: {
                    if (!"message".equals(this.reader.getLocalName())) break;
                    endLoop = true;
                }
            }
            if (endLoop) break;
            this.reader.next();
        }
        this.sendMessage(queues, (Message)message);
    }

    private Byte getMessageType(String value) {
        Byte type = 0;
        switch (value) {
            case "default": {
                type = 0;
                break;
            }
            case "bytes": {
                type = 4;
                break;
            }
            case "map": {
                type = 5;
                break;
            }
            case "object": {
                type = 2;
                break;
            }
            case "stream": {
                type = 6;
                break;
            }
            case "text": {
                type = 3;
            }
        }
        return type;
    }

    private void sendMessage(ArrayList<String> queues, Message message) throws Exception {
        StringBuilder logMessage = new StringBuilder();
        String destination = this.addressMap.get(queues.get(0));
        logMessage.append("Sending ").append(message).append(" to address: ").append(destination).append("; routed to queues: ");
        ByteBuffer buffer = ByteBuffer.allocate(queues.size() * 8);
        for (String queue : queues) {
            long queueID;
            if (this.queueIDs.containsKey(queue)) {
                queueID = this.queueIDs.get(queue);
            } else {
                try (ClientRequestor requestor = new ClientRequestor(this.managementSession, "activemq.management");){
                    ClientMessage managementMessage = this.managementSession.createMessage(false);
                    ManagementHelper.putAttribute((ICoreMessage)managementMessage, (String)("queue." + queue), (String)"ID");
                    this.managementSession.start();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Requesting ID for: " + queue));
                    }
                    ClientMessage reply = requestor.request(managementMessage);
                    Number idObject = (Number)ManagementHelper.getResult((ICoreMessage)reply);
                    queueID = idObject.longValue();
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("ID for " + queue + " is: " + queueID));
                }
                this.queueIDs.put(queue, queueID);
            }
            logMessage.append(queue).append(", ");
            buffer.putLong(queueID);
        }
        logMessage.delete(logMessage.length() - 2, logMessage.length());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)logMessage);
        }
        message.putBytesProperty(Message.HDR_ROUTE_TO_IDS, buffer.array());
        try (ClientProducer producer = this.session.createProducer(destination);){
            producer.send(message);
        }
        if (this.tempFileName.length() > 0) {
            File tempFile = new File(this.tempFileName);
            if (!tempFile.delete()) {
                ActiveMQServerLogger.LOGGER.couldNotDeleteTempFile(this.tempFileName);
            }
            this.tempFileName = "";
        }
    }

    private void processMessageQueues(ArrayList<String> queues) {
        for (int i = 0; i < this.reader.getAttributeCount(); ++i) {
            if (!"name".equals(this.reader.getAttributeLocalName(i))) continue;
            queues.add(this.reader.getAttributeValue(i));
        }
    }

    private void processMessageProperties(Message message) {
        String key = "";
        String value = "";
        String propertyType = "";
        Object realStringValue = null;
        Object realSimpleStringValue = null;
        block34: for (int i = 0; i < this.reader.getAttributeCount(); ++i) {
            String attributeName;
            switch (attributeName = this.reader.getAttributeLocalName(i)) {
                case "name": {
                    key = this.reader.getAttributeValue(i);
                    continue block34;
                }
                case "value": {
                    value = this.reader.getAttributeValue(i);
                    continue block34;
                }
                case "type": {
                    propertyType = this.reader.getAttributeValue(i);
                }
            }
        }
        if (value.equals("_AMQ_NULL")) {
            value = null;
        }
        switch (propertyType) {
            case "short": {
                message.putShortProperty(key, Short.parseShort(value));
                break;
            }
            case "boolean": {
                message.putBooleanProperty(key, Boolean.parseBoolean(value));
                break;
            }
            case "byte": {
                message.putByteProperty(key, Byte.parseByte(value));
                break;
            }
            case "bytes": {
                message.putBytesProperty(key, value == null ? null : XmlDataImporter.decode(value));
                break;
            }
            case "double": {
                message.putDoubleProperty(key, Double.parseDouble(value));
                break;
            }
            case "float": {
                message.putFloatProperty(key, Float.parseFloat(value));
                break;
            }
            case "integer": {
                message.putIntProperty(key, Integer.parseInt(value));
                break;
            }
            case "long": {
                message.putLongProperty(key, Long.parseLong(value));
                break;
            }
            case "simple-string": {
                message.putStringProperty(new SimpleString(key), value == null ? null : SimpleString.toSimpleString((String)value));
                break;
            }
            case "string": {
                message.putStringProperty(key, value);
            }
        }
    }

    private void processMessageBody(final ICoreMessage message) throws XMLStreamException, IOException {
        Object attributeName;
        boolean isLarge = false;
        for (int i = 0; i < this.reader.getAttributeCount(); ++i) {
            attributeName = this.reader.getAttributeLocalName(i);
            if (!"isLarge".equals(attributeName)) continue;
            isLarge = Boolean.parseBoolean(this.reader.getAttributeValue(i));
        }
        this.reader.next();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("XMLStreamReader impl: " + this.reader));
        }
        if (isLarge) {
            this.tempFileName = UUID.randomUUID().toString() + ".tmp";
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Creating temp file " + this.tempFileName + " for large message."));
            }
            final FileOutputStream out = new FileOutputStream(this.tempFileName);
            attributeName = null;
            try {
                this.getMessageBodyBytes(new MessageBodyBytesProcessor(){

                    @Override
                    public void processBodyBytes(byte[] bytes) throws IOException {
                        out.write(bytes);
                    }
                });
            }
            catch (Throwable throwable) {
                attributeName = throwable;
                throw throwable;
            }
            finally {
                if (out != null) {
                    if (attributeName != null) {
                        try {
                            ((OutputStream)out).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)attributeName).addSuppressed(throwable);
                        }
                    } else {
                        ((OutputStream)out).close();
                    }
                }
            }
            FileInputStream fileInputStream = new FileInputStream(this.tempFileName);
            BufferedInputStream bufferedInput = new BufferedInputStream(fileInputStream);
            ((ClientMessage)message).setBodyInputStream((InputStream)bufferedInput);
        } else {
            this.getMessageBodyBytes(new MessageBodyBytesProcessor(){

                @Override
                public void processBodyBytes(byte[] bytes) throws IOException {
                    message.getBodyBuffer().writeBytes(bytes);
                }
            });
        }
    }

    private void getMessageBodyBytes(MessageBodyBytesProcessor processor) throws IOException, XMLStreamException {
        int currentEventType;
        StringBuilder cdata = new StringBuilder();
        while (this.reader.hasNext() && (currentEventType = this.reader.getEventType()) != 2) {
            if (currentEventType == 4 && this.reader.isWhiteSpace() && cdata.length() > 0) {
                processor.processBodyBytes(XmlDataImporter.decode(cdata.toString()));
                cdata.setLength(0);
            } else {
                cdata.append(new String(this.reader.getTextCharacters(), this.reader.getTextStart(), this.reader.getTextLength()).trim());
            }
            this.reader.next();
        }
    }

    private void bindQueue() throws Exception {
        String queueName = "";
        String address = "";
        String filter = "";
        String routingType = "";
        block12: for (int i = 0; i < this.reader.getAttributeCount(); ++i) {
            String attributeName;
            switch (attributeName = this.reader.getAttributeLocalName(i)) {
                case "address": {
                    address = this.reader.getAttributeValue(i);
                    continue block12;
                }
                case "name": {
                    queueName = this.reader.getAttributeValue(i);
                    continue block12;
                }
                case "filter-string": {
                    filter = this.reader.getAttributeValue(i);
                    continue block12;
                }
                case "routing-type": {
                    routingType = this.reader.getAttributeValue(i);
                }
            }
        }
        ClientSession.QueueQuery queueQuery = this.session.queueQuery(new SimpleString(queueName));
        if (!queueQuery.isExists()) {
            this.session.createQueue(address, RoutingType.valueOf((String)routingType), queueName, filter, true);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Binding queue(name=" + queueName + ", address=" + address + ", filter=" + filter + ")"));
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("Binding " + queueName + " already exists so won't re-bind."));
        }
        this.addressMap.put(queueName, address);
    }

    private void bindAddress() throws Exception {
        String addressName = "";
        String routingTypes = "";
        block8: for (int i = 0; i < this.reader.getAttributeCount(); ++i) {
            String attributeName = this.reader.getAttributeLocalName(i);
            switch (attributeName) {
                case "name": {
                    addressName = this.reader.getAttributeValue(i);
                    continue block8;
                }
                case "routing-types": {
                    routingTypes = this.reader.getAttributeValue(i);
                }
            }
        }
        ClientSession.AddressQuery addressQuery = this.session.addressQuery(new SimpleString(addressName));
        if (!addressQuery.isExists()) {
            HashSet<RoutingType> set = new HashSet<RoutingType>();
            for (String routingType : ListUtil.toList((String)routingTypes)) {
                set.add(RoutingType.valueOf((String)routingType));
            }
            this.session.createAddress(SimpleString.toSimpleString((String)addressName), set, false);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Binding address(name=" + addressName + ", routingTypes=" + routingTypes + ")"));
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("Binding " + addressName + " already exists so won't re-bind."));
        }
    }

    private String getEntries() throws Exception {
        StringBuilder entry = new StringBuilder();
        boolean endLoop = false;
        while (this.reader.hasNext()) {
            int eventType = this.reader.getEventType();
            switch (eventType) {
                case 1: {
                    if (!"entry".equals(this.reader.getLocalName())) break;
                    String elementText = this.reader.getElementText();
                    entry.append(elementText).append(", ");
                    if (!logger.isDebugEnabled()) break;
                    logger.debug((Object)("JMS admin object JNDI entry: " + entry.toString()));
                    break;
                }
                case 2: {
                    if (!"entries".equals(this.reader.getLocalName())) break;
                    endLoop = true;
                }
            }
            if (endLoop) break;
            this.reader.next();
        }
        return entry.delete(entry.length() - 2, entry.length()).toString();
    }

    private String getConnectors() throws Exception {
        StringBuilder entry = new StringBuilder();
        boolean endLoop = false;
        while (this.reader.hasNext()) {
            int eventType = this.reader.getEventType();
            switch (eventType) {
                case 1: {
                    if (!"connector".equals(this.reader.getLocalName())) break;
                    entry.append(this.reader.getElementText()).append(", ");
                    break;
                }
                case 2: {
                    if (!"connectors".equals(this.reader.getLocalName())) break;
                    endLoop = true;
                }
            }
            if (endLoop) break;
            this.reader.next();
        }
        return entry.delete(entry.length() - 2, entry.length()).toString();
    }

    private static byte[] decode(String data) {
        return Base64.decode((String)data, (int)24);
    }

    private static interface MessageBodyBytesProcessor {
        public void processBodyBytes(byte[] var1) throws IOException;
    }
}

