/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.cli.kahadb.exporter.artemis;

import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.cli.commands.tools.XmlDataExporterUtil;
import org.apache.activemq.artemis.core.protocol.openwire.OpenWireMessageConverter;
import org.apache.activemq.artemis.jms.client.ActiveMQDestination;
import org.apache.activemq.cli.kahadb.exporter.OpenWireExportConverter;
import org.apache.activemq.cli.schema.BodyType;
import org.apache.activemq.cli.schema.MessageType;
import org.apache.activemq.cli.schema.PropertiesType;
import org.apache.activemq.cli.schema.PropertyType;
import org.apache.activemq.cli.schema.QueueType;
import org.apache.activemq.cli.schema.QueuesType;
import org.apache.activemq.openwire.OpenWireFormat;
import org.apache.activemq.store.kahadb.KahaDBStore;
import org.apache.activemq.store.kahadb.KahaDBUtil;
import org.apache.activemq.wireformat.WireFormat;

public class OpenWireCoreMessageTypeConverter
implements OpenWireExportConverter<MessageType> {
    private final OpenWireMessageConverter converter = new OpenWireMessageConverter((WireFormat)new OpenWireFormat());
    private final KahaDBStore store;

    public OpenWireCoreMessageTypeConverter(KahaDBStore store) {
        this.store = store;
    }

    public OpenWireCoreMessageTypeConverter() {
        this(null);
    }

    @Override
    public MessageType convert(org.apache.activemq.command.Message message) throws Exception {
        ICoreMessage serverMessage = (ICoreMessage)this.converter.inbound((Object)message);
        MessageType messageType = this.convertAttributes(serverMessage);
        try {
            if (!message.getProperties().isEmpty()) {
                PropertiesType propertiesType = new PropertiesType();
                serverMessage.getPropertyNames().forEach(key -> {
                    Object value = serverMessage.getObjectProperty(key);
                    propertiesType.getProperty().add(PropertyType.builder().withName(key.toString()).withValueAttribute(XmlDataExporterUtil.convertProperty((Object)value)).withType(XmlDataExporterUtil.getPropertyType((Object)value)).build());
                });
                messageType.setProperties(propertiesType);
            }
            messageType.setQueues(this.convertQueues(message));
            messageType.setBody(this.convertBody(serverMessage));
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        return messageType;
    }

    private QueuesType convertQueues(org.apache.activemq.command.Message message) throws Exception {
        if (this.store == null || message.getDestination().isQueue()) {
            return QueuesType.builder().withQueue(QueueType.builder().withName(message.getDestination().getPhysicalName()).build()).build();
        }
        QueuesType.Builder<Void> queuesBuilder = QueuesType.builder();
        KahaDBUtil.getUnackedSubscriptions(this.store, message).forEach(sub -> queuesBuilder.addQueue(QueueType.builder().withName(ActiveMQDestination.createQueueNameForDurableSubscription((boolean)true, (String)sub.getClientId(), (String)sub.getSubcriptionName())).build()));
        return queuesBuilder.build();
    }

    private BodyType convertBody(ICoreMessage serverMessage) throws Exception {
        String value = XmlDataExporterUtil.encodeMessageBody((Message)serverMessage);
        return BodyType.builder().withValue("<![CDATA[" + value + "]]>").build();
    }

    private MessageType convertAttributes(ICoreMessage message) {
        MessageType messageType = MessageType.builder().withId(message.getMessageID()).withTimestamp(message.getTimestamp()).withPriority(message.getPriority()).withType(XmlDataExporterUtil.getMessagePrettyType((byte)message.getType())).build();
        return messageType;
    }
}

