/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.cli.kahadb.exporter.artemis;

import java.io.IOException;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.jms.client.ActiveMQDestination;
import org.apache.activemq.cli.artemis.schema.ArtemisJournalMarshaller;
import org.apache.activemq.cli.kahadb.exporter.MessageStoreMetadataExporter;
import org.apache.activemq.cli.schema.QueueBindingType;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.command.SubscriptionInfo;
import org.apache.activemq.store.kahadb.KahaDBStore;

public class ArtemisXmlMetadataExporter
implements MessageStoreMetadataExporter {
    private final KahaDBStore store;
    private final ArtemisJournalMarshaller xmlMarshaller;

    public ArtemisXmlMetadataExporter(KahaDBStore store, ArtemisJournalMarshaller xmlMarshaller) {
        this.store = store;
        this.xmlMarshaller = xmlMarshaller;
    }

    @Override
    public void export() throws IOException {
        this.store.getDestinations().stream().forEach(dest -> {
            try {
                if (dest.isQueue()) {
                    this.xmlMarshaller.appendBinding(QueueBindingType.builder().withName(dest.getPhysicalName()).withRoutingType(RoutingType.ANYCAST.toString()).withAddress(dest.getPhysicalName()).build());
                } else if (dest.isTopic()) {
                    for (SubscriptionInfo info : this.store.createTopicMessageStore((ActiveMQTopic)dest).getAllSubscriptions()) {
                        this.xmlMarshaller.appendBinding(QueueBindingType.builder().withName(ActiveMQDestination.createQueueNameForDurableSubscription((boolean)true, (String)info.getClientId(), (String)info.getSubcriptionName())).withRoutingType(RoutingType.MULTICAST.toString()).withAddress(dest.getPhysicalName()).build());
                    }
                }
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        });
    }
}

