/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.openwire;

import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.IllegalStateException;
import javax.jms.InvalidClientIDException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSSecurityException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.apache.activemq.advisory.AdvisorySupport;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQNonExistentQueueException;
import org.apache.activemq.artemis.api.core.ActiveMQSecurityException;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.io.IOCallback;
import org.apache.activemq.artemis.core.persistence.OperationContext;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.postoffice.Bindings;
import org.apache.activemq.artemis.core.postoffice.QueueBinding;
import org.apache.activemq.artemis.core.protocol.openwire.OpenWireProtocolManager;
import org.apache.activemq.artemis.core.protocol.openwire.amq.AMQCompositeConsumerBrokerExchange;
import org.apache.activemq.artemis.core.protocol.openwire.amq.AMQConnectionContext;
import org.apache.activemq.artemis.core.protocol.openwire.amq.AMQConsumer;
import org.apache.activemq.artemis.core.protocol.openwire.amq.AMQConsumerBrokerExchange;
import org.apache.activemq.artemis.core.protocol.openwire.amq.AMQProducerBrokerExchange;
import org.apache.activemq.artemis.core.protocol.openwire.amq.AMQSession;
import org.apache.activemq.artemis.core.protocol.openwire.amq.AMQSingleConsumerBrokerExchange;
import org.apache.activemq.artemis.core.protocol.openwire.util.OpenWireUtil;
import org.apache.activemq.artemis.core.remoting.FailureListener;
import org.apache.activemq.artemis.core.security.CheckType;
import org.apache.activemq.artemis.core.security.SecurityAuth;
import org.apache.activemq.artemis.core.server.ActiveMQMessageBundle;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.BindingQueryResult;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.ServerConsumer;
import org.apache.activemq.artemis.core.server.ServerSession;
import org.apache.activemq.artemis.core.server.SlowConsumerDetectionListener;
import org.apache.activemq.artemis.core.server.TempQueueObserver;
import org.apache.activemq.artemis.core.server.impl.RefsOperation;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.core.transaction.TransactionOperation;
import org.apache.activemq.artemis.core.transaction.TransactionOperationAbstract;
import org.apache.activemq.artemis.core.transaction.impl.XidImpl;
import org.apache.activemq.artemis.jms.client.ActiveMQDestination;
import org.apache.activemq.artemis.spi.core.protocol.AbstractRemotingConnection;
import org.apache.activemq.artemis.spi.core.protocol.ConnectionEntry;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.remoting.Connection;
import org.apache.activemq.artemis.utils.ConcurrentHashSet;
import org.apache.activemq.artemis.utils.UUIDGenerator;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.ActiveMQTempQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.command.BrokerInfo;
import org.apache.activemq.command.BrokerSubscriptionInfo;
import org.apache.activemq.command.Command;
import org.apache.activemq.command.ConnectionControl;
import org.apache.activemq.command.ConnectionError;
import org.apache.activemq.command.ConnectionId;
import org.apache.activemq.command.ConnectionInfo;
import org.apache.activemq.command.ConsumerControl;
import org.apache.activemq.command.ConsumerId;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.ControlCommand;
import org.apache.activemq.command.DataArrayResponse;
import org.apache.activemq.command.DataStructure;
import org.apache.activemq.command.DestinationInfo;
import org.apache.activemq.command.ExceptionResponse;
import org.apache.activemq.command.FlushCommand;
import org.apache.activemq.command.IntegerResponse;
import org.apache.activemq.command.KeepAliveInfo;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.MessageDispatch;
import org.apache.activemq.command.MessageDispatchNotification;
import org.apache.activemq.command.MessagePull;
import org.apache.activemq.command.ProducerAck;
import org.apache.activemq.command.ProducerId;
import org.apache.activemq.command.ProducerInfo;
import org.apache.activemq.command.RemoveSubscriptionInfo;
import org.apache.activemq.command.Response;
import org.apache.activemq.command.SessionId;
import org.apache.activemq.command.SessionInfo;
import org.apache.activemq.command.ShutdownInfo;
import org.apache.activemq.command.TransactionId;
import org.apache.activemq.command.TransactionInfo;
import org.apache.activemq.command.WireFormatInfo;
import org.apache.activemq.command.XATransactionId;
import org.apache.activemq.openwire.OpenWireFormat;
import org.apache.activemq.state.CommandVisitor;
import org.apache.activemq.state.ConnectionState;
import org.apache.activemq.state.ConsumerState;
import org.apache.activemq.state.ProducerState;
import org.apache.activemq.state.SessionState;
import org.apache.activemq.transport.TransmitCallback;
import org.apache.activemq.util.ByteSequence;
import org.apache.activemq.wireformat.WireFormat;
import org.jboss.logging.Logger;

public class OpenWireConnection
extends AbstractRemotingConnection
implements SecurityAuth,
TempQueueObserver {
    private static final Logger logger = Logger.getLogger(OpenWireConnection.class);
    private static final KeepAliveInfo PING = new KeepAliveInfo();
    private final OpenWireProtocolManager protocolManager;
    private boolean destroyed = false;
    private final Object sendLock = new Object();
    private final OpenWireFormat wireFormat;
    private AMQConnectionContext context;
    private final AtomicBoolean stopping = new AtomicBoolean(false);
    private final Map<String, SessionId> sessionIdMap = new ConcurrentHashMap<String, SessionId>();
    private final Map<ConsumerId, AMQConsumerBrokerExchange> consumerExchanges = new ConcurrentHashMap<ConsumerId, AMQConsumerBrokerExchange>();
    private final Map<ProducerId, AMQProducerBrokerExchange> producerExchanges = new ConcurrentHashMap<ProducerId, AMQProducerBrokerExchange>();
    private final Map<SessionId, AMQSession> sessions = new ConcurrentHashMap<SessionId, AMQSession>();
    private ConnectionState state;
    private volatile boolean noLocal;
    private final Map<TransactionId, Transaction> txMap = new ConcurrentHashMap<TransactionId, Transaction>();
    private volatile AMQSession advisorySession;
    private final ActiveMQServer server;
    private ServerSession internalSession;
    private final OperationContext operationContext;
    private volatile long lastSent = -1L;
    private ConnectionEntry connectionEntry;
    private boolean useKeepAlive;
    private long maxInactivityDuration;
    private final Set<SimpleString> knownDestinations = new ConcurrentHashSet();
    private AtomicBoolean disableTtl = new AtomicBoolean(false);
    CommandProcessor commandProcessorInstance = new CommandProcessor();

    public OpenWireConnection(Connection connection, ActiveMQServer server, Executor executor, OpenWireProtocolManager openWireProtocolManager, OpenWireFormat wf) {
        super(connection, executor);
        this.server = server;
        this.operationContext = server.newOperationContext();
        this.protocolManager = openWireProtocolManager;
        this.wireFormat = wf;
        this.useKeepAlive = openWireProtocolManager.isUseKeepAlive();
        this.maxInactivityDuration = openWireProtocolManager.getMaxInactivityDuration();
    }

    public String getUsername() {
        ConnectionInfo info = this.getConnectionInfo();
        if (info == null) {
            return null;
        }
        return info.getUserName();
    }

    public OperationContext getOperationContext() {
        return this.operationContext;
    }

    public RemotingConnection getRemotingConnection() {
        return this;
    }

    public String getPassword() {
        ConnectionInfo info = this.getConnectionInfo();
        if (info == null) {
            return null;
        }
        return info.getPassword();
    }

    private ConnectionInfo getConnectionInfo() {
        if (this.state == null) {
            return null;
        }
        ConnectionInfo info = this.state.getInfo();
        if (info == null) {
            return null;
        }
        return info;
    }

    public void bufferSent() {
        this.lastSent = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bufferReceived(Object connectionID, ActiveMQBuffer buffer) {
        block14: {
            super.bufferReceived(connectionID, buffer);
            try {
                this.recoverOperationContext();
                Command command = (Command)this.wireFormat.unmarshal((DataInput)buffer);
                boolean responseRequired = command.isResponseRequired();
                int commandId = command.getCommandId();
                if (command.getClass() == KeepAliveInfo.class) break block14;
                Response response = null;
                try {
                    this.setLastCommand(command);
                    response = command.visit((CommandVisitor)this.commandProcessorInstance);
                }
                catch (Exception e) {
                    ActiveMQServerLogger.LOGGER.warn((Object)"Errors occurred during the buffering operation ", (Throwable)e);
                    if (responseRequired) {
                        response = this.convertException(e);
                    }
                }
                finally {
                    this.setLastCommand(null);
                }
                if (response instanceof ExceptionResponse && !responseRequired) {
                    Throwable cause = ((ExceptionResponse)response).getException();
                    this.serviceException(cause);
                    response = null;
                }
                if (responseRequired && response == null) {
                    response = new Response();
                    response.setCorrelationId(commandId);
                }
                if (this.context != null && this.context.isDontSendReponse()) {
                    this.context.setDontSendReponse(false);
                    response = null;
                }
                this.sendAsyncResponse(commandId, response);
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.debug((Object)e);
                this.sendException(e);
            }
            finally {
                this.clearupOperationContext();
            }
        }
    }

    private void sendAsyncResponse(final int commandId, final Response response) throws Exception {
        if (response != null) {
            this.operationContext.executeOnCompletion(new IOCallback(){

                public void done() {
                    if (!OpenWireConnection.this.protocolManager.isStopping()) {
                        try {
                            response.setCorrelationId(commandId);
                            OpenWireConnection.this.dispatchSync((Command)response);
                        }
                        catch (Exception e) {
                            OpenWireConnection.this.sendException(e);
                        }
                    }
                }

                public void onError(int errorCode, String errorMessage) {
                    OpenWireConnection.this.sendException(new IOException(errorCode + "-" + errorMessage));
                }
            });
        }
    }

    public void sendException(Exception e) {
        Command command;
        Response resp = this.convertException(e);
        if (this.context != null && (command = this.context.getLastCommand()) != null) {
            resp.setCorrelationId(command.getCommandId());
        }
        try {
            this.dispatch((Command)resp);
        }
        catch (IOException e2) {
            ActiveMQServerLogger.LOGGER.warn((Object)e.getMessage(), (Throwable)e2);
        }
    }

    private Response convertException(Exception e) {
        ExceptionResponse resp = e instanceof ActiveMQSecurityException ? new ExceptionResponse((Throwable)new JMSSecurityException(e.getMessage())) : (e instanceof ActiveMQNonExistentQueueException ? new ExceptionResponse((Throwable)new InvalidDestinationException(e.getMessage())) : new ExceptionResponse((Throwable)e));
        return resp;
    }

    private void setLastCommand(Command command) {
        if (this.context != null) {
            this.context.setLastCommand(command);
        }
    }

    public void destroy() {
        this.fail(null, null);
    }

    public boolean isClient() {
        return false;
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    public void disconnect(boolean criticalError) {
        this.disconnect(null, null, criticalError);
    }

    public void flush() {
        this.checkInactivity();
    }

    private void checkInactivity() {
        if (!this.useKeepAlive) {
            return;
        }
        long dur = System.currentTimeMillis() - this.lastSent;
        if (dur >= this.maxInactivityDuration / 2L) {
            this.sendCommand((Command)PING);
        }
    }

    private void callFailureListeners(ActiveMQException me) {
        ArrayList listenersClone = new ArrayList(this.failureListeners);
        for (FailureListener listener : listenersClone) {
            try {
                listener.connectionFailed(me, false);
            }
            catch (Throwable t) {
                ActiveMQServerLogger.LOGGER.errorCallingFailureListener(t);
            }
        }
    }

    public void sendHandshake() {
        WireFormatInfo info = this.wireFormat.getPreferedWireFormatInfo();
        this.sendCommand((Command)info);
    }

    public ConnectionState getState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void physicalSend(Command command) throws IOException {
        try {
            ByteSequence bytes = this.wireFormat.marshal((Object)command);
            ActiveMQBuffer buffer = OpenWireUtil.toActiveMQBuffer(bytes);
            Object object = this.sendLock;
            synchronized (object) {
                this.getTransportConnection().write(buffer, false, false);
            }
            this.bufferSent();
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable t) {
            ActiveMQServerLogger.LOGGER.error((Object)"error sending", t);
        }
    }

    public void dispatchAsync(Command message) throws Exception {
        this.dispatchSync(message);
    }

    public void dispatchSync(Command message) throws Exception {
        this.processDispatch(message);
    }

    public void serviceException(Throwable e) throws Exception {
        ConnectionError ce = new ConnectionError();
        ce.setException(e);
        this.dispatchAsync((Command)ce);
    }

    public void dispatch(Command command) throws IOException {
        this.physicalSend(command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processDispatch(Command command) throws IOException {
        MessageDispatch messageDispatch = (MessageDispatch)(command.isMessageDispatch() ? command : null);
        try {
            if (!this.stopping.get()) {
                if (messageDispatch != null) {
                    this.protocolManager.preProcessDispatch(messageDispatch);
                }
                this.dispatch(command);
            }
        }
        catch (IOException e) {
            if (messageDispatch != null) {
                TransmitCallback sub = messageDispatch.getTransmitCallback();
                this.protocolManager.postProcessDispatch(messageDispatch);
                if (sub != null) {
                    sub.onFailure();
                }
                messageDispatch = null;
                throw e;
            }
        }
        finally {
            if (messageDispatch != null) {
                TransmitCallback sub = messageDispatch.getTransmitCallback();
                this.protocolManager.postProcessDispatch(messageDispatch);
                if (sub != null) {
                    sub.onSuccess();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addConsumerBrokerExchange(ConsumerId id, AMQSession amqSession, List<AMQConsumer> consumerList) {
        AMQConsumerBrokerExchange result = this.consumerExchanges.get(id);
        if (result == null) {
            result = consumerList.size() == 1 ? new AMQSingleConsumerBrokerExchange(amqSession, consumerList.get(0)) : new AMQCompositeConsumerBrokerExchange(amqSession, consumerList);
            Map<ConsumerId, AMQConsumerBrokerExchange> map = this.consumerExchanges;
            synchronized (map) {
                this.consumerExchanges.put(id, result);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AMQProducerBrokerExchange getProducerBrokerExchange(ProducerId id) throws IOException {
        AMQProducerBrokerExchange result = this.producerExchanges.get(id);
        if (result == null) {
            Map<ProducerId, AMQProducerBrokerExchange> map = this.producerExchanges;
            synchronized (map) {
                SessionState ss;
                result = new AMQProducerBrokerExchange();
                result.setConnectionContext(this.context);
                if (this.context.isReconnect() || this.context.isNetworkConnection()) {
                    result.setLastStoredSequenceId(0L);
                }
                if ((ss = this.state.getSessionState(id.getParentId())) != null) {
                    result.setProducerState(ss.getProducerState(id));
                    ProducerState producerState = ss.getProducerState(id);
                    if (producerState != null && producerState.getInfo() != null) {
                        ProducerInfo producerInfo = producerState.getInfo();
                    }
                }
                this.producerExchanges.put(id, result);
            }
        }
        return result;
    }

    public void deliverMessage(MessageDispatch dispatch) {
        Message m = dispatch.getMessage();
        if (m != null) {
            long endTime = System.currentTimeMillis();
            m.setBrokerOutTime(endTime);
        }
        this.sendCommand((Command)dispatch);
    }

    public WireFormat getMarshaller() {
        return this.wireFormat;
    }

    private void shutdown(boolean fail) {
        if (fail) {
            this.transportConnection.forceClose();
        } else {
            this.transportConnection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnect(ActiveMQException me, String reason, boolean fail) {
        if (this.context == null || this.destroyed) {
            return;
        }
        this.state.shutdown();
        this.callFailureListeners(me);
        Object object = this.sendLock;
        synchronized (object) {
            this.callClosingListeners();
        }
        this.destroyed = true;
        Command command = this.context.getLastCommand();
        if (command != null && command.isResponseRequired()) {
            Response lastResponse = new Response();
            lastResponse.setCorrelationId(command.getCommandId());
            try {
                this.dispatchSync((Command)lastResponse);
            }
            catch (Throwable e) {
                ActiveMQServerLogger.LOGGER.warn((Object)e.getMessage(), e);
            }
        }
    }

    public void disconnect(String reason, boolean fail) {
        this.disconnect(null, reason, fail);
    }

    public void fail(ActiveMQException me, String message) {
        if (me != null) {
            ActiveMQServerLogger.LOGGER.connectionFailureDetected(me.getMessage(), me.getType());
        }
        try {
            this.protocolManager.removeConnection(this.getConnectionInfo(), (Throwable)me);
        }
        catch (InvalidClientIDException e) {
            ActiveMQServerLogger.LOGGER.warn((Object)"Couldn't close connection because invalid clientID", (Throwable)e);
        }
        this.shutdown(true);
    }

    public void setAdvisorySession(AMQSession amqSession) {
        this.advisorySession = amqSession;
    }

    public AMQSession getAdvisorySession() {
        return this.advisorySession;
    }

    public AMQConnectionContext getContext() {
        return this.context;
    }

    public void updateClient(ConnectionControl control) throws Exception {
        if (this.protocolManager.isUpdateClusterClients()) {
            this.dispatchAsync((Command)control);
        }
    }

    public AMQConnectionContext initContext(ConnectionInfo info) throws Exception {
        WireFormatInfo wireFormatInfo = this.wireFormat.getPreferedWireFormatInfo();
        if (wireFormatInfo != null && wireFormatInfo.getVersion() <= 2) {
            info.setClientMaster(true);
        }
        this.state = new ConnectionState(info);
        this.context = new AMQConnectionContext();
        this.state.reset(info);
        String clientId = info.getClientId();
        this.context.setBroker(this.protocolManager);
        this.context.setClientId(clientId);
        this.context.setClientMaster(info.isClientMaster());
        this.context.setConnection(this);
        this.context.setConnectionId(info.getConnectionId());
        this.context.setFaultTolerant(info.isFaultTolerant());
        this.context.setUserName(info.getUserName());
        this.context.setWireFormatInfo(wireFormatInfo);
        this.context.setReconnect(info.isFailoverReconnect());
        this.context.setConnectionState(this.state);
        if (info.getClientIp() == null) {
            info.setClientIp(this.getRemoteAddress());
        }
        this.createInternalSession(info);
        return this.context;
    }

    private void createInternalSession(ConnectionInfo info) throws Exception {
        this.internalSession = this.server.createSession(UUIDGenerator.getInstance().generateStringUUID(), this.context.getUserName(), info.getPassword(), -1, (RemotingConnection)this, true, false, false, false, null, null, true, this.operationContext, this.protocolManager.getPrefixes());
    }

    public void reconnect(AMQConnectionContext existingContext, ConnectionInfo info) {
        this.context = existingContext;
        WireFormatInfo wireFormatInfo = this.wireFormat.getPreferedWireFormatInfo();
        if (wireFormatInfo != null && wireFormatInfo.getVersion() <= 2) {
            info.setClientMaster(true);
        }
        if (info.getClientIp() == null) {
            info.setClientIp(this.getRemoteAddress());
        }
        this.state = new ConnectionState(info);
        this.state.reset(info);
        this.context.setConnection(this);
        this.context.setConnectionState(this.state);
        this.context.setClientMaster(info.isClientMaster());
        this.context.setFaultTolerant(info.isFaultTolerant());
        this.context.setReconnect(true);
        this.context.incRefCount();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean sendCommand(Command command) {
        if (ActiveMQServerLogger.LOGGER.isTraceEnabled()) {
            ActiveMQServerLogger.LOGGER.trace((Object)("sending " + command));
        }
        if (this.isDestroyed()) {
            return false;
        }
        try {
            this.physicalSend(command);
            return true;
        }
        catch (Exception e) {}
        finally {
            return false;
        }
    }

    public void addDestination(DestinationInfo info) throws Exception {
        org.apache.activemq.command.ActiveMQDestination dest = info.getDestination();
        if (dest.isQueue()) {
            SimpleString qName = new SimpleString(dest.getPhysicalName());
            QueueBinding binding = (QueueBinding)this.server.getPostOffice().getBinding(qName);
            if (binding == null) {
                if (dest.isTemporary()) {
                    this.internalSession.createQueue(qName, qName, RoutingType.ANYCAST, null, dest.isTemporary(), false);
                } else {
                    ConnectionInfo connInfo = this.getState().getInfo();
                    CheckType checkType = dest.isTemporary() ? CheckType.CREATE_NON_DURABLE_QUEUE : CheckType.CREATE_DURABLE_QUEUE;
                    this.server.getSecurityStore().check(qName, checkType, (SecurityAuth)this);
                    this.server.checkQueueCreationLimit(this.getUsername());
                    this.server.createQueue(qName, RoutingType.ANYCAST, qName, connInfo == null ? null : SimpleString.toSimpleString((String)connInfo.getUserName()), true, false);
                }
            }
        }
        if (dest.isTemporary()) {
            this.state.addTempDestination(info);
        }
        if (!AdvisorySupport.isAdvisoryTopic((org.apache.activemq.command.ActiveMQDestination)dest)) {
            AMQConnectionContext context = this.getContext();
            DestinationInfo advInfo = new DestinationInfo(context.getConnectionId(), 0, dest);
            ActiveMQTopic topic = AdvisorySupport.getDestinationAdvisoryTopic((org.apache.activemq.command.ActiveMQDestination)dest);
            this.protocolManager.fireAdvisory(context, topic, (Command)advInfo);
        }
    }

    public void updateConsumer(ConsumerControl consumerControl) {
        ConsumerId consumerId = consumerControl.getConsumerId();
        AMQConsumerBrokerExchange exchange = this.consumerExchanges.get(consumerId);
        if (exchange != null) {
            exchange.updateConsumerPrefetchSize(consumerControl.getPrefetch());
        }
    }

    public void addConsumer(ConsumerInfo info) throws Exception {
        SessionId sessionId = info.getConsumerId().getParentId();
        ConnectionId connectionId = sessionId.getParentId();
        ConnectionState cs = this.getState();
        if (cs == null) {
            throw new IllegalStateException("Cannot add a consumer to a connection that had not been registered: " + connectionId);
        }
        SessionState ss = cs.getSessionState(sessionId);
        if (ss == null) {
            throw new IllegalStateException(this.server + " Cannot add a consumer to a session that had not been registered: " + sessionId);
        }
        if (!ss.getConsumerIds().contains(info.getConsumerId())) {
            AMQSession amqSession = this.sessions.get(sessionId);
            if (amqSession == null) {
                throw new IllegalStateException("Session not exist! : " + sessionId);
            }
            List<AMQConsumer> consumersList = amqSession.createConsumer(info, new SlowConsumerDetection());
            this.addConsumerBrokerExchange(info.getConsumerId(), amqSession, consumersList);
            ss.addConsumer(info);
            amqSession.start();
            if (AdvisorySupport.isAdvisoryTopic((org.apache.activemq.command.ActiveMQDestination)info.getDestination()) && AdvisorySupport.isTempDestinationAdvisoryTopic((org.apache.activemq.command.ActiveMQDestination)info.getDestination())) {
                List<DestinationInfo> tmpDests = this.protocolManager.getTemporaryDestinations();
                for (DestinationInfo di : tmpDests) {
                    ActiveMQTopic topic = AdvisorySupport.getDestinationAdvisoryTopic((org.apache.activemq.command.ActiveMQDestination)di.getDestination());
                    String originalConnectionId = di.getConnectionId().getValue();
                    this.protocolManager.fireAdvisory(this.context, topic, (Command)di, info.getConsumerId(), originalConnectionId);
                }
            }
        }
    }

    public void setConnectionEntry(ConnectionEntry connectionEntry) {
        this.connectionEntry = connectionEntry;
    }

    public boolean checkDataReceived() {
        if (this.disableTtl.get()) {
            return true;
        }
        return super.checkDataReceived();
    }

    public void setUpTtl(final long inactivityDuration, long inactivityDurationInitialDelay, boolean useKeepAlive) {
        this.useKeepAlive = useKeepAlive;
        this.maxInactivityDuration = inactivityDuration;
        this.protocolManager.getScheduledPool().schedule(new Runnable(){

            @Override
            public void run() {
                if (inactivityDuration >= 0L) {
                    ((OpenWireConnection)OpenWireConnection.this).connectionEntry.ttl = inactivityDuration;
                }
            }
        }, inactivityDurationInitialDelay, TimeUnit.MILLISECONDS);
        this.checkInactivity();
    }

    public void addKnownDestination(SimpleString address) {
        this.knownDestinations.add(address);
    }

    public boolean containsKnownDestination(SimpleString address) {
        return this.knownDestinations.contains(address);
    }

    public void tempQueueDeleted(SimpleString bindingName) {
        ActiveMQTempQueue dest = new ActiveMQTempQueue(bindingName.toString());
        this.state.removeTempDestination((org.apache.activemq.command.ActiveMQDestination)dest);
        if (!AdvisorySupport.isAdvisoryTopic((org.apache.activemq.command.ActiveMQDestination)dest)) {
            AMQConnectionContext context = this.getContext();
            DestinationInfo advInfo = new DestinationInfo(context.getConnectionId(), 1, (org.apache.activemq.command.ActiveMQDestination)dest);
            ActiveMQTopic topic = AdvisorySupport.getDestinationAdvisoryTopic((org.apache.activemq.command.ActiveMQDestination)dest);
            try {
                this.protocolManager.fireAdvisory(context, topic, (Command)advInfo);
            }
            catch (Exception e) {
                logger.warn((Object)("Failed to fire advisory on " + topic), (Throwable)e);
            }
        }
    }

    public void disableTtl() {
        this.disableTtl.set(true);
    }

    public void enableTtl() {
        this.disableTtl.set(false);
    }

    public boolean isNoLocal() {
        return this.noLocal;
    }

    public void setNoLocal(boolean noLocal) {
        this.noLocal = noLocal;
    }

    public List<DestinationInfo> getTemporaryDestinations() {
        return this.state.getTempDestinations();
    }

    public void addSessions(Set<SessionId> sessionSet) {
        for (SessionId sid : sessionSet) {
            this.addSession(this.getState().getSessionState(sid).getInfo(), true);
        }
    }

    public AMQSession addSession(SessionInfo ss) {
        return this.addSession(ss, false);
    }

    public AMQSession addSession(SessionInfo ss, boolean internal) {
        AMQSession amqSession = new AMQSession(this.getState().getInfo(), ss, this.server, this, this.protocolManager);
        amqSession.initialize();
        if (internal) {
            amqSession.disableSecurity();
        }
        this.sessions.put(ss.getSessionId(), amqSession);
        this.sessionIdMap.put(amqSession.getCoreSession().getName(), ss.getSessionId());
        return amqSession;
    }

    public void removeSession(AMQConnectionContext context, SessionInfo info) throws Exception {
        AMQSession session = this.sessions.remove(info.getSessionId());
        if (session != null) {
            session.close();
        }
    }

    public AMQSession getSession(SessionId sessionId) {
        return this.sessions.get(sessionId);
    }

    public void removeDestination(org.apache.activemq.command.ActiveMQDestination dest) throws Exception {
        if (dest.isQueue()) {
            try {
                this.server.destroyQueue(new SimpleString(dest.getPhysicalName()));
            }
            catch (ActiveMQNonExistentQueueException neq) {
                ActiveMQServerLogger.LOGGER.debug((Object)"queue never existed");
            }
        } else {
            Bindings bindings = this.server.getPostOffice().getBindingsForAddress(new SimpleString(dest.getPhysicalName()));
            for (Binding binding : bindings.getBindings()) {
                Queue b = (Queue)binding.getBindable();
                if (b.getConsumerCount() > 0) {
                    throw new Exception("Destination still has an active subscription: " + dest.getPhysicalName());
                }
                if (b.isDurable()) {
                    throw new Exception("Destination still has durable subscription: " + dest.getPhysicalName());
                }
                b.deleteQueue();
            }
        }
        if (!AdvisorySupport.isAdvisoryTopic((org.apache.activemq.command.ActiveMQDestination)dest)) {
            AMQConnectionContext context = this.getContext();
            DestinationInfo advInfo = new DestinationInfo(context.getConnectionId(), 1, dest);
            ActiveMQTopic topic = AdvisorySupport.getDestinationAdvisoryTopic((org.apache.activemq.command.ActiveMQDestination)dest);
            this.protocolManager.fireAdvisory(context, topic, (Command)advInfo);
        }
    }

    private void validateDestination(org.apache.activemq.command.ActiveMQDestination destination) throws Exception {
        SimpleString physicalName;
        BindingQueryResult result;
        if (destination.isQueue() && !(result = this.server.bindingQuery(physicalName = new SimpleString(destination.getPhysicalName()))).isExists() && !result.isAutoCreateQueues()) {
            throw ActiveMQMessageBundle.BUNDLE.noSuchQueue(physicalName);
        }
    }

    private void recoverOperationContext() {
        this.server.getStorageManager().setContext(this.operationContext);
    }

    private void clearupOperationContext() {
        this.server.getStorageManager().clearContext();
    }

    private Transaction lookupTX(TransactionId txID, AMQSession session) throws IllegalStateException {
        Transaction transaction;
        if (txID == null) {
            return null;
        }
        XidImpl xid = null;
        if (txID.isXATransaction()) {
            xid = OpenWireUtil.toXID(txID);
            transaction = this.server.getResourceManager().getTransaction((Xid)xid);
        } else {
            transaction = this.txMap.get(txID);
        }
        if (transaction == null) {
            return null;
        }
        if (session != null && transaction.getProtocolData() != session) {
            transaction.setProtocolData((Object)session);
        }
        return transaction;
    }

    public static XAException newXAException(String s, int errorCode) {
        XAException xaException = new XAException(s + " " + "xaErrorCode:" + errorCode);
        xaException.errorCode = errorCode;
        return xaException;
    }

    public void killMessage(SimpleString nodeID) {
    }

    public class CommandProcessor
    implements CommandVisitor {
        public AMQConnectionContext getContext() {
            return OpenWireConnection.this.getContext();
        }

        public Response processAddConnection(ConnectionInfo info) throws Exception {
            try {
                OpenWireConnection.this.protocolManager.addConnection(OpenWireConnection.this, info);
            }
            catch (Exception e) {
                ExceptionResponse resp = new ExceptionResponse((Throwable)e);
                return resp;
            }
            if (info.isManageable() && OpenWireConnection.this.protocolManager.isUpdateClusterClients()) {
                ConnectionControl command = OpenWireConnection.this.protocolManager.newConnectionControl();
                command.setFaultTolerant(OpenWireConnection.this.protocolManager.isFaultTolerantConfiguration());
                if (info.isFailoverReconnect()) {
                    command.setRebalanceConnection(false);
                }
                OpenWireConnection.this.dispatchAsync((Command)command);
            }
            return null;
        }

        public Response processBrokerSubscriptionInfo(BrokerSubscriptionInfo brokerSubscriptionInfo) throws Exception {
            return null;
        }

        public Response processAddProducer(ProducerInfo info) throws Exception {
            SessionId sessionId = info.getProducerId().getParentId();
            ConnectionState cs = OpenWireConnection.this.getState();
            if (cs == null) {
                throw new IllegalStateException("Cannot add a producer to a connection that had not been registered: " + sessionId.getParentId());
            }
            SessionState ss = cs.getSessionState(sessionId);
            if (ss == null) {
                throw new IllegalStateException("Cannot add a producer to a session that had not been registered: " + sessionId);
            }
            if (!ss.getProducerIds().contains(info.getProducerId())) {
                org.apache.activemq.command.ActiveMQDestination destination = info.getDestination();
                if (destination != null && !AdvisorySupport.isAdvisoryTopic((org.apache.activemq.command.ActiveMQDestination)destination)) {
                    if (destination.isQueue()) {
                        OpenWireConnection.this.validateDestination(destination);
                    }
                    DestinationInfo destInfo = new DestinationInfo(this.getContext().getConnectionId(), 0, destination);
                    OpenWireConnection.this.addDestination(destInfo);
                }
                ss.addProducer(info);
            }
            return null;
        }

        public Response processAddConsumer(ConsumerInfo info) throws Exception {
            OpenWireConnection.this.addConsumer(info);
            return null;
        }

        public Response processRemoveDestination(DestinationInfo info) throws Exception {
            org.apache.activemq.command.ActiveMQDestination dest = info.getDestination();
            OpenWireConnection.this.removeDestination(dest);
            return null;
        }

        public Response processRemoveProducer(ProducerId id) throws Exception {
            return null;
        }

        public Response processRemoveSession(SessionId id, long lastDeliveredSequenceId) throws Exception {
            SessionState session = OpenWireConnection.this.state.getSessionState(id);
            if (session == null) {
                throw new IllegalStateException("Cannot remove session that had not been registered: " + id);
            }
            session.shutdown();
            for (ProducerId producerId : session.getProducerIds()) {
                try {
                    this.processRemoveProducer(producerId);
                }
                catch (Throwable throwable) {}
            }
            OpenWireConnection.this.state.removeSession(id);
            OpenWireConnection.this.removeSession(OpenWireConnection.this.context, session.getInfo());
            return null;
        }

        public Response processRemoveSubscription(RemoveSubscriptionInfo subInfo) throws Exception {
            SimpleString subQueueName = new SimpleString(ActiveMQDestination.createQueueNameForDurableSubscription((boolean)true, (String)subInfo.getClientId(), (String)subInfo.getSubscriptionName()));
            OpenWireConnection.this.server.destroyQueue(subQueueName);
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Response processRollbackTransaction(TransactionInfo info) throws Exception {
            Transaction tx = OpenWireConnection.this.lookupTX(info.getTransactionId(), null);
            if (info.getTransactionId().isXATransaction() && tx == null) {
                throw OpenWireConnection.newXAException("Transaction '" + info.getTransactionId() + "' has not been started.", -4);
            }
            if (tx != null) {
                AMQSession amqSession = (AMQSession)tx.getProtocolData();
                if (amqSession != null) {
                    amqSession.getCoreSession().resetTX(tx);
                    try {
                        this.returnReferences(tx, amqSession);
                    }
                    finally {
                        amqSession.getCoreSession().resetTX(null);
                    }
                }
                tx.rollback();
            }
            return null;
        }

        private void returnReferences(Transaction tx, AMQSession session) throws Exception {
            if (session == null || session.isClosed()) {
                return;
            }
            RefsOperation oper = (RefsOperation)tx.getProperty(6);
            if (oper != null) {
                List ackRefs = oper.getReferencesToAcknowledge();
                ListIterator referenceIterator = ackRefs.listIterator(ackRefs.size());
                while (referenceIterator.hasPrevious()) {
                    MessageReference ref = (MessageReference)referenceIterator.previous();
                    Long consumerID = ref.getConsumerId();
                    ServerConsumer consumer = null;
                    if (consumerID != null) {
                        consumer = session.getCoreSession().locateConsumer(consumerID.longValue());
                    }
                    if (consumer == null) continue;
                    referenceIterator.remove();
                    ref.incrementDeliveryCount();
                    consumer.backToDelivering(ref);
                }
            }
        }

        public Response processShutdown(ShutdownInfo info) throws Exception {
            OpenWireConnection.this.shutdown(false);
            return null;
        }

        public Response processWireFormat(WireFormatInfo command) throws Exception {
            OpenWireConnection.this.wireFormat.renegotiateWireFormat(command);
            OpenWireConnection.this.protocolManager.sendBrokerInfo(OpenWireConnection.this);
            OpenWireConnection.this.protocolManager.setUpInactivityParams(OpenWireConnection.this, command);
            return null;
        }

        public Response processAddDestination(DestinationInfo dest) throws Exception {
            ExceptionResponse resp = null;
            try {
                OpenWireConnection.this.addDestination(dest);
            }
            catch (Exception e) {
                resp = e instanceof ActiveMQSecurityException ? new ExceptionResponse((Throwable)new JMSSecurityException(e.getMessage())) : new ExceptionResponse((Throwable)e);
            }
            return resp;
        }

        public Response processAddSession(SessionInfo info) throws Exception {
            if (!OpenWireConnection.this.state.getSessionIds().contains(info.getSessionId())) {
                OpenWireConnection.this.addSession(info);
                OpenWireConnection.this.state.addSession(info);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Response processBeginTransaction(TransactionInfo info) throws Exception {
            final TransactionId txID = info.getTransactionId();
            try {
                OpenWireConnection.this.internalSession.resetTX(null);
                if (txID.isXATransaction()) {
                    XidImpl xid = OpenWireUtil.toXID(txID);
                    OpenWireConnection.this.internalSession.xaStart((Xid)xid);
                } else {
                    Transaction transaction = OpenWireConnection.this.internalSession.newTransaction();
                    OpenWireConnection.this.txMap.put(txID, transaction);
                    transaction.addOperation((TransactionOperation)new TransactionOperationAbstract(){

                        public void afterCommit(Transaction tx) {
                            OpenWireConnection.this.txMap.remove(txID);
                        }
                    });
                }
            }
            finally {
                OpenWireConnection.this.internalSession.resetTX(null);
            }
            return null;
        }

        public Response processCommitTransactionOnePhase(TransactionInfo info) throws Exception {
            return this.processCommit(info, true);
        }

        private Response processCommit(TransactionInfo info, boolean onePhase) throws Exception {
            TransactionId txID = info.getTransactionId();
            Transaction tx = OpenWireConnection.this.lookupTX(txID, null);
            AMQSession session = (AMQSession)tx.getProtocolData();
            tx.commit(onePhase);
            return null;
        }

        public Response processCommitTransactionTwoPhase(TransactionInfo info) throws Exception {
            return this.processCommit(info, false);
        }

        public Response processForgetTransaction(TransactionInfo info) throws Exception {
            TransactionId txID = info.getTransactionId();
            if (txID.isXATransaction()) {
                try {
                    XidImpl xid = OpenWireUtil.toXID(info.getTransactionId());
                    OpenWireConnection.this.internalSession.xaForget((Xid)xid);
                }
                catch (Exception e) {
                    ActiveMQServerLogger.LOGGER.warn((Object)"Error during method invocation", (Throwable)e);
                    throw e;
                }
            } else {
                OpenWireConnection.this.txMap.remove(txID);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Response processPrepareTransaction(TransactionInfo info) throws Exception {
            block6: {
                TransactionId txID = info.getTransactionId();
                try {
                    if (txID.isXATransaction()) {
                        try {
                            XidImpl xid = OpenWireUtil.toXID(info.getTransactionId());
                            OpenWireConnection.this.internalSession.xaPrepare((Xid)xid);
                            break block6;
                        }
                        catch (Exception e) {
                            ActiveMQServerLogger.LOGGER.warn((Object)"Error during method invocation", (Throwable)e);
                            throw e;
                        }
                    }
                    Transaction tx = OpenWireConnection.this.lookupTX(txID, null);
                    tx.prepare();
                }
                finally {
                    OpenWireConnection.this.internalSession.resetTX(null);
                }
            }
            return new IntegerResponse(3);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Response processEndTransaction(TransactionInfo info) throws Exception {
            block6: {
                TransactionId txID = info.getTransactionId();
                if (txID.isXATransaction()) {
                    try {
                        Transaction tx = OpenWireConnection.this.lookupTX(txID, null);
                        OpenWireConnection.this.internalSession.resetTX(tx);
                        try {
                            XidImpl xid = OpenWireUtil.toXID(info.getTransactionId());
                            OpenWireConnection.this.internalSession.xaEnd((Xid)xid);
                            break block6;
                        }
                        finally {
                            OpenWireConnection.this.internalSession.resetTX(null);
                        }
                    }
                    catch (Exception e) {
                        ActiveMQServerLogger.LOGGER.warn((Object)"Error during method invocation", (Throwable)e);
                        throw e;
                    }
                }
                OpenWireConnection.this.txMap.remove(txID);
            }
            return null;
        }

        public Response processBrokerInfo(BrokerInfo arg0) throws Exception {
            throw new IllegalStateException("not implemented! ");
        }

        public Response processConnectionControl(ConnectionControl connectionControl) throws Exception {
            return null;
        }

        public Response processConnectionError(ConnectionError arg0) throws Exception {
            throw new IllegalStateException("not implemented! ");
        }

        public Response processConsumerControl(ConsumerControl consumerControl) throws Exception {
            try {
                OpenWireConnection.this.updateConsumer(consumerControl);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }

        public Response processControlCommand(ControlCommand arg0) throws Exception {
            throw new IllegalStateException("not implemented! ");
        }

        public Response processFlush(FlushCommand arg0) throws Exception {
            throw new IllegalStateException("not implemented! ");
        }

        public Response processKeepAlive(KeepAliveInfo arg0) throws Exception {
            throw new IllegalStateException("not implemented! ");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Response processMessage(Message messageSend) throws Exception {
            ProducerId producerId = messageSend.getProducerId();
            AMQProducerBrokerExchange producerExchange = OpenWireConnection.this.getProducerBrokerExchange(producerId);
            AMQConnectionContext pcontext = producerExchange.getConnectionContext();
            ProducerInfo producerInfo = producerExchange.getProducerState().getInfo();
            boolean sendProducerAck = !messageSend.isResponseRequired() && producerInfo.getWindowSize() > 0 && !pcontext.isInRecoveryMode();
            AMQSession session = OpenWireConnection.this.getSession(producerId.getParentId());
            Transaction tx = OpenWireConnection.this.lookupTX(messageSend.getTransactionId(), session);
            session.getCoreSession().resetTX(tx);
            try {
                session.send(producerInfo, messageSend, sendProducerAck);
            }
            finally {
                session.getCoreSession().resetTX(null);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Response processMessageAck(MessageAck ack) throws Exception {
            AMQSession session = OpenWireConnection.this.getSession(ack.getConsumerId().getParentId());
            Transaction tx = OpenWireConnection.this.lookupTX(ack.getTransactionId(), session);
            session.getCoreSession().resetTX(tx);
            try {
                AMQConsumerBrokerExchange consumerBrokerExchange = (AMQConsumerBrokerExchange)OpenWireConnection.this.consumerExchanges.get(ack.getConsumerId());
                consumerBrokerExchange.acknowledge(ack);
            }
            finally {
                session.getCoreSession().resetTX(null);
            }
            return null;
        }

        public Response processMessageDispatch(MessageDispatch arg0) throws Exception {
            return null;
        }

        public Response processMessageDispatchNotification(MessageDispatchNotification arg0) throws Exception {
            return null;
        }

        public Response processMessagePull(MessagePull arg0) throws Exception {
            AMQConsumerBrokerExchange amqConsumerBrokerExchange = (AMQConsumerBrokerExchange)OpenWireConnection.this.consumerExchanges.get(arg0.getConsumerId());
            if (amqConsumerBrokerExchange == null) {
                throw new IllegalStateException("Consumer does not exist");
            }
            amqConsumerBrokerExchange.processMessagePull(arg0);
            return null;
        }

        public Response processProducerAck(ProducerAck arg0) throws Exception {
            return null;
        }

        public Response processRecoverTransactions(TransactionInfo info) throws Exception {
            List xids = OpenWireConnection.this.server.getResourceManager().getInDoubtTransactions();
            ArrayList<XATransactionId> recovered = new ArrayList<XATransactionId>();
            for (Xid xid : xids) {
                XATransactionId amqXid = new XATransactionId(xid);
                recovered.add(amqXid);
            }
            return new DataArrayResponse((DataStructure[])recovered.toArray(new TransactionId[recovered.size()]));
        }

        public Response processRemoveConnection(ConnectionId id, long lastDeliveredSequenceId) throws Exception {
            try {
                OpenWireConnection.this.protocolManager.removeConnection(OpenWireConnection.this.state.getInfo(), null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return null;
        }

        public Response processRemoveConsumer(ConsumerId id, long lastDeliveredSequenceId) throws Exception {
            if (OpenWireConnection.this.destroyed) {
                return null;
            }
            SessionId sessionId = id.getParentId();
            SessionState ss = OpenWireConnection.this.state.getSessionState(sessionId);
            if (ss == null) {
                throw new IllegalStateException("Cannot remove a consumer from a session that had not been registered: " + sessionId);
            }
            ConsumerState consumerState = ss.removeConsumer(id);
            if (consumerState == null) {
                throw new IllegalStateException("Cannot remove a consumer that had not been registered: " + id);
            }
            ConsumerInfo info = consumerState.getInfo();
            info.setLastDeliveredSequenceId(lastDeliveredSequenceId);
            AMQConsumerBrokerExchange consumerBrokerExchange = (AMQConsumerBrokerExchange)OpenWireConnection.this.consumerExchanges.remove(id);
            consumerBrokerExchange.removeConsumer();
            return null;
        }
    }

    class SlowConsumerDetection
    implements SlowConsumerDetectionListener {
        SlowConsumerDetection() {
        }

        public void onSlowConsumer(ServerConsumer consumer) {
            if (consumer.getProtocolData() != null && consumer.getProtocolData() instanceof AMQConsumer) {
                AMQConsumer amqConsumer = (AMQConsumer)consumer.getProtocolData();
                ActiveMQTopic topic = AdvisorySupport.getSlowConsumerAdvisoryTopic((org.apache.activemq.command.ActiveMQDestination)amqConsumer.getOpenwireDestination());
                ActiveMQMessage advisoryMessage = new ActiveMQMessage();
                try {
                    advisoryMessage.setStringProperty("consumerId", amqConsumer.getId().toString());
                    OpenWireConnection.this.protocolManager.fireAdvisory(OpenWireConnection.this.context, topic, (Command)advisoryMessage, amqConsumer.getId(), null);
                }
                catch (Exception e) {
                    ActiveMQServerLogger.LOGGER.warn((Object)"Error during method invocation", (Throwable)e);
                }
            }
        }
    }
}

