/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.replication;

import java.util.List;
import java.util.Map;
import org.apache.activemq.artemis.core.io.SequentialFileFactory;
import org.apache.activemq.artemis.core.journal.EncodingSupport;
import org.apache.activemq.artemis.core.journal.IOCompletion;
import org.apache.activemq.artemis.core.journal.Journal;
import org.apache.activemq.artemis.core.journal.JournalLoadInformation;
import org.apache.activemq.artemis.core.journal.LoaderCallback;
import org.apache.activemq.artemis.core.journal.PreparedTransactionInfo;
import org.apache.activemq.artemis.core.journal.RecordInfo;
import org.apache.activemq.artemis.core.journal.TransactionFailureCallback;
import org.apache.activemq.artemis.core.journal.impl.JournalFile;
import org.apache.activemq.artemis.core.journal.impl.dataformat.ByteArrayEncoding;
import org.apache.activemq.artemis.core.persistence.OperationContext;
import org.apache.activemq.artemis.core.persistence.Persister;
import org.apache.activemq.artemis.core.replication.ReplicationManager;

public class ReplicatedJournal
implements Journal {
    private static final boolean trace = false;
    private final ReplicationManager replicationManager;
    private final Journal localJournal;
    private final byte journalID;

    private static void trace(String message) {
        System.out.println("ReplicatedJournal::" + message);
    }

    public ReplicatedJournal(byte journalID, Journal localJournal, ReplicationManager replicationManager) {
        this.journalID = journalID;
        this.localJournal = localJournal;
        this.replicationManager = replicationManager;
    }

    public void flush() throws Exception {
    }

    public void appendAddRecord(long id, byte recordType, byte[] record, boolean sync) throws Exception {
        this.appendAddRecord(id, recordType, (EncodingSupport)new ByteArrayEncoding(record), sync);
    }

    public void appendAddRecord(long id, byte recordType, Persister persister, Object record, boolean sync) throws Exception {
        this.replicationManager.appendUpdateRecord(this.journalID, ReplicationManager.ADD_OPERATION_TYPE.ADD, id, recordType, persister, record);
        this.localJournal.appendAddRecord(id, recordType, persister, record, sync);
    }

    public void appendAddRecord(long id, byte recordType, Persister persister, Object record, boolean sync, IOCompletion completionCallback) throws Exception {
        this.replicationManager.appendUpdateRecord(this.journalID, ReplicationManager.ADD_OPERATION_TYPE.ADD, id, recordType, persister, record);
        this.localJournal.appendAddRecord(id, recordType, persister, record, sync, completionCallback);
    }

    public void appendAddRecordTransactional(long txID, long id, byte recordType, byte[] record) throws Exception {
        this.appendAddRecordTransactional(txID, id, recordType, (EncodingSupport)new ByteArrayEncoding(record));
    }

    public void appendAddRecordTransactional(long txID, long id, byte recordType, Persister persister, Object record) throws Exception {
        this.replicationManager.appendAddRecordTransactional(this.journalID, ReplicationManager.ADD_OPERATION_TYPE.ADD, txID, id, recordType, persister, record);
        this.localJournal.appendAddRecordTransactional(txID, id, recordType, persister, record);
    }

    public void appendCommitRecord(long txID, boolean sync) throws Exception {
        this.replicationManager.appendCommitRecord(this.journalID, txID, sync, true);
        this.localJournal.appendCommitRecord(txID, sync);
    }

    public void appendCommitRecord(long txID, boolean sync, IOCompletion callback) throws Exception {
        this.replicationManager.appendCommitRecord(this.journalID, txID, sync, true);
        this.localJournal.appendCommitRecord(txID, sync, callback);
    }

    public void appendCommitRecord(long txID, boolean sync, IOCompletion callback, boolean lineUpContext) throws Exception {
        this.replicationManager.appendCommitRecord(this.journalID, txID, sync, lineUpContext);
        this.localJournal.appendCommitRecord(txID, sync, callback, lineUpContext);
    }

    public void appendDeleteRecord(long id, boolean sync) throws Exception {
        this.replicationManager.appendDeleteRecord(this.journalID, id);
        this.localJournal.appendDeleteRecord(id, sync);
    }

    public void appendDeleteRecord(long id, boolean sync, IOCompletion completionCallback) throws Exception {
        this.replicationManager.appendDeleteRecord(this.journalID, id);
        this.localJournal.appendDeleteRecord(id, sync, completionCallback);
    }

    public void appendDeleteRecordTransactional(long txID, long id, byte[] record) throws Exception {
        this.appendDeleteRecordTransactional(txID, id, (EncodingSupport)new ByteArrayEncoding(record));
    }

    public void appendDeleteRecordTransactional(long txID, long id, EncodingSupport record) throws Exception {
        this.replicationManager.appendDeleteRecordTransactional(this.journalID, txID, id, record);
        this.localJournal.appendDeleteRecordTransactional(txID, id, record);
    }

    public void appendDeleteRecordTransactional(long txID, long id) throws Exception {
        this.replicationManager.appendDeleteRecordTransactional(this.journalID, txID, id);
        this.localJournal.appendDeleteRecordTransactional(txID, id);
    }

    public void appendPrepareRecord(long txID, byte[] transactionData, boolean sync) throws Exception {
        this.appendPrepareRecord(txID, (EncodingSupport)new ByteArrayEncoding(transactionData), sync);
    }

    public void appendPrepareRecord(long txID, EncodingSupport transactionData, boolean sync) throws Exception {
        this.replicationManager.appendPrepareRecord(this.journalID, txID, transactionData);
        this.localJournal.appendPrepareRecord(txID, transactionData, sync);
    }

    public void appendPrepareRecord(long txID, EncodingSupport transactionData, boolean sync, IOCompletion callback) throws Exception {
        this.replicationManager.appendPrepareRecord(this.journalID, txID, transactionData);
        this.localJournal.appendPrepareRecord(txID, transactionData, sync, callback);
    }

    public void appendRollbackRecord(long txID, boolean sync) throws Exception {
        this.replicationManager.appendRollbackRecord(this.journalID, txID);
        this.localJournal.appendRollbackRecord(txID, sync);
    }

    public void appendRollbackRecord(long txID, boolean sync, IOCompletion callback) throws Exception {
        this.replicationManager.appendRollbackRecord(this.journalID, txID);
        this.localJournal.appendRollbackRecord(txID, sync, callback);
    }

    public void appendUpdateRecord(long id, byte recordType, byte[] record, boolean sync) throws Exception {
        this.appendUpdateRecord(id, recordType, (EncodingSupport)new ByteArrayEncoding(record), sync);
    }

    public void appendUpdateRecord(long id, byte recordType, Persister persister, Object record, boolean sync) throws Exception {
        this.replicationManager.appendUpdateRecord(this.journalID, ReplicationManager.ADD_OPERATION_TYPE.UPDATE, id, recordType, persister, record);
        this.localJournal.appendUpdateRecord(id, recordType, persister, record, sync);
    }

    public void appendUpdateRecord(long id, byte journalRecordType, Persister persister, Object record, boolean sync, IOCompletion completionCallback) throws Exception {
        this.replicationManager.appendUpdateRecord(this.journalID, ReplicationManager.ADD_OPERATION_TYPE.UPDATE, id, journalRecordType, persister, record);
        this.localJournal.appendUpdateRecord(id, journalRecordType, persister, record, sync, completionCallback);
    }

    public void appendUpdateRecordTransactional(long txID, long id, byte recordType, byte[] record) throws Exception {
        this.appendUpdateRecordTransactional(txID, id, recordType, (EncodingSupport)new ByteArrayEncoding(record));
    }

    public void appendUpdateRecordTransactional(long txID, long id, byte recordType, Persister persister, Object record) throws Exception {
        this.replicationManager.appendAddRecordTransactional(this.journalID, ReplicationManager.ADD_OPERATION_TYPE.UPDATE, txID, id, recordType, persister, record);
        this.localJournal.appendUpdateRecordTransactional(txID, id, recordType, persister, record);
    }

    public JournalLoadInformation load(List<RecordInfo> committedRecords, List<PreparedTransactionInfo> preparedTransactions, TransactionFailureCallback transactionFailure) throws Exception {
        return this.localJournal.load(committedRecords, preparedTransactions, transactionFailure);
    }

    public JournalLoadInformation load(LoaderCallback reloadManager) throws Exception {
        return this.localJournal.load(reloadManager);
    }

    public void start() throws Exception {
        this.localJournal.start();
    }

    public void stop() throws Exception {
        this.localJournal.stop();
    }

    public int getAlignment() throws Exception {
        return this.localJournal.getAlignment();
    }

    public boolean isStarted() {
        return this.localJournal.isStarted();
    }

    public JournalLoadInformation loadInternalOnly() throws Exception {
        return this.localJournal.loadInternalOnly();
    }

    public int getNumberOfRecords() {
        return this.localJournal.getNumberOfRecords();
    }

    public void runDirectJournalBlast() throws Exception {
        this.localJournal.runDirectJournalBlast();
    }

    public int getUserVersion() {
        return this.localJournal.getUserVersion();
    }

    public void lineUpContext(IOCompletion callback) {
        ((OperationContext)callback).replicationLineUp();
        this.localJournal.lineUpContext(callback);
    }

    public JournalLoadInformation loadSyncOnly(Journal.JournalState state) throws Exception {
        return this.localJournal.loadSyncOnly(state);
    }

    public Map<Long, JournalFile> createFilesForBackupSync(long[] fileIds) throws Exception {
        throw new UnsupportedOperationException("This method should only be called at a replicating backup");
    }

    public void synchronizationLock() {
        throw new UnsupportedOperationException();
    }

    public void synchronizationUnlock() {
        throw new UnsupportedOperationException();
    }

    public void forceMoveNextFile() {
        throw new UnsupportedOperationException();
    }

    public JournalFile[] getDataFiles() {
        throw new UnsupportedOperationException();
    }

    public SequentialFileFactory getFileFactory() {
        throw new UnsupportedOperationException();
    }

    public int getFileSize() {
        return this.localJournal.getFileSize();
    }

    public void scheduleCompactAndBlock(int timeout) throws Exception {
        this.localJournal.scheduleCompactAndBlock(timeout);
    }

    public void replicationSyncPreserveOldFiles() {
        throw new UnsupportedOperationException("should never get called");
    }

    public void replicationSyncFinished() {
        throw new UnsupportedOperationException("should never get called");
    }
}

