/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.paging.PagedMessage;
import org.apache.activemq.artemis.core.paging.impl.PagedMessageImpl;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;

public class ReplicationPageWriteMessage
extends PacketImpl {
    private int pageNumber;
    private PagedMessage pagedMessage;

    public ReplicationPageWriteMessage() {
        super((byte)97);
    }

    public ReplicationPageWriteMessage(PagedMessage pagedMessage, int pageNumber) {
        this();
        this.pageNumber = pageNumber;
        this.pagedMessage = pagedMessage;
    }

    public void encodeRest(ActiveMQBuffer buffer) {
        buffer.writeInt(this.pageNumber);
        this.pagedMessage.encode(buffer);
    }

    public void decodeRest(ActiveMQBuffer buffer) {
        this.pageNumber = buffer.readInt();
        this.pagedMessage = new PagedMessageImpl(null);
        this.pagedMessage.decode(buffer);
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public PagedMessage getPagedMessage() {
        return this.pagedMessage;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.pageNumber;
        result = 31 * result + (this.pagedMessage == null ? 0 : this.pagedMessage.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ReplicationPageWriteMessage other = (ReplicationPageWriteMessage)((Object)obj);
        if (this.pageNumber != other.pageNumber) {
            return false;
        }
        return !(this.pagedMessage == null ? other.pagedMessage != null : !this.pagedMessage.equals(other.pagedMessage));
    }
}

