/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jdbc.store.file;

import java.nio.ByteBuffer;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.apache.activemq.artemis.jdbc.store.drivers.AbstractJDBCDriver;
import org.apache.activemq.artemis.jdbc.store.file.JDBCSequentialFile;
import org.apache.activemq.artemis.jdbc.store.sql.SQLProvider;

public class JDBCSequentialFileFactoryDriver
extends AbstractJDBCDriver {
    protected PreparedStatement deleteFile;
    protected PreparedStatement createFile;
    protected PreparedStatement selectFileByFileName;
    protected PreparedStatement copyFileRecord;
    protected PreparedStatement renameFile;
    protected PreparedStatement readLargeObject;
    protected PreparedStatement appendToLargeObject;
    protected PreparedStatement selectFileNamesByExtension;

    JDBCSequentialFileFactoryDriver() {
    }

    JDBCSequentialFileFactoryDriver(DataSource dataSource, SQLProvider provider) {
        super(dataSource, provider);
    }

    JDBCSequentialFileFactoryDriver(Connection connection, SQLProvider sqlProvider) {
        super(connection, sqlProvider);
    }

    @Override
    protected void createSchema() throws SQLException {
        this.createTable(this.sqlProvider.getCreateFileTableSQL());
    }

    @Override
    protected void prepareStatements() throws SQLException {
        this.deleteFile = this.connection.prepareStatement(this.sqlProvider.getDeleteFileSQL());
        this.createFile = this.connection.prepareStatement(this.sqlProvider.getInsertFileSQL(), new String[]{"ID"});
        this.selectFileByFileName = this.connection.prepareStatement(this.sqlProvider.getSelectFileByFileName());
        this.copyFileRecord = this.connection.prepareStatement(this.sqlProvider.getCopyFileRecordByIdSQL());
        this.renameFile = this.connection.prepareStatement(this.sqlProvider.getUpdateFileNameByIdSQL());
        this.readLargeObject = this.connection.prepareStatement(this.sqlProvider.getReadLargeObjectSQL());
        this.appendToLargeObject = this.connection.prepareStatement(this.sqlProvider.getAppendToLargeObjectSQL(), 1003, 1008);
        this.selectFileNamesByExtension = this.connection.prepareStatement(this.sqlProvider.getSelectFileNamesByExtensionSQL());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> listFiles(String extension) throws Exception {
        Connection connection = this.connection;
        synchronized (connection) {
            ArrayList<String> fileNames = new ArrayList<String>();
            try {
                this.connection.setAutoCommit(false);
                this.selectFileNamesByExtension.setString(1, extension);
                try (ResultSet rs = this.selectFileNamesByExtension.executeQuery();){
                    while (rs.next()) {
                        fileNames.add(rs.getString(1));
                    }
                }
                this.connection.commit();
            }
            catch (SQLException e) {
                this.connection.rollback();
                throw e;
            }
            return fileNames;
        }
    }

    public void openFile(JDBCSequentialFile file) throws SQLException {
        long fileId = this.fileExists(file);
        if (fileId < 0L) {
            this.createFile(file);
        } else {
            file.setId(fileId);
            this.loadFile(file);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long fileExists(JDBCSequentialFile file) throws SQLException {
        try {
            Connection connection = this.connection;
            synchronized (connection) {
                this.connection.setAutoCommit(false);
                this.selectFileByFileName.setString(1, file.getFileName());
                try (ResultSet rs = this.selectFileByFileName.executeQuery();){
                    long id = rs.next() ? rs.getLong(1) : -1L;
                    this.connection.commit();
                    long l = id;
                    return l;
                }
                catch (Exception e) {
                    this.connection.rollback();
                    throw e;
                }
            }
        }
        catch (NullPointerException npe) {
            npe.printStackTrace();
            throw npe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFile(JDBCSequentialFile file) throws SQLException {
        Connection connection = this.connection;
        synchronized (connection) {
            this.connection.setAutoCommit(false);
            this.readLargeObject.setLong(1, file.getId());
            try (ResultSet rs = this.readLargeObject.executeQuery();){
                Blob blob;
                if (rs.next() && (blob = rs.getBlob(1)) != null) {
                    file.setWritePosition((int)blob.length());
                }
                this.connection.commit();
            }
            catch (SQLException e) {
                this.connection.rollback();
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createFile(JDBCSequentialFile file) throws SQLException {
        Connection connection = this.connection;
        synchronized (connection) {
            try {
                this.connection.setAutoCommit(false);
                this.createFile.setString(1, file.getFileName());
                this.createFile.setString(2, file.getExtension());
                this.createFile.setBytes(3, new byte[0]);
                this.createFile.executeUpdate();
                try (ResultSet keys = this.createFile.getGeneratedKeys();){
                    keys.next();
                    file.setId(keys.getLong(1));
                }
                this.connection.commit();
            }
            catch (SQLException e) {
                this.connection.rollback();
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameFile(JDBCSequentialFile file, String newFileName) throws SQLException {
        Connection connection = this.connection;
        synchronized (connection) {
            try {
                this.connection.setAutoCommit(false);
                this.renameFile.setString(1, newFileName);
                this.renameFile.setLong(2, file.getId());
                this.renameFile.executeUpdate();
                this.connection.commit();
            }
            catch (SQLException e) {
                this.connection.rollback();
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteFile(JDBCSequentialFile file) throws SQLException {
        Connection connection = this.connection;
        synchronized (connection) {
            try {
                this.connection.setAutoCommit(false);
                this.deleteFile.setLong(1, file.getId());
                this.deleteFile.executeUpdate();
                this.connection.commit();
            }
            catch (SQLException e) {
                this.connection.rollback();
                throw e;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int writeToFile(JDBCSequentialFile file, byte[] data) throws SQLException {
        Connection connection = this.connection;
        synchronized (connection) {
            this.connection.setAutoCommit(false);
            this.appendToLargeObject.setLong(1, file.getId());
            int bytesWritten = 0;
            try (ResultSet rs = this.appendToLargeObject.executeQuery();){
                if (rs.next()) {
                    Blob blob = rs.getBlob(1);
                    if (blob == null) {
                        blob = this.connection.createBlob();
                    }
                    bytesWritten = blob.setBytes(blob.length() + 1L, data);
                    rs.updateBlob(1, blob);
                    rs.updateRow();
                }
                this.connection.commit();
                int n = bytesWritten;
                return n;
            }
            catch (SQLException e) {
                this.connection.rollback();
                throw e;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int readFromFile(JDBCSequentialFile file, ByteBuffer bytes) throws SQLException {
        Connection connection = this.connection;
        synchronized (connection) {
            this.connection.setAutoCommit(false);
            this.readLargeObject.setLong(1, file.getId());
            int readLength = 0;
            try (ResultSet rs = this.readLargeObject.executeQuery();){
                Blob blob;
                if (rs.next() && (blob = rs.getBlob(1)) != null) {
                    readLength = (int)this.calculateReadLength(blob.length(), bytes.remaining(), file.position());
                    byte[] data = blob.getBytes(file.position() + 1L, readLength);
                    bytes.put(data);
                }
                this.connection.commit();
                int n = readLength;
                return n;
            }
            catch (Throwable e) {
                this.connection.rollback();
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyFileData(JDBCSequentialFile fileFrom, JDBCSequentialFile fileTo) throws SQLException {
        Connection connection = this.connection;
        synchronized (connection) {
            try {
                this.connection.setAutoCommit(false);
                this.copyFileRecord.setLong(1, fileFrom.getId());
                this.copyFileRecord.setLong(2, fileTo.getId());
                this.copyFileRecord.executeUpdate();
                this.connection.commit();
            }
            catch (SQLException e) {
                this.connection.rollback();
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() throws SQLException {
        Connection connection = this.connection;
        synchronized (connection) {
            try {
                this.connection.setAutoCommit(false);
                try (Statement statement = this.connection.createStatement();){
                    statement.executeUpdate(this.sqlProvider.getDropFileTableSQL());
                }
                this.connection.commit();
            }
            catch (SQLException e) {
                this.connection.rollback();
                throw e;
            }
        }
    }

    public long calculateReadLength(long objectLength, int bufferSpace, long readPosition) {
        long bytesRemaining = objectLength - readPosition;
        if (bytesRemaining > (long)bufferSpace) {
            return bufferSpace;
        }
        return bytesRemaining;
    }

    public long getMaxSize() {
        return this.sqlProvider.getMaxBlobSize();
    }
}

