/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import io.netty.buffer.Unpooled;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.core.buffers.impl.ChannelBufferWrapper;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.MessagePacketI;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;

public abstract class MessagePacket
extends PacketImpl
implements MessagePacketI {
    protected ICoreMessage message;

    public MessagePacket(byte type, ICoreMessage message) {
        super(type);
        this.message = message;
    }

    @Override
    public ICoreMessage getMessage() {
        return this.message;
    }

    @Override
    public String getParentString() {
        return super.getParentString() + ", message=" + this.message;
    }

    protected ActiveMQBuffer internalCreatePacket(int size, RemotingConnection connection, boolean usePooled) {
        if (connection == null) {
            return new ChannelBufferWrapper(Unpooled.buffer((int)size));
        }
        return connection.createTransportBuffer(size, usePooled);
    }
}

