/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.message.impl;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.message.impl.CoreMessage;
import org.apache.activemq.artemis.core.persistence.Persister;

public class CoreMessagePersister
implements Persister<Message> {
    public static CoreMessagePersister theInstance = new CoreMessagePersister();

    public static CoreMessagePersister getInstance() {
        return theInstance;
    }

    protected CoreMessagePersister() {
    }

    public int getEncodeSize(Message record) {
        return 1 + record.getPersistSize() + SimpleString.sizeofNullableString((SimpleString)record.getAddressSimpleString()) + 8;
    }

    public void encode(ActiveMQBuffer buffer, Message record) {
        buffer.writeByte((byte)1);
        buffer.writeLong(record.getMessageID());
        buffer.writeNullableSimpleString(record.getAddressSimpleString());
        record.persist(buffer);
    }

    public Message decode(ActiveMQBuffer buffer, Message record) {
        long id = buffer.readLong();
        SimpleString address = buffer.readNullableSimpleString();
        record = new CoreMessage();
        record.reloadPersistence(buffer);
        record.setMessageID(id);
        record.setAddress(address);
        return record;
    }
}

