/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.api.core.management;

import java.util.Map;
import java.util.Set;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.management.Attribute;
import org.apache.activemq.artemis.api.core.management.Operation;
import org.apache.activemq.artemis.api.core.management.Parameter;

public interface AddressControl {
    @Attribute(desc="managed address")
    public String getAddress();

    @Attribute(desc="Get the delivery modes enabled on this address")
    public Set<RoutingType> getDeliveryModes();

    @Attribute(desc="Get the delivery modes enabled on this address as JSON")
    public String getDeliveryModesAsJSON() throws Exception;

    @Attribute(desc="roles (name and permissions) associated with this address")
    public Object[] getRoles() throws Exception;

    @Attribute(desc="roles  (name and permissions) associated with this address using JSON serialization")
    public String getRolesAsJSON() throws Exception;

    @Attribute(desc="the number of estimated bytes being used by the queue(s), used to control paging and blocking")
    public long getAddressSize() throws Exception;

    @Attribute(desc="the sum of messages on queue(s), including messages in delivery")
    public long getNumberOfMessages() throws Exception;

    @Attribute(desc="names of the queue(s) bound to this address")
    public String[] getQueueNames() throws Exception;

    @Attribute(desc="number of pages used by this address")
    public int getNumberOfPages() throws Exception;

    @Attribute(desc="whether this address is paging")
    public boolean isPaging() throws Exception;

    @Attribute(desc="number of bytes used by each page for this address")
    public long getNumberOfBytesPerPage() throws Exception;

    @Attribute(desc="names of all bindings (both queues and diverts) bound to this address")
    public String[] getBindingNames() throws Exception;

    @Attribute(desc="number of messages added to all the queues for this address")
    public long getMessageCount();

    @Operation(desc="Sends a TextMessage to a password-protected address.", impact=1)
    public String sendMessage(@Parameter(name="headers", desc="The headers to add to the message") Map<String, String> var1, @Parameter(name="type", desc="A type for the message") int var2, @Parameter(name="body", desc="The body (byte[]) of the message encoded as a string using Base64") String var3, @Parameter(name="durable", desc="Whether the message is durable") boolean var4, @Parameter(name="user", desc="The user to authenticate with") String var5, @Parameter(name="password", desc="The users password to authenticate with") String var6) throws Exception;
}

