/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.io.mapped;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.UnpooledUnsafeDirectByteBufWrapper;
import io.netty.util.internal.PlatformDependent;
import java.io.File;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.buffers.impl.ChannelBufferWrapper;
import org.apache.activemq.artemis.core.io.mapped.MappedByteBufferCache;
import org.apache.activemq.artemis.core.journal.EncodingSupport;

final class MappedFile
implements AutoCloseable {
    private final MappedByteBufferCache cache;
    private final UnpooledUnsafeDirectByteBufWrapper byteBufWrapper;
    private final ChannelBufferWrapper channelBufferWrapper;
    private MappedByteBuffer lastMapped;
    private long lastMappedStart;
    private long lastMappedLimit;
    private long position;
    private long length;

    private MappedFile(MappedByteBufferCache cache) throws IOException {
        this.cache = cache;
        this.lastMapped = null;
        this.lastMappedStart = -1L;
        this.lastMappedLimit = -1L;
        this.position = 0L;
        this.length = this.cache.fileSize();
        this.byteBufWrapper = new UnpooledUnsafeDirectByteBufWrapper();
        this.channelBufferWrapper = new ChannelBufferWrapper((ByteBuf)this.byteBufWrapper, false);
    }

    public static MappedFile of(File file, long chunckSize, long overlapSize) throws IOException {
        return new MappedFile(MappedByteBufferCache.of(file, chunckSize, overlapSize));
    }

    public MappedByteBufferCache cache() {
        return this.cache;
    }

    private int checkOffset(long offset, int bytes) throws BufferUnderflowException, IOException {
        if (!MappedByteBufferCache.inside(offset, this.lastMappedStart, this.lastMappedLimit)) {
            return this.updateOffset(offset, bytes);
        }
        int bufferPosition = (int)(offset - this.lastMappedStart);
        return bufferPosition;
    }

    private int updateOffset(long offset, int bytes) throws BufferUnderflowException, IOException {
        try {
            int index = this.cache.indexFor(offset);
            long mappedPosition = this.cache.mappedPositionFor(index);
            long mappedLimit = this.cache.mappedLimitFor(mappedPosition);
            if (offset + (long)bytes > mappedLimit) {
                throw new IOException("mapping overflow!");
            }
            this.lastMapped = this.cache.acquireMappedByteBuffer(index);
            this.lastMappedStart = mappedPosition;
            this.lastMappedLimit = mappedLimit;
            int bufferPosition = (int)(offset - mappedPosition);
            return bufferPosition;
        }
        catch (IllegalStateException e) {
            throw new IOException(e);
        }
        catch (IllegalArgumentException e) {
            throw new BufferUnderflowException();
        }
    }

    public void force() {
        if (this.lastMapped != null) {
            this.lastMapped.force();
        }
    }

    public int read(long position, ByteBuf dst, int dstStart, int dstLength) throws IOException {
        int bufferPosition = this.checkOffset(position, dstLength);
        long srcAddress = PlatformDependent.directBufferAddress((ByteBuffer)this.lastMapped) + (long)bufferPosition;
        if (dst.hasMemoryAddress()) {
            long dstAddress = dst.memoryAddress() + (long)dstStart;
            PlatformDependent.copyMemory((long)srcAddress, (long)dstAddress, (long)dstLength);
        } else if (dst.hasArray()) {
            byte[] dstArray = dst.array();
            PlatformDependent.copyMemory((long)srcAddress, (byte[])dstArray, (int)dstStart, (long)dstLength);
        } else {
            throw new IllegalArgumentException("unsupported byte buffer");
        }
        if ((position += (long)dstLength) > this.length) {
            this.length = position;
        }
        return dstLength;
    }

    public int read(long position, ByteBuffer dst, int dstStart, int dstLength) throws IOException {
        int bufferPosition = this.checkOffset(position, dstLength);
        long srcAddress = PlatformDependent.directBufferAddress((ByteBuffer)this.lastMapped) + (long)bufferPosition;
        if (dst.isDirect()) {
            long dstAddress = PlatformDependent.directBufferAddress((ByteBuffer)dst) + (long)dstStart;
            PlatformDependent.copyMemory((long)srcAddress, (long)dstAddress, (long)dstLength);
        } else {
            byte[] dstArray = dst.array();
            PlatformDependent.copyMemory((long)srcAddress, (byte[])dstArray, (int)dstStart, (long)dstLength);
        }
        if ((position += (long)dstLength) > this.length) {
            this.length = position;
        }
        return dstLength;
    }

    public int read(ByteBuf dst, int dstStart, int dstLength) throws IOException {
        int remaining = (int)Math.min(this.length - this.position, Integer.MAX_VALUE);
        int read = Math.min(remaining, dstLength);
        int bufferPosition = this.checkOffset(this.position, read);
        long srcAddress = PlatformDependent.directBufferAddress((ByteBuffer)this.lastMapped) + (long)bufferPosition;
        if (dst.hasMemoryAddress()) {
            long dstAddress = dst.memoryAddress() + (long)dstStart;
            PlatformDependent.copyMemory((long)srcAddress, (long)dstAddress, (long)read);
        } else if (dst.hasArray()) {
            byte[] dstArray = dst.array();
            PlatformDependent.copyMemory((long)srcAddress, (byte[])dstArray, (int)dstStart, (long)read);
        } else {
            throw new IllegalArgumentException("unsupported byte buffer");
        }
        this.position += (long)read;
        return read;
    }

    public int read(ByteBuffer dst, int dstStart, int dstLength) throws IOException {
        int remaining = (int)Math.min(this.length - this.position, Integer.MAX_VALUE);
        int read = Math.min(remaining, dstLength);
        int bufferPosition = this.checkOffset(this.position, read);
        long srcAddress = PlatformDependent.directBufferAddress((ByteBuffer)this.lastMapped) + (long)bufferPosition;
        if (dst.isDirect()) {
            long dstAddress = PlatformDependent.directBufferAddress((ByteBuffer)dst) + (long)dstStart;
            PlatformDependent.copyMemory((long)srcAddress, (long)dstAddress, (long)read);
        } else {
            byte[] dstArray = dst.array();
            PlatformDependent.copyMemory((long)srcAddress, (byte[])dstArray, (int)dstStart, (long)read);
        }
        this.position += (long)read;
        return read;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(EncodingSupport encodingSupport) throws IOException {
        int encodedSize = encodingSupport.getEncodeSize();
        int bufferPosition = this.checkOffset(this.position, encodedSize);
        this.byteBufWrapper.wrap(this.lastMapped, bufferPosition, encodedSize);
        try {
            encodingSupport.encode((ActiveMQBuffer)this.channelBufferWrapper);
        }
        finally {
            this.byteBufWrapper.reset();
        }
        this.position += (long)encodedSize;
        if (this.position > this.length) {
            this.length = this.position;
        }
    }

    public void write(ByteBuf src, int srcStart, int srcLength) throws IOException {
        int bufferPosition = this.checkOffset(this.position, srcLength);
        long destAddress = PlatformDependent.directBufferAddress((ByteBuffer)this.lastMapped) + (long)bufferPosition;
        if (src.hasMemoryAddress()) {
            long srcAddress = src.memoryAddress() + (long)srcStart;
            PlatformDependent.copyMemory((long)srcAddress, (long)destAddress, (long)srcLength);
        } else if (src.hasArray()) {
            byte[] srcArray = src.array();
            PlatformDependent.copyMemory((byte[])srcArray, (int)srcStart, (long)destAddress, (long)srcLength);
        } else {
            throw new IllegalArgumentException("unsupported byte buffer");
        }
        this.position += (long)srcLength;
        if (this.position > this.length) {
            this.length = this.position;
        }
    }

    public void write(ByteBuffer src, int srcStart, int srcLength) throws IOException {
        int bufferPosition = this.checkOffset(this.position, srcLength);
        long destAddress = PlatformDependent.directBufferAddress((ByteBuffer)this.lastMapped) + (long)bufferPosition;
        if (src.isDirect()) {
            long srcAddress = PlatformDependent.directBufferAddress((ByteBuffer)src) + (long)srcStart;
            PlatformDependent.copyMemory((long)srcAddress, (long)destAddress, (long)srcLength);
        } else {
            byte[] srcArray = src.array();
            PlatformDependent.copyMemory((byte[])srcArray, (int)srcStart, (long)destAddress, (long)srcLength);
        }
        this.position += (long)srcLength;
        if (this.position > this.length) {
            this.length = this.position;
        }
    }

    public void write(long position, ByteBuf src, int srcStart, int srcLength) throws IOException {
        int bufferPosition = this.checkOffset(position, srcLength);
        long destAddress = PlatformDependent.directBufferAddress((ByteBuffer)this.lastMapped) + (long)bufferPosition;
        if (src.hasMemoryAddress()) {
            long srcAddress = src.memoryAddress() + (long)srcStart;
            PlatformDependent.copyMemory((long)srcAddress, (long)destAddress, (long)srcLength);
        } else if (src.hasArray()) {
            byte[] srcArray = src.array();
            PlatformDependent.copyMemory((byte[])srcArray, (int)srcStart, (long)destAddress, (long)srcLength);
        } else {
            throw new IllegalArgumentException("unsupported byte buffer");
        }
        if ((position += (long)srcLength) > this.length) {
            this.length = position;
        }
    }

    public void write(long position, ByteBuffer src, int srcStart, int srcLength) throws IOException {
        int bufferPosition = this.checkOffset(position, srcLength);
        long destAddress = PlatformDependent.directBufferAddress((ByteBuffer)this.lastMapped) + (long)bufferPosition;
        if (src.isDirect()) {
            long srcAddress = PlatformDependent.directBufferAddress((ByteBuffer)src) + (long)srcStart;
            PlatformDependent.copyMemory((long)srcAddress, (long)destAddress, (long)srcLength);
        } else {
            byte[] srcArray = src.array();
            PlatformDependent.copyMemory((byte[])srcArray, (int)srcStart, (long)destAddress, (long)srcLength);
        }
        if ((position += (long)srcLength) > this.length) {
            this.length = position;
        }
    }

    public void zeros(long offset, int count) throws IOException {
        while (count > 0) {
            int bufferPosition = this.checkOffset(offset, 0);
            int endZerosPosition = (int)Math.min((long)bufferPosition + (long)count, (long)this.lastMapped.capacity());
            int zeros = endZerosPosition - bufferPosition;
            long destAddress = PlatformDependent.directBufferAddress((ByteBuffer)this.lastMapped) + (long)bufferPosition;
            PlatformDependent.setMemory((long)destAddress, (long)zeros, (byte)0);
            offset += (long)zeros;
            count -= zeros;
        }
        if (offset > this.length) {
            this.length = offset;
        }
    }

    public long position() {
        return this.position;
    }

    public long position(long newPosition) {
        long oldPosition = this.position;
        this.position = newPosition;
        return oldPosition;
    }

    public long length() {
        return this.length;
    }

    @Override
    public void close() {
        this.cache.close();
    }

    public void closeAndResize(long length) {
        this.cache.closeAndResize(length);
    }
}

