/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.sasl;

import java.io.IOException;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.apache.qpid.jms.sasl.AbstractMechanism;
import org.apache.qpid.jms.sasl.Mechanism;
import org.apache.qpid.jms.util.PropertyUtil;

public class GssapiMechanism
extends AbstractMechanism {
    public static final String NAME = "GSSAPI";
    private Subject subject;
    private SaslClient saslClient;
    private String protocol = "amqp";
    private String serverName = null;
    private String configScope = "amqp-jms-client";

    @Override
    public int getPriority() {
        return Mechanism.PRIORITY.LOW.getValue();
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean isEnabledByDefault() {
        return false;
    }

    @Override
    public void init(Map<String, String> saslOptions) {
        PropertyUtil.setProperties((Object)this, saslOptions);
    }

    @Override
    public byte[] getInitialResponse() throws SaslException {
        try {
            LoginContext loginContext = new LoginContext(this.configScope, new CredentialCallbackHandler());
            loginContext.login();
            this.subject = loginContext.getSubject();
            return Subject.doAs(this.subject, new PrivilegedExceptionAction<byte[]>(){

                @Override
                public byte[] run() throws Exception {
                    HashMap<String, String> props = new HashMap<String, String>();
                    props.put("javax.security.sasl.server.authentication", "true");
                    GssapiMechanism.this.saslClient = Sasl.createSaslClient(new String[]{GssapiMechanism.NAME}, null, GssapiMechanism.this.protocol, GssapiMechanism.this.serverName, props, null);
                    if (GssapiMechanism.this.saslClient.hasInitialResponse()) {
                        return GssapiMechanism.this.saslClient.evaluateChallenge(new byte[0]);
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            throw new SaslException(e.toString(), e);
        }
    }

    @Override
    public byte[] getChallengeResponse(final byte[] challenge) throws SaslException {
        try {
            return Subject.doAs(this.subject, new PrivilegedExceptionAction<byte[]>(){

                @Override
                public byte[] run() throws Exception {
                    return GssapiMechanism.this.saslClient.evaluateChallenge(challenge);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw new SaslException(e.toString(), e);
        }
    }

    @Override
    public void verifyCompletion() throws SaslException {
        boolean result = this.saslClient.isComplete();
        this.saslClient.dispose();
        if (!result) {
            throw new SaslException("not complete");
        }
    }

    @Override
    public boolean isApplicable(String username, String password, Principal localPrincipal) {
        return true;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getConfigScope() {
        return this.configScope;
    }

    public void setConfigScope(String configScope) {
        this.configScope = configScope;
    }

    private class CredentialCallbackHandler
    implements CallbackHandler {
        private CredentialCallbackHandler() {
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (int i = 0; i < callbacks.length; ++i) {
                Callback cb = callbacks[i];
                if (cb instanceof NameCallback) {
                    ((NameCallback)cb).setName(GssapiMechanism.this.getUsername());
                    continue;
                }
                if (cb instanceof PasswordCallback) {
                    String pass = GssapiMechanism.this.getPassword();
                    if (pass == null) continue;
                    ((PasswordCallback)cb).setPassword(pass.toCharArray());
                    continue;
                }
                throw new UnsupportedCallbackException(cb);
            }
        }
    }
}

