/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.mqtt;

import io.netty.handler.codec.mqtt.MqttTopicSubscription;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.core.filter.impl.FilterImpl;
import org.apache.activemq.artemis.core.message.impl.CoreMessage;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTConnection;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTLogger;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTSessionState;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.core.transaction.impl.TransactionImpl;
import org.apache.activemq.artemis.utils.collections.LinkedListIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MQTTStateManager {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final ActiveMQServer server;
    private final Map<String, MQTTSessionState> sessionStates = new ConcurrentHashMap<String, MQTTSessionState>();
    private final Queue sessionStore;
    private static final Map<Integer, MQTTStateManager> INSTANCES = new HashMap<Integer, MQTTStateManager>();
    private final Map<String, MQTTConnection> connectedClients = new ConcurrentHashMap<String, MQTTConnection>();
    private final boolean subscriptionPersistenceEnabled;

    public static synchronized MQTTStateManager getInstance(ActiveMQServer server) throws Exception {
        MQTTStateManager instance = INSTANCES.get(System.identityHashCode(server));
        if (instance == null) {
            instance = new MQTTStateManager(server);
            INSTANCES.put(System.identityHashCode(server), instance);
        }
        return instance;
    }

    public static synchronized void removeInstance(ActiveMQServer server) {
        INSTANCES.remove(System.identityHashCode(server));
    }

    private MQTTStateManager(ActiveMQServer server) throws Exception {
        this.server = server;
        this.subscriptionPersistenceEnabled = server.getConfiguration().isMqttSubscriptionPersistenceEnabled();
        if (this.subscriptionPersistenceEnabled) {
            this.sessionStore = server.createQueue(QueueConfiguration.of((String)"$sys.mqtt.sessions").setRoutingType(RoutingType.ANYCAST).setLastValue(Boolean.valueOf(true)).setDurable(Boolean.valueOf(true)).setInternal(Boolean.valueOf(true)).setAutoCreateAddress(Boolean.valueOf(true)), true);
            try (LinkedListIterator iterator = this.sessionStore.browserIterator();){
                while (iterator.hasNext()) {
                    MQTTSessionState sessionState;
                    Message message = ((MessageReference)iterator.next()).getMessage();
                    if (!(message instanceof CoreMessage)) {
                        MQTTLogger.LOGGER.sessionStateMessageIncorrectType(message.getClass().getName());
                        continue;
                    }
                    String clientId = message.getStringProperty(Message.HDR_LAST_VALUE_NAME);
                    if (clientId == null || clientId.isEmpty()) {
                        MQTTLogger.LOGGER.sessionStateMessageBadClientId();
                        continue;
                    }
                    try {
                        sessionState = new MQTTSessionState((CoreMessage)message);
                    }
                    catch (Exception e) {
                        MQTTLogger.LOGGER.errorDeserializingStateMessage(e);
                        continue;
                    }
                    this.sessionStates.put(clientId, sessionState);
                }
            }
            catch (NoSuchElementException noSuchElementException) {}
        } else {
            this.sessionStore = null;
        }
    }

    public void scanSessions() {
        MQTTSessionState state;
        ArrayList<String> toRemove = new ArrayList<String>();
        for (Map.Entry<String, MQTTSessionState> entry : this.sessionStates.entrySet()) {
            state = entry.getValue();
            logger.debug("Inspecting session: {}", (Object)state);
            int sessionExpiryInterval = state.getClientSessionExpiryInterval();
            if (!state.isAttached() && sessionExpiryInterval > 0 && state.getDisconnectedTime() + (long)(sessionExpiryInterval * 1000) < System.currentTimeMillis()) {
                toRemove.add(entry.getKey());
            }
            if (!state.isWill() || state.isAttached() || !state.isFailed() || state.getWillDelayInterval() <= 0L || state.getDisconnectedTime() + state.getWillDelayInterval() * 1000L >= System.currentTimeMillis()) continue;
            state.getSession().sendWillMessage();
        }
        for (String key : toRemove) {
            try {
                state = this.removeSessionState(key);
                if (state == null) continue;
                if (state.isWill() && !state.isAttached() && state.isFailed()) {
                    state.getSession().sendWillMessage();
                }
                state.getSession().clean(false);
            }
            catch (Exception e) {
                MQTTLogger.LOGGER.failedToRemoveSessionState(key, e);
            }
        }
    }

    public MQTTSessionState getSessionState(String clientId) throws Exception {
        if (this.sessionStates.containsKey(clientId)) {
            return this.sessionStates.get(clientId);
        }
        MQTTSessionState sessionState = new MQTTSessionState(clientId);
        logger.debug("Adding MQTT session state for: {}", (Object)clientId);
        this.sessionStates.put(clientId, sessionState);
        return sessionState;
    }

    public MQTTSessionState removeSessionState(String clientId) throws Exception {
        logger.debug("Removing MQTT session state for: {}", (Object)clientId);
        if (clientId == null) {
            return null;
        }
        MQTTSessionState removed = this.sessionStates.remove(clientId);
        if (removed != null && removed.getSubscriptions().size() > 0) {
            this.removeDurableSubscriptionState(clientId);
        }
        return removed;
    }

    public void removeDurableSubscriptionState(String clientId) throws Exception {
        if (this.subscriptionPersistenceEnabled) {
            int deletedCount = this.sessionStore.deleteMatchingReferences(FilterImpl.createFilter((String)new StringBuilder((CharSequence)Message.HDR_LAST_VALUE_NAME).append(" = '").append(clientId).append("'").toString()));
            logger.debug("Removed {} durable MQTT subscription record(s) for: {}", (Object)deletedCount, (Object)clientId);
        }
    }

    public Map<String, MQTTSessionState> getSessionStates() {
        return new HashMap<String, MQTTSessionState>(this.sessionStates);
    }

    public String toString() {
        return "MQTTSessionStateManager@" + Integer.toHexString(System.identityHashCode(this));
    }

    public void storeDurableSubscriptionState(MQTTSessionState state) throws Exception {
        if (this.subscriptionPersistenceEnabled) {
            logger.debug("Adding durable MQTT subscription record for: {}", (Object)state.getClientId());
            TransactionImpl tx = new TransactionImpl(this.server.getStorageManager());
            tx.setAsync(true);
            this.server.getPostOffice().route((Message)MQTTStateManager.serializeState(state, this.server.getStorageManager().generateID()), (Transaction)tx, false);
            tx.commit();
        }
    }

    public static CoreMessage serializeState(MQTTSessionState state, long messageID) {
        CoreMessage message = new CoreMessage().initBuffer(50).setMessageID(messageID);
        message.setAddress("$sys.mqtt.sessions");
        message.setDurable(true);
        message.putStringProperty(Message.HDR_LAST_VALUE_NAME, state.getClientId());
        Map<String, MQTTSessionState.SubscriptionItem> subscriptions = state.getSubscriptionsPlusID();
        ActiveMQBuffer buf = message.getBodyBuffer();
        buf.writeByte((byte)0);
        buf.writeInt(subscriptions.size());
        logger.debug("Serializing {} subscriptions", (Object)subscriptions.size());
        for (MQTTSessionState.SubscriptionItem item : subscriptions.values()) {
            MqttTopicSubscription sub = item.getSubscription();
            buf.writeString(sub.topicFilter());
            buf.writeInt(sub.option().qos().value());
            buf.writeBoolean(sub.option().isNoLocal());
            buf.writeBoolean(sub.option().isRetainAsPublished());
            buf.writeInt(sub.option().retainHandling().value());
            buf.writeNullableInt(item.getId());
        }
        return message;
    }

    public boolean isClientConnected(String clientId, MQTTConnection connection) {
        MQTTConnection connectedConn = this.connectedClients.get(clientId);
        if (connectedConn != null) {
            return ((Object)((Object)connectedConn)).equals((Object)connection);
        }
        return false;
    }

    public boolean isClientConnected(String clientId) {
        return this.connectedClients.containsKey(clientId);
    }

    public void removeConnectedClient(String clientId) {
        this.connectedClients.remove(clientId);
    }

    public MQTTConnection addConnectedClient(String clientId, MQTTConnection connection) {
        return this.connectedClients.put(clientId, connection);
    }

    public MQTTConnection getConnectedClient(String clientId) {
        return this.connectedClients.get(clientId);
    }

    public Map<String, MQTTConnection> getConnectedClients() {
        return this.connectedClients;
    }
}

