/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.connect.bridge;

import java.io.Closeable;
import java.lang.invoke.MethodHandles;
import java.util.Objects;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.core.config.TransformerConfiguration;
import org.apache.activemq.artemis.core.server.transformer.Transformer;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeAsyncCompletion;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeFromPolicyManager;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeManager;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeMetrics;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgePolicy;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeReceiverConfiguration;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeReceiverInfo;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPException;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPConnectionContext;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPSessionContext;
import org.apache.activemq.artemis.protocol.amqp.proton.AmqpSupport;
import org.apache.activemq.artemis.protocol.amqp.proton.ProtonAbstractReceiver;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.Accepted;
import org.apache.qpid.proton.amqp.messaging.Modified;
import org.apache.qpid.proton.amqp.messaging.Rejected;
import org.apache.qpid.proton.amqp.messaging.Released;
import org.apache.qpid.proton.engine.Link;
import org.apache.qpid.proton.engine.Receiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AMQPBridgeReceiver
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected static final Symbol[] OUTCOMES = new Symbol[]{Accepted.DESCRIPTOR_SYMBOL, Rejected.DESCRIPTOR_SYMBOL, Released.DESCRIPTOR_SYMBOL, Modified.DESCRIPTOR_SYMBOL};
    protected static final Modified DEFAULT_OUTCOME = new Modified();
    protected static final AtomicLong LINK_SEQUENCE_ID;
    protected final AMQPBridgeManager bridgeManager;
    protected final AMQPBridgeFromPolicyManager policyManager;
    protected final AMQPBridgeReceiverConfiguration configuration;
    protected final AMQPBridgeReceiverInfo receiverInfo;
    protected final AMQPBridgePolicy policy;
    protected final AMQPConnectionContext connection;
    protected final AMQPSessionContext session;
    protected final Transformer transformer;
    protected final AtomicBoolean closed = new AtomicBoolean();
    protected final AMQPBridgeMetrics.ReceiverMetrics metrics;
    protected ProtonAbstractReceiver receiver;
    protected Receiver protonReceiver;
    protected volatile boolean initialized;
    protected Consumer<AMQPBridgeReceiver> remoteOpenHandler;
    protected Consumer<AMQPBridgeReceiver> remoteCloseHandler;

    public AMQPBridgeReceiver(AMQPBridgeFromPolicyManager policyManager, AMQPBridgeReceiverConfiguration configuration, AMQPSessionContext session, AMQPBridgeReceiverInfo receiverInfo, AMQPBridgePolicy policy, AMQPBridgeMetrics.ReceiverMetrics metrics) {
        this.policyManager = policyManager;
        this.bridgeManager = policyManager.getBridgeManager();
        this.receiverInfo = receiverInfo;
        this.policy = policy;
        this.connection = session.getAMQPConnectionContext();
        this.session = session;
        this.configuration = configuration;
        this.metrics = metrics;
        TransformerConfiguration transformerConfiguration = policy.getTransformerConfiguration();
        this.transformer = transformerConfiguration != null ? this.bridgeManager.getServer().getServiceRegistry().getBridgeTransformer(policy.getPolicyName(), transformerConfiguration) : m -> m;
    }

    public abstract int getReceiverIdleTimeout();

    public boolean isClosed() {
        return this.closed.get();
    }

    public final AMQPBridgeReceiverInfo.ReceiverRole getRole() {
        return this.receiverInfo.getRole();
    }

    public final AMQPBridgeFromPolicyManager getPolicyManager() {
        return this.policyManager;
    }

    public final long getMessagesReceived() {
        return this.metrics.getMessagesReceived();
    }

    public final boolean isInitialized() {
        return this.initialized;
    }

    public void initialize() {
        if (this.initialized) {
            throw new IllegalStateException("A receiver should only be initialized once");
        }
        this.initialized = true;
        this.connection.runLater(this::doCreateReceiver);
    }

    protected abstract void doCreateReceiver();

    public final void startAsync(AMQPBridgeAsyncCompletion<AMQPBridgeReceiver> completion) {
        Objects.requireNonNull(completion, "The asynchronous completion object cannot be null");
        if (this.closed.get()) {
            throw new IllegalStateException("The receiver has already been closed.");
        }
        if (!this.initialized) {
            throw new IllegalStateException("A receiver must be initialized before a start call");
        }
        this.connection.runLater(() -> {
            try {
                if (this.receiver == null) {
                    throw new IllegalStateException("The receiver was either not initialized or the receiver create failed");
                }
                this.receiver.start();
                completion.onComplete(this);
            }
            catch (Exception error) {
                completion.onException(this, error);
            }
            this.connection.flush();
        });
    }

    public final void stopAsync(AMQPBridgeAsyncCompletion<AMQPBridgeReceiver> completion) {
        Objects.requireNonNull(completion, "The asynchronous completion object cannot be null");
        if (!this.initialized) {
            throw new IllegalStateException("A receiver must be initialized before a stop call");
        }
        this.connection.runLater(() -> {
            try {
                if (this.receiver == null) {
                    throw new IllegalStateException("The receiver was either not yet initialized or the receiver create failed");
                }
                this.receiver.stop(this.configuration.getReceiverQuiesceTimeout(), (rcvr, stopped) -> {
                    try {
                        if (stopped.booleanValue()) {
                            completion.onComplete(this);
                        } else {
                            completion.onException(this, new TimeoutException("Timed out waiting for the AMQP link to stop"));
                        }
                    }
                    catch (Exception ex) {
                        logger.trace("Caught error running provided completion callback: ", (Throwable)ex);
                    }
                });
            }
            catch (Exception error) {
                completion.onException(this, error);
            }
            this.connection.flush();
        });
    }

    @Override
    public final void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.connection.runLater(() -> {
                this.bridgeManager.removeLinkClosedInterceptor(this.receiverInfo.getId());
                if (this.receiver != null) {
                    try {
                        this.receiver.close(false);
                    }
                    catch (ActiveMQAMQPException activeMQAMQPException) {
                    }
                    finally {
                        this.receiver = null;
                    }
                }
                if (this.protonReceiver != null) {
                    try {
                        this.protonReceiver.close();
                    }
                    finally {
                        this.protonReceiver = null;
                    }
                }
                this.connection.flush();
            });
        }
    }

    public final AMQPBridgePolicy getPolicy() {
        return this.policy;
    }

    public final AMQPBridgeManager getBridgeManager() {
        return this.bridgeManager;
    }

    public final AMQPBridgeReceiverInfo getReceiverInfo() {
        return this.receiverInfo;
    }

    public final AMQPBridgeReceiver setRemoteOpenHandler(Consumer<AMQPBridgeReceiver> handler) {
        if (this.protonReceiver != null) {
            throw new IllegalStateException("Cannot set a remote open handler after the bridgeManager receiver is started");
        }
        this.remoteOpenHandler = handler;
        return this;
    }

    public final AMQPBridgeReceiver setRemoteClosedHandler(Consumer<AMQPBridgeReceiver> handler) {
        if (this.protonReceiver != null) {
            throw new IllegalStateException("Cannot set a remote close handler after the bridgeManager receiver is started");
        }
        this.remoteCloseHandler = handler;
        return this;
    }

    protected final void recordMessageReceived(Message message) {
        this.metrics.incrementMessagesReceived();
    }

    protected final Symbol[] getRemoteTerminusCapabilities() {
        if (this.policy.getRemoteTerminusCapabilities() != null && !this.policy.getRemoteTerminusCapabilities().isEmpty()) {
            return this.policy.getRemoteTerminusCapabilities().toArray(new Symbol[0]);
        }
        return null;
    }

    protected final boolean remoteLinkClosedInterceptor(Link link) {
        if (link == this.protonReceiver && link.getRemoteCondition() != null && link.getRemoteCondition().getCondition() != null) {
            Symbol errorCondition = link.getRemoteCondition().getCondition();
            if (AmqpSupport.RESOURCE_DELETED.equals(errorCondition)) {
                return true;
            }
            if (AmqpSupport.NOT_FOUND.equals(errorCondition)) {
                return true;
            }
            if (AmqpSupport.DETACH_FORCED.equals(errorCondition)) {
                return true;
            }
        }
        return false;
    }

    static {
        DEFAULT_OUTCOME.setDeliveryFailed(Boolean.valueOf(true));
        LINK_SEQUENCE_ID = new AtomicLong();
    }
}

