/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.service.jmx.handler.notification;

import java.io.IOException;
import javax.management.MBeanException;
import javax.management.ReflectionException;
import org.jolokia.json.JSONObject;
import org.jolokia.server.core.request.EmptyResponseException;
import org.jolokia.server.core.request.notification.AddCommand;
import org.jolokia.server.core.request.notification.ClientCommand;
import org.jolokia.server.core.request.notification.NotificationCommand;
import org.jolokia.server.core.request.notification.OpenCommand;
import org.jolokia.server.core.request.notification.RemoveCommand;
import org.jolokia.server.core.service.api.JolokiaContext;
import org.jolokia.server.core.service.notification.NotificationBackendManager;
import org.jolokia.server.core.util.jmx.MBeanServerAccess;
import org.jolokia.service.jmx.handler.notification.NotificationListenerDelegate;

public class NotificationDispatcher {
    private final NotificationListenerDelegate listenerDelegate;
    private final NotificationBackendManager backendManager;

    public NotificationDispatcher(JolokiaContext pContext) {
        this.backendManager = new NotificationBackendManager(pContext);
        this.listenerDelegate = new NotificationListenerDelegate(this.backendManager);
    }

    public Object dispatch(MBeanServerAccess pExecutor, NotificationCommand pCommand) throws MBeanException, IOException, ReflectionException, EmptyResponseException {
        String client = pCommand instanceof ClientCommand ? ((ClientCommand)pCommand).getClient() : null;
        switch (pCommand.getType()) {
            case REGISTER: {
                return this.register();
            }
            case UNREGISTER: {
                this.listenerDelegate.unregister(pExecutor, client);
                return null;
            }
            case ADD: {
                return this.listenerDelegate.addListener(pExecutor, (AddCommand)pCommand);
            }
            case REMOVE: {
                this.listenerDelegate.removeListener(pExecutor, client, ((RemoveCommand)pCommand).getHandle());
                return null;
            }
            case PING: {
                this.listenerDelegate.refresh(client);
                return null;
            }
            case OPEN: {
                this.listenerDelegate.openChannel((OpenCommand)pCommand);
            }
            case LIST: {
                return this.listenerDelegate.list(client);
            }
        }
        throw new UnsupportedOperationException("Unsupported notification command " + pCommand.getType());
    }

    private JSONObject register() {
        String id = this.listenerDelegate.register();
        JSONObject ret = new JSONObject();
        ret.put((Object)"backend", (Object)this.backendManager.getBackendConfig());
        ret.put((Object)"id", (Object)id);
        return ret;
    }
}

