/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.connect.federation;

import java.util.Objects;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanOperationInfo;
import javax.management.NotCompliantMBeanException;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.core.management.impl.AbstractControl;
import org.apache.activemq.artemis.core.management.impl.MBeanInfoHelper;
import org.apache.activemq.artemis.core.server.ServerConsumer;
import org.apache.activemq.artemis.logs.AuditLogger;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationProducerControl;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationSenderController;
import org.apache.activemq.artemis.utils.CompositeAddress;

public class AMQPFederationProducerControlType
extends AbstractControl
implements AMQPFederationProducerControl {
    private final AMQPFederationSenderController senderController;
    private final String address;
    private final String queue;
    private final RoutingType routingType;
    private final String fqqn;
    private final String filterString;
    private final int priority;

    public AMQPFederationProducerControlType(AMQPFederationSenderController senderController) throws NotCompliantMBeanException {
        super(AMQPFederationProducerControl.class, senderController.getServer().getStorageManager());
        ServerConsumer consumer = senderController.getServerConsumer();
        Objects.requireNonNull(consumer, "The provided sender controller must have an associated server consumer");
        this.senderController = senderController;
        this.address = consumer.getQueueAddress().toString();
        this.queue = consumer.getQueueName().toString();
        this.routingType = consumer.getQueueType();
        this.fqqn = CompositeAddress.toFullyQualified((String)this.address, (String)this.queue);
        this.priority = consumer.getPriority();
        this.filterString = consumer.getFilterString() == null ? null : consumer.getFilterString().toString();
    }

    @Override
    public long getMessagesSent() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getMessagesSent((Object)this.senderController);
        }
        this.clearIO();
        try {
            long l = this.senderController.getMessagesSent();
            return l;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public String getRole() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getRole((Object)this.senderController);
        }
        this.clearIO();
        try {
            String string = this.senderController.getRole().toString();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public String getQueueName() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getQueueName((Object)this.senderController);
        }
        this.clearIO();
        try {
            String string = this.queue;
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public String getAddress() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getAddress((Object)this.senderController);
        }
        this.clearIO();
        try {
            String string = this.address;
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public String getFqqn() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getFqqn((Object)this.senderController);
        }
        this.clearIO();
        try {
            String string = this.fqqn;
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public String getRoutingType() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getRoutingType((Object)this.senderController);
        }
        this.clearIO();
        try {
            String string = this.routingType.toString();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public String getFilterString() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getFilterString((Object)this.senderController);
        }
        this.clearIO();
        try {
            String string = this.filterString;
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public int getPriority() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getPriority((Object)this.senderController);
        }
        this.clearIO();
        try {
            int n = this.priority;
            return n;
        }
        finally {
            this.blockOnIO();
        }
    }

    protected MBeanOperationInfo[] fillMBeanOperationInfo() {
        return MBeanInfoHelper.getMBeanOperationsInfo(AMQPFederationProducerControl.class);
    }

    protected MBeanAttributeInfo[] fillMBeanAttributeInfo() {
        return MBeanInfoHelper.getMBeanAttributesInfo(AMQPFederationProducerControl.class);
    }
}

