/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.connect.mirror;

import io.netty.util.collection.LongObjectHashMap;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.LongSupplier;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.io.IOCriticalErrorListener;
import org.apache.activemq.artemis.core.journal.RecordInfo;
import org.apache.activemq.artemis.core.journal.collections.AbstractHashMapPersister;
import org.apache.activemq.artemis.core.journal.collections.JournalHashMap;
import org.apache.activemq.artemis.core.journal.collections.JournalHashMapProvider;
import org.apache.activemq.artemis.core.journal.collections.MapStorageManager;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.paging.cursor.PageSubscription;
import org.apache.activemq.artemis.core.paging.cursor.PagedReference;
import org.apache.activemq.artemis.core.paging.impl.Page;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.persistence.impl.journal.OperationContextImpl;
import org.apache.activemq.artemis.core.persistence.impl.journal.codec.AckRetry;
import org.apache.activemq.artemis.core.postoffice.PostOffice;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.core.server.ActiveMQScheduledComponent;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.RoutingContext;
import org.apache.activemq.artemis.core.server.impl.AckReason;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.server.mirror.MirrorController;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.core.transaction.impl.TransactionImpl;
import org.apache.activemq.artemis.protocol.amqp.connect.mirror.AMQPMirrorControllerTarget;
import org.apache.activemq.artemis.protocol.amqp.connect.mirror.AckManagerProvider;
import org.apache.activemq.artemis.protocol.amqp.connect.mirror.ReferenceIDSupplier;
import org.apache.activemq.artemis.protocol.amqp.logger.ActiveMQAMQPProtocolLogger;
import org.apache.activemq.artemis.utils.collections.NodeStoreFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AckManager
implements ActiveMQComponent {
    private static DisabledAckMirrorController disabledAckMirrorController = new DisabledAckMirrorController();
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    final Set<AMQPMirrorControllerTarget> mirrorControllerTargets = new HashSet<AMQPMirrorControllerTarget>();
    final LongSupplier sequenceGenerator;
    final JournalHashMapProvider<AckRetry, AckRetry, Queue> journalHashMapProvider;
    final ActiveMQServer server;
    final Configuration configuration;
    final ReferenceIDSupplier referenceIDSupplier;
    final IOCriticalErrorListener ioCriticalErrorListener;
    volatile MultiStepProgress progress;
    ActiveMQScheduledComponent scheduledComponent;

    public AckManager(ActiveMQServer server) {
        assert (server != null && server.getConfiguration() != null);
        this.server = server;
        this.configuration = server.getConfiguration();
        this.ioCriticalErrorListener = server.getIoCriticalErrorListener();
        this.sequenceGenerator = () -> ((StorageManager)server.getStorageManager()).generateID();
        this.journalHashMapProvider = new JournalHashMapProvider(this.sequenceGenerator, (MapStorageManager)server.getStorageManager(), (AbstractHashMapPersister)AckRetry.getPersister(), 53, OperationContextImpl::getContext, arg_0 -> ((PostOffice)server.getPostOffice()).findQueue(arg_0), server.getIoCriticalErrorListener());
        this.referenceIDSupplier = new ReferenceIDSupplier(server);
    }

    public void reload(RecordInfo recordInfo) {
        this.journalHashMapProvider.reload(recordInfo);
    }

    public synchronized void stop() {
        if (this.scheduledComponent != null) {
            this.scheduledComponent.stop();
            this.scheduledComponent = null;
        }
        AckManagerProvider.remove(this.server);
        logger.debug("Stopping ackmanager on server {}", (Object)this.server);
    }

    public synchronized boolean isStarted() {
        return this.scheduledComponent != null && this.scheduledComponent.isStarted();
    }

    public synchronized void start() {
        if (logger.isDebugEnabled()) {
            logger.debug("Starting ACKManager on {} with period = {}, minQueueAttempts={}, maxPageAttempts={}", new Object[]{this.server, this.configuration.getMirrorAckManagerRetryDelay(), this.configuration.getMirrorAckManagerQueueAttempts(), this.configuration.getMirrorAckManagerPageAttempts()});
        }
        if (!this.isStarted()) {
            this.scheduledComponent = new ActiveMQScheduledComponent(this.server.getScheduledPool(), (Executor)this.server.getExecutorFactory().getExecutor(), this.server.getConfiguration().getMirrorAckManagerRetryDelay(), this.server.getConfiguration().getMirrorAckManagerRetryDelay(), TimeUnit.MILLISECONDS, true){

                public void run() {
                    AckManager.this.beginRetry();
                }
            };
            this.scheduledComponent.start();
            this.scheduledComponent.delay();
        } else {
            logger.debug("Starting ignored on server {}", (Object)this.server);
        }
    }

    public void beginRetry() {
        logger.trace("being retry server {}", (Object)this.server);
        if (this.initRetry()) {
            logger.trace("Starting process to retry, server={}", (Object)this.server);
            this.progress.nextStep();
        } else {
            logger.trace("Retry already happened");
        }
    }

    public void endRetry() {
        ActiveMQScheduledComponent scheduleComponentReference;
        logger.trace("Retry done on server {}", (Object)this.server);
        this.progress = null;
        if (!this.sortRetries().isEmpty() && (scheduleComponentReference = this.scheduledComponent) != null) {
            try {
                scheduleComponentReference.delay();
            }
            catch (RejectedExecutionException ree) {
                logger.debug("AckManager could not schedule a new retry due to the executor being shutdown {}", (Object)ree.getMessage(), (Object)ree);
            }
        }
    }

    public boolean initRetry() {
        if (this.progress != null) {
            logger.trace("Retry already in progress, we will wait next time, server={}", (Object)this.server);
            return false;
        }
        HashMap<SimpleString, LongObjectHashMap<JournalHashMap<AckRetry, AckRetry, Queue>>> retries = this.sortRetries();
        this.flushMirrorTargets();
        if (retries.isEmpty()) {
            logger.trace("Nothing to retry!, server={}", (Object)this.server);
            return false;
        }
        this.progress = new MultiStepProgress(retries);
        return true;
    }

    public synchronized void registerMirror(AMQPMirrorControllerTarget mirrorTarget) {
        this.mirrorControllerTargets.add(mirrorTarget);
    }

    public synchronized void unregisterMirror(AMQPMirrorControllerTarget mirrorTarget) {
        this.mirrorControllerTargets.remove(mirrorTarget);
    }

    private void flushMirrorTargets() {
        logger.debug("scanning and flushing mirror targets");
        List<AMQPMirrorControllerTarget> targetCopy = this.copyTargets();
        targetCopy.forEach(AMQPMirrorControllerTarget::flush);
    }

    private synchronized List<AMQPMirrorControllerTarget> copyTargets() {
        return new ArrayList<AMQPMirrorControllerTarget>(this.mirrorControllerTargets);
    }

    public HashMap<SimpleString, LongObjectHashMap<JournalHashMap<AckRetry, AckRetry, Queue>>> sortRetries() {
        HashMap<SimpleString, LongObjectHashMap<JournalHashMap<AckRetry, AckRetry, Queue>>> retriesByAddress = new HashMap<SimpleString, LongObjectHashMap<JournalHashMap<AckRetry, AckRetry, Queue>>>();
        for (JournalHashMap ackRetries : this.journalHashMapProvider.getMaps()) {
            Queue queue;
            if (ackRetries.isEmpty() || (queue = (Queue)ackRetries.getContext()) == null) continue;
            SimpleString address = queue.getAddress();
            LongObjectHashMap queueRetriesOnAddress = retriesByAddress.get(address);
            if (queueRetriesOnAddress == null) {
                queueRetriesOnAddress = new LongObjectHashMap();
                retriesByAddress.put(address, (LongObjectHashMap<JournalHashMap<AckRetry, AckRetry, Queue>>)queueRetriesOnAddress);
            }
            queueRetriesOnAddress.put(queue.getID(), (Object)ackRetries);
        }
        return retriesByAddress;
    }

    private boolean isEmpty(LongObjectHashMap<JournalHashMap<AckRetry, AckRetry, Queue>> queuesToRetry) {
        AtomicBoolean empty = new AtomicBoolean(true);
        queuesToRetry.forEach((id, journalHashMap) -> {
            if (!journalHashMap.isEmpty()) {
                empty.set(false);
            }
        });
        return empty.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retryAddress(SimpleString address, LongObjectHashMap<JournalHashMap<AckRetry, AckRetry, Queue>> acksToRetry) {
        MirrorController previousController = AMQPMirrorControllerTarget.getControllerInUse();
        logger.trace("retrying address {} on server {}", (Object)address, (Object)this.server);
        try {
            AMQPMirrorControllerTarget.setControllerInUse(disabledAckMirrorController);
            if (this.checkRetriesAndPaging(acksToRetry)) {
                logger.trace("scanning paging for {}", (Object)address);
                AckRetry key = new AckRetry();
                PagingStore store = this.server.getPagingManager().getPageStore(address);
                for (long pageId = store.getFirstPage(); pageId <= store.getCurrentWritingPage(); ++pageId) {
                    if (this.isEmpty(acksToRetry)) {
                        logger.trace("Retry stopped while reading page {} on address {} as the outcome is now empty, server={}", new Object[]{pageId, address, this.server});
                        break;
                    }
                    Page page = this.openPage(store, pageId);
                    if (page == null) continue;
                    try {
                        this.retryPage(acksToRetry, address, page, key);
                        continue;
                    }
                    finally {
                        page.usageDown();
                    }
                }
                this.validateExpiredSet(address, acksToRetry);
            } else {
                logger.trace("Page Scan not required for address {}", (Object)address);
            }
        }
        catch (Throwable e) {
            logger.warn(e.getMessage(), e);
        }
        finally {
            AMQPMirrorControllerTarget.setControllerInUse(previousController);
        }
    }

    private Page openPage(PagingStore store, long pageID) throws Throwable {
        Page page = store.newPageObject(pageID);
        if (page.getFile().exists()) {
            page.getMessages();
            return page;
        }
        return null;
    }

    private void validateExpiredSet(SimpleString address, LongObjectHashMap<JournalHashMap<AckRetry, AckRetry, Queue>> queuesToRetry) {
        queuesToRetry.forEach((q, r) -> this.validateExpireSet(address, (long)q, (JournalHashMap<AckRetry, AckRetry, Queue>)r));
    }

    private void validateExpireSet(SimpleString address, long queueID, JournalHashMap<AckRetry, AckRetry, Queue> retries) {
        for (AckRetry retry : retries.valuesCopy()) {
            if (retry.getQueueAttempts() >= this.configuration.getMirrorAckManagerQueueAttempts()) {
                if (retry.attemptedPage() >= this.configuration.getMirrorAckManagerPageAttempts()) {
                    if (this.configuration.isMirrorAckManagerWarnUnacked()) {
                        ActiveMQAMQPProtocolLogger.LOGGER.ackRetryFailed(retry, address, queueID);
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("Retried {} {} times, giving up on the entry now. Configured Page Attempts={}", new Object[]{retry, retry.getPageAttempts(), this.configuration.getMirrorAckManagerPageAttempts()});
                    }
                    retries.remove((Object)retry);
                    continue;
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Retry {} attempted {} times on paging, Configuration Page Attempts={}", new Object[]{retry, retry.getPageAttempts(), this.configuration.getMirrorAckManagerPageAttempts()});
                continue;
            }
            logger.debug("Retry {} queue attempted {} times on paging, QueueAttempts {} Configuration Page Attempts={}", new Object[]{retry, retry.getQueueAttempts(), retry.getPageAttempts(), this.configuration.getMirrorAckManagerPageAttempts()});
        }
    }

    private void retryPage(LongObjectHashMap<JournalHashMap<AckRetry, AckRetry, Queue>> queuesToRetry, SimpleString address, Page page, AckRetry key) throws Exception {
        block2: {
            logger.debug("scanning for acks on page {} on address {}", (Object)page.getPageId(), (Object)address);
            TransactionImpl transaction = new TransactionImpl(this.server.getStorageManager()).setAsync(true);
            page.getMessages().forEach(pagedMessage -> {
                for (int i = 0; i < pagedMessage.getQueueIDs().length; ++i) {
                    long queueID = pagedMessage.getQueueIDs()[i];
                    JournalHashMap retries = (JournalHashMap)queuesToRetry.get(queueID);
                    if (retries != null) {
                        AckRetry ackRetry;
                        block6: {
                            Queue queue;
                            String serverID = this.referenceIDSupplier.getServerID(pagedMessage.getMessage());
                            if (serverID == null) {
                                serverID = this.referenceIDSupplier.getDefaultNodeID();
                            }
                            long id = this.referenceIDSupplier.getID(pagedMessage.getMessage());
                            logger.trace("Looking for retry on serverID={}, id={} on server={}", new Object[]{serverID, id, this.server});
                            key.setNodeID(serverID).setMessageID(id);
                            ackRetry = (AckRetry)retries.get((Object)key);
                            if (ackRetry == null || ackRetry.getQueueAttempts() <= this.configuration.getMirrorAckManagerQueueAttempts() || (queue = (Queue)retries.getContext()) == null) continue;
                            PageSubscription subscription = queue.getPageSubscription();
                            if (!subscription.isAcked(pagedMessage)) {
                                PagedReference reference = ((Queue)retries.getContext()).getPagingStore().getCursorProvider().newReference(pagedMessage, subscription);
                                try {
                                    subscription.ackTx((Transaction)transaction, reference, false);
                                    subscription.getQueue().postAcknowledge((MessageReference)reference, ackRetry.getReason(), false);
                                }
                                catch (Exception e) {
                                    logger.warn(e.getMessage(), (Throwable)e);
                                    if (this.ioCriticalErrorListener == null) break block6;
                                    this.ioCriticalErrorListener.onIOException((Throwable)e, e.getMessage(), null);
                                }
                            }
                        }
                        retries.remove((Object)ackRetry, transaction.getID());
                        transaction.setContainsPersistent();
                        logger.trace("retry performed ok, ackRetry={} for message={} on queue", (Object)ackRetry, pagedMessage);
                        continue;
                    }
                    logger.trace("Retry key={} not found server={}", (Object)key, (Object)this.server);
                }
            });
            try {
                transaction.commit();
            }
            catch (Exception e) {
                logger.warn(e.getMessage(), (Throwable)e);
                if (this.ioCriticalErrorListener == null) break block2;
                this.ioCriticalErrorListener.onIOException((Throwable)e, e.getMessage(), null);
            }
        }
    }

    private boolean checkRetriesAndPaging(LongObjectHashMap<JournalHashMap<AckRetry, AckRetry, Queue>> queuesToRetry) {
        boolean needScanOnPaging = false;
        for (Map.Entry entry : queuesToRetry.entrySet()) {
            JournalHashMap queueRetries = (JournalHashMap)entry.getValue();
            Queue queue = (Queue)queueRetries.getContext();
            for (AckRetry retry : queueRetries.valuesCopy()) {
                if (this.ack(retry.getNodeID(), queue, retry.getMessageID(), retry.getReason(), false)) {
                    logger.trace("Removing retry {} as the retry went ok", (Object)retry);
                    queueRetries.remove((Object)retry);
                    continue;
                }
                int retried = retry.attemptedQueue();
                if (logger.isTraceEnabled()) {
                    logger.trace("retry {} attempted {} times on the queue", (Object)retry, (Object)retried);
                }
                if (retried < this.configuration.getMirrorAckManagerQueueAttempts()) continue;
                needScanOnPaging = true;
            }
        }
        return needScanOnPaging;
    }

    public synchronized void addRetry(String nodeID, Queue queue, long messageID, AckReason reason) {
        if (nodeID == null) {
            nodeID = this.referenceIDSupplier.getDefaultNodeID();
        }
        AckRetry retry = new AckRetry(nodeID, messageID, reason);
        this.journalHashMapProvider.getMap(queue.getID().longValue(), (Object)queue).put((Object)retry, (Object)retry);
        if (this.scheduledComponent != null) {
            this.scheduledComponent.setPeriod((long)this.configuration.getMirrorAckManagerRetryDelay());
            this.scheduledComponent.delay();
        }
    }

    public boolean ack(String nodeID, Queue targetQueue, long messageID, AckReason reason, boolean allowRetry) {
        MessageReference reference;
        if (logger.isTraceEnabled()) {
            logger.trace("performAck (nodeID={}, messageID={}), targetQueue={}, allowRetry={})", new Object[]{nodeID, messageID, targetQueue.getName(), allowRetry});
        }
        if ((reference = targetQueue.removeWithSuppliedID(nodeID, messageID, (NodeStoreFactory)this.referenceIDSupplier)) == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("ACK Manager could not find reference nodeID={} (while localID={}), messageID={} on queue {}, server={}. Adding retry with minQueue={}, maxPage={}, delay={}", new Object[]{nodeID, this.referenceIDSupplier.getDefaultNodeID(), messageID, targetQueue.getName(), this.server, this.configuration.getMirrorAckManagerQueueAttempts(), this.configuration.getMirrorAckManagerPageAttempts(), this.configuration.getMirrorAckManagerRetryDelay()});
            }
            if (allowRetry) {
                if (this.configuration != null && this.configuration.isMirrorAckManagerWarnUnacked() && targetQueue.getConsumerCount() > 0) {
                    ActiveMQAMQPProtocolLogger.LOGGER.unackWithConsumer(targetQueue.getConsumerCount(), targetQueue.getName(), nodeID, messageID);
                } else {
                    logger.debug("There are {} consumers on queue {}, what made Ack for message with nodeID={}, messageID={} enter a retry list", new Object[]{targetQueue.getConsumerCount(), targetQueue.getName(), nodeID, messageID});
                }
                this.addRetry(nodeID, targetQueue, messageID, reason);
            }
            return false;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("ack worked well for messageID={} nodeID={} queue={}, reference={}", new Object[]{messageID, nodeID, reference.getQueue().getName(), reference});
            if (reference.isPaged()) {
                logger.trace("position for messageID={} = {}", (Object)messageID, (Object)((PagedReference)reference).getPosition());
            }
        }
        this.doACK(targetQueue, reference, reason);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doACK(Queue targetQueue, MessageReference reference, AckReason reason) {
        try {
            switch (reason) {
                case EXPIRED: {
                    targetQueue.expire(reference, null, false);
                    return;
                }
                default: {
                    TransactionImpl transaction = new TransactionImpl(this.server.getStorageManager());
                    targetQueue.acknowledge((Transaction)transaction, reference, reason, null, false);
                    transaction.commit();
                    if (!logger.isTraceEnabled()) return;
                    logger.trace("Transaction {} committed on acking reference {}", (Object)transaction.getID(), (Object)reference);
                    return;
                }
            }
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
            return;
        }
        finally {
            targetQueue.deliverAsync();
        }
    }

    class MultiStepProgress {
        HashMap<SimpleString, LongObjectHashMap<JournalHashMap<AckRetry, AckRetry, Queue>>> retryList;
        Iterator<Map.Entry<SimpleString, LongObjectHashMap<JournalHashMap<AckRetry, AckRetry, Queue>>>> retryIterator;

        MultiStepProgress(HashMap<SimpleString, LongObjectHashMap<JournalHashMap<AckRetry, AckRetry, Queue>>> retryList) {
            this.retryList = retryList;
            this.retryIterator = retryList.entrySet().iterator();
        }

        public void nextStep() {
            try {
                if (!this.retryIterator.hasNext()) {
                    logger.trace("Iterator is done on retry, server={}", (Object)AckManager.this.server);
                    AckManager.this.endRetry();
                } else {
                    Map.Entry<SimpleString, LongObjectHashMap<JournalHashMap<AckRetry, AckRetry, Queue>>> entry = this.retryIterator.next();
                    entry.getValue().values().forEach(this::deliveryAsync);
                    PagingStore pagingStore = AckManager.this.server.getPagingManager().getPageStore(entry.getKey());
                    pagingStore.execute(() -> {
                        AckManager.this.retryAddress((SimpleString)entry.getKey(), (LongObjectHashMap<JournalHashMap<AckRetry, AckRetry, Queue>>)((LongObjectHashMap)entry.getValue()));
                        this.nextStep();
                    });
                }
            }
            catch (Throwable e) {
                logger.warn(e.getMessage(), e);
                AckManager.this.endRetry();
            }
        }

        private void deliveryAsync(JournalHashMap<AckRetry, AckRetry, Queue> map) {
            Queue queue = (Queue)map.getContext();
            if (queue != null) {
                queue.deliverAsync();
            }
        }
    }

    private static class DisabledAckMirrorController
    implements MirrorController {
        private DisabledAckMirrorController() {
        }

        public boolean isRetryACK() {
            return true;
        }

        public void addAddress(AddressInfo addressInfo) throws Exception {
        }

        public void deleteAddress(AddressInfo addressInfo) throws Exception {
        }

        public void createQueue(QueueConfiguration queueConfiguration) throws Exception {
        }

        public void deleteQueue(SimpleString addressName, SimpleString queueName) throws Exception {
        }

        public void sendMessage(Transaction tx, Message message, RoutingContext context) {
        }

        public void postAcknowledge(MessageReference ref, AckReason reason) throws Exception {
        }

        public void preAcknowledge(Transaction tx, MessageReference ref, AckReason reason) throws Exception {
        }

        public String getRemoteMirrorId() {
            return null;
        }
    }
}

