/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.connect.federation;

import javax.management.MBeanAttributeInfo;
import javax.management.MBeanOperationInfo;
import javax.management.NotCompliantMBeanException;
import org.apache.activemq.artemis.core.management.impl.AbstractControl;
import org.apache.activemq.artemis.core.management.impl.MBeanInfoHelper;
import org.apache.activemq.artemis.logs.AuditLogger;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationPolicyControl;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationQueuePolicyManager;

public class AMQPFederationQueuePolicyControl
extends AbstractControl
implements AMQPFederationPolicyControl {
    private final AMQPFederationQueuePolicyManager policyManager;

    public AMQPFederationQueuePolicyControl(AMQPFederationQueuePolicyManager policyManager) throws NotCompliantMBeanException {
        super(AMQPFederationPolicyControl.class, policyManager.getFederation().getServer().getStorageManager());
        this.policyManager = policyManager;
    }

    @Override
    public String getType() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getType((Object)this.policyManager);
        }
        this.clearIO();
        try {
            String string = this.policyManager.getPolicyType().toString();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public String getName() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getName((Object)this.policyManager);
        }
        this.clearIO();
        try {
            String string = this.policyManager.getPolicyName();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public long getMessagesReceived() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getMessagesReceived((Object)this.policyManager);
        }
        this.clearIO();
        try {
            long l = this.policyManager.getMessagesReceived();
            return l;
        }
        finally {
            this.blockOnIO();
        }
    }

    protected MBeanOperationInfo[] fillMBeanOperationInfo() {
        return MBeanInfoHelper.getMBeanOperationsInfo(AMQPFederationPolicyControl.class);
    }

    protected MBeanAttributeInfo[] fillMBeanAttributeInfo() {
        return MBeanInfoHelper.getMBeanAttributesInfo(AMQPFederationPolicyControl.class);
    }
}

