/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.federation.internal;

import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.core.filter.Filter;
import org.apache.activemq.artemis.core.filter.impl.FilterImpl;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.postoffice.QueueBinding;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.ServerConsumer;
import org.apache.activemq.artemis.core.server.ServerSession;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerBasePlugin;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerBindingPlugin;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerConsumerPlugin;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.protocol.amqp.federation.FederationConsumerInfo;
import org.apache.activemq.artemis.protocol.amqp.federation.FederationReceiveFromQueuePolicy;
import org.apache.activemq.artemis.protocol.amqp.federation.internal.FederationConsumerInternal;
import org.apache.activemq.artemis.protocol.amqp.federation.internal.FederationInternal;
import org.apache.activemq.artemis.protocol.amqp.federation.internal.FederationPolicyManager;
import org.apache.activemq.artemis.protocol.amqp.federation.internal.FederationQueueEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FederationQueuePolicyManager
extends FederationPolicyManager
implements ActiveMQServerConsumerPlugin,
ActiveMQServerBindingPlugin {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected final Predicate<ServerConsumer> federationConsumerMatcher;
    protected final FederationReceiveFromQueuePolicy policy;
    protected final Map<FederationConsumerInfo, FederationQueueEntry> demandTracking = new HashMap<FederationConsumerInfo, FederationQueueEntry>();

    public FederationQueuePolicyManager(FederationInternal federation, FederationReceiveFromQueuePolicy queuePolicy) throws ActiveMQException {
        super(federation);
        Objects.requireNonNull(queuePolicy, "The Queue match policy cannot be null");
        this.policy = queuePolicy;
        this.federationConsumerMatcher = this.createFederationConsumerMatcher(this.server, queuePolicy);
    }

    @Override
    public FederationReceiveFromQueuePolicy getPolicy() {
        return this.policy;
    }

    public synchronized void start() {
        if (!this.federation.isStarted()) {
            throw new IllegalStateException("Cannot start a federation policy manager when the federation is stopped.");
        }
        if (!this.started) {
            this.started = true;
            this.handlePolicyManagerStarted(this.policy);
            this.server.registerBrokerPlugin((ActiveMQServerBasePlugin)this);
            this.scanAllQueueBindings();
        }
    }

    public synchronized void stop() {
        if (this.started) {
            this.server.unRegisterBrokerPlugin((ActiveMQServerBasePlugin)this);
            this.started = false;
            this.demandTracking.forEach((k, v) -> {
                if (v.hasConsumer()) {
                    v.getConsumer().close();
                }
            });
            this.demandTracking.clear();
        }
    }

    public synchronized void afterCreateConsumer(ServerConsumer consumer) {
        if (this.started) {
            this.reactIfConsumerMatchesPolicy(consumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void afterCloseConsumer(ServerConsumer consumer, boolean failed) {
        if (this.started) {
            String queueName = consumer.getQueue().getName().toString();
            FederationConsumerInfo consumerInfo = this.createConsumerInfo(consumer);
            FederationQueueEntry entry = this.demandTracking.get(consumerInfo);
            if (entry == null) {
                return;
            }
            entry.removeDemand(consumer);
            logger.trace("Reducing demand on federated queue {}, remaining demand? {}", (Object)queueName, (Object)entry.hasDemand());
            if (!entry.hasDemand() && entry.hasConsumer()) {
                FederationConsumerInternal federationConsuner = entry.getConsumer();
                try {
                    this.signalBeforeCloseFederationConsumer(federationConsuner);
                    federationConsuner.close();
                    this.signalAfterCloseFederationConsumer(federationConsuner);
                }
                finally {
                    this.demandTracking.remove(consumerInfo);
                }
            }
        }
    }

    public synchronized void afterRemoveBinding(Binding binding, Transaction tx, boolean deleteData) throws ActiveMQException {
        if (binding instanceof QueueBinding) {
            QueueBinding queueBinding = (QueueBinding)binding;
            String queueName = queueBinding.getQueue().getName().toString();
            this.demandTracking.values().forEach(entry -> {
                if (entry.getConsumerInfo().getQueueName().equals(queueName) && entry.hasConsumer()) {
                    entry.getConsumer().close();
                }
            });
        }
    }

    protected final void scanAllQueueBindings() {
        this.server.getPostOffice().getAllBindings().filter(b -> b instanceof QueueBinding).map(b -> (QueueBinding)b).forEach(b -> this.checkQueueForMatch(b.getQueue()));
    }

    protected final void checkQueueForMatch(Queue queue) {
        queue.getConsumers().stream().filter(consumer -> consumer instanceof ServerConsumer).map(c -> (ServerConsumer)c).forEach(this::reactIfConsumerMatchesPolicy);
    }

    protected final void reactIfConsumerMatchesPolicy(ServerConsumer consumer) {
        String queueName = consumer.getQueue().getName().toString();
        if (this.testIfQueueMatchesPolicy(consumer.getQueueAddress().toString(), queueName)) {
            FederationQueueEntry entry;
            if (this.federationConsumerMatcher.test(consumer)) {
                return;
            }
            logger.trace("Federation Policy matched on consumer for binding: {}", (Object)consumer.getBinding());
            FederationConsumerInfo consumerInfo = this.createConsumerInfo(consumer);
            if (this.demandTracking.containsKey(consumerInfo)) {
                logger.trace("Federation Queue Policy manager found existing demand for queue: {}, adding demand", (Object)queueName);
                entry = this.demandTracking.get(consumerInfo);
            } else {
                entry = this.createConsumerEntry(consumerInfo);
                this.demandTracking.put(consumerInfo, entry);
            }
            entry.addDemand(consumer);
            this.tryCreateFederationConsumerForQueue(entry, consumer.getQueue());
        }
    }

    private void tryCreateFederationConsumerForQueue(FederationQueueEntry queueEntry, Queue queue) {
        if (queueEntry.hasDemand() && !queueEntry.hasConsumer() && !this.isPluginBlockingFederationConsumerCreate(queue)) {
            logger.trace("Federation Queue Policy manager creating remote consumer for queue: {}", (Object)queueEntry.getQueueName());
            this.signalBeforeCreateFederationConsumer(queueEntry.getConsumerInfo());
            FederationConsumerInternal queueConsumer = this.createFederationConsumer(queueEntry.getConsumerInfo());
            queueConsumer.setRemoteClosedHandler(closedConsumer -> {
                FederationQueuePolicyManager federationQueuePolicyManager = this;
                synchronized (federationQueuePolicyManager) {
                    try {
                        FederationQueueEntry tracked = this.demandTracking.get(closedConsumer.getConsumerInfo());
                        if (tracked != null) {
                            tracked.clearConsumer();
                        }
                    }
                    finally {
                        closedConsumer.close();
                    }
                }
            });
            queueEntry.setConsumer(queueConsumer);
            queueConsumer.start();
            this.signalAfterCreateFederationConsumer(queueConsumer);
        }
    }

    public synchronized void afterRemoteQueueAdded(String addressName, String queueName) throws Exception {
        Queue queue;
        if (this.started && this.testIfQueueMatchesPolicy(queueName) && (queue = this.server.locateQueue(queueName)) != null) {
            this.demandTracking.forEach((k, v) -> {
                if (k.getQueueName().equals(queueName)) {
                    this.tryCreateFederationConsumerForQueue((FederationQueueEntry)v, queue);
                }
            });
        }
    }

    protected boolean testIfQueueMatchesPolicy(String address, String queueName) {
        return this.policy.test(address, queueName);
    }

    protected boolean testIfQueueMatchesPolicy(String queueName) {
        return this.policy.testQueue(queueName);
    }

    protected abstract FederationConsumerInfo createConsumerInfo(ServerConsumer var1);

    protected FederationQueueEntry createConsumerEntry(FederationConsumerInfo consumerInfo) {
        return new FederationQueueEntry(consumerInfo);
    }

    protected Predicate<ServerConsumer> createFederationConsumerMatcher(ActiveMQServer server, FederationReceiveFromQueuePolicy policy) throws ActiveMQException {
        if (policy.isIncludeFederated()) {
            return consumer -> false;
        }
        Filter metaDataMatcher = FilterImpl.createFilter((String)"\"federation-name\" IS NOT NULL");
        return consumer -> {
            ServerSession serverSession = server.getSessionByID(consumer.getSessionID());
            if (serverSession != null && serverSession.getMetaData() != null) {
                return metaDataMatcher.match(serverSession.getMetaData());
            }
            return false;
        };
    }

    protected abstract boolean isPluginBlockingFederationConsumerCreate(Queue var1);
}

