/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.check;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.apache.activemq.artemis.api.core.management.SimpleManagement;
import org.apache.activemq.artemis.cli.commands.ActionContext;
import org.apache.activemq.artemis.json.JsonArray;
import org.apache.activemq.artemis.json.JsonObject;
import org.apache.activemq.artemis.json.JsonString;

public class ClusterNodeVerifier
implements AutoCloseable {
    final String uri;
    final String user;
    final String password;
    final SimpleManagement simpleManagement;
    final long allowedVariance;

    public ClusterNodeVerifier(String uri, String user, String password) {
        this(uri, user, password, 1000L);
    }

    public ClusterNodeVerifier(String uri, String user, String password, long variance) {
        this.uri = uri;
        this.user = user;
        this.password = password;
        this.allowedVariance = variance;
        this.simpleManagement = new SimpleManagement(uri, user, password);
    }

    @Override
    public void close() throws Exception {
        this.simpleManagement.close();
    }

    public ClusterNodeVerifier open() throws Exception {
        this.simpleManagement.open();
        return this;
    }

    public boolean verify(ActionContext context) throws Exception {
        String mainID = this.getNodeID();
        JsonArray mainToplogy = this.fetchMainTopology();
        AtomicBoolean verificationResult = new AtomicBoolean(true);
        Map<String, TopologyItem> mainTopology = this.parseTopology(mainToplogy);
        boolean supportTime = true;
        try {
            this.fetchTopologyTime(mainTopology);
        }
        catch (Exception e) {
            supportTime = false;
        }
        if (supportTime) {
            this.verifyTime(context, mainTopology, verificationResult, supportTime);
        } else {
            context.out.println("*******************************************************************************************************************************");
            context.out.println("Topology on " + this.uri + " nodeID=" + mainID + " with " + mainToplogy.size() + " nodes :");
            this.printTopology(context, "", mainToplogy);
            context.out.println("*******************************************************************************************************************************");
        }
        mainTopology.forEach((a, b) -> {
            try {
                context.out.println("--> Verifying Topology for NodeID " + b.nodeID + ", primary = " + b.primary + ", backup = " + b.backup);
                if (b.primary != null) {
                    context.out.println("   verification on primary " + b.primary);
                    if (!this.subVerify(context, b.primary, mainTopology)) {
                        verificationResult.set(false);
                    } else {
                        context.out.println("   ok!");
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace(context.out);
                verificationResult.set(false);
            }
        });
        return verificationResult.get();
    }

    protected void verifyTime(ActionContext context, Map<String, TopologyItem> mainTopology, AtomicBoolean verificationResult, boolean supportTime) {
        String FORMAT = "%-40s | %-25s | %-19s | %-25s";
        context.out.println("*******************************************************************************************************************************");
        if (supportTime) {
            long allowedVarianceWithLatency;
            Long[] times = this.fetchTopologyTime(mainTopology);
            context.out.printf("%-40s | %-25s | %-19s | %-25s", "nodeID", "primary", "primary local time", "backup");
            context.out.println();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            long initialTime = System.currentTimeMillis();
            mainTopology.forEach((id, node) -> {
                context.out.printf("%-40s | %-25s | %-19s | %-25s", id, node.primary, this.formatDate(sdf, node.primaryTime), node.backup);
                context.out.println();
            });
            long latencyTime = System.currentTimeMillis() - initialTime;
            long min = Long.MAX_VALUE;
            long max = Long.MIN_VALUE;
            Long[] longArray = times;
            int n = longArray.length;
            for (int i = 0; i < n; ++i) {
                long l = longArray[i];
                if (l < min) {
                    min = l;
                }
                if (l <= max) continue;
                max = l;
            }
            long variance = times.length > 0 ? max - min : 0L;
            if (variance < (allowedVarianceWithLatency = this.allowedVariance + latencyTime)) {
                context.out.println("Time variance in the cluster is " + variance + " milliseconds");
            } else {
                context.out.println("WARNING: Time variance in the cluster is greater than " + allowedVarianceWithLatency + " milliseconds: " + variance + ". Please verify your server's NTP configuration.");
                verificationResult.set(false);
            }
        } else {
            context.out.println("The current management version does not support the getCurrentTimeMillis() method. Please verify whether your server's times are in sync and whether they are using NTP.");
        }
        context.out.println("*******************************************************************************************************************************");
    }

    String formatDate(SimpleDateFormat sdf, long time) {
        if (time == 0L) {
            return "";
        }
        return sdf.format(new Date(time));
    }

    protected Long[] fetchTopologyTime(Map<String, TopologyItem> topologyItemMap) {
        ArrayList times = new ArrayList(topologyItemMap.size() * 2);
        topologyItemMap.forEach((id, node) -> {
            if (node.primary != null) {
                try {
                    node.primaryTime = this.fetchTime(node.primary);
                    times.add(node.primaryTime);
                }
                catch (Exception e) {
                    ActionContext.system().err.println("Cannot fetch liveTime for nodeID=" + id + ", url=" + node.primary + " -> " + e.getMessage());
                    node.primaryTime = 0L;
                }
            }
        });
        return times.toArray(new Long[times.size()]);
    }

    private boolean subVerify(ActionContext context, String uri, Map<String, TopologyItem> mainTopology) throws Exception {
        JsonArray verifyTopology = this.fetchTopology(uri);
        Map<String, TopologyItem> verifyTopologyMap = this.parseTopology(verifyTopology);
        String result = this.compareTopology(mainTopology, verifyTopologyMap);
        if (result != null) {
            context.out.println(result);
            context.out.println("    Topology detailing for " + uri);
            this.printTopology(context, "    ", verifyTopology);
            return false;
        }
        return true;
    }

    public String compareTopology(Map<String, TopologyItem> mainTopology, Map<String, TopologyItem> compareTopology) {
        if (mainTopology.size() != compareTopology.size()) {
            return "main topology size " + mainTopology.size() + "!= compareTopology size " + compareTopology.size();
        }
        int matchElements = 0;
        for (Map.Entry<String, TopologyItem> entry : mainTopology.entrySet()) {
            TopologyItem item = compareTopology.get(entry.getKey());
            if (!item.equals(entry.getValue())) {
                return "Topology mistmatch on " + item;
            }
            ++matchElements;
        }
        if (matchElements != mainTopology.size()) {
            return "Not all elements match!";
        }
        return null;
    }

    Map<String, TopologyItem> parseTopology(JsonArray topology) {
        LinkedHashMap<String, TopologyItem> map = new LinkedHashMap<String, TopologyItem>();
        this.navigateTopology(topology, t -> map.put(t.nodeID, (TopologyItem)t));
        return map;
    }

    private void printTopology(ActionContext context, String prefix, JsonArray topology) {
        context.out.printf(prefix + "%-40s | %-25s | %-25s", "nodeID", "live", "backup");
        context.out.println();
        this.navigateTopology(topology, t -> {
            context.out.printf(prefix + "%-40s | %-25s | %-25s", t.nodeID, t.primary, t.backup);
            context.out.println();
        });
    }

    private void navigateTopology(JsonArray topology, Consumer<TopologyItem> consumer) {
        for (int i = 0; i < topology.size(); ++i) {
            JsonObject node = topology.getJsonObject(i);
            JsonString primary = node.getJsonString("primary");
            JsonString backup = node.getJsonString("backup");
            String nodeID = node.getString("nodeID");
            TopologyItem item = new TopologyItem(nodeID, primary != null ? primary.getString() : null, backup != null ? backup.getString() : null);
            consumer.accept(item);
        }
    }

    protected String getNodeID() throws Exception {
        return this.simpleManagement.getNodeID();
    }

    protected long fetchMainTime() throws Exception {
        return this.simpleManagement.getCurrentTimeMillis();
    }

    protected long fetchTime(String uri) throws Exception {
        SimpleManagement management = new SimpleManagement(uri, this.user, this.password);
        return management.getCurrentTimeMillis();
    }

    protected JsonArray fetchMainTopology() throws Exception {
        return this.simpleManagement.listNetworkTopology();
    }

    protected JsonArray fetchTopology(String uri) throws Exception {
        SimpleManagement management = new SimpleManagement(uri, this.user, this.password);
        return management.listNetworkTopology();
    }

    public static class TopologyItem {
        final String nodeID;
        final String primary;
        final String backup;
        long primaryTime;
        long backupTime;

        TopologyItem(String nodeID, String primary, String backup) {
            this.nodeID = nodeID;
            this.primary = primary != null ? "tcp://" + primary : null;
            this.backup = backup != null ? "tcp://" + backup : null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TopologyItem item = (TopologyItem)o;
            if (this.nodeID != null ? !this.nodeID.equals(item.nodeID) : item.nodeID != null) {
                return false;
            }
            if (this.primary != null ? !this.primary.equals(item.primary) : item.primary != null) {
                return false;
            }
            return this.backup != null ? this.backup.equals(item.backup) : item.backup == null;
        }

        public int hashCode() {
            int result = this.nodeID != null ? this.nodeID.hashCode() : 0;
            result = 31 * result + (this.primary != null ? this.primary.hashCode() : 0);
            result = 31 * result + (this.backup != null ? this.backup.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "TopologyItem{nodeID='" + this.nodeID + "', primary='" + this.primary + "', backup='" + this.backup + "'}";
        }
    }
}

