/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.paging.cursor.impl;

import io.netty.util.collection.IntObjectHashMap;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.core.filter.Filter;
import org.apache.activemq.artemis.core.io.IOCallback;
import org.apache.activemq.artemis.core.paging.PageTransactionInfo;
import org.apache.activemq.artemis.core.paging.PagedMessage;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.paging.cursor.ConsumedPage;
import org.apache.activemq.artemis.core.paging.cursor.PageCursorProvider;
import org.apache.activemq.artemis.core.paging.cursor.PageIterator;
import org.apache.activemq.artemis.core.paging.cursor.PagePosition;
import org.apache.activemq.artemis.core.paging.cursor.PageSubscription;
import org.apache.activemq.artemis.core.paging.cursor.PageSubscriptionCounter;
import org.apache.activemq.artemis.core.paging.cursor.PagedReference;
import org.apache.activemq.artemis.core.paging.cursor.PagedReferenceImpl;
import org.apache.activemq.artemis.core.paging.cursor.impl.PagePositionImpl;
import org.apache.activemq.artemis.core.paging.impl.Page;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.core.transaction.TransactionOperationAbstract;
import org.apache.activemq.artemis.core.transaction.impl.TransactionImpl;
import org.apache.activemq.artemis.utils.collections.LinkedList;
import org.apache.activemq.artemis.utils.collections.LinkedListIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PageSubscriptionImpl
implements PageSubscription {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final Object DUMMY = new Object();
    private static final PagedReference RETRY_MARK = new PagedReferenceImpl(null, null);
    private boolean empty = true;
    private final AtomicInteger scheduledCleanupCount = new AtomicInteger(0);
    private volatile boolean autoCleanup = true;
    private final StorageManager store;
    private final long cursorId;
    private Queue queue;
    private final boolean persistent;
    private final Filter filter;
    private final PagingStore pageStore;
    private final PageCursorProvider cursorProvider;
    private volatile PagePosition lastAckedPosition;
    private List<PagePosition> recoveredACK;
    private final SortedMap<Long, PageCursorInfo> consumedPages = new TreeMap<Long, PageCursorInfo>();
    private final PageSubscriptionCounter counter;

    public AtomicInteger getScheduledCleanupCount() {
        return this.scheduledCleanupCount;
    }

    PageSubscriptionImpl(PageCursorProvider cursorProvider, PagingStore pageStore, StorageManager store, Filter filter, long cursorId, boolean persistent, PageSubscriptionCounter counter) {
        assert (counter != null);
        this.pageStore = pageStore;
        this.store = store;
        this.cursorProvider = cursorProvider;
        this.cursorId = cursorId;
        this.filter = filter;
        this.persistent = persistent;
        this.counter = counter;
        this.counter.setSubscription(this);
    }

    @Override
    public PagingStore getPagingStore() {
        return this.pageStore;
    }

    @Override
    public Queue getQueue() {
        return this.queue;
    }

    @Override
    public boolean isPaging() {
        return this.pageStore.isPaging();
    }

    @Override
    public void setQueue(Queue queue) {
        this.queue = queue;
    }

    @Override
    public void disableAutoCleanup() {
        this.autoCleanup = false;
    }

    @Override
    public void enableAutoCleanup() {
        this.autoCleanup = true;
    }

    public PageCursorProvider getProvider() {
        return this.cursorProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notEmpty() {
        SortedMap<Long, PageCursorInfo> sortedMap = this.consumedPages;
        synchronized (sortedMap) {
            this.empty = false;
        }
    }

    @Override
    public void bookmark(PagePosition position) throws Exception {
        PageCursorInfo cursorInfo = this.getPageInfo(position);
        if (position.getMessageNr() > 0) {
            cursorInfo.confirmed.addAndGet(position.getMessageNr());
        }
        this.confirmPosition(position);
    }

    @Override
    public long getMessageCount() {
        if (this.empty) {
            return 0L;
        }
        return this.counter.getValue();
    }

    @Override
    public boolean isCounterPending() {
        return this.counter.isRebuilding();
    }

    @Override
    public long getPersistentSize() {
        if (this.empty) {
            return 0L;
        }
        long messageSize = this.counter.getPersistentSize();
        return messageSize > 0L ? messageSize : 0L;
    }

    @Override
    public PageSubscriptionCounter getCounter() {
        return this.counter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean reloadPageCompletion(PagePosition position) throws Exception {
        if (!this.pageStore.checkPageFileExists((int)position.getPageNr())) {
            return false;
        }
        if (this.pageStore.getCurrentPage() != null && this.pageStore.getCurrentPage().getPageId() == position.getPageNr()) {
            this.pageStore.forceAnotherPage();
        }
        PageCursorInfo info = new PageCursorInfo(position.getPageNr(), position.getMessageNr());
        info.setCompleteInfo(position);
        info.clear();
        SortedMap<Long, PageCursorInfo> sortedMap = this.consumedPages;
        synchronized (sortedMap) {
            this.consumedPages.put(position.getPageNr(), info);
        }
        return true;
    }

    @Override
    public void scheduleCleanupCheck() {
        if (this.autoCleanup) {
            if (logger.isTraceEnabled()) {
                logger.trace("Scheduling cleanup", (Throwable)new Exception("trace"));
            }
            if (this.scheduledCleanupCount.get() > 2) {
                return;
            }
            this.scheduledCleanupCount.incrementAndGet();
            this.pageStore.execute(this::performCleanup);
        }
    }

    private void performCleanup() {
        try {
            if (this.autoCleanup) {
                this.cleanupEntries(false);
            }
        }
        catch (Exception e) {
            ActiveMQServerLogger.LOGGER.problemCleaningCursorPages(e);
        }
        finally {
            this.scheduledCleanupCount.decrementAndGet();
        }
    }

    @Override
    public void onPageModeCleared(Transaction tx) throws Exception {
        this.counter.delete(tx);
        this.empty = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanupEntries(final boolean completeDelete) throws Exception {
        if (completeDelete) {
            this.counter.delete();
        }
        logger.trace(">>>>>>> cleanupEntries");
        try {
            TransactionImpl tx = new TransactionImpl(this.store);
            boolean persist = false;
            ArrayList<PageCursorInfo> completedPages = new ArrayList<PageCursorInfo>();
            SortedMap<Long, PageCursorInfo> sortedMap = this.consumedPages;
            synchronized (sortedMap) {
                block17: {
                    if (this.lastAckedPosition != null) break block17;
                    return;
                }
                for (Map.Entry<Long, PageCursorInfo> entry : this.consumedPages.entrySet()) {
                    Page currentPage;
                    PageCursorInfo info = entry.getValue();
                    if (!info.isDone() || info.isPendingDelete()) continue;
                    if (logger.isDebugEnabled()) {
                        logger.debug("Complete page {} on queue {} / {}", new Object[]{info, this.queue.getName(), this.queue.getID()});
                    }
                    if ((currentPage = this.pageStore.getCurrentPage()) != null && entry.getKey().longValue() == this.pageStore.getCurrentPage().getPageId()) {
                        logger.trace("We can't clear page {} 's the current page", (Object)entry.getKey());
                        continue;
                    }
                    if (logger.isTraceEnabled()) {
                        logger.trace("cleanup marking page {} as complete", (Object)info.pageId);
                    }
                    info.setPendingDelete();
                    completedPages.add(entry.getValue());
                }
            }
            for (PageCursorInfo infoPG : completedPages) {
                if (this.isPersistent()) {
                    PagePositionImpl completePage = new PagePositionImpl(infoPG.getPageId(), infoPG.getNumberOfMessages());
                    infoPG.setCompleteInfo(completePage);
                    this.store.storePageCompleteTransactional(tx.getID(), this.getId(), completePage);
                    if (!persist) {
                        persist = true;
                        tx.setContainsPersistent();
                    }
                }
                if (infoPG.acks == null) continue;
                for (PagePosition pos : infoPG.acks.values()) {
                    if (pos.getRecordID() < 0L) continue;
                    this.store.deleteCursorAcknowledgeTransactional(tx.getID(), pos.getRecordID());
                    if (persist) continue;
                    tx.setContainsPersistent();
                    persist = true;
                }
                infoPG.clear();
            }
            tx.addOperation(new TransactionOperationAbstract(){

                @Override
                public void afterCommit(Transaction tx1) {
                    PageSubscriptionImpl.this.pageStore.execute(() -> {
                        if (!completeDelete) {
                            PageSubscriptionImpl.this.cursorProvider.scheduleCleanup();
                        }
                    });
                }
            });
            tx.commit();
        }
        finally {
            logger.trace("<<<<<< cleanupEntries");
        }
    }

    public String toString() {
        return "PageSubscriptionImpl [cursorId=" + this.cursorId + ", queue=" + this.queue + ", filter = " + this.filter + "]";
    }

    @Override
    public PageIterator iterator() {
        return new CursorIterator();
    }

    @Override
    public PageIterator iterator(boolean browsing) {
        return new CursorIterator(browsing);
    }

    private boolean routed(PagedMessage message) {
        long id = this.getId();
        for (long qid : message.getQueueIDs()) {
            if (qid != id) continue;
            return true;
        }
        return false;
    }

    @Override
    public void confirmPosition(Transaction tx, PagePosition position, boolean fromDelivery) throws Exception {
        if (this.persistent) {
            this.store.storeCursorAcknowledgeTransactional(tx.getID(), this.cursorId, position);
        }
        this.installTXCallback(tx, position, fromDelivery);
    }

    @Override
    public void ackTx(Transaction tx, PagedReference reference, boolean fromDelivery) throws Exception {
        long persistentSize = this.getPersistentSize(reference);
        this.confirmPosition(tx, reference.getPagedMessage().newPositionObject(), true);
        this.counter.increment(tx, -1, -persistentSize);
        PageTransactionInfo txInfo = this.getPageTransaction(reference);
        if (txInfo != null) {
            txInfo.storeUpdate(this.store, this.pageStore.getPagingManager(), tx);
            tx.setContainsPersistent();
        }
    }

    @Override
    public void ack(PagedReference reference) throws Exception {
        TransactionImpl tx = new TransactionImpl(this.store);
        this.ackTx(tx, reference);
        tx.commit();
    }

    @Override
    public boolean contains(PagedReference ref) throws Exception {
        boolean routed = false;
        for (long idRef : ref.getPagedMessage().getQueueIDs()) {
            if (idRef != this.cursorId) continue;
            routed = true;
            break;
        }
        if (!routed) {
            return false;
        }
        return !this.getPageInfo(ref.getPagedMessage().getPageNumber()).isAck(ref.getPagedMessage().getMessageNumber());
    }

    @Override
    public boolean isAcked(PagedMessage pagedMessage) {
        return this.getPageInfo(pagedMessage.getPageNumber()).isAck(pagedMessage.getMessageNumber());
    }

    @Override
    public void confirmPosition(final PagePosition position) throws Exception {
        if (this.persistent) {
            this.store.storeCursorAcknowledge(this.cursorId, position);
        }
        this.store.afterCompleteOperations(new IOCallback(){
            volatile String error = "";

            public void onError(int errorCode, String errorMessage) {
                this.error = " errorCode=" + errorCode + ", msg=" + errorMessage;
                ActiveMQServerLogger.LOGGER.pageSubscriptionError(this, this.error);
            }

            public void done() {
                PageSubscriptionImpl.this.processACK(position);
            }

            public String toString() {
                return IOCallback.class.getSimpleName() + "(" + PageSubscriptionImpl.class.getSimpleName() + ") " + this.error;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getFirstPage() {
        SortedMap<Long, PageCursorInfo> sortedMap = this.consumedPages;
        synchronized (sortedMap) {
            if (this.empty && this.consumedPages.isEmpty()) {
                return -1L;
            }
            long lastPageSeen = 0L;
            for (Map.Entry<Long, PageCursorInfo> info : this.consumedPages.entrySet()) {
                lastPageSeen = info.getKey();
                if (info.getValue().isDone() || info.getValue().isPendingDelete()) continue;
                return info.getKey();
            }
            return lastPageSeen;
        }
    }

    @Override
    public void addPendingDelivery(PagedMessage pagedMessage) {
        PageCursorInfo info = this.getPageInfo(pagedMessage.getPageNumber());
        if (info != null) {
            info.incrementPendingTX();
        }
    }

    @Override
    public void removePendingDelivery(PagedMessage pagedMessage) {
        PageCursorInfo info = this.getPageInfo(pagedMessage.getPageNumber());
        if (info != null) {
            info.decrementPendingTX();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void redeliver(PageIterator iterator, PagedReference pagedReference) {
        iterator.redeliver(pagedReference);
        SortedMap<Long, PageCursorInfo> sortedMap = this.consumedPages;
        synchronized (sortedMap) {
            PageCursorInfo pageInfo = (PageCursorInfo)this.consumedPages.get(pagedReference.getPagedMessage().getPageNumber());
            if (pageInfo != null) {
                pageInfo.decrementPendingTX();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PagedMessage queryMessage(PagePosition pos) {
        PagedMessage pagedMessage;
        Page page = this.pageStore.usePage(pos.getPageNr());
        if (page == null) {
            return null;
        }
        try {
            LinkedList<PagedMessage> messages = page.getMessages();
            PagedMessage retMessage = pos.getMessageNr() < messages.size() ? (PagedMessage)messages.get(pos.getMessageNr()) : null;
            pagedMessage = retMessage;
            page.usageDown();
        }
        catch (Throwable throwable) {
            try {
                page.usageDown();
                throw throwable;
            }
            catch (Exception e) {
                this.store.criticalError(e);
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return pagedMessage;
    }

    @Override
    public void reloadACK(PagePosition position) {
        if (this.recoveredACK == null) {
            this.recoveredACK = new java.util.LinkedList<PagePosition>();
        }
        this.recoveredACK.add(position);
    }

    @Override
    public void reloadPreparedACK(Transaction tx, PagePosition position) {
        this.installTXCallback(tx, position, true);
        try {
            this.counter.increment(tx, -1, -position.getPersistentSize());
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void positionIgnored(PagePosition position) {
        this.processACK(position);
    }

    @Override
    public void lateDeliveryRollback(PagePosition position) {
        PageCursorInfo cursorInfo = this.processACK(position);
        cursorInfo.decrementPendingTX();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forEachConsumedPage(Consumer<ConsumedPage> pageConsumer) {
        SortedMap<Long, PageCursorInfo> sortedMap = this.consumedPages;
        synchronized (sortedMap) {
            this.consumedPages.values().forEach(pageConsumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isComplete(long page) {
        logger.trace("{} isComplete {}", (Object)this, (Object)page);
        SortedMap<Long, PageCursorInfo> sortedMap = this.consumedPages;
        synchronized (sortedMap) {
            boolean isDone;
            if (this.empty && this.consumedPages.isEmpty()) {
                if (logger.isTraceEnabled()) {
                    logger.trace("isComplete({})::Subscription {} has empty={}, consumedPages.isEmpty={}", new Object[]{page, this, this.empty, this.consumedPages.isEmpty()});
                }
                return true;
            }
            PageCursorInfo info = (PageCursorInfo)this.consumedPages.get(page);
            if (info == null && this.empty) {
                logger.trace("isComplete({})::::Couldn't find info and it is empty", (Object)page);
                return true;
            }
            boolean bl = isDone = info != null && info.isDone();
            if (logger.isTraceEnabled()) {
                logger.trace("isComplete({}):: found info={}, isDone={}", new Object[]{page, info, isDone});
            }
            return isDone;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() throws Exception {
        long tx = this.store.generateID();
        try {
            boolean isPersistent = false;
            SortedMap<Long, PageCursorInfo> sortedMap = this.consumedPages;
            synchronized (sortedMap) {
                for (PageCursorInfo cursor : this.consumedPages.values()) {
                    PagePosition completeInfo;
                    if (cursor.acks != null) {
                        for (PagePosition info : cursor.acks.values()) {
                            if (info.getRecordID() < 0L) continue;
                            isPersistent = true;
                            this.store.deleteCursorAcknowledgeTransactional(tx, info.getRecordID());
                        }
                    }
                    if ((completeInfo = cursor.getCompleteInfo()) == null || completeInfo.getRecordID() < 0L) continue;
                    this.store.deletePageComplete(completeInfo.getRecordID());
                    cursor.setCompleteInfo(null);
                }
            }
            if (isPersistent) {
                this.store.commit(tx);
            }
            this.cursorProvider.close(this);
        }
        catch (Exception e) {
            try {
                this.store.rollback(tx);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public long getId() {
        return this.cursorId;
    }

    @Override
    public boolean isPersistent() {
        return this.persistent;
    }

    @Override
    public void processReload() throws Exception {
        if (this.recoveredACK != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("processing reload queue name={} with id={}", this.queue != null ? this.queue.getName() : "N/A", (Object)this.cursorId);
            }
            Collections.sort(this.recoveredACK);
            long txDeleteCursorOnReload = -1L;
            for (PagePosition pos : this.recoveredACK) {
                logger.trace("reloading pos {}", (Object)pos);
                this.lastAckedPosition = pos;
                PageCursorInfo pageInfo = this.getPageInfo(pos);
                pageInfo.loadACK(pos);
            }
            if (txDeleteCursorOnReload >= 0L) {
                this.store.commit(txDeleteCursorOnReload);
            }
            this.recoveredACK.clear();
            this.recoveredACK = null;
        }
    }

    @Override
    public void stop() {
    }

    @Override
    public void counterSnapshot() {
        this.counter.snapshot();
    }

    @Override
    public void printDebug() {
        this.printDebug(this.toString());
    }

    public void printDebug(String msg) {
        System.out.println("Debug information on PageCurorImpl- " + msg);
        for (PageCursorInfo info : this.consumedPages.values()) {
            System.out.println(info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDeletePage(Page deletedPage) throws Exception {
        PageCursorInfo info;
        logger.debug("removing page {}", (Object)deletedPage);
        SortedMap<Long, PageCursorInfo> sortedMap = this.consumedPages;
        synchronized (sortedMap) {
            info = (PageCursorInfo)this.consumedPages.remove(deletedPage.getPageId());
        }
        if (info != null) {
            PagePosition completeInfo = info.getCompleteInfo();
            if (completeInfo != null) {
                try {
                    this.store.deletePageComplete(completeInfo.getRecordID());
                }
                catch (Exception e) {
                    ActiveMQServerLogger.LOGGER.errorDeletingPageCompleteRecord(e);
                }
                info.setCompleteInfo(null);
            }
            if (info.acks != null) {
                for (PagePosition deleteInfo : info.acks.values()) {
                    if (deleteInfo.getRecordID() < 0L) continue;
                    try {
                        this.store.deleteCursorAcknowledge(deleteInfo.getRecordID());
                    }
                    catch (Exception e) {
                        ActiveMQServerLogger.LOGGER.errorDeletingPageCompleteRecord(e);
                    }
                }
            }
        }
        deletedPage.usageExhaust();
    }

    @Override
    public void reloadPageInfo(long pageNr) {
        this.getPageInfo(pageNr);
    }

    PageCursorInfo getPageInfo(PagePosition pos) {
        return this.getPageInfo(pos.getPageNr());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PageCursorInfo locatePageInfo(long pageNr) {
        SortedMap<Long, PageCursorInfo> sortedMap = this.consumedPages;
        synchronized (sortedMap) {
            return (PageCursorInfo)this.consumedPages.get(pageNr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PageCursorInfo getPageInfo(long pageNr) {
        SortedMap<Long, PageCursorInfo> sortedMap = this.consumedPages;
        synchronized (sortedMap) {
            PageCursorInfo pageInfo = (PageCursorInfo)this.consumedPages.get(pageNr);
            if (pageInfo == null) {
                pageInfo = new PageCursorInfo(pageNr);
                this.consumedPages.put(pageNr, pageInfo);
            }
            return pageInfo;
        }
    }

    private boolean match(Message message) {
        if (this.filter == null) {
            return true;
        }
        return this.filter.match(message);
    }

    private PageCursorInfo processACK(PagePosition pos) {
        PageCursorInfo info;
        if (this.lastAckedPosition == null || pos.compareTo(this.lastAckedPosition) > 0) {
            logger.trace("a new position is being processed as ACK");
            if (this.lastAckedPosition != null && this.lastAckedPosition.getPageNr() != pos.getPageNr()) {
                logger.trace("Scheduling cleanup on pageSubscription for address = {} queue = {}", (Object)this.pageStore.getAddress(), (Object)this.getQueue().getName());
                if (this.autoCleanup) {
                    this.scheduleCleanupCheck();
                }
            }
            this.lastAckedPosition = pos;
        }
        if ((info = this.getPageInfo(pos)) == null) {
            ActiveMQServerLogger.LOGGER.nullPageCursorInfo(this.getPagingStore().getAddress().toString(), pos.toString(), this.cursorId);
        } else {
            info.addACK(pos);
        }
        return info;
    }

    private void installTXCallback(Transaction tx, PagePosition position, boolean fromDelivery) {
        PageCursorInfo info;
        if (position.getRecordID() >= 0L) {
            tx.setContainsPersistent();
        }
        if ((info = this.getPageInfo(position)) != null) {
            logger.trace("InstallTXCallback looking up pagePosition {}, result={}", (Object)position, (Object)info);
            info.remove(position.getMessageNr());
            PageCursorTX cursorTX = (PageCursorTX)tx.getProperty(8);
            if (cursorTX == null) {
                cursorTX = new PageCursorTX(fromDelivery);
                tx.putProperty(8, cursorTX);
                tx.addOperation(cursorTX);
            }
            cursorTX.addPositionConfirmation(this, position);
        }
    }

    private PageTransactionInfo getPageTransaction(PagedReference reference) throws ActiveMQException {
        if (reference.getTransactionID() >= 0L) {
            return this.pageStore.getPagingManager().getTransaction(reference.getTransactionID());
        }
        return null;
    }

    private void onPageDone(PageCursorInfo info) {
        if (this.autoCleanup) {
            if (logger.isTraceEnabled()) {
                logger.trace("onPageDone page {}", (Object)info.getPageId());
            }
            this.scheduleCleanupCheck();
        }
    }

    private long getPersistentSize(PagedReference ref) {
        try {
            return ref != null && ref.getPersistentSize() > 0L ? ref.getPersistentSize() : 0L;
        }
        catch (ActiveMQException e) {
            logger.warn("Error computing persistent size of message: {}", (Object)ref, (Object)e);
            return 0L;
        }
    }

    private class CursorIterator
    implements PageIterator {
        private Page currentPage;
        private LinkedListIterator<PagedMessage> currentPageIterator;
        private PagedReference currentDelivery = null;
        private volatile PagedReference lastDelivery = null;
        private final boolean browsing;
        private final java.util.Queue<PagedReference> redeliveries = new java.util.LinkedList<PagedReference>();
        private volatile PagedReference cachedNext;

        private void initPage(long page) {
            if (logger.isDebugEnabled()) {
                logger.debug("initPage {}", (Object)page);
            }
            try {
                if (this.currentPage != null) {
                    if (logger.isTraceEnabled()) {
                        logger.trace("usage down {} on subscription {}", (Object)this.currentPage.getPageId(), (Object)PageSubscriptionImpl.this.cursorId);
                    }
                    this.currentPage.usageDown();
                }
                if (this.currentPageIterator != null) {
                    if (logger.isTraceEnabled()) {
                        logger.trace("closing pageIterator on {}", (Object)PageSubscriptionImpl.this.cursorId);
                    }
                    this.currentPageIterator.close();
                }
                this.currentPage = PageSubscriptionImpl.this.pageStore.usePage(page);
                if (logger.isTraceEnabled()) {
                    logger.trace("CursorIterator: getting page {} which will contain {}", (Object)page, (Object)this.currentPage.getNumberOfMessages());
                }
                this.currentPageIterator = this.currentPage.iterator();
            }
            catch (Exception e) {
                PageSubscriptionImpl.this.store.criticalError(e);
                throw new IllegalStateException(e.getMessage(), e);
            }
        }

        private CursorIterator(boolean browsing) {
            this.browsing = browsing;
        }

        private CursorIterator() {
            this.browsing = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void redeliver(PagedReference reference) {
            java.util.Queue<PagedReference> queue = this.redeliveries;
            synchronized (queue) {
                this.redeliveries.add(reference);
            }
        }

        public void repeat() {
            this.cachedNext = this.lastDelivery;
        }

        public synchronized PagedReference next() {
            try {
                if (this.cachedNext != null) {
                    this.currentDelivery = this.cachedNext;
                    this.cachedNext = null;
                    return this.currentDelivery;
                }
                if (this.currentPage == null) {
                    logger.trace("CursorIterator::next initializing first page as {}", (Object)PageSubscriptionImpl.this.pageStore.getFirstPage());
                    this.initPage(PageSubscriptionImpl.this.pageStore.getFirstPage());
                }
                this.currentDelivery = this.moveNext();
                return this.currentDelivery;
            }
            catch (Throwable e) {
                logger.warn(e.getMessage(), e);
                PageSubscriptionImpl.this.store.criticalError(e);
                throw new RuntimeException(e.getMessage(), e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private PagedReference moveNext() {
            PageSubscriptionImpl pageSubscriptionImpl = PageSubscriptionImpl.this;
            synchronized (pageSubscriptionImpl) {
                PagedReference message;
                boolean match = false;
                long timeout = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(1000L);
                do {
                    if (System.nanoTime() - timeout > 0L) {
                        return RETRY_MARK;
                    }
                    java.util.Queue<PagedReference> queue = this.redeliveries;
                    synchronized (queue) {
                        PagedReference redelivery = this.redeliveries.poll();
                        if (redelivery != null) {
                            return redelivery;
                        }
                        this.lastDelivery = null;
                    }
                    message = this.internalGetNext();
                    if (message == null) break;
                    boolean valid = true;
                    boolean ignored = false;
                    valid = PageSubscriptionImpl.this.routed(message.getPagedMessage());
                    if (!valid) {
                        logger.trace("CursorIterator::message {} was deemed invalid, marking it to ignore", (Object)message.getPagedMessage());
                        ignored = true;
                    }
                    PageCursorInfo info = PageSubscriptionImpl.this.getPageInfo(message.getPagedMessage().getPageNumber());
                    if (!this.browsing && info != null && (info.isRemoved(message.getPagedMessage().getMessageNumber()) || info.getCompleteInfo() != null)) {
                        if (!logger.isTraceEnabled()) continue;
                        boolean removed = info.isRemoved(message.getPagedMessage().getMessageNumber());
                        logger.trace("CursorIterator::Message from page {} # {} isRemoved={}", new Object[]{message.getPagedMessage().getPageNumber(), message.getPagedMessage().getMessageNumber(), removed});
                        continue;
                    }
                    if (info != null && info.isAck(message.getPagedMessage().getMessageNumber())) {
                        logger.trace("CursorIterator::message {} is acked, moving next", (Object)message);
                        continue;
                    }
                    if (valid && message.getPagedMessage().getTransactionID() >= 0L) {
                        PageTransactionInfo tx = PageSubscriptionImpl.this.pageStore.getPagingManager().getTransaction(message.getPagedMessage().getTransactionID());
                        if (tx == null) {
                            if (logger.isDebugEnabled()) {
                                logger.debug("Could not locate page transaction {}, ignoring message on position {} on address={} queue={}", new Object[]{message.getPagedMessage().getTransactionID(), message.getPagedMessage().newPositionObject(), PageSubscriptionImpl.this.pageStore.getAddress(), PageSubscriptionImpl.this.queue.getName()});
                            }
                            valid = false;
                            ignored = true;
                        } else if (tx.deliverAfterCommit(this, PageSubscriptionImpl.this, message)) {
                            valid = false;
                            ignored = false;
                        }
                    }
                    if (valid && !this.browsing && info != null && info.isRemoved(message.getPagedMessage().getMessageNumber())) {
                        valid = false;
                    }
                    if (valid) {
                        if (this.browsing) {
                            match = PageSubscriptionImpl.this.match(message.getMessage());
                            continue;
                        }
                        match = true;
                        continue;
                    }
                    if (this.browsing || !ignored) continue;
                    PageSubscriptionImpl.this.positionIgnored(message.getPagedMessage().newPositionObject());
                } while (!match);
                if (message != null) {
                    this.lastDelivery = message;
                }
                return message;
            }
        }

        private PagedReference internalGetNext() {
            while (true) {
                assert (this.currentPageIterator != null) : "currentPageIterator is null";
                PagedMessage message = this.currentPageIterator.hasNext() ? (PagedMessage)this.currentPageIterator.next() : null;
                logger.trace("CursorIterator::internalGetNext:: new reference {}", (Object)message);
                if (message != null) {
                    return PageSubscriptionImpl.this.cursorProvider.newReference(message, PageSubscriptionImpl.this);
                }
                if (logger.isTraceEnabled()) {
                    logger.trace("Current page {}", this.currentPage != null ? Long.valueOf(this.currentPage.getPageId()) : null);
                }
                long nextPage = this.getNextPage();
                if (logger.isTraceEnabled()) {
                    logger.trace("next page {}", (Object)nextPage);
                }
                if (nextPage < 0L) break;
                if (logger.isTraceEnabled()) {
                    logger.trace("CursorIterator::internalGetNext:: moving to currentPage {}", (Object)nextPage);
                }
                this.initPage(nextPage);
            }
            return null;
        }

        private long getNextPage() {
            for (long page = this.currentPage.getPageId() + 1L; page <= PageSubscriptionImpl.this.pageStore.getCurrentWritingPage(); ++page) {
                PageCursorInfo info = PageSubscriptionImpl.this.locatePageInfo(page);
                if (info == null || info.getCompleteInfo() == null && !info.isPendingDelete()) {
                    return page;
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Subscription {} named {}  moving faster from page {} to next", new Object[]{PageSubscriptionImpl.this.cursorId, PageSubscriptionImpl.this.queue.getName(), page});
            }
            return -1L;
        }

        @Override
        public synchronized PageIterator.NextResult tryNext() {
            if (this.cachedNext != null) {
                return PageIterator.NextResult.hasElements;
            }
            if (!PageSubscriptionImpl.this.pageStore.isPaging()) {
                return PageIterator.NextResult.noElements;
            }
            PagedReference pagedReference = this.next();
            if (pagedReference == RETRY_MARK) {
                return PageIterator.NextResult.retry;
            }
            this.cachedNext = pagedReference;
            return this.cachedNext == null ? PageIterator.NextResult.noElements : PageIterator.NextResult.hasElements;
        }

        public synchronized boolean hasNext() {
            PageIterator.NextResult status;
            while ((status = this.tryNext()) == PageIterator.NextResult.retry) {
            }
            return status == PageIterator.NextResult.hasElements;
        }

        public void remove() {
            this.removeLastElement();
        }

        public PagedReference removeLastElement() {
            PageCursorInfo info;
            PagedReference delivery = this.currentDelivery;
            if (delivery != null && (info = PageSubscriptionImpl.this.getPageInfo(delivery.getPagedMessage().getPageNumber())) != null) {
                info.remove(delivery.getPagedMessage().getMessageNumber());
            }
            return delivery;
        }

        public void close() {
            Page toClose = this.currentPage;
            if (toClose != null) {
                toClose.usageDown();
            }
            this.currentPage = null;
        }
    }

    private final class PageCursorTX
    extends TransactionOperationAbstract {
        private boolean fromDelivery;
        private final Map<PageSubscriptionImpl, List<PagePosition>> pendingPositions = new HashMap<PageSubscriptionImpl, List<PagePosition>>();

        PageCursorTX(boolean fromDelivery) {
            this.fromDelivery = fromDelivery;
        }

        private void addPositionConfirmation(PageSubscriptionImpl cursor, PagePosition position) {
            List<PagePosition> list = this.pendingPositions.get(cursor);
            if (list == null) {
                list = new java.util.LinkedList<PagePosition>();
                this.pendingPositions.put(cursor, list);
            }
            list.add(position);
        }

        @Override
        public void afterCommit(Transaction tx) {
            for (Map.Entry<PageSubscriptionImpl, List<PagePosition>> entry : this.pendingPositions.entrySet()) {
                PageSubscriptionImpl cursor = entry.getKey();
                List<PagePosition> positions = entry.getValue();
                for (PagePosition confirmed : positions) {
                    cursor.processACK(confirmed);
                }
            }
        }

        @Override
        public List<MessageReference> getRelatedMessageReferences() {
            return Collections.emptyList();
        }
    }

    public final class PageCursorInfo
    implements ConsumedPage {
        private int numberOfMessages;
        private final long pageId;
        private IntObjectHashMap<PagePosition> acks = new IntObjectHashMap();
        private IntObjectHashMap<Object> removedReferences = new IntObjectHashMap();
        private final AtomicInteger pendingTX = new AtomicInteger(0);
        private boolean pendingDelete;
        private PagePosition completePage;
        private final AtomicInteger confirmed = new AtomicInteger(0);

        @Override
        public synchronized boolean isAck(int messageNumber) {
            return this.completePage != null || this.acks != null && this.acks.get(messageNumber) != null;
        }

        @Override
        public void forEachAck(BiConsumer<Integer, PagePosition> ackConsumer) {
            if (this.acks != null) {
                this.acks.forEach(ackConsumer);
            }
        }

        public IntObjectHashMap getAcks() {
            return this.acks;
        }

        public IntObjectHashMap getRemovedReferences() {
            return this.removedReferences;
        }

        public PagePosition getCompletePageInformation() {
            return this.completePage;
        }

        public String toString() {
            try {
                return "PageCursorInfo::pageNr=" + this.pageId + " numberOfMessage = " + this.numberOfMessages + ", confirmed = " + this.confirmed + ", isDone=" + this.isDone();
            }
            catch (Exception e) {
                return "PageCursorInfo::pageNr=" + this.pageId + " numberOfMessage = " + this.numberOfMessages + ", confirmed = " + this.confirmed + ", isDone=" + e.toString();
            }
        }

        PageCursorInfo(long pageId, int numberOfMessages) {
            if (numberOfMessages < 0) {
                throw new IllegalStateException("numberOfMessages = " + numberOfMessages + " instead of being >=0");
            }
            this.pageId = pageId;
            this.numberOfMessages = numberOfMessages;
            if (logger.isTraceEnabled()) {
                logger.trace("Created PageCursorInfo for pageNr={}, numberOfMessages={}, not live", (Object)pageId, (Object)numberOfMessages);
            }
        }

        private PageCursorInfo(long pageId) {
            this.pageId = pageId;
            this.numberOfMessages = -1;
        }

        public void clear() {
            this.removedReferences = null;
            this.acks = null;
        }

        public void setCompleteInfo(PagePosition completePage) {
            if (logger.isTraceEnabled()) {
                logger.trace("Setting up complete page {} on cursor {} on subscription {}", new Object[]{completePage, this, PageSubscriptionImpl.this});
            }
            this.completePage = completePage;
        }

        public PagePosition getCompleteInfo() {
            return this.completePage;
        }

        @Override
        public boolean isDone() {
            if (logger.isTraceEnabled()) {
                logger.trace("{}::PageCursorInfo({})::isDone checking with completePage!=null->{} getNumberOfMessages={}, confirmed={} and pendingTX={}", new Object[]{PageSubscriptionImpl.this, this.pageId, this.completePage != null, this.getNumberOfMessages(), this.confirmed.get(), this.pendingTX.get()});
            }
            return this.completePage != null || this.confirmed.get() >= this.getNumberOfMessages() && this.pendingTX.get() == 0;
        }

        public boolean isPendingDelete() {
            return this.pendingDelete || this.completePage != null;
        }

        public void setPendingDelete() {
            this.pendingDelete = true;
        }

        @Override
        public long getPageId() {
            return this.pageId;
        }

        public void incrementPendingTX() {
            this.pendingTX.incrementAndGet();
        }

        public void decrementPendingTX() {
            this.pendingTX.decrementAndGet();
            this.checkDone();
        }

        public synchronized boolean isRemoved(int messageNr) {
            return this.completePage != null || this.removedReferences == null || this.removedReferences.get(messageNr) != null;
        }

        public synchronized void remove(int messageNr) {
            if (logger.isTraceEnabled()) {
                logger.trace("PageCursor Removing messageNr {} on page {}", (Object)messageNr, (Object)this.pageId);
            }
            if (this.removedReferences != null) {
                this.removedReferences.put(messageNr, DUMMY);
            }
        }

        public void addACK(PagePosition posACK) {
            boolean added;
            if (logger.isTraceEnabled()) {
                try {
                    logger.trace("numberOfMessages = {} confirmed = {} pendingTX = {}, pageNr = {} posACK = {}", new Object[]{this.getNumberOfMessages(), this.confirmed.get() + 1, this.pendingTX, this.pageId, posACK});
                }
                catch (Throwable ignored) {
                    logger.debug(ignored.getMessage(), ignored);
                }
            }
            if ((added = this.internalAddACK(posACK)) && posACK.getMessageNr() >= 0) {
                this.confirmed.incrementAndGet();
                this.checkDone();
            }
        }

        public void loadACK(PagePosition posACK) {
            if (this.internalAddACK(posACK) && posACK.getMessageNr() >= 0) {
                this.confirmed.incrementAndGet();
            }
        }

        synchronized boolean internalAddACK(PagePosition position) {
            if (logger.isDebugEnabled()) {
                logger.debug("internalAddACK on queue {} (id={}), position {}", new Object[]{PageSubscriptionImpl.this.queue.getName(), PageSubscriptionImpl.this.queue.getID(), position});
            }
            if (this.removedReferences != null) {
                this.removedReferences.put(position.getMessageNr(), DUMMY);
            }
            if (this.acks == null) {
                return false;
            }
            return this.acks.put(position.getMessageNr(), (Object)position) == null;
        }

        protected void checkDone() {
            if (this.isDone()) {
                PageSubscriptionImpl.this.onPageDone(this);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private int getNumberOfMessages() {
            if (this.numberOfMessages >= 0) return this.numberOfMessages;
            try {
                Page page = PageSubscriptionImpl.this.pageStore.usePage(this.pageId, false);
                if (page == null) {
                    page = PageSubscriptionImpl.this.pageStore.newPageObject(this.pageId);
                    this.numberOfMessages = page.readNumberOfMessages();
                    return this.numberOfMessages;
                }
                try {
                    if (page.isOpen()) {
                        int n = page.getNumberOfMessages();
                        return n;
                    }
                    this.numberOfMessages = page.getNumberOfMessages();
                    return this.numberOfMessages;
                }
                finally {
                    page.usageDown();
                }
            }
            catch (Exception e) {
                PageSubscriptionImpl.this.store.criticalError(e);
                throw new RuntimeException(e.getMessage(), e);
            }
        }

        public int getPendingTx() {
            return this.pendingTX.get();
        }
    }
}

