/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.proton;

import java.lang.invoke.MethodHandles;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.core.persistence.impl.nullpm.NullStorageManager;
import org.apache.activemq.artemis.core.server.RoutingContext;
import org.apache.activemq.artemis.core.server.impl.RoutingContextImpl;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPSessionCallback;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPException;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPInternalErrorException;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPConnectionContext;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPLargeMessageReader;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPMessageReader;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPSessionContext;
import org.apache.activemq.artemis.protocol.amqp.proton.MessageReader;
import org.apache.activemq.artemis.protocol.amqp.proton.ProtonDeliveryHandler;
import org.apache.activemq.artemis.protocol.amqp.proton.ProtonInitializable;
import org.apache.qpid.proton.amqp.messaging.DeliveryAnnotations;
import org.apache.qpid.proton.amqp.transaction.TransactionalState;
import org.apache.qpid.proton.amqp.transport.AmqpError;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.Receiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ProtonAbstractReceiver
extends ProtonInitializable
implements ProtonDeliveryHandler {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected final AMQPConnectionContext connection;
    protected final AMQPSessionContext protonSession;
    protected final Receiver receiver;
    protected final int minLargeMessageSize;
    protected final RoutingContext routingContext;
    protected final AMQPSessionCallback sessionSPI;
    protected final MessageReader standardMessageReader = new AMQPMessageReader(this);
    protected final MessageReader largeMessageReader = new AMQPLargeMessageReader(this);
    protected volatile MessageReader messageReader;
    protected final Runnable creditRunnable;
    protected final boolean useModified;
    protected int pendingSettles = 0;

    public static boolean isBellowThreshold(int credit, int pending, int threshold) {
        return credit <= threshold - pending;
    }

    public static int calculatedUpdateRefill(int refill, int credits, int pending) {
        return refill - credits - pending;
    }

    public ProtonAbstractReceiver(AMQPSessionCallback sessionSPI, AMQPConnectionContext connection, AMQPSessionContext protonSession, Receiver receiver) {
        this.sessionSPI = sessionSPI;
        this.connection = connection;
        this.protonSession = protonSession;
        this.receiver = receiver;
        this.minLargeMessageSize = this.getConfiguredMinLargeMessageSize(connection);
        this.creditRunnable = this.createCreditRunnable(connection);
        this.useModified = this.connection.getProtocolManager().isUseModifiedForTransientDeliveryErrors();
        this.routingContext = new RoutingContextImpl(null).setDuplicateDetection(connection.getProtocolManager().isAmqpDuplicateDetection());
    }

    public AMQPSessionContext getSessionContext() {
        return this.protonSession;
    }

    protected void recoverContext() {
        this.sessionSPI.recoverContext();
    }

    protected void closeCurrentReader() {
        this.connection.runNow(() -> {
            if (this.messageReader != null) {
                this.messageReader.close();
                this.messageReader = null;
            }
        });
    }

    protected Runnable createCreditRunnable(AMQPConnectionContext connection) {
        return ProtonAbstractReceiver.createCreditRunnable(connection.getAmqpCredits(), connection.getAmqpLowCredits(), this.receiver, connection, this);
    }

    protected int getConfiguredMinLargeMessageSize(AMQPConnectionContext connection) {
        return connection.getProtocolManager().getAmqpMinLargeMessageSize();
    }

    public static Runnable createCreditRunnable(int refill, int threshold, Receiver receiver, AMQPConnectionContext connection, ProtonAbstractReceiver context) {
        return new FlowControlRunner(refill, threshold, receiver, connection, context);
    }

    public static Runnable createCreditRunnable(int refill, int threshold, Receiver receiver, AMQPConnectionContext connection) {
        return new FlowControlRunner(refill, threshold, receiver, connection, null);
    }

    public void incrementSettle() {
        assert (this.pendingSettles >= 0);
        this.connection.requireInHandler();
        ++this.pendingSettles;
    }

    public void settle(Delivery settlement) {
        this.connection.requireInHandler();
        --this.pendingSettles;
        assert (this.pendingSettles >= 0);
        settlement.settle();
        this.flow();
    }

    @Override
    public void onFlow(int credits, boolean drain) {
        this.flow();
    }

    private void handleAbortedDelivery(Delivery delivery) {
        Receiver receiver = (Receiver)delivery.getLink();
        this.closeCurrentReader();
        receiver.advance();
        delivery.settle();
        if (!receiver.getDrain()) {
            receiver.flow(1);
        }
    }

    private MessageReader getOrSelectMessageReader(Receiver receiver, Delivery delivery) {
        if (this.messageReader != null) {
            return this.messageReader;
        }
        MessageReader selected = this.trySelectMessageReader(receiver, delivery);
        if (selected != null) {
            this.messageReader = selected.open();
            return this.messageReader;
        }
        return null;
    }

    protected MessageReader trySelectMessageReader(Receiver receiver, Delivery delivery) {
        if (this.sessionSPI.getStorageManager() instanceof NullStorageManager) {
            return this.standardMessageReader;
        }
        if (delivery.isPartial()) {
            if (this.minLargeMessageSize > 0 && delivery.available() >= this.minLargeMessageSize) {
                return this.largeMessageReader;
            }
            return null;
        }
        if (this.minLargeMessageSize > 0 && delivery.available() >= this.minLargeMessageSize) {
            return this.largeMessageReader;
        }
        return this.standardMessageReader;
    }

    @Override
    public final void onMessage(Delivery delivery) throws ActiveMQAMQPException {
        this.connection.requireInHandler();
        if (this.receiver.current() != delivery) {
            return;
        }
        if (delivery.isAborted()) {
            this.handleAbortedDelivery(delivery);
            return;
        }
        try {
            MessageReader messageReader = this.getOrSelectMessageReader(this.receiver, delivery);
            if (messageReader == null) {
                return;
            }
            Message completeMessage = messageReader.readBytes(delivery);
            if (completeMessage != null) {
                this.onMessageComplete(delivery, completeMessage, messageReader.getDeliveryAnnotations());
            }
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
            throw new ActiveMQAMQPInternalErrorException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessageComplete(Delivery delivery, Message message, DeliveryAnnotations deliveryAnnotations) {
        this.connection.requireInHandler();
        try {
            this.receiver.advance();
            Transaction tx = null;
            if (delivery.getRemoteState() instanceof TransactionalState) {
                TransactionalState txState = (TransactionalState)delivery.getRemoteState();
                try {
                    tx = this.sessionSPI.getTransaction(txState.getTxnId(), false);
                }
                catch (Exception e) {
                    this.onExceptionWhileReading(e);
                }
            }
            this.actualDelivery(message, delivery, deliveryAnnotations, this.receiver, tx);
        }
        finally {
            this.messageReader.close();
            this.messageReader = null;
        }
    }

    @Override
    public void close(boolean remoteLinkClose) throws ActiveMQAMQPException {
        this.protonSession.removeReceiver(this.receiver);
        this.closeCurrentReader();
    }

    public void onExceptionWhileReading(Throwable e) {
        logger.warn(e.getMessage(), e);
        this.connection.runNow(() -> {
            this.connection.enableAutoRead();
            ErrorCondition ec = new ErrorCondition(AmqpError.INTERNAL_ERROR, e.getMessage());
            this.connection.close(ec);
            this.connection.flush();
        });
    }

    @Override
    public void close(ErrorCondition condition) throws ActiveMQAMQPException {
        this.receiver.setCondition(condition);
        this.close(false);
    }

    public AMQPConnectionContext getConnection() {
        return this.connection;
    }

    protected abstract void actualDelivery(Message var1, Delivery var2, DeliveryAnnotations var3, Receiver var4, Transaction var5);

    public abstract void flow();

    static class FlowControlRunner
    implements Runnable {
        final int refill;
        final int threshold;
        final Receiver receiver;
        final AMQPConnectionContext connection;
        final ProtonAbstractReceiver context;

        FlowControlRunner(int refill, int threshold, Receiver receiver, AMQPConnectionContext connection, ProtonAbstractReceiver context) {
            this.refill = refill;
            this.threshold = threshold;
            this.receiver = receiver;
            this.connection = connection;
            this.context = context;
        }

        @Override
        public void run() {
            int topUp;
            int pending;
            if (!this.connection.isHandler()) {
                this.connection.runLater(this);
                return;
            }
            this.connection.requireInHandler();
            int n = pending = this.context != null ? this.context.pendingSettles : 0;
            if (ProtonAbstractReceiver.isBellowThreshold(this.receiver.getCredit(), pending, this.threshold) && (topUp = ProtonAbstractReceiver.calculatedUpdateRefill(this.refill, this.receiver.getCredit(), pending)) > 0) {
                this.receiver.flow(topUp);
                this.connection.instantFlush();
            }
        }
    }
}

