/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.Spliterator;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.apache.activemq.artemis.core.PriorityAware;
import org.apache.activemq.artemis.core.server.impl.QueueConsumers;
import org.apache.activemq.artemis.utils.collections.PriorityCollection;
import org.apache.activemq.artemis.utils.collections.UpdatableIterator;

public class QueueConsumersImpl<T extends PriorityAware>
implements QueueConsumers<T> {
    private final PriorityCollection<T> consumers = new PriorityCollection(CopyOnWriteArraySet::new);
    private final Collection<T> unmodifiableConsumers = Collections.unmodifiableCollection(this.consumers);
    private final UpdatableIterator<T> iterator = new UpdatableIterator(this.consumers.resettableIterator());

    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    public T next() {
        return (T)((PriorityAware)this.iterator.next());
    }

    public void repeat() {
        this.iterator.repeat();
    }

    public void reset() {
        this.iterator.reset();
    }

    @Override
    public boolean add(T t) {
        boolean result = this.consumers.add(t);
        if (result) {
            this.iterator.update(this.consumers.resettableIterator());
        }
        return result;
    }

    public void removed(T t) {
        this.iterator.removed(t);
    }

    @Override
    public boolean remove(T t) {
        boolean result = this.consumers.remove(t);
        if (result) {
            this.iterator.removed(t);
            this.iterator.update(this.consumers.resettableIterator());
            if (this.consumers.isEmpty()) {
                this.reset();
            }
        }
        return result;
    }

    @Override
    public int size() {
        return this.consumers.size();
    }

    @Override
    public boolean isEmpty() {
        return this.consumers.isEmpty();
    }

    @Override
    public Stream<T> stream() {
        return this.unmodifiableConsumers.stream();
    }

    @Override
    public Iterator<T> iterator() {
        return this.unmodifiableConsumers.iterator();
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        this.unmodifiableConsumers.forEach(action);
    }

    @Override
    public Spliterator<T> spliterator() {
        return this.unmodifiableConsumers.spliterator();
    }

    @Override
    public Set<Integer> getPriorites() {
        return this.consumers.getPriorites();
    }
}

