/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.TopologyMember;
import org.apache.activemq.artemis.core.server.NodeLocator;
import org.apache.activemq.artemis.utils.ConcurrentUtil;

public class NamedNodeIdLocatorForReplication
extends NodeLocator {
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private final String nodeID;
    private final long retryReplicationWait;
    private final Queue<Pair<TransportConfiguration, TransportConfiguration>> configurations = new LinkedList<Pair<TransportConfiguration, TransportConfiguration>>();
    private final ArrayList<Pair<TransportConfiguration, TransportConfiguration>> triedConfigurations = new ArrayList();
    private boolean found;

    public NamedNodeIdLocatorForReplication(String nodeID, NodeLocator.BackupRegistrationListener backupRegistrationListener, long retryReplicationWait) {
        super(backupRegistrationListener);
        this.nodeID = nodeID;
        this.retryReplicationWait = retryReplicationWait;
    }

    @Override
    public void locateNode() throws ActiveMQException {
        this.locateNode(-1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void locateNode(long timeout) throws ActiveMQException {
        block8: {
            try {
                this.lock.lock();
                if (this.configurations.size() != 0) break block8;
                try {
                    if (timeout != -1L) {
                        ConcurrentUtil.await((Condition)this.condition, (long)timeout);
                    } else {
                        while (this.configurations.size() == 0) {
                            this.condition.await(this.retryReplicationWait, TimeUnit.MILLISECONDS);
                            this.configurations.addAll(this.triedConfigurations);
                            this.triedConfigurations.clear();
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nodeUP(TopologyMember topologyMember, boolean last) {
        try {
            this.lock.lock();
            if (this.nodeID.equals(topologyMember.getNodeId()) && topologyMember.getPrimary() != null) {
                Pair configuration = new Pair((Object)topologyMember.getPrimary(), (Object)topologyMember.getBackup());
                if (!this.configurations.contains(configuration)) {
                    this.configurations.add((Pair<TransportConfiguration, TransportConfiguration>)configuration);
                }
                this.found = true;
                this.condition.signal();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void nodeDown(long eventUID, String nodeID) {
    }

    @Override
    public String getNodeID() {
        return this.found ? this.nodeID : null;
    }

    @Override
    public Pair<TransportConfiguration, TransportConfiguration> getPrimaryConfiguration() {
        return this.configurations.peek();
    }

    @Override
    public void notifyRegistrationFailed(boolean alreadyReplicating) {
        try {
            this.lock.lock();
            this.triedConfigurations.add(this.configurations.poll());
            super.notifyRegistrationFailed(alreadyReplicating);
        }
        finally {
            this.lock.unlock();
        }
    }
}

