/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.proton;

import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.LargeServerMessage;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPLargeMessage;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPSessionCallback;
import org.apache.activemq.artemis.protocol.amqp.proton.MessageReader;
import org.apache.activemq.artemis.protocol.amqp.proton.ProtonAbstractReceiver;
import org.apache.qpid.proton.amqp.messaging.DeliveryAnnotations;
import org.apache.qpid.proton.codec.ReadableBuffer;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.Receiver;

public class AMQPLargeMessageReader
implements MessageReader {
    private final ProtonAbstractReceiver serverReceiver;
    private volatile AMQPLargeMessage currentMessage;
    private DeliveryAnnotations deliveryAnnotations;
    private boolean closed = true;

    public AMQPLargeMessageReader(ProtonAbstractReceiver serverReceiver) {
        this.serverReceiver = serverReceiver;
    }

    @Override
    public DeliveryAnnotations getDeliveryAnnotations() {
        return this.deliveryAnnotations;
    }

    @Override
    public void close() {
        if (!this.closed) {
            try {
                AMQPLargeMessage localCurrentMessage = this.currentMessage;
                if (localCurrentMessage != null) {
                    localCurrentMessage.deleteFile();
                }
            }
            catch (Throwable error) {
                ActiveMQServerLogger.LOGGER.errorDeletingLargeMessageFile(error);
            }
            finally {
                this.currentMessage = null;
            }
            this.deliveryAnnotations = null;
            this.closed = true;
        }
    }

    @Override
    public AMQPLargeMessageReader open() {
        if (!this.closed) {
            throw new IllegalStateException("Reader was not closed before call to open.");
        }
        this.closed = false;
        return this;
    }

    @Override
    public Message readBytes(Delivery delivery) throws Exception {
        if (this.closed) {
            throw new IllegalStateException("AMQP Large Message Reader is closed and read cannot proceed");
        }
        try {
            this.serverReceiver.connection.requireInHandler();
            Receiver receiver = (Receiver)delivery.getLink();
            ReadableBuffer dataBuffer = receiver.recv();
            AMQPSessionCallback sessionSPI = this.serverReceiver.getSessionContext().getSessionSPI();
            if (this.currentMessage == null) {
                long id = sessionSPI.getStorageManager().generateID();
                AMQPLargeMessage localCurrentMessage = new AMQPLargeMessage(id, delivery.getMessageFormat(), null, sessionSPI.getCoreMessageObjectPools(), sessionSPI.getStorageManager());
                localCurrentMessage.parseHeader(dataBuffer);
                sessionSPI.getStorageManager().onLargeMessageCreate(id, (LargeServerMessage)localCurrentMessage);
                this.currentMessage = localCurrentMessage;
            }
            this.serverReceiver.getConnection().disableAutoRead();
            boolean partial = delivery.isPartial();
            sessionSPI.execute(() -> this.addBytes(delivery, dataBuffer, partial));
            return null;
        }
        catch (Exception e) {
            this.serverReceiver.getConnection().enableAutoRead();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addBytes(Delivery delivery, ReadableBuffer dataBuffer, boolean isPartial) {
        block5: {
            AMQPLargeMessage localCurrentMessage = this.currentMessage;
            try {
                localCurrentMessage.addBytes(dataBuffer);
                if (isPartial) break block5;
                localCurrentMessage.releaseResources(this.serverReceiver.getConnection().isLargeMessageSync(), true);
                this.currentMessage = null;
                this.serverReceiver.connection.runNow(() -> this.serverReceiver.onMessageComplete(delivery, localCurrentMessage, localCurrentMessage.getDeliveryAnnotations()));
            }
            catch (Throwable e) {
                try {
                    this.serverReceiver.onExceptionWhileReading(e);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    this.serverReceiver.connection.runNow(this.serverReceiver.getConnection()::enableAutoRead);
                }
            }
        }
        this.serverReceiver.connection.runNow(this.serverReceiver.getConnection()::enableAutoRead);
    }
}

