/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.connect.federation;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederation;

public final class AMQPFederationConsumerConfiguration {
    private final Map<String, Object> properties;
    private final AMQPFederation federation;

    public AMQPFederationConsumerConfiguration(AMQPFederation federation, Map<String, ?> properties) {
        this.federation = federation;
        this.properties = properties == null || properties.isEmpty() ? Collections.EMPTY_MAP : Collections.unmodifiableMap(new HashMap(properties));
    }

    public int getReceiverCredits() {
        Object property = this.properties.get("amqpCredits");
        if (property instanceof Number) {
            return ((Number)property).intValue();
        }
        if (property instanceof String) {
            return Integer.parseInt((String)property);
        }
        return this.federation.getConfiguration().getReceiverCredits();
    }

    public int getReceiverCreditsLow() {
        Object property = this.properties.get("amqpLowCredits");
        if (property instanceof Number) {
            return ((Number)property).intValue();
        }
        if (property instanceof String) {
            return Integer.parseInt((String)property);
        }
        return this.federation.getConfiguration().getReceiverCreditsLow();
    }

    public int getPullReceiverBatchSize() {
        Object property = this.properties.get("amqpPullConsumerCredits");
        if (property instanceof Number) {
            return ((Number)property).intValue();
        }
        if (property instanceof String) {
            return Integer.parseInt((String)property);
        }
        return this.federation.getConfiguration().getPullReceiverBatchSize();
    }

    public int getLargeMessageThreshold() {
        Object property = this.properties.get("minLargeMessageSize");
        if (property instanceof Number) {
            return ((Number)property).intValue();
        }
        if (property instanceof String) {
            return Integer.parseInt((String)property);
        }
        return this.federation.getConfiguration().getLargeMessageThreshold();
    }

    public int getLinkAttachTimeout() {
        Object property = this.properties.get("attach-timeout");
        if (property instanceof Number) {
            return ((Number)property).intValue();
        }
        if (property instanceof String) {
            return Integer.parseInt((String)property);
        }
        return this.federation.getConfiguration().getLinkAttachTimeout();
    }

    public boolean isCoreMessageTunnelingEnabled() {
        Object property = this.properties.get("tunnel-core-messages");
        if (property instanceof Boolean) {
            return (Boolean)property;
        }
        if (property instanceof String) {
            return Boolean.parseBoolean((String)property);
        }
        return this.federation.getConfiguration().isCoreMessageTunnelingEnabled();
    }

    public boolean isIgnoreSubscriptionFilters() {
        Object property = this.properties.get("ignoreQueueConsumerFilters");
        if (property instanceof Boolean) {
            return (Boolean)property;
        }
        if (property instanceof String) {
            return Boolean.parseBoolean((String)property);
        }
        return this.federation.getConfiguration().isIgnoreSubscriptionFilters();
    }

    public boolean isIgnoreSubscriptionPriorities() {
        Object property = this.properties.get("ignoreQueueConsumerPriorities");
        if (property instanceof Boolean) {
            return (Boolean)property;
        }
        if (property instanceof String) {
            return Boolean.parseBoolean((String)property);
        }
        return this.federation.getConfiguration().isIgnoreSubscriptionPriorities();
    }
}

