/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.protocols.TransferQueueBundler;
import org.jgroups.util.Util;

public class SimplifiedTransferQueueBundler
extends TransferQueueBundler {
    protected static final int MSG_BUF_SIZE = 512;
    protected final Message[] msg_queue = new Message[512];
    protected int curr;

    public SimplifiedTransferQueueBundler() {
    }

    public SimplifiedTransferQueueBundler(int capacity) {
        super(new ArrayBlockingQueue<Message>(SimplifiedTransferQueueBundler.assertPositive(capacity, "bundler capacity cannot be " + capacity)));
    }

    @Override
    public int size() {
        return this.curr + this.removeQueueSize();
    }

    @Override
    protected void addMessage(Message msg, int size) {
        try {
            while (this.curr < 512 && this.msg_queue[this.curr] != null) {
                ++this.curr;
            }
            if (this.curr < 512) {
                this.msg_queue[this.curr] = msg;
                ++this.curr;
            } else {
                this.sendBundledMessages();
                this.msg_queue[0] = msg;
            }
        }
        finally {
            this.count += (long)size;
        }
    }

    @Override
    protected void sendBundledMessages() {
        try {
            this._sendBundledMessages();
        }
        finally {
            this.curr = 0;
        }
    }

    protected void _sendBundledMessages() {
        int start = 0;
        while (true) {
            Message msg;
            int i;
            if (start < 512 && this.msg_queue[start] == null) {
                ++start;
                continue;
            }
            if (start >= 512) {
                this.count = 0L;
                return;
            }
            Address dest = this.msg_queue[start].getDest();
            int numMsgs = 1;
            for (i = start + 1; i < 512; ++i) {
                msg = this.msg_queue[i];
                if (msg == null || dest != msg.getDest() && !Objects.equals(dest, msg.getDest())) continue;
                msg.setDest(dest);
                ++numMsgs;
            }
            try {
                this.output.position(0);
                if (numMsgs == 1) {
                    this.sendSingleMessage(this.msg_queue[start]);
                    this.msg_queue[start] = null;
                } else {
                    Util.writeMessageListHeader(dest, this.msg_queue[start].getSrc(), this.transport.cluster_name.chars(), numMsgs, this.output, dest == null);
                    for (i = start; i < 512; ++i) {
                        msg = this.msg_queue[i];
                        if (msg == null || msg.getDest() != dest) continue;
                        this.output.writeShort(msg.getType());
                        msg.writeToNoAddrs(msg.getSrc(), this.output, this.transport.getId());
                        this.msg_queue[i] = null;
                    }
                    this.transport.doSend(this.output.buffer(), 0, this.output.position(), dest);
                }
                ++start;
                continue;
            }
            catch (Exception e) {
                this.log.error("Failed to send message", e);
                continue;
            }
            break;
        }
    }
}

