/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.mqtt;

import io.netty.handler.codec.mqtt.MqttSubscriptionOption;
import io.netty.handler.codec.mqtt.MqttTopicSubscription;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.activemq.artemis.api.core.ActiveMQQueueExistsException;
import org.apache.activemq.artemis.api.core.ActiveMQSecurityException;
import org.apache.activemq.artemis.api.core.FilterConstants;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTLogger;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTSession;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTSessionState;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTStateManager;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTUtil;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTVersion;
import org.apache.activemq.artemis.core.server.ActiveMQMessageBundle;
import org.apache.activemq.artemis.core.server.BindingQueryResult;
import org.apache.activemq.artemis.core.server.Consumer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.ServerConsumer;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.utils.CompositeAddress;

public class MQTTSubscriptionManager {
    private final MQTTSession session;
    private final MQTTStateManager stateManager;
    private final ConcurrentMap<Long, Integer> consumerQoSLevels;
    private final ConcurrentMap<String, ServerConsumer> consumers;
    private final SimpleString messageFilter;
    private final SimpleString messageFilterNoDollar;
    private final char singleWord;
    private final char anyWords;

    public MQTTSubscriptionManager(MQTTSession session, MQTTStateManager stateManager) {
        this.session = session;
        this.stateManager = stateManager;
        this.singleWord = session.getServer().getConfiguration().getWildcardConfiguration().getSingleWord();
        this.anyWords = session.getServer().getConfiguration().getWildcardConfiguration().getAnyWords();
        this.consumers = new ConcurrentHashMap<String, ServerConsumer>();
        this.consumerQoSLevels = new ConcurrentHashMap<Long, Integer>();
        StringBuilder baseFilter = new StringBuilder();
        baseFilter.append("NOT (");
        baseFilter.append("(").append((CharSequence)FilterConstants.ACTIVEMQ_ADDRESS).append(" = '").append((CharSequence)session.getServer().getConfiguration().getManagementAddress()).append("')");
        baseFilter.append(" OR ");
        baseFilter.append("(").append((CharSequence)FilterConstants.ACTIVEMQ_ADDRESS).append(" = '").append((CharSequence)session.getServer().getConfiguration().getManagementNotificationAddress()).append("')");
        StringBuilder messageFilter = new StringBuilder(baseFilter);
        messageFilter.append(")");
        this.messageFilter = new SimpleString(messageFilter.toString());
        StringBuilder messageFilterNoDollar = new StringBuilder(baseFilter);
        messageFilterNoDollar.append(" OR ");
        messageFilterNoDollar.append("(").append((CharSequence)FilterConstants.ACTIVEMQ_ADDRESS).append(" LIKE '").append('$').append("%')");
        messageFilterNoDollar.append(")");
        this.messageFilterNoDollar = new SimpleString(messageFilterNoDollar.toString());
    }

    synchronized void start() throws Exception {
        for (MqttTopicSubscription subscription : this.session.getState().getSubscriptions()) {
            this.addSubscription(subscription, null, true);
        }
    }

    private void addSubscription(MqttTopicSubscription subscription, Integer subscriptionIdentifier, boolean initialStart) throws Exception {
        String rawTopicName = CompositeAddress.extractAddressName((String)subscription.topicName());
        String parsedTopicName = this.parseTopicName(rawTopicName);
        int qos = subscription.qualityOfService().value();
        String coreAddress = MQTTUtil.convertMqttTopicFilterToCoreAddress(parsedTopicName, this.session.getWildcardConfiguration());
        Queue q = this.createQueueForSubscription(coreAddress, this.getQueueNameForTopic(rawTopicName));
        try {
            if (initialStart) {
                this.createConsumerForSubscriptionQueue(q, parsedTopicName, qos, subscription.option().isNoLocal(), null);
            } else {
                MqttTopicSubscription existingSubscription = this.session.getState().getSubscription(parsedTopicName);
                if (existingSubscription == null) {
                    this.createConsumerForSubscriptionQueue(q, parsedTopicName, qos, subscription.option().isNoLocal(), null);
                } else {
                    Long existingConsumerId = ((ServerConsumer)this.consumers.get(parsedTopicName)).getID();
                    this.consumerQoSLevels.put(existingConsumerId, qos);
                    if (existingSubscription.option().isNoLocal() != subscription.option().isNoLocal()) {
                        this.createConsumerForSubscriptionQueue(q, parsedTopicName, qos, subscription.option().isNoLocal(), existingConsumerId);
                    }
                }
                if (subscription.option().retainHandling() == MqttSubscriptionOption.RetainedHandlingPolicy.SEND_AT_SUBSCRIBE || subscription.option().retainHandling() == MqttSubscriptionOption.RetainedHandlingPolicy.SEND_AT_SUBSCRIBE_IF_NOT_YET_EXISTS && existingSubscription == null) {
                    this.session.getRetainMessageManager().addRetainedMessagesToQueue(q, parsedTopicName);
                }
                this.session.getState().addSubscription(subscription, this.session.getWildcardConfiguration(), subscriptionIdentifier);
            }
        }
        catch (Exception e) {
            q.deleteQueue();
            throw e;
        }
    }

    private String parseTopicName(String rawTopicName) {
        String parsedTopicName = rawTopicName;
        if (rawTopicName.startsWith("$share/")) {
            parsedTopicName = rawTopicName.substring(rawTopicName.indexOf(47, rawTopicName.indexOf(47) + 1) + 1);
        }
        return parsedTopicName;
    }

    synchronized void stop() throws Exception {
        for (ServerConsumer consumer : this.consumers.values()) {
            consumer.setStarted(false);
            consumer.disconnect();
            consumer.getQueue().removeConsumer((Consumer)consumer);
            consumer.close(false);
        }
    }

    private Queue createQueueForSubscription(String address, SimpleString queueName) throws Exception {
        Queue q = this.session.getServer().locateQueue(queueName);
        if (q == null) {
            SimpleString sAddress = SimpleString.toSimpleString((String)address);
            BindingQueryResult bindingQueryResult = this.session.getServerSession().executeBindingQuery(sAddress);
            if (!bindingQueryResult.isAutoCreateQueues()) {
                throw ActiveMQMessageBundle.BUNDLE.noSuchQueue(sAddress);
            }
            AddressInfo addressInfo = this.session.getServerSession().getAddress(sAddress);
            if (addressInfo == null) {
                if (!bindingQueryResult.isAutoCreateAddresses()) {
                    throw ActiveMQMessageBundle.BUNDLE.addressDoesNotExist(SimpleString.toSimpleString((String)address));
                }
                addressInfo = this.session.getServerSession().createAddress(SimpleString.toSimpleString((String)address), RoutingType.MULTICAST, true);
            }
            return this.findOrCreateQueue(bindingQueryResult, addressInfo, queueName);
        }
        return q;
    }

    private Queue findOrCreateQueue(BindingQueryResult bindingQueryResult, AddressInfo addressInfo, SimpleString queue) throws Exception {
        boolean durable;
        boolean bl = durable = this.session.getVersion() == MQTTVersion.MQTT_5 || this.session.getVersion() != MQTTVersion.MQTT_5 && !this.session.isClean();
        if (addressInfo.getRoutingTypes().contains(RoutingType.MULTICAST)) {
            return this.session.getServerSession().createQueue(new QueueConfiguration(queue).setAddress(addressInfo.getName()).setFilterString(this.getMessageFilter(addressInfo.getName())).setDurable(Boolean.valueOf(durable)));
        }
        if (addressInfo.getRoutingTypes().contains(RoutingType.ANYCAST)) {
            if (!bindingQueryResult.getQueueNames().isEmpty()) {
                SimpleString name = null;
                for (SimpleString qName : bindingQueryResult.getQueueNames()) {
                    if (name == null) {
                        name = qName;
                        continue;
                    }
                    if (!qName.equals((Object)addressInfo.getName())) continue;
                    name = qName;
                }
                return this.session.getServer().locateQueue(name);
            }
            try {
                return this.session.getServerSession().createQueue(new QueueConfiguration(addressInfo.getName()).setRoutingType(RoutingType.ANYCAST).setFilterString(this.getMessageFilter(addressInfo.getName())).setDurable(Boolean.valueOf(durable)));
            }
            catch (ActiveMQQueueExistsException e) {
                return this.session.getServer().locateQueue(addressInfo.getName());
            }
        }
        throw ActiveMQMessageBundle.BUNDLE.invalidRoutingTypeForAddress(addressInfo.getRoutingType(), addressInfo.getName().toString(), EnumSet.allOf(RoutingType.class));
    }

    private SimpleString getMessageFilter(SimpleString addressName) {
        if (addressName.startsWith(this.singleWord) || addressName.startsWith(this.anyWords)) {
            return this.messageFilterNoDollar;
        }
        return this.messageFilter;
    }

    private void createConsumerForSubscriptionQueue(Queue queue, String topic, int qos, boolean noLocal, Long existingConsumerId) throws Exception {
        long cid = existingConsumerId != null ? existingConsumerId.longValue() : this.session.getServer().getStorageManager().generateID();
        ServerConsumer consumer = this.session.getServerSession().createConsumer(cid, queue.getName(), noLocal ? SimpleString.toSimpleString((String)("__AMQ_CID <> '" + this.session.getState().getClientId() + "'")) : null, false, false, Integer.valueOf(-1));
        ServerConsumer existingConsumer = this.consumers.put(this.parseTopicName(topic), consumer);
        if (existingConsumer != null) {
            existingConsumer.setStarted(false);
            existingConsumer.close(false);
        }
        consumer.setStarted(true);
        this.consumerQoSLevels.put(cid, qos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    short[] removeSubscriptions(List<String> topics, boolean enforceSecurity) throws Exception {
        short[] reasonCodes;
        MQTTSessionState state;
        MQTTSessionState mQTTSessionState = state = this.session.getState();
        synchronized (mQTTSessionState) {
            reasonCodes = new short[topics.size()];
            for (int i = 0; i < topics.size(); ++i) {
                if (this.session.getState().getSubscription(topics.get(i)) == null) {
                    reasonCodes[i] = 17;
                    continue;
                }
                int reasonCode = 0;
                try {
                    this.session.getState().removeSubscription(topics.get(i));
                    ServerConsumer removed = (ServerConsumer)this.consumers.remove(this.parseTopicName(topics.get(i)));
                    if (removed != null) {
                        removed.close(false);
                        this.consumerQoSLevels.remove(removed.getID());
                    }
                    SimpleString internalQueueName = this.getQueueNameForTopic(topics.get(i));
                    Queue queue = this.session.getServer().locateQueue(internalQueueName);
                    if (queue != null) {
                        if (queue.isConfigurationManaged()) {
                            queue.deleteAllReferences();
                        } else if (!topics.get(i).startsWith("$share/") || topics.get(i).startsWith("$share/") && queue.getConsumerCount() == 0) {
                            this.session.getServerSession().deleteQueue(internalQueueName, enforceSecurity);
                        }
                    }
                }
                catch (Exception e) {
                    MQTTLogger.LOGGER.errorRemovingSubscription(e);
                    reasonCode = -128;
                }
                reasonCodes[i] = reasonCode;
            }
            this.stateManager.storeSessionState(state);
        }
        return reasonCodes;
    }

    private SimpleString getQueueNameForTopic(String topic) {
        if (topic.startsWith("$share/")) {
            int slashIndex = topic.indexOf(47) + 1;
            String sharedSubscriptionName = topic.substring(slashIndex, topic.indexOf(47, slashIndex));
            String parsedTopicName = topic.substring(topic.indexOf(47, slashIndex) + 1);
            return new SimpleString(sharedSubscriptionName).concat(".").concat(parsedTopicName);
        }
        return new SimpleString(this.session.getState().getClientId()).concat(".").concat(topic);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int[] addSubscriptions(List<MqttTopicSubscription> subscriptions, Integer subscriptionIdentifier) throws Exception {
        MQTTSessionState state;
        MQTTSessionState mQTTSessionState = state = this.session.getState();
        synchronized (mQTTSessionState) {
            int[] qos = new int[subscriptions.size()];
            for (int i = 0; i < subscriptions.size(); ++i) {
                try {
                    this.addSubscription(subscriptions.get(i), subscriptionIdentifier, false);
                    qos[i] = subscriptions.get(i).qualityOfService().value();
                    continue;
                }
                catch (ActiveMQSecurityException e) {
                    qos[i] = this.session.getVersion() == MQTTVersion.MQTT_5 ? -121 : (this.session.getVersion() == MQTTVersion.MQTT_3_1_1 ? -128 : subscriptions.get(i).qualityOfService().value());
                }
            }
            this.stateManager.storeSessionState(state);
            return qos;
        }
    }

    Map<Long, Integer> getConsumerQoSLevels() {
        return this.consumerQoSLevels;
    }

    void clean(boolean enforceSecurity) throws Exception {
        ArrayList<String> topics = new ArrayList<String>();
        for (MqttTopicSubscription mqttTopicSubscription : this.session.getState().getSubscriptions()) {
            topics.add(mqttTopicSubscription.topicName());
        }
        this.removeSubscriptions(topics, enforceSecurity);
    }
}

