/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.persistence.impl.journal;

import io.netty.buffer.Unpooled;
import java.lang.invoke.MethodHandles;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiConsumer;
import javax.transaction.xa.Xid;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffers;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.buffers.impl.ChannelBufferWrapper;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.filter.Filter;
import org.apache.activemq.artemis.core.io.IOCallback;
import org.apache.activemq.artemis.core.io.IOCriticalErrorListener;
import org.apache.activemq.artemis.core.journal.EncodingSupport;
import org.apache.activemq.artemis.core.journal.IOCompletion;
import org.apache.activemq.artemis.core.journal.Journal;
import org.apache.activemq.artemis.core.journal.JournalLoadInformation;
import org.apache.activemq.artemis.core.journal.PreparedTransactionInfo;
import org.apache.activemq.artemis.core.journal.RecordInfo;
import org.apache.activemq.artemis.core.journal.TransactionFailureCallback;
import org.apache.activemq.artemis.core.paging.PageTransactionInfo;
import org.apache.activemq.artemis.core.paging.PagingManager;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.paging.cursor.PagePosition;
import org.apache.activemq.artemis.core.paging.cursor.PageSubscription;
import org.apache.activemq.artemis.core.paging.cursor.QueryPagedReferenceImpl;
import org.apache.activemq.artemis.core.paging.impl.PageTransactionInfoImpl;
import org.apache.activemq.artemis.core.persistence.AddressBindingInfo;
import org.apache.activemq.artemis.core.persistence.AddressQueueStatus;
import org.apache.activemq.artemis.core.persistence.CoreMessageObjectPools;
import org.apache.activemq.artemis.core.persistence.GroupingInfo;
import org.apache.activemq.artemis.core.persistence.OperationContext;
import org.apache.activemq.artemis.core.persistence.Persister;
import org.apache.activemq.artemis.core.persistence.QueueBindingInfo;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.persistence.config.PersistedAddressSetting;
import org.apache.activemq.artemis.core.persistence.config.PersistedBridgeConfiguration;
import org.apache.activemq.artemis.core.persistence.config.PersistedConnector;
import org.apache.activemq.artemis.core.persistence.config.PersistedDivertConfiguration;
import org.apache.activemq.artemis.core.persistence.config.PersistedKeyValuePair;
import org.apache.activemq.artemis.core.persistence.config.PersistedRole;
import org.apache.activemq.artemis.core.persistence.config.PersistedSecuritySetting;
import org.apache.activemq.artemis.core.persistence.config.PersistedUser;
import org.apache.activemq.artemis.core.persistence.impl.PageCountPending;
import org.apache.activemq.artemis.core.persistence.impl.journal.AddMessageRecord;
import org.apache.activemq.artemis.core.persistence.impl.journal.BatchingIDGenerator;
import org.apache.activemq.artemis.core.persistence.impl.journal.LargeMessageTXFailureCallback;
import org.apache.activemq.artemis.core.persistence.impl.journal.LargeServerMessageImpl;
import org.apache.activemq.artemis.core.persistence.impl.journal.OperationContextImpl;
import org.apache.activemq.artemis.core.persistence.impl.journal.TXLargeMessageConfirmationOperation;
import org.apache.activemq.artemis.core.persistence.impl.journal.codec.AddressStatusEncoding;
import org.apache.activemq.artemis.core.persistence.impl.journal.codec.CursorAckRecordEncoding;
import org.apache.activemq.artemis.core.persistence.impl.journal.codec.DeleteEncoding;
import org.apache.activemq.artemis.core.persistence.impl.journal.codec.DeliveryCountUpdateEncoding;
import org.apache.activemq.artemis.core.persistence.impl.journal.codec.DuplicateIDEncoding;
import org.apache.activemq.artemis.core.persistence.impl.journal.codec.FinishPageMessageOperation;
import org.apache.activemq.artemis.core.persistence.impl.journal.codec.GroupingEncoding;
import org.apache.activemq.artemis.core.persistence.impl.journal.codec.HeuristicCompletionEncoding;
import org.apache.activemq.artemis.core.persistence.impl.journal.codec.LargeMessagePersister;
import org.apache.activemq.artemis.core.persistence.impl.journal.codec.PageCountPendingImpl;
import org.apache.activemq.artemis.core.persistence.impl.journal.codec.PageCountRecord;
import org.apache.activemq.artemis.core.persistence.impl.journal.codec.PageCountRecordInc;
import org.apache.activemq.artemis.core.persistence.impl.journal.codec.PageUpdateTXEncoding;
import org.apache.activemq.artemis.core.persistence.impl.journal.codec.PendingLargeMessageEncoding;
import org.apache.activemq.artemis.core.persistence.impl.journal.codec.PersistentAddressBindingEncoding;
import org.apache.activemq.artemis.core.persistence.impl.journal.codec.PersistentQueueBindingEncoding;
import org.apache.activemq.artemis.core.persistence.impl.journal.codec.QueueStatusEncoding;
import org.apache.activemq.artemis.core.persistence.impl.journal.codec.RefEncoding;
import org.apache.activemq.artemis.core.persistence.impl.journal.codec.ScheduledDeliveryEncoding;
import org.apache.activemq.artemis.core.persistence.impl.journal.codec.XidEncoding;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.postoffice.DuplicateIDCache;
import org.apache.activemq.artemis.core.postoffice.PostOffice;
import org.apache.activemq.artemis.core.server.ActiveMQMessageBundle;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.LargeServerMessage;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.RouteContextList;
import org.apache.activemq.artemis.core.server.group.impl.GroupBinding;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.server.impl.JournalLoader;
import org.apache.activemq.artemis.core.transaction.ResourceManager;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.core.transaction.impl.TransactionImpl;
import org.apache.activemq.artemis.spi.core.protocol.MessagePersister;
import org.apache.activemq.artemis.utils.ArtemisCloseable;
import org.apache.activemq.artemis.utils.ExecutorFactory;
import org.apache.activemq.artemis.utils.IDGenerator;
import org.apache.activemq.artemis.utils.collections.ConcurrentLongHashMap;
import org.apache.activemq.artemis.utils.collections.SparseArrayLinkedList;
import org.apache.activemq.artemis.utils.critical.CriticalAnalyzer;
import org.apache.activemq.artemis.utils.critical.CriticalCloseable;
import org.apache.activemq.artemis.utils.critical.CriticalComponentImpl;
import org.apache.activemq.artemis.utils.critical.CriticalMeasure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJournalStorageManager
extends CriticalComponentImpl
implements StorageManager {
    protected static final int CRITICAL_PATHS = 3;
    protected static final int CRITICAL_STORE = 0;
    protected static final int CRITICAL_STOP = 1;
    protected static final int CRITICAL_STOP_2 = 2;
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final long CHECKPOINT_BATCH_SIZE = Integer.MAX_VALUE;
    protected BatchingIDGenerator idGenerator;
    protected final ExecutorFactory ioExecutorFactory;
    protected final ScheduledExecutorService scheduledExecutorService;
    protected final ReentrantReadWriteLock storageManagerLock = new ReentrantReadWriteLock(false);
    protected final ArtemisCloseable unlockCloseable = this::unlockCloseable;
    protected static final ArtemisCloseable dummyCloseable = () -> {};
    private static final ThreadLocal<Boolean> reentrant = ThreadLocal.withInitial(() -> false);
    protected Journal messageJournal;
    protected Journal bindingsJournal;
    protected volatile boolean started;
    protected final ExecutorFactory executorFactory;
    final Executor executor;
    Executor singleThreadExecutor;
    private final boolean syncTransactional;
    private final boolean syncNonTransactional;
    protected boolean journalLoaded = false;
    protected final IOCriticalErrorListener ioCriticalErrorListener;
    protected final Configuration config;
    protected final Map<SimpleString, PersistedSecuritySetting> mapPersistedSecuritySettings = new ConcurrentHashMap<SimpleString, PersistedSecuritySetting>();
    protected final Map<SimpleString, PersistedAddressSetting> mapPersistedAddressSettings = new ConcurrentHashMap<SimpleString, PersistedAddressSetting>();
    protected final Map<String, PersistedDivertConfiguration> mapPersistedDivertConfigurations = new ConcurrentHashMap<String, PersistedDivertConfiguration>();
    protected final Map<String, PersistedBridgeConfiguration> mapPersistedBridgeConfigurations = new ConcurrentHashMap<String, PersistedBridgeConfiguration>();
    protected final Map<String, PersistedConnector> mapPersistedConnectors = new ConcurrentHashMap<String, PersistedConnector>();
    protected final Map<String, PersistedUser> mapPersistedUsers = new ConcurrentHashMap<String, PersistedUser>();
    protected final Map<String, PersistedRole> mapPersistedRoles = new ConcurrentHashMap<String, PersistedRole>();
    protected final ConcurrentMap<String, ConcurrentMap<String, PersistedKeyValuePair>> mapPersistedKeyValuePairs = new ConcurrentHashMap<String, ConcurrentMap<String, PersistedKeyValuePair>>();
    protected final ConcurrentLongHashMap<LargeServerMessage> largeMessagesToDelete = new ConcurrentLongHashMap();

    private void unlockCloseable() {
        this.storageManagerLock.readLock().unlock();
        reentrant.set(false);
    }

    public Configuration getConfig() {
        return this.config;
    }

    public AbstractJournalStorageManager(Configuration config, CriticalAnalyzer analyzer, ExecutorFactory executorFactory, ScheduledExecutorService scheduledExecutorService, ExecutorFactory ioExecutorFactory) {
        this(config, analyzer, executorFactory, scheduledExecutorService, ioExecutorFactory, null);
    }

    public AbstractJournalStorageManager(Configuration config, CriticalAnalyzer analyzer, ExecutorFactory executorFactory, ScheduledExecutorService scheduledExecutorService, ExecutorFactory ioExecutorFactory, IOCriticalErrorListener criticalErrorListener) {
        super(analyzer, 3);
        this.executorFactory = executorFactory;
        this.ioCriticalErrorListener = criticalErrorListener;
        this.ioExecutorFactory = ioExecutorFactory;
        this.scheduledExecutorService = scheduledExecutorService;
        this.config = config;
        this.executor = executorFactory.getExecutor();
        this.syncNonTransactional = config.isJournalSyncNonTransactional();
        this.syncTransactional = config.isJournalSyncTransactional();
        this.init(config, criticalErrorListener);
        this.idGenerator = new BatchingIDGenerator(0L, Integer.MAX_VALUE, this);
    }

    @Override
    public long getMaxRecordSize() {
        return this.messageJournal.getMaxRecordSize();
    }

    protected abstract void init(Configuration var1, IOCriticalErrorListener var2);

    @Override
    public void criticalError(Throwable error) {
        this.ioCriticalErrorListener.onIOException(error, error.getMessage(), null);
    }

    @Override
    public void clearContext() {
        OperationContextImpl.clearContext();
    }

    public IDGenerator getIDGenerator() {
        return this.idGenerator;
    }

    @Override
    public final void waitOnOperations() throws Exception {
        if (!this.started) {
            ActiveMQServerLogger.LOGGER.serverIsStopped();
            throw new IllegalStateException("Server is stopped");
        }
        this.waitOnOperations(0L);
    }

    @Override
    public final boolean waitOnOperations(long timeout) throws Exception {
        if (!this.started) {
            ActiveMQServerLogger.LOGGER.serverIsStopped();
            throw new IllegalStateException("Server is stopped");
        }
        return this.getContext().waitCompletion(timeout);
    }

    @Override
    public OperationContext getContext() {
        return OperationContextImpl.getContext(this.executorFactory);
    }

    @Override
    public void setContext(OperationContext context) {
        OperationContextImpl.setContext(context);
    }

    @Override
    public OperationContext newSingleThreadContext() {
        return this.newContext(this.singleThreadExecutor);
    }

    @Override
    public OperationContext newContext(Executor executor1) {
        return new OperationContextImpl(executor1);
    }

    @Override
    public void afterCompleteOperations(IOCallback run) {
        this.getContext().executeOnCompletion(run);
    }

    @Override
    public void afterStoreOperations(IOCallback run) {
        this.getContext().executeOnCompletion(run, true);
    }

    public long generateID() {
        return this.idGenerator.generateID();
    }

    public long getCurrentID() {
        return this.idGenerator.getCurrentID();
    }

    @Override
    public void confirmPendingLargeMessageTX(Transaction tx, long messageID, long recordID) throws Exception {
        try (ArtemisCloseable lock = this.closeableReadLock();){
            this.installLargeMessageConfirmationOnTX(tx, recordID);
            this.messageJournal.appendDeleteRecordTransactional(tx.getID(), recordID, (EncodingSupport)new DeleteEncoding(29, messageID));
        }
    }

    @Override
    public void confirmPendingLargeMessage(long recordID) throws Exception {
        try (ArtemisCloseable lock = this.closeableReadLock();){
            this.messageJournal.tryAppendDeleteRecord(recordID, true, this::messageUpdateCallback, (IOCompletion)this.getContext());
        }
    }

    @Override
    public void storeMessage(Message message) throws Exception {
        if (message.getMessageID() <= 0L) {
            throw ActiveMQMessageBundle.BUNDLE.messageIdNotAssigned();
        }
        try (ArtemisCloseable lock = this.closeableReadLock();){
            if (message.isLargeMessage() && message instanceof LargeServerMessageImpl) {
                this.messageJournal.appendAddRecord(message.getMessageID(), (byte)30, (Persister)LargeMessagePersister.getInstance(), (Object)message, false, (IOCompletion)this.getContext(false));
            } else {
                this.messageJournal.appendAddRecord(message.getMessageID(), (byte)45, message.getPersister(), (Object)message, false, (IOCompletion)this.getContext(false));
            }
        }
    }

    @Override
    public void storeReference(long queueID, long messageID, boolean last) throws Exception {
        try (ArtemisCloseable lock = this.closeableReadLock();){
            this.messageJournal.tryAppendUpdateRecord(messageID, (byte)32, (EncodingSupport)new RefEncoding(queueID), last && this.syncNonTransactional, false, this::messageUpdateCallback, (IOCompletion)this.getContext(last && this.syncNonTransactional));
        }
    }

    @Override
    public ArtemisCloseable closeableReadLock() {
        if (reentrant.get().booleanValue()) {
            return dummyCloseable;
        }
        reentrant.set(true);
        CriticalCloseable measure = this.measureCritical(0);
        this.storageManagerLock.readLock().lock();
        if (CriticalMeasure.isDummy((ArtemisCloseable)measure)) {
            return this.unlockCloseable;
        }
        measure.beforeClose(this.unlockCloseable);
        return measure;
    }

    @Override
    public void storeAcknowledge(long queueID, long messageID) throws Exception {
        try (ArtemisCloseable lock = this.closeableReadLock();){
            this.messageJournal.tryAppendUpdateRecord(messageID, (byte)33, (EncodingSupport)new RefEncoding(queueID), this.syncNonTransactional, false, this::messageUpdateCallback, (IOCompletion)this.getContext(this.syncNonTransactional));
        }
    }

    @Override
    public void storeCursorAcknowledge(long queueID, PagePosition position) throws Exception {
        try (ArtemisCloseable lock = this.closeableReadLock();){
            long ackID = this.idGenerator.generateID();
            position.setRecordID(ackID);
            this.messageJournal.appendAddRecord(ackID, (byte)39, (EncodingSupport)new CursorAckRecordEncoding(queueID, position), this.syncNonTransactional, (IOCompletion)this.getContext(this.syncNonTransactional));
        }
    }

    @Override
    public void deleteMessage(long messageID) throws Exception {
        try (ArtemisCloseable lock = this.closeableReadLock();){
            this.messageJournal.tryAppendDeleteRecord(messageID, false, this::messageUpdateCallback, (IOCompletion)this.getContext(false));
        }
    }

    private void messageUpdateCallback(long id, boolean found) {
        if (!found) {
            ActiveMQServerLogger.LOGGER.cannotFindMessageOnJournal(id, new Exception("trace"));
        }
    }

    private void recordNotFoundCallback(long id, boolean found) {
        if (!found && logger.isDebugEnabled()) {
            logger.debug("Record {} not found", (Object)id);
        }
    }

    @Override
    public void updateScheduledDeliveryTime(MessageReference ref) throws Exception {
        if (this.config.getMaxRedeliveryRecords() >= 0 && ref.getDeliveryCount() > this.config.getMaxRedeliveryRecords()) {
            return;
        }
        ScheduledDeliveryEncoding encoding = new ScheduledDeliveryEncoding(ref.getScheduledDeliveryTime(), ref.getQueue().getID());
        try (ArtemisCloseable lock = this.closeableReadLock();){
            this.messageJournal.tryAppendUpdateRecord(ref.getMessage().getMessageID(), (byte)36, (EncodingSupport)encoding, this.syncNonTransactional, true, this::recordNotFoundCallback, (IOCompletion)this.getContext(this.syncNonTransactional));
        }
    }

    @Override
    public void storeDuplicateID(SimpleString address, byte[] duplID, long recordID) throws Exception {
        try (ArtemisCloseable lock = this.closeableReadLock();){
            DuplicateIDEncoding encoding = new DuplicateIDEncoding(address, duplID);
            this.messageJournal.appendAddRecord(recordID, (byte)37, (EncodingSupport)encoding, this.syncNonTransactional, (IOCompletion)this.getContext(this.syncNonTransactional));
        }
    }

    @Override
    public void deleteDuplicateID(long recordID) throws Exception {
        try (ArtemisCloseable lock = this.closeableReadLock();){
            this.messageJournal.tryAppendDeleteRecord(recordID, this.syncNonTransactional, this::recordNotFoundCallback, (IOCompletion)this.getContext(this.syncNonTransactional));
        }
    }

    @Override
    public void storeMessageTransactional(long txID, Message message) throws Exception {
        if (message.getMessageID() <= 0L) {
            throw ActiveMQMessageBundle.BUNDLE.messageIdNotAssigned();
        }
        try (ArtemisCloseable lock = this.closeableReadLock();){
            if (message.isLargeMessage() && message instanceof LargeServerMessageImpl) {
                this.messageJournal.appendAddRecordTransactional(txID, message.getMessageID(), (byte)30, (Persister)LargeMessagePersister.getInstance(), (Object)message);
            } else {
                this.messageJournal.appendAddRecordTransactional(txID, message.getMessageID(), (byte)45, message.getPersister(), (Object)message);
            }
        }
    }

    @Override
    public void storePageTransaction(long txID, PageTransactionInfo pageTransaction) throws Exception {
        try (ArtemisCloseable lock = this.closeableReadLock();){
            pageTransaction.setRecordID(this.generateID());
            this.messageJournal.appendAddRecordTransactional(txID, pageTransaction.getRecordID(), (byte)35, (EncodingSupport)pageTransaction);
        }
    }

    @Override
    public void updatePageTransaction(long txID, PageTransactionInfo pageTransaction, int depages) throws Exception {
        try (ArtemisCloseable lock = this.closeableReadLock();){
            this.messageJournal.appendUpdateRecordTransactional(txID, pageTransaction.getRecordID(), (byte)35, (EncodingSupport)new PageUpdateTXEncoding(pageTransaction.getTransactionID(), depages));
        }
    }

    @Override
    public void storeReferenceTransactional(long txID, long queueID, long messageID) throws Exception {
        try (ArtemisCloseable lock = this.closeableReadLock();){
            this.messageJournal.appendUpdateRecordTransactional(txID, messageID, (byte)32, (EncodingSupport)new RefEncoding(queueID));
        }
    }

    @Override
    public void storeAcknowledgeTransactional(long txID, long queueID, long messageID) throws Exception {
        try (ArtemisCloseable lock = this.closeableReadLock();){
            this.messageJournal.appendUpdateRecordTransactional(txID, messageID, (byte)33, (EncodingSupport)new RefEncoding(queueID));
        }
    }

    @Override
    public void storeCursorAcknowledgeTransactional(long txID, long queueID, PagePosition position) throws Exception {
        try (ArtemisCloseable lock = this.closeableReadLock();){
            long ackID = this.idGenerator.generateID();
            position.setRecordID(ackID);
            this.messageJournal.appendAddRecordTransactional(txID, ackID, (byte)39, (EncodingSupport)new CursorAckRecordEncoding(queueID, position));
        }
    }

    @Override
    public void storePageCompleteTransactional(long txID, long queueID, PagePosition position) throws Exception {
        long recordID = this.idGenerator.generateID();
        position.setRecordID(recordID);
        this.messageJournal.appendAddRecordTransactional(txID, recordID, (byte)42, (EncodingSupport)new CursorAckRecordEncoding(queueID, position));
    }

    @Override
    public void deletePageComplete(long ackID) throws Exception {
        this.messageJournal.tryAppendDeleteRecord(ackID, this::recordNotFoundCallback, false);
    }

    @Override
    public void deleteCursorAcknowledgeTransactional(long txID, long ackID) throws Exception {
        try (ArtemisCloseable lock = this.closeableReadLock();){
            this.messageJournal.appendDeleteRecordTransactional(txID, ackID);
        }
    }

    @Override
    public void deleteCursorAcknowledge(long ackID) throws Exception {
        this.messageJournal.tryAppendDeleteRecord(ackID, this::recordNotFoundCallback, false);
    }

    @Override
    public long storeHeuristicCompletion(Xid xid, boolean isCommit) throws Exception {
        try (ArtemisCloseable lock = this.closeableReadLock();){
            long id = this.generateID();
            this.messageJournal.appendAddRecord(id, (byte)38, (EncodingSupport)new HeuristicCompletionEncoding(xid, isCommit), true, (IOCompletion)this.getContext(true));
            long l = id;
            return l;
        }
    }

    @Override
    public void deleteHeuristicCompletion(long id) throws Exception {
        try (ArtemisCloseable lock = this.closeableReadLock();){
            this.messageJournal.tryAppendDeleteRecord(id, true, this::recordNotFoundCallback, (IOCompletion)this.getContext(true));
        }
    }

    @Override
    public void deletePageTransactional(long recordID) throws Exception {
        try (ArtemisCloseable lock = this.closeableReadLock();){
            this.messageJournal.tryAppendDeleteRecord(recordID, this::recordNotFoundCallback, false);
        }
    }

    @Override
    public void updateScheduledDeliveryTimeTransactional(long txID, MessageReference ref) throws Exception {
        ScheduledDeliveryEncoding encoding = new ScheduledDeliveryEncoding(ref.getScheduledDeliveryTime(), ref.getQueue().getID());
        try (ArtemisCloseable lock = this.closeableReadLock();){
            this.messageJournal.appendUpdateRecordTransactional(txID, ref.getMessage().getMessageID(), (byte)36, (EncodingSupport)encoding);
        }
    }

    @Override
    public void prepare(long txID, Xid xid) throws Exception {
        try (ArtemisCloseable lock = this.closeableReadLock();){
            this.messageJournal.appendPrepareRecord(txID, (EncodingSupport)new XidEncoding(xid), this.syncTransactional, (IOCompletion)this.getContext(this.syncTransactional));
        }
    }

    @Override
    public void commit(long txID) throws Exception {
        this.commit(txID, true);
    }

    @Override
    public void commitBindings(long txID) throws Exception {
        this.bindingsJournal.appendCommitRecord(txID, true, (IOCompletion)this.getContext(true), true);
    }

    @Override
    public void rollbackBindings(long txID) throws Exception {
        this.bindingsJournal.appendRollbackRecord(txID, false);
    }

    @Override
    public void commit(long txID, boolean lineUpContext) throws Exception {
        try (ArtemisCloseable lock = this.closeableReadLock();){
            this.messageJournal.appendCommitRecord(txID, this.syncTransactional, (IOCompletion)this.getContext(this.syncTransactional), lineUpContext);
            if (!lineUpContext && !this.syncTransactional) {
                if (logger.isTraceEnabled()) {
                    logger.trace("calling getContext(true).done() for txID={}, lineupContext={} syncTransactional={}... forcing call on getContext(true).done", new Object[]{txID, lineUpContext, this.syncTransactional});
                }
                this.getContext(true).done();
            }
        }
    }

    @Override
    public void rollback(long txID) throws Exception {
        try (ArtemisCloseable lock = this.closeableReadLock();){
            this.messageJournal.appendRollbackRecord(txID, this.syncTransactional, (IOCompletion)this.getContext(this.syncTransactional));
        }
    }

    @Override
    public void storeDuplicateIDTransactional(long txID, SimpleString address, byte[] duplID, long recordID) throws Exception {
        DuplicateIDEncoding encoding = new DuplicateIDEncoding(address, duplID);
        try (ArtemisCloseable lock = this.closeableReadLock();){
            this.messageJournal.appendAddRecordTransactional(txID, recordID, (byte)37, (EncodingSupport)encoding);
        }
    }

    @Override
    public void updateDuplicateIDTransactional(long txID, SimpleString address, byte[] duplID, long recordID) throws Exception {
        DuplicateIDEncoding encoding = new DuplicateIDEncoding(address, duplID);
        try (ArtemisCloseable lock = this.closeableReadLock();){
            this.messageJournal.appendUpdateRecordTransactional(txID, recordID, (byte)37, (EncodingSupport)encoding);
        }
    }

    @Override
    public void deleteDuplicateIDTransactional(long txID, long recordID) throws Exception {
        try (ArtemisCloseable lock = this.closeableReadLock();){
            this.messageJournal.appendDeleteRecordTransactional(txID, recordID);
        }
    }

    @Override
    public void updateDeliveryCount(MessageReference ref) throws Exception {
        if (ref.getDeliveryCount() == ref.getPersistedCount()) {
            return;
        }
        if (this.config.getMaxRedeliveryRecords() >= 0 && ref.getDeliveryCount() > this.config.getMaxRedeliveryRecords()) {
            return;
        }
        ref.setPersistedCount(ref.getDeliveryCount());
        DeliveryCountUpdateEncoding updateInfo = new DeliveryCountUpdateEncoding(ref.getQueue().getID(), ref.getDeliveryCount());
        try (ArtemisCloseable lock = this.closeableReadLock();){
            this.messageJournal.tryAppendUpdateRecord(ref.getMessage().getMessageID(), (byte)34, (EncodingSupport)updateInfo, this.syncNonTransactional, true, this::messageUpdateCallback, (IOCompletion)this.getContext(this.syncNonTransactional));
        }
    }

    @Override
    public void storeAddressSetting(PersistedAddressSetting addressSetting) throws Exception {
        this.deleteAddressSetting(addressSetting.getAddressMatch());
        try (ArtemisCloseable lock = this.closeableReadLock();){
            long id = this.idGenerator.generateID();
            addressSetting.setStoreId(id);
            this.bindingsJournal.appendAddRecord(id, (byte)25, (EncodingSupport)addressSetting, true);
            this.mapPersistedAddressSettings.put(addressSetting.getAddressMatch(), addressSetting);
        }
    }

    @Override
    public List<PersistedAddressSetting> recoverAddressSettings() throws Exception {
        return new ArrayList<PersistedAddressSetting>(this.mapPersistedAddressSettings.values());
    }

    @Override
    public List<PersistedSecuritySetting> recoverSecuritySettings() throws Exception {
        return new ArrayList<PersistedSecuritySetting>(this.mapPersistedSecuritySettings.values());
    }

    @Override
    public void storeSecuritySetting(PersistedSecuritySetting persistedRoles) throws Exception {
        this.deleteSecuritySetting(persistedRoles.getAddressMatch());
        try (ArtemisCloseable lock = this.closeableReadLock();){
            long id = this.idGenerator.generateID();
            persistedRoles.setStoreId(id);
            this.bindingsJournal.appendAddRecord(id, (byte)26, (EncodingSupport)persistedRoles, true);
            this.mapPersistedSecuritySettings.put(persistedRoles.getAddressMatch(), persistedRoles);
        }
    }

    @Override
    public void storeDivertConfiguration(PersistedDivertConfiguration persistedDivertConfiguration) throws Exception {
        this.deleteDivertConfiguration(persistedDivertConfiguration.getName());
        try (ArtemisCloseable lock = this.closeableReadLock();){
            long id = this.idGenerator.generateID();
            persistedDivertConfiguration.setStoreId(id);
            this.bindingsJournal.appendAddRecord(id, (byte)27, (EncodingSupport)persistedDivertConfiguration, true);
            this.mapPersistedDivertConfigurations.put(persistedDivertConfiguration.getName(), persistedDivertConfiguration);
        }
    }

    @Override
    public void deleteDivertConfiguration(String divertName) throws Exception {
        PersistedDivertConfiguration oldDivert = this.mapPersistedDivertConfigurations.remove(divertName);
        if (oldDivert != null) {
            try (ArtemisCloseable lock = this.closeableReadLock();){
                this.bindingsJournal.tryAppendDeleteRecord(oldDivert.getStoreId(), this::recordNotFoundCallback, false);
            }
        }
    }

    @Override
    public List<PersistedDivertConfiguration> recoverDivertConfigurations() {
        return new ArrayList<PersistedDivertConfiguration>(this.mapPersistedDivertConfigurations.values());
    }

    @Override
    public void storeBridgeConfiguration(PersistedBridgeConfiguration persistedBridgeConfiguration) throws Exception {
        this.deleteBridgeConfiguration(persistedBridgeConfiguration.getName());
        try (ArtemisCloseable lock = this.closeableReadLock();){
            long id = this.idGenerator.generateID();
            persistedBridgeConfiguration.setStoreId(id);
            this.bindingsJournal.appendAddRecord(id, (byte)28, (EncodingSupport)persistedBridgeConfiguration, true);
            this.mapPersistedBridgeConfigurations.put(persistedBridgeConfiguration.getName(), persistedBridgeConfiguration);
        }
    }

    @Override
    public void deleteBridgeConfiguration(String bridgeName) throws Exception {
        PersistedBridgeConfiguration oldBridge = this.mapPersistedBridgeConfigurations.remove(bridgeName);
        if (oldBridge != null) {
            try (ArtemisCloseable lock = this.closeableReadLock();){
                this.bindingsJournal.tryAppendDeleteRecord(oldBridge.getStoreId(), this::recordNotFoundCallback, false);
            }
        }
    }

    @Override
    public List<PersistedBridgeConfiguration> recoverBridgeConfigurations() {
        return new ArrayList<PersistedBridgeConfiguration>(this.mapPersistedBridgeConfigurations.values());
    }

    @Override
    public void storeConnector(PersistedConnector persistedConnector) throws Exception {
        this.deleteConnector(persistedConnector.getName());
        try (ArtemisCloseable lock = this.closeableReadLock();){
            long id = this.idGenerator.generateID();
            persistedConnector.setStoreId(id);
            this.bindingsJournal.appendAddRecord(id, (byte)51, (EncodingSupport)persistedConnector, true);
            this.mapPersistedConnectors.put(persistedConnector.getName(), persistedConnector);
        }
    }

    @Override
    public void deleteConnector(String connectorName) throws Exception {
        PersistedConnector oldConnector = this.mapPersistedConnectors.remove(connectorName);
        if (oldConnector != null) {
            try (ArtemisCloseable lock = this.closeableReadLock();){
                this.bindingsJournal.tryAppendDeleteRecord(oldConnector.getStoreId(), this::recordNotFoundCallback, false);
            }
        }
    }

    @Override
    public List<PersistedConnector> recoverConnectors() {
        return new ArrayList<PersistedConnector>(this.mapPersistedConnectors.values());
    }

    @Override
    public void storeUser(PersistedUser persistedUser) throws Exception {
        this.deleteUser(persistedUser.getUsername());
        try (ArtemisCloseable lock = this.closeableReadLock();){
            long id = this.idGenerator.generateID();
            persistedUser.setStoreId(id);
            this.bindingsJournal.appendAddRecord(id, (byte)47, (EncodingSupport)persistedUser, true);
            this.mapPersistedUsers.put(persistedUser.getUsername(), persistedUser);
        }
    }

    @Override
    public void deleteUser(String username) throws Exception {
        PersistedUser oldUser = this.mapPersistedUsers.remove(username);
        if (oldUser != null) {
            try (ArtemisCloseable lock = this.closeableReadLock();){
                this.bindingsJournal.tryAppendDeleteRecord(oldUser.getStoreId(), this::recordNotFoundCallback, false);
            }
        }
    }

    @Override
    public Map<String, PersistedUser> getPersistedUsers() {
        return new HashMap<String, PersistedUser>(this.mapPersistedUsers);
    }

    @Override
    public void storeRole(PersistedRole persistedRole) throws Exception {
        this.deleteRole(persistedRole.getUsername());
        try (ArtemisCloseable lock = this.closeableReadLock();){
            long id = this.idGenerator.generateID();
            persistedRole.setStoreId(id);
            this.bindingsJournal.appendAddRecord(id, (byte)48, (EncodingSupport)persistedRole, true);
            this.mapPersistedRoles.put(persistedRole.getUsername(), persistedRole);
        }
    }

    @Override
    public void deleteRole(String username) throws Exception {
        PersistedRole oldRole = this.mapPersistedRoles.remove(username);
        if (oldRole != null) {
            try (ArtemisCloseable lock = this.closeableReadLock();){
                this.bindingsJournal.tryAppendDeleteRecord(oldRole.getStoreId(), this::recordNotFoundCallback, false);
            }
        }
    }

    @Override
    public Map<String, PersistedRole> getPersistedRoles() {
        return new HashMap<String, PersistedRole>(this.mapPersistedRoles);
    }

    @Override
    public void storeKeyValuePair(PersistedKeyValuePair persistedKeyValuePair) throws Exception {
        this.deleteKeyValuePair(persistedKeyValuePair.getMapId(), persistedKeyValuePair.getKey());
        try (ArtemisCloseable lock = this.closeableReadLock();){
            long id = this.idGenerator.generateID();
            persistedKeyValuePair.setStoreId(id);
            this.bindingsJournal.appendAddRecord(id, (byte)50, (EncodingSupport)persistedKeyValuePair, true);
            this.insertPersistedKeyValuePair(persistedKeyValuePair);
        }
    }

    @Override
    public void deleteKeyValuePair(String mapId, String key) throws Exception {
        PersistedKeyValuePair oldMapStringEntry;
        Map persistedKeyValuePairs = (Map)this.mapPersistedKeyValuePairs.get(mapId);
        if (persistedKeyValuePairs != null && (oldMapStringEntry = (PersistedKeyValuePair)persistedKeyValuePairs.remove(key)) != null) {
            try (ArtemisCloseable lock = this.closeableReadLock();){
                this.bindingsJournal.tryAppendDeleteRecord(oldMapStringEntry.getStoreId(), this::recordNotFoundCallback, false);
            }
        }
    }

    @Override
    public Map<String, PersistedKeyValuePair> getPersistedKeyValuePairs(String mapId) {
        Map persistedKeyValuePairs = (Map)this.mapPersistedKeyValuePairs.get(mapId);
        return persistedKeyValuePairs != null ? new HashMap<String, PersistedKeyValuePair>(persistedKeyValuePairs) : new HashMap();
    }

    @Override
    public void storeID(long journalID, long id) throws Exception {
        try (ArtemisCloseable lock = this.closeableReadLock();){
            this.bindingsJournal.appendAddRecord(journalID, (byte)24, BatchingIDGenerator.createIDEncodingSupport(id), true, (IOCompletion)this.getContext(true));
        }
    }

    @Override
    public void deleteID(long journalD) throws Exception {
        try (ArtemisCloseable lock = this.closeableReadLock();){
            this.bindingsJournal.tryAppendDeleteRecord(journalD, this::recordNotFoundCallback, false);
        }
    }

    @Override
    public void deleteAddressSetting(SimpleString addressMatch) throws Exception {
        PersistedAddressSetting oldSetting = this.mapPersistedAddressSettings.remove(addressMatch);
        if (oldSetting != null) {
            try (ArtemisCloseable lock = this.closeableReadLock();){
                this.bindingsJournal.tryAppendDeleteRecord(oldSetting.getStoreId(), this::recordNotFoundCallback, false);
            }
        }
    }

    @Override
    public void deleteSecuritySetting(SimpleString addressMatch) throws Exception {
        PersistedSecuritySetting oldRoles = this.mapPersistedSecuritySettings.remove(addressMatch);
        if (oldRoles != null) {
            try (ArtemisCloseable lock = this.closeableReadLock();){
                this.bindingsJournal.tryAppendDeleteRecord(oldRoles.getStoreId(), this::recordNotFoundCallback, false);
            }
        }
    }

    @Override
    public JournalLoadInformation loadMessageJournal(PostOffice postOffice, PagingManager pagingManager, ResourceManager resourceManager, Map<Long, QueueBindingInfo> queueInfos, Map<SimpleString, List<Pair<byte[], Long>>> duplicateIDMap, Set<Pair<Long, Long>> pendingLargeMessages, Set<Long> storedLargeMessages, List<PageCountPending> pendingNonTXPageCounter, JournalLoader journalLoader) throws Exception {
        SparseArrayLinkedList records = new SparseArrayLinkedList();
        ArrayList<PreparedTransactionInfo> preparedTransactions = new ArrayList<PreparedTransactionInfo>();
        HashSet<PageTransactionInfo> invalidPageTransactions = new HashSet<PageTransactionInfo>();
        HashMap<Long, Message> messages = new HashMap<Long, Message>();
        try (ArtemisCloseable lock = this.closeableReadLock();){
            CoreMessageObjectPools pools;
            this.messageJournal.setRemoveExtraFilesOnLoad(true);
            JournalLoadInformation info = this.messageJournal.load(records, preparedTransactions, (TransactionFailureCallback)new LargeMessageTXFailureCallback(this));
            ArrayList largeMessages = new ArrayList();
            HashMap<Long, Map<Long, AddMessageRecord>> queueMap = new HashMap<Long, Map<Long, AddMessageRecord>>();
            HashMap<Long, PageSubscription> pageSubscriptions = new HashMap<Long, PageSubscription>();
            long totalSize = records.size();
            final class MutableLong {
                long value;

                MutableLong() {
                }
            }
            MutableLong recordNumber = new MutableLong();
            if (totalSize > 0L) {
                int addresses = (int)Math.max(32L, queueInfos == null ? 0L : queueInfos.values().stream().map(QueueBindingInfo::getAddress).filter(addr -> addr.length() <= 36).count() * 2L);
                pools = new CoreMessageObjectPools(addresses, 32, 128, 128);
            } else {
                pools = null;
            }
            records.clear(record -> {
                try {
                    if (recordNumber.value > 0L && recordNumber.value % 1000000L == 0L) {
                        long percent = (long)((double)recordNumber.value / (double)totalSize * 100.0);
                        ActiveMQServerLogger.LOGGER.percentLoaded(percent);
                    }
                    ++recordNumber.value;
                    byte[] data = record.data;
                    ChannelBufferWrapper buff = new ChannelBufferWrapper(Unpooled.wrappedBuffer((byte[])data), true);
                    byte recordType = record.getUserRecordType();
                    switch (recordType) {
                        case 29: {
                            PendingLargeMessageEncoding pending = new PendingLargeMessageEncoding();
                            pending.decode((ActiveMQBuffer)buff);
                            if (pendingLargeMessages != null) {
                                pendingLargeMessages.add(new Pair((Object)record.id, (Object)pending.largeMessageID));
                            }
                            break;
                        }
                        case 30: {
                            LargeServerMessage largeMessage = this.parseLargeMessage((ActiveMQBuffer)buff);
                            messages.put(record.id, largeMessage.toMessage());
                            if (storedLargeMessages != null) {
                                storedLargeMessages.remove(largeMessage.getMessageID());
                            }
                            largeMessages.add(largeMessage);
                            break;
                        }
                        case 31: {
                            throw new IllegalStateException("This is using old journal data, export your data and import at the correct version");
                        }
                        case 45: {
                            Message message = this.decodeMessage(pools, (ActiveMQBuffer)buff);
                            if (message.isLargeMessage() && storedLargeMessages != null) {
                                storedLargeMessages.remove(message.getMessageID());
                            }
                            if (message.isLargeMessage()) {
                                largeMessages.add((LargeServerMessage)message);
                            }
                            messages.put(record.id, message);
                            break;
                        }
                        case 32: {
                            Message message;
                            long messageID = record.id;
                            RefEncoding encoding = new RefEncoding();
                            encoding.decode((ActiveMQBuffer)buff);
                            LinkedHashMap<Long, AddMessageRecord> queueMessages = (LinkedHashMap<Long, AddMessageRecord>)queueMap.get(encoding.queueID);
                            if (queueMessages == null) {
                                queueMessages = new LinkedHashMap<Long, AddMessageRecord>();
                                queueMap.put(encoding.queueID, queueMessages);
                            }
                            if ((message = (Message)messages.get(messageID)) == null) {
                                ActiveMQServerLogger.LOGGER.cannotFindMessage(record.id);
                                break;
                            }
                            queueMessages.put(messageID, new AddMessageRecord(message));
                            break;
                        }
                        case 33: {
                            long messageID = record.id;
                            RefEncoding encoding = new RefEncoding();
                            encoding.decode((ActiveMQBuffer)buff);
                            Map queueMessages = (Map)queueMap.get(encoding.queueID);
                            if (queueMessages == null) {
                                ActiveMQServerLogger.LOGGER.journalCannotFindQueue(encoding.queueID, messageID);
                                break;
                            }
                            AddMessageRecord rec = (AddMessageRecord)queueMessages.remove(messageID);
                            if (rec == null) {
                                ActiveMQServerLogger.LOGGER.cannotFindMessage(messageID);
                            }
                            break;
                        }
                        case 34: {
                            long messageID = record.id;
                            DeliveryCountUpdateEncoding encoding = new DeliveryCountUpdateEncoding();
                            encoding.decode((ActiveMQBuffer)buff);
                            Map queueMessages = (Map)queueMap.get(encoding.queueID);
                            if (queueMessages == null) {
                                ActiveMQServerLogger.LOGGER.journalCannotFindQueueDelCount(encoding.queueID);
                                break;
                            }
                            AddMessageRecord rec = (AddMessageRecord)queueMessages.get(messageID);
                            if (rec == null) {
                                ActiveMQServerLogger.LOGGER.journalCannotFindMessageDelCount(messageID);
                                break;
                            }
                            rec.setDeliveryCount(encoding.count);
                            break;
                        }
                        case 35: {
                            PageTransactionInfo invalidPGTx = null;
                            if (record.isUpdate) {
                                PageUpdateTXEncoding pageUpdate = new PageUpdateTXEncoding();
                                pageUpdate.decode((ActiveMQBuffer)buff);
                                PageTransactionInfo pageTX = pagingManager.getTransaction(pageUpdate.pageTX);
                                if (pageTX == null) {
                                    ActiveMQServerLogger.LOGGER.journalCannotFindPageTX(pageUpdate.pageTX);
                                } else if (!pageTX.onUpdate(pageUpdate.records, null, null)) {
                                    invalidPGTx = pageTX;
                                }
                            } else {
                                PageTransactionInfoImpl pageTransactionInfo = new PageTransactionInfoImpl();
                                pageTransactionInfo.decode((ActiveMQBuffer)buff);
                                pageTransactionInfo.setRecordID(record.id);
                                pagingManager.addTransaction(pageTransactionInfo);
                                if (!pageTransactionInfo.checkSize(null, null)) {
                                    invalidPGTx = pageTransactionInfo;
                                }
                            }
                            if (invalidPGTx != null) {
                                invalidPageTransactions.add(invalidPGTx);
                            }
                            break;
                        }
                        case 36: {
                            long messageID = record.id;
                            ScheduledDeliveryEncoding encoding = new ScheduledDeliveryEncoding();
                            encoding.decode((ActiveMQBuffer)buff);
                            Map queueMessages = (Map)queueMap.get(encoding.queueID);
                            if (queueMessages == null) {
                                ActiveMQServerLogger.LOGGER.journalCannotFindQueueScheduled(encoding.queueID, messageID);
                                break;
                            }
                            AddMessageRecord rec = (AddMessageRecord)queueMessages.get(messageID);
                            if (rec == null) {
                                ActiveMQServerLogger.LOGGER.cannotFindMessage(messageID);
                                break;
                            }
                            rec.setScheduledDeliveryTime(encoding.scheduledDeliveryTime);
                            break;
                        }
                        case 37: {
                            DuplicateIDEncoding encoding = new DuplicateIDEncoding();
                            encoding.decode((ActiveMQBuffer)buff);
                            ArrayList<Pair> ids = (ArrayList<Pair>)duplicateIDMap.get(encoding.address);
                            if (ids == null) {
                                ids = new ArrayList<Pair>();
                                duplicateIDMap.put(encoding.address, ids);
                            }
                            ids.add(new Pair((Object)encoding.duplID, (Object)record.id));
                            break;
                        }
                        case 38: {
                            HeuristicCompletionEncoding encoding = new HeuristicCompletionEncoding();
                            encoding.decode((ActiveMQBuffer)buff);
                            resourceManager.putHeuristicCompletion(record.id, encoding.xid, encoding.isCommit);
                            break;
                        }
                        case 39: {
                            CursorAckRecordEncoding encoding = new CursorAckRecordEncoding();
                            encoding.decode((ActiveMQBuffer)buff);
                            encoding.position.setRecordID(record.id);
                            PageSubscription sub = AbstractJournalStorageManager.locateSubscription(encoding.queueID, pageSubscriptions, queueInfos, pagingManager);
                            if (sub != null) {
                                sub.reloadACK(encoding.position);
                                break;
                            }
                            ActiveMQServerLogger.LOGGER.journalCannotFindQueueReloading(encoding.queueID);
                            this.messageJournal.tryAppendDeleteRecord(record.id, this::recordNotFoundCallback, false);
                            break;
                        }
                        case 40: {
                            PageCountRecord encoding = new PageCountRecord();
                            encoding.decode((ActiveMQBuffer)buff);
                            PageSubscription sub = AbstractJournalStorageManager.locateSubscription(encoding.getQueueID(), pageSubscriptions, queueInfos, pagingManager);
                            if (sub != null) {
                                sub.getCounter().loadValue(record.id, encoding.getValue(), encoding.getPersistentSize());
                                if (encoding.getValue() > 0L) {
                                    sub.notEmpty();
                                }
                                break;
                            }
                            ActiveMQServerLogger.LOGGER.journalCannotFindQueueReloadingPage(encoding.getQueueID());
                            this.messageJournal.tryAppendDeleteRecord(record.id, this::recordNotFoundCallback, false);
                            break;
                        }
                        case 41: {
                            PageCountRecordInc encoding = new PageCountRecordInc();
                            encoding.decode((ActiveMQBuffer)buff);
                            PageSubscription sub = AbstractJournalStorageManager.locateSubscription(encoding.getQueueID(), pageSubscriptions, queueInfos, pagingManager);
                            if (sub != null) {
                                sub.getCounter().loadInc(record.id, encoding.getValue(), encoding.getPersistentSize());
                                break;
                            }
                            ActiveMQServerLogger.LOGGER.journalCannotFindQueueReloadingPageCursor(encoding.getQueueID());
                            this.messageJournal.tryAppendDeleteRecord(record.id, this::recordNotFoundCallback, false);
                            break;
                        }
                        case 42: {
                            CursorAckRecordEncoding encoding = new CursorAckRecordEncoding();
                            encoding.decode((ActiveMQBuffer)buff);
                            encoding.position.setRecordID(record.id);
                            PageSubscription sub = AbstractJournalStorageManager.locateSubscription(encoding.queueID, pageSubscriptions, queueInfos, pagingManager);
                            if (sub != null) {
                                if (!sub.reloadPageCompletion(encoding.position)) {
                                    if (logger.isDebugEnabled()) {
                                        logger.debug("Complete page {} doesn't exist on page manager {}", (Object)encoding.position.getPageNr(), (Object)sub.getPagingStore().getAddress());
                                    }
                                    this.messageJournal.tryAppendDeleteRecord(record.id, this::recordNotFoundCallback, false);
                                }
                                break;
                            }
                            ActiveMQServerLogger.LOGGER.cantFindQueueOnPageComplete(encoding.queueID);
                            this.messageJournal.tryAppendDeleteRecord(record.id, this::recordNotFoundCallback, false);
                            break;
                        }
                        case 43: {
                            PageCountPendingImpl pendingCountEncoding = new PageCountPendingImpl();
                            pendingCountEncoding.decode((ActiveMQBuffer)buff);
                            pendingCountEncoding.setID(record.id);
                            PageSubscription sub = AbstractJournalStorageManager.locateSubscription(pendingCountEncoding.getQueueID(), pageSubscriptions, queueInfos, pagingManager);
                            if (sub != null) {
                                sub.notEmpty();
                            }
                            if (pendingNonTXPageCounter != null) {
                                pendingNonTXPageCounter.add(pendingCountEncoding);
                            }
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Invalid record type " + recordType);
                        }
                    }
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
            records = null;
            journalLoader.handleAddMessage(queueMap);
            this.loadPreparedTransactions(postOffice, pagingManager, resourceManager, queueInfos, preparedTransactions, this::failedToPrepareException, pageSubscriptions, pendingLargeMessages, storedLargeMessages, journalLoader);
            for (PageSubscription sub : pageSubscriptions.values()) {
                sub.getCounter().processReload();
            }
            for (LargeServerMessage msg : largeMessages) {
                if (storedLargeMessages != null && storedLargeMessages.remove(msg.getMessageID()) && logger.isDebugEnabled()) {
                    logger.debug("Large message in folder removed on {}", (Object)msg.getMessageID());
                }
                if (msg.toMessage().getRefCount() != 0 || msg.toMessage().getDurableCount() != 0) continue;
                ActiveMQServerLogger.LOGGER.largeMessageWithNoRef(msg.getMessageID());
                msg.toMessage().usageDown();
            }
            journalLoader.handleNoMessageReferences(messages);
            if (pagingManager != null) {
                pagingManager.processReload();
            }
            journalLoader.postLoad(this.messageJournal, resourceManager, duplicateIDMap);
            this.checkInvalidPageTransactions(pagingManager, invalidPageTransactions);
            this.journalLoaded = true;
            Iterator<Object> iterator = info;
            return iterator;
        }
    }

    private void failedToPrepareException(PreparedTransactionInfo txInfo, Throwable e) {
        XidEncoding encodingXid = null;
        try {
            encodingXid = new XidEncoding(txInfo.getExtraData());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        ActiveMQServerLogger.LOGGER.failedToLoadPreparedTX(String.valueOf(encodingXid != null ? encodingXid.xid : null), e);
        try {
            this.rollback(txInfo.getId());
        }
        catch (Throwable e2) {
            logger.warn(e.getMessage(), e2);
        }
    }

    private Message decodeMessage(CoreMessageObjectPools pools, ActiveMQBuffer buff) {
        Message message = MessagePersister.getInstance().decode(buff, null, pools, this);
        return message;
    }

    public void checkInvalidPageTransactions(PagingManager pagingManager, Set<PageTransactionInfo> invalidPageTransactions) {
        if (invalidPageTransactions != null && !invalidPageTransactions.isEmpty()) {
            for (PageTransactionInfo pginfo : invalidPageTransactions) {
                pginfo.checkSize(this, pagingManager);
            }
        }
    }

    private static PageSubscription locateSubscription(long queueID, Map<Long, PageSubscription> pageSubscriptions, Map<Long, QueueBindingInfo> queueInfos, PagingManager pagingManager) throws Exception {
        QueueBindingInfo queueInfo;
        PageSubscription subs = pageSubscriptions.get(queueID);
        if (subs == null && (queueInfo = queueInfos.get(queueID)) != null) {
            SimpleString address = queueInfo.getAddress();
            PagingStore store = pagingManager.getPageStore(address);
            if (store == null) {
                return null;
            }
            subs = store.getCursorProvider().getSubscription(queueID);
            pageSubscriptions.put(queueID, subs);
        }
        return subs;
    }

    @Override
    public void addGrouping(GroupBinding groupBinding) throws Exception {
        GroupingEncoding groupingEncoding = new GroupingEncoding(groupBinding.getId(), groupBinding.getGroupId(), groupBinding.getClusterName());
        try (ArtemisCloseable lock = this.closeableReadLock();){
            this.bindingsJournal.appendAddRecord(groupBinding.getId(), (byte)20, (EncodingSupport)groupingEncoding, true);
        }
    }

    @Override
    public void deleteGrouping(long tx, GroupBinding groupBinding) throws Exception {
        try (ArtemisCloseable lock = this.closeableReadLock();){
            this.bindingsJournal.appendDeleteRecordTransactional(tx, groupBinding.getId());
        }
    }

    @Override
    public void updateQueueBinding(long tx, Binding binding) throws Exception {
        this.internalQueueBinding(true, tx, binding);
    }

    @Override
    public void addQueueBinding(long tx, Binding binding) throws Exception {
        this.internalQueueBinding(false, tx, binding);
    }

    private void internalQueueBinding(boolean update, long tx, Binding binding) throws Exception {
        Queue queue = (Queue)binding.getBindable();
        Filter filter = queue.getFilter();
        SimpleString filterString = filter == null ? null : filter.getFilterString();
        PersistentQueueBindingEncoding bindingEncoding = new PersistentQueueBindingEncoding(queue.getName(), binding.getAddress(), filterString, queue.getUser(), queue.isAutoCreated(), queue.getMaxConsumers(), queue.isPurgeOnNoConsumers(), queue.isEnabled(), queue.isExclusive(), queue.isGroupRebalance(), queue.isGroupRebalancePauseDispatch(), queue.getGroupBuckets(), queue.getGroupFirstKey(), queue.isLastValue(), queue.getLastValueKey(), queue.isNonDestructive(), queue.getConsumersBeforeDispatch(), queue.getDelayBeforeDispatch(), queue.isAutoDelete(), queue.getAutoDeleteDelay(), queue.getAutoDeleteMessageCount(), queue.getRoutingType().getType(), queue.isConfigurationManaged(), queue.getRingSize(), queue.isInternalQueue());
        try (ArtemisCloseable lock = this.closeableReadLock();){
            if (update) {
                this.bindingsJournal.appendUpdateRecordTransactional(tx, binding.getID().longValue(), (byte)21, (EncodingSupport)bindingEncoding);
            } else {
                this.bindingsJournal.appendAddRecordTransactional(tx, binding.getID().longValue(), (byte)21, (EncodingSupport)bindingEncoding);
            }
        }
    }

    @Override
    public void deleteQueueBinding(long tx, long queueBindingID) throws Exception {
        try (ArtemisCloseable lock = this.closeableReadLock();){
            this.bindingsJournal.appendDeleteRecordTransactional(tx, queueBindingID);
        }
    }

    @Override
    public long storeQueueStatus(long queueID, AddressQueueStatus status) throws Exception {
        long recordID = this.idGenerator.generateID();
        try (ArtemisCloseable lock = this.closeableReadLock();){
            this.bindingsJournal.appendAddRecord(recordID, (byte)22, (EncodingSupport)new QueueStatusEncoding(queueID, status), true);
        }
        return recordID;
    }

    @Override
    public void deleteQueueStatus(long recordID) throws Exception {
        try (ArtemisCloseable lock = this.closeableReadLock();){
            this.bindingsJournal.tryAppendDeleteRecord(recordID, this::recordNotFoundCallback, true);
        }
    }

    @Override
    public long storeAddressStatus(long addressID, AddressQueueStatus status) throws Exception {
        long recordID = this.idGenerator.generateID();
        try (ArtemisCloseable lock = this.closeableReadLock();){
            this.bindingsJournal.appendAddRecord(recordID, (byte)46, (EncodingSupport)new AddressStatusEncoding(addressID, status), true);
        }
        return recordID;
    }

    @Override
    public void deleteAddressStatus(long recordID) throws Exception {
        try (ArtemisCloseable lock = this.closeableReadLock();){
            this.bindingsJournal.tryAppendDeleteRecord(recordID, this::recordNotFoundCallback, true);
        }
    }

    @Override
    public void addAddressBinding(long tx, AddressInfo addressInfo) throws Exception {
        PersistentAddressBindingEncoding bindingEncoding = new PersistentAddressBindingEncoding(addressInfo.getName(), addressInfo.getRoutingTypes(), addressInfo.isAutoCreated(), addressInfo.isInternal());
        try (ArtemisCloseable lock = this.closeableReadLock();){
            long recordID = this.idGenerator.generateID();
            bindingEncoding.setId(recordID);
            addressInfo.setId(recordID);
            this.bindingsJournal.appendAddRecordTransactional(tx, recordID, (byte)44, (EncodingSupport)bindingEncoding);
        }
    }

    @Override
    public void deleteAddressBinding(long tx, long addressBindingID) throws Exception {
        try (ArtemisCloseable lock = this.closeableReadLock();){
            this.bindingsJournal.appendDeleteRecordTransactional(tx, addressBindingID);
        }
    }

    @Override
    public long storePageCounterInc(long txID, long queueID, int value, long persistentSize) throws Exception {
        try (ArtemisCloseable lock = this.closeableReadLock();){
            long recordID = this.idGenerator.generateID();
            this.messageJournal.appendAddRecordTransactional(txID, recordID, (byte)41, (EncodingSupport)new PageCountRecordInc(queueID, value, persistentSize));
            long l = recordID;
            return l;
        }
    }

    @Override
    public long storePageCounterInc(long queueID, int value, long persistentSize) throws Exception {
        try (ArtemisCloseable lock = this.closeableReadLock();){
            long recordID = this.idGenerator.generateID();
            this.messageJournal.appendAddRecord(recordID, (byte)41, (EncodingSupport)new PageCountRecordInc(queueID, value, persistentSize), true, (IOCompletion)this.getContext());
            long l = recordID;
            return l;
        }
    }

    @Override
    public long storePageCounter(long txID, long queueID, long value, long persistentSize) throws Exception {
        try (ArtemisCloseable lock = this.closeableReadLock();){
            long recordID = this.idGenerator.generateID();
            this.messageJournal.appendAddRecordTransactional(txID, recordID, (byte)40, (EncodingSupport)new PageCountRecord(queueID, value, persistentSize));
            long l = recordID;
            return l;
        }
    }

    @Override
    public long storePendingCounter(long queueID, long pageID) throws Exception {
        try (ArtemisCloseable lock = this.closeableReadLock();){
            long recordID = this.idGenerator.generateID();
            PageCountPendingImpl pendingInc = new PageCountPendingImpl(queueID, pageID);
            this.messageJournal.appendAddRecord(recordID, (byte)43, (EncodingSupport)pendingInc, true);
            long l = recordID;
            return l;
        }
    }

    @Override
    public void deleteIncrementRecord(long txID, long recordID) throws Exception {
        try (ArtemisCloseable lock = this.closeableReadLock();){
            this.messageJournal.appendDeleteRecordTransactional(txID, recordID);
        }
    }

    @Override
    public void deletePageCounter(long txID, long recordID) throws Exception {
        try (ArtemisCloseable lock = this.closeableReadLock();){
            this.messageJournal.appendDeleteRecordTransactional(txID, recordID);
        }
    }

    @Override
    public void deletePendingPageCounter(long txID, long recordID) throws Exception {
        try (ArtemisCloseable lock = this.closeableReadLock();){
            this.messageJournal.appendDeleteRecordTransactional(txID, recordID);
        }
    }

    @Override
    public JournalLoadInformation loadBindingJournal(List<QueueBindingInfo> queueBindingInfos, List<GroupingInfo> groupingInfos, List<AddressBindingInfo> addressBindingInfos) throws Exception {
        SparseArrayLinkedList records = new SparseArrayLinkedList();
        ArrayList preparedTransactions = new ArrayList();
        this.bindingsJournal.setRemoveExtraFilesOnLoad(true);
        JournalLoadInformation bindingsInfo = this.bindingsJournal.load(records, preparedTransactions, null);
        HashMap mapBindings = new HashMap();
        HashMap mapAddressBindings = new HashMap();
        records.clear(record -> {
            try {
                long id = record.id;
                ActiveMQBuffer buffer = ActiveMQBuffers.wrappedBuffer((byte[])record.data);
                byte rec = record.getUserRecordType();
                if (rec == 21) {
                    PersistentQueueBindingEncoding bindingEncoding = AbstractJournalStorageManager.newQueueBindingEncoding(id, buffer);
                    mapBindings.put(bindingEncoding.getId(), bindingEncoding);
                } else if (rec == 24) {
                    this.idGenerator.loadState(record.id, buffer);
                } else if (rec == 44) {
                    PersistentAddressBindingEncoding bindingEncoding = AbstractJournalStorageManager.newAddressBindingEncoding(id, buffer);
                    addressBindingInfos.add(bindingEncoding);
                    mapAddressBindings.put(id, bindingEncoding);
                } else if (rec == 20) {
                    GroupingEncoding encoding = AbstractJournalStorageManager.newGroupEncoding(id, buffer);
                    groupingInfos.add(encoding);
                } else if (rec == 25) {
                    PersistedAddressSetting setting = AbstractJournalStorageManager.newAddressEncoding(id, buffer);
                    this.mapPersistedAddressSettings.put(setting.getAddressMatch(), setting);
                } else if (rec == 26) {
                    PersistedSecuritySetting roles = AbstractJournalStorageManager.newSecurityRecord(id, buffer);
                    this.mapPersistedSecuritySettings.put(roles.getAddressMatch(), roles);
                } else if (rec == 22) {
                    QueueStatusEncoding statusEncoding = AbstractJournalStorageManager.newQueueStatusEncoding(id, buffer);
                    PersistentQueueBindingEncoding queueBindingEncoding = (PersistentQueueBindingEncoding)mapBindings.get(statusEncoding.queueID);
                    if (queueBindingEncoding != null) {
                        queueBindingEncoding.addQueueStatusEncoding(statusEncoding);
                    } else {
                        ActiveMQServerLogger.LOGGER.infoNoQueueWithID(statusEncoding.queueID, statusEncoding.getId());
                        this.deleteQueueStatus(statusEncoding.getId());
                    }
                } else if (rec == 46) {
                    AddressStatusEncoding statusEncoding = AbstractJournalStorageManager.newAddressStatusEncoding(id, buffer);
                    PersistentAddressBindingEncoding addressBindingEncoding = (PersistentAddressBindingEncoding)mapAddressBindings.get(statusEncoding.getAddressId());
                    if (addressBindingEncoding != null) {
                        addressBindingEncoding.setAddressStatusEncoding(statusEncoding);
                    } else {
                        ActiveMQServerLogger.LOGGER.infoNoAddressWithID(statusEncoding.getAddressId(), statusEncoding.getId());
                        this.deleteAddressStatus(statusEncoding.getId());
                    }
                } else if (rec == 27) {
                    PersistedDivertConfiguration divertConfiguration = AbstractJournalStorageManager.newDivertEncoding(id, buffer);
                    this.mapPersistedDivertConfigurations.put(divertConfiguration.getName(), divertConfiguration);
                } else if (rec == 28) {
                    PersistedBridgeConfiguration bridgeConfiguration = AbstractJournalStorageManager.newBridgeEncoding(id, buffer);
                    this.mapPersistedBridgeConfigurations.put(bridgeConfiguration.getName(), bridgeConfiguration);
                } else if (rec == 47) {
                    PersistedUser user = AbstractJournalStorageManager.newUserEncoding(id, buffer);
                    this.mapPersistedUsers.put(user.getUsername(), user);
                } else if (rec == 48) {
                    PersistedRole role = AbstractJournalStorageManager.newRoleEncoding(id, buffer);
                    this.mapPersistedRoles.put(role.getUsername(), role);
                } else if (rec == 50) {
                    PersistedKeyValuePair keyValuePair = AbstractJournalStorageManager.newKeyValuePairEncoding(id, buffer);
                    this.insertPersistedKeyValuePair(keyValuePair);
                } else if (rec == 51) {
                    PersistedConnector connector = AbstractJournalStorageManager.newConnectorEncoding(id, buffer);
                    this.mapPersistedConnectors.put(connector.getName(), connector);
                } else {
                    ActiveMQServerLogger.LOGGER.invalidRecordType(rec, new Exception("invalid record type " + rec));
                }
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        for (PersistentQueueBindingEncoding queue : mapBindings.values()) {
            queueBindingInfos.add(queue);
        }
        mapBindings.clear();
        this.idGenerator.cleanup();
        return bindingsInfo;
    }

    private void insertPersistedKeyValuePair(PersistedKeyValuePair keyValuePair) {
        ConcurrentHashMap<String, PersistedKeyValuePair> persistedKeyValuePairs = (ConcurrentHashMap<String, PersistedKeyValuePair>)this.mapPersistedKeyValuePairs.get(keyValuePair.getMapId());
        if (persistedKeyValuePairs == null) {
            ConcurrentHashMap newMap = new ConcurrentHashMap();
            Map existingMap = this.mapPersistedKeyValuePairs.putIfAbsent(keyValuePair.getMapId(), newMap);
            persistedKeyValuePairs = existingMap == null ? newMap : existingMap;
        }
        persistedKeyValuePairs.put(keyValuePair.getKey(), keyValuePair);
    }

    @Override
    public void lineUpContext() {
        try (ArtemisCloseable lock = this.closeableReadLock();){
            this.messageJournal.lineUpContext((IOCompletion)this.getContext());
        }
    }

    protected abstract void beforeStart() throws Exception;

    public synchronized void start() throws Exception {
        if (this.started) {
            return;
        }
        this.beforeStart();
        this.singleThreadExecutor = this.ioExecutorFactory.getExecutor();
        this.bindingsJournal.start();
        if (this.config.getJournalRetentionLocation() != null) {
            this.messageJournal.getFileFactory().start();
            this.messageJournal.setHistoryFolder(this.config.getJournalRetentionLocation(), this.config.getJournalRetentionMaxBytes(), this.config.getJournalRetentionPeriod());
        }
        this.messageJournal.start();
        this.started = true;
    }

    public void stop() throws Exception {
        this.stop(false, true);
    }

    @Override
    public synchronized void persistIdGenerator() {
        if (this.journalLoaded && this.idGenerator != null) {
            this.idGenerator.persistCurrentID();
        }
    }

    protected abstract void performCachedLargeMessageDeletes();

    @Override
    public synchronized void stop(boolean ioCriticalError, boolean sendFailover) throws Exception {
        if (!this.started) {
            return;
        }
        if (!ioCriticalError) {
            this.performCachedLargeMessageDeletes();
            if (this.journalLoaded && this.idGenerator != null) {
                this.idGenerator.persistCurrentID();
            }
        }
        final CountDownLatch latch = new CountDownLatch(1);
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                latch.countDown();
            }
        });
        latch.await(30L, TimeUnit.SECONDS);
        this.beforeStop();
        this.bindingsJournal.stop();
        this.messageJournal.stop();
        this.journalLoaded = false;
        this.started = false;
    }

    protected abstract void beforeStop() throws Exception;

    public synchronized boolean isStarted() {
        if (this.ioCriticalErrorListener != null) {
            return this.started && !this.ioCriticalErrorListener.isPreviouslyFailed();
        }
        return this.started;
    }

    public JournalLoadInformation[] loadInternalOnly() throws Exception {
        try (ArtemisCloseable lock = this.closeableReadLock();){
            JournalLoadInformation[] info = new JournalLoadInformation[]{this.bindingsJournal.loadInternalOnly(), this.messageJournal.loadInternalOnly()};
            JournalLoadInformation[] journalLoadInformationArray = info;
            return journalLoadInformationArray;
        }
    }

    @Override
    public Journal getMessageJournal() {
        return this.messageJournal;
    }

    @Override
    public Journal getBindingsJournal() {
        return this.bindingsJournal;
    }

    protected abstract LargeServerMessage parseLargeMessage(ActiveMQBuffer var1) throws Exception;

    private void loadPreparedTransactions(PostOffice postOffice, PagingManager pagingManager, ResourceManager resourceManager, Map<Long, QueueBindingInfo> queueInfos, List<PreparedTransactionInfo> preparedTransactions, BiConsumer<PreparedTransactionInfo, Throwable> failedTransactionCallback, Map<Long, PageSubscription> pageSubscriptions, Set<Pair<Long, Long>> pendingLargeMessages, Set<Long> storedLargeMessages, JournalLoader journalLoader) throws Exception {
        CoreMessageObjectPools pools = new CoreMessageObjectPools();
        for (PreparedTransactionInfo preparedTransaction : preparedTransactions) {
            try {
                this.loadSinglePreparedTransaction(postOffice, pagingManager, resourceManager, queueInfos, pageSubscriptions, pendingLargeMessages, storedLargeMessages, journalLoader, pools, preparedTransaction);
            }
            catch (Throwable e) {
                if (failedTransactionCallback != null) {
                    failedTransactionCallback.accept(preparedTransaction, e);
                    continue;
                }
                logger.warn(e.getMessage(), e);
            }
        }
    }

    private void loadSinglePreparedTransaction(PostOffice postOffice, PagingManager pagingManager, ResourceManager resourceManager, Map<Long, QueueBindingInfo> queueInfos, Map<Long, PageSubscription> pageSubscriptions, Set<Pair<Long, Long>> pendingLargeMessages, Set<Long> storedLargeMessages, JournalLoader journalLoader, CoreMessageObjectPools pools, PreparedTransactionInfo preparedTransaction) throws Exception {
        ActiveMQBuffer buff;
        byte[] data;
        XidEncoding encodingXid = new XidEncoding(preparedTransaction.getExtraData());
        Xid xid = encodingXid.xid;
        TransactionImpl tx = new TransactionImpl(preparedTransaction.getId(), xid, this);
        ArrayList<MessageReference> referencesToAck = new ArrayList<MessageReference>();
        HashMap<Long, Message> messages = new HashMap<Long, Message>();
        block15: for (RecordInfo record : preparedTransaction.getRecords()) {
            data = record.data;
            buff = ActiveMQBuffers.wrappedBuffer((byte[])data);
            byte recordType = record.getUserRecordType();
            switch (recordType) {
                case 30: {
                    if (storedLargeMessages != null && storedLargeMessages.remove(record.id) && logger.isDebugEnabled()) {
                        logger.debug("PreparedTX/AddLargeMessage load removing stored large message {}", (Object)record.id);
                    }
                    messages.put(record.id, this.parseLargeMessage(buff).toMessage());
                    break;
                }
                case 31: {
                    break;
                }
                case 45: {
                    Message message = this.decodeMessage(pools, buff);
                    if (storedLargeMessages != null && message.isLargeMessage() && storedLargeMessages.remove(record.id)) {
                        logger.debug("PreparedTX/AddMessgeProtocol load removing stored large message {}", (Object)record.id);
                    }
                    messages.put(record.id, message);
                    break;
                }
                case 32: {
                    long messageID = record.id;
                    RefEncoding encoding = new RefEncoding();
                    encoding.decode(buff);
                    Message message = (Message)messages.get(messageID);
                    if (message == null) {
                        throw new IllegalStateException("Cannot find message with id " + messageID);
                    }
                    journalLoader.handlePreparedSendMessage(message, tx, encoding.queueID);
                    break;
                }
                case 33: {
                    long messageID = record.id;
                    RefEncoding encoding = new RefEncoding();
                    encoding.decode(buff);
                    journalLoader.handlePreparedAcknowledge(messageID, referencesToAck, encoding.queueID);
                    break;
                }
                case 35: {
                    PageTransactionInfoImpl pageTransactionInfo = new PageTransactionInfoImpl();
                    pageTransactionInfo.decode(buff);
                    if (record.isUpdate) {
                        PageTransactionInfo pgTX = pagingManager.getTransaction(pageTransactionInfo.getTransactionID());
                        if (pgTX == null) continue block15;
                        pgTX.reloadUpdate(this, pagingManager, tx, pageTransactionInfo.getNumberOfMessages());
                        break;
                    }
                    pageTransactionInfo.reloadPrepared(tx);
                    tx.putProperty(5, pageTransactionInfo);
                    pagingManager.addTransaction(pageTransactionInfo);
                    tx.addOperation(new FinishPageMessageOperation());
                    break;
                }
                case 36: {
                    break;
                }
                case 37: {
                    Object encoding = new DuplicateIDEncoding();
                    ((DuplicateIDEncoding)encoding).decode(buff);
                    DuplicateIDCache cache = postOffice.getDuplicateIDCache(((DuplicateIDEncoding)encoding).address);
                    cache.load(tx, ((DuplicateIDEncoding)encoding).duplID);
                    break;
                }
                case 39: {
                    Object encoding = new CursorAckRecordEncoding();
                    ((CursorAckRecordEncoding)encoding).decode(buff);
                    ((CursorAckRecordEncoding)encoding).position.setRecordID(record.id);
                    PageSubscription sub = AbstractJournalStorageManager.locateSubscription(((CursorAckRecordEncoding)encoding).queueID, pageSubscriptions, queueInfos, pagingManager);
                    if (sub != null) {
                        sub.reloadPreparedACK(tx, ((CursorAckRecordEncoding)encoding).position);
                        referencesToAck.add(new QueryPagedReferenceImpl(((CursorAckRecordEncoding)encoding).position, null, sub));
                        break;
                    }
                    ActiveMQServerLogger.LOGGER.journalCannotFindQueueReloadingACK(((CursorAckRecordEncoding)encoding).queueID);
                    break;
                }
                case 41: {
                    Object encoding = new PageCountRecordInc();
                    ((PageCountRecordInc)encoding).decode(buff);
                    logger.debug("Page cursor counter inc on a prepared TX.");
                    break;
                }
                default: {
                    ActiveMQServerLogger.LOGGER.journalInvalidRecordType(recordType);
                }
            }
        }
        block16: for (RecordInfo recordDeleted : preparedTransaction.getRecordsToDelete()) {
            data = recordDeleted.data;
            if (data.length <= 0) continue;
            buff = ActiveMQBuffers.wrappedBuffer((byte[])data);
            byte b = buff.readByte();
            switch (b) {
                case 29: {
                    long messageID = buff.readLong();
                    if (!pendingLargeMessages.remove(new Pair((Object)recordDeleted.id, (Object)messageID))) {
                        ActiveMQServerLogger.LOGGER.largeMessageNotFound(recordDeleted.id);
                    }
                    this.installLargeMessageConfirmationOnTX(tx, recordDeleted.id);
                    continue block16;
                }
            }
            ActiveMQServerLogger.LOGGER.journalInvalidRecordTypeOnPreparedTX(b);
        }
        journalLoader.handlePreparedTransaction(tx, referencesToAck, xid, resourceManager);
    }

    OperationContext getContext(boolean sync) {
        if (sync) {
            return this.getContext();
        }
        return DummyOperationContext.getInstance();
    }

    protected static PersistedSecuritySetting newSecurityRecord(long id, ActiveMQBuffer buffer) {
        PersistedSecuritySetting roles = new PersistedSecuritySetting();
        roles.decode(buffer);
        roles.setStoreId(id);
        return roles;
    }

    static PersistedAddressSetting newAddressEncoding(long id, ActiveMQBuffer buffer) {
        PersistedAddressSetting setting = new PersistedAddressSetting();
        setting.decode(buffer);
        setting.setStoreId(id);
        return setting;
    }

    static AddressStatusEncoding newAddressStatusEncoding(long id, ActiveMQBuffer buffer) {
        AddressStatusEncoding addressStatus = new AddressStatusEncoding();
        addressStatus.decode(buffer);
        addressStatus.setId(id);
        return addressStatus;
    }

    static PersistedDivertConfiguration newDivertEncoding(long id, ActiveMQBuffer buffer) {
        PersistedDivertConfiguration persistedDivertConfiguration = new PersistedDivertConfiguration();
        persistedDivertConfiguration.decode(buffer);
        persistedDivertConfiguration.setStoreId(id);
        return persistedDivertConfiguration;
    }

    static PersistedBridgeConfiguration newBridgeEncoding(long id, ActiveMQBuffer buffer) {
        PersistedBridgeConfiguration persistedBridgeConfiguration = new PersistedBridgeConfiguration();
        persistedBridgeConfiguration.decode(buffer);
        persistedBridgeConfiguration.setStoreId(id);
        return persistedBridgeConfiguration;
    }

    static PersistedConnector newConnectorEncoding(long id, ActiveMQBuffer buffer) {
        PersistedConnector persistedBridgeConfiguration = new PersistedConnector();
        persistedBridgeConfiguration.decode(buffer);
        persistedBridgeConfiguration.setStoreId(id);
        return persistedBridgeConfiguration;
    }

    static PersistedUser newUserEncoding(long id, ActiveMQBuffer buffer) {
        PersistedUser persistedUser = new PersistedUser();
        persistedUser.decode(buffer);
        persistedUser.setStoreId(id);
        return persistedUser;
    }

    static PersistedRole newRoleEncoding(long id, ActiveMQBuffer buffer) {
        PersistedRole persistedRole = new PersistedRole();
        persistedRole.decode(buffer);
        persistedRole.setStoreId(id);
        return persistedRole;
    }

    static PersistedKeyValuePair newKeyValuePairEncoding(long id, ActiveMQBuffer buffer) {
        PersistedKeyValuePair persistedKeyValuePair = new PersistedKeyValuePair();
        persistedKeyValuePair.decode(buffer);
        persistedKeyValuePair.setStoreId(id);
        return persistedKeyValuePair;
    }

    static GroupingEncoding newGroupEncoding(long id, ActiveMQBuffer buffer) {
        GroupingEncoding encoding = new GroupingEncoding();
        encoding.decode(buffer);
        encoding.setId(id);
        return encoding;
    }

    protected static PersistentQueueBindingEncoding newQueueBindingEncoding(long id, ActiveMQBuffer buffer) {
        PersistentQueueBindingEncoding bindingEncoding = new PersistentQueueBindingEncoding();
        bindingEncoding.decode(buffer);
        bindingEncoding.setId(id);
        return bindingEncoding;
    }

    protected static QueueStatusEncoding newQueueStatusEncoding(long id, ActiveMQBuffer buffer) {
        QueueStatusEncoding statusEncoding = new QueueStatusEncoding();
        statusEncoding.decode(buffer);
        statusEncoding.setId(id);
        return statusEncoding;
    }

    protected static PersistentAddressBindingEncoding newAddressBindingEncoding(long id, ActiveMQBuffer buffer) {
        PersistentAddressBindingEncoding bindingEncoding = new PersistentAddressBindingEncoding();
        bindingEncoding.decode(buffer);
        bindingEncoding.setId(id);
        return bindingEncoding;
    }

    @Override
    public boolean addToPage(PagingStore store, Message msg, Transaction tx, RouteContextList listCtx) throws Exception {
        try (ArtemisCloseable closeable = this.closeableReadLock();){
            boolean bl = store.page(msg, tx, listCtx);
            return bl;
        }
    }

    private void installLargeMessageConfirmationOnTX(Transaction tx, long recordID) {
        TXLargeMessageConfirmationOperation txoper = (TXLargeMessageConfirmationOperation)tx.getProperty(1);
        if (txoper == null) {
            txoper = new TXLargeMessageConfirmationOperation(this);
            tx.putProperty(1, txoper);
        }
        txoper.confirmedMessages.add(recordID);
    }

    private static final class DummyOperationContext
    implements OperationContext {
        private static DummyOperationContext instance = new DummyOperationContext();

        private DummyOperationContext() {
        }

        public static OperationContext getInstance() {
            return instance;
        }

        @Override
        public void executeOnCompletion(IOCallback runnable) {
            runnable.done();
        }

        @Override
        public void executeOnCompletion(IOCallback runnable, boolean storeOnly) {
            this.executeOnCompletion(runnable);
        }

        @Override
        public void replicationDone() {
        }

        @Override
        public void replicationLineUp() {
        }

        public void storeLineUp() {
        }

        public void done() {
        }

        public void onError(int errorCode, String errorMessage) {
        }

        @Override
        public void waitCompletion() {
        }

        @Override
        public boolean waitCompletion(long timeout) {
            return true;
        }

        @Override
        public void pageSyncLineUp() {
        }

        @Override
        public void pageSyncDone() {
        }
    }

    public static enum JournalContent {
        BINDINGS(0),
        MESSAGES(1);

        public final byte typeByte;

        private JournalContent(byte b) {
            this.typeByte = b;
        }

        public static JournalContent getType(byte type) {
            if (JournalContent.MESSAGES.typeByte == type) {
                return MESSAGES;
            }
            if (JournalContent.BINDINGS.typeByte == type) {
                return BINDINGS;
            }
            throw new InvalidParameterException("invalid byte: " + type);
        }
    }
}

